"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Links metadata in the gpkg_metadata table to data in the feature, and tiles tables
 * @class MetadataReference
 */
var MetadataReference = /** @class */ (function () {
    function MetadataReference() {
    }
    /**
     * @param {string} columnName
     */
    MetadataReference.prototype.toDatabaseValue = function (columnName) {
        if (columnName === 'timestamp') {
            return this.timestamp.toISOString();
        }
        return this[columnName];
    };
    /**
     * Set the metadata
     * @param  {Metadata} [metadata] metadata
     */
    MetadataReference.prototype.setMetadata = function (metadata) {
        if (metadata) {
            this.md_file_id = metadata.id;
        }
        else {
            this.md_file_id = -1;
        }
    };
    /**
     * Set the parent metadata
     * @param  {Metadata} [metadata] parent metadata
     */
    MetadataReference.prototype.setParentMetadata = function (metadata) {
        if (metadata) {
            this.md_parent_id = metadata.id;
        }
        else {
            this.md_parent_id = -1;
        }
    };
    MetadataReference.prototype.setReferenceScopeType = function (referenceScopeType) {
        this.reference_scope = referenceScopeType;
        switch (referenceScopeType) {
            case MetadataReference.GEOPACKAGE:
                this.table_name = undefined;
                this.column_name = undefined;
                this.row_id_value = undefined;
                break;
            case MetadataReference.TABLE:
                this.column_name = undefined;
                this.row_id_value = undefined;
                break;
            case MetadataReference.ROW:
                this.column_name = undefined;
                break;
            case MetadataReference.COLUMN:
                this.row_id_value = undefined;
                break;
        }
    };
    MetadataReference.GEOPACKAGE = 'geopackage';
    MetadataReference.TABLE = 'table';
    MetadataReference.COLUMN = 'column';
    MetadataReference.ROW = 'row';
    MetadataReference.ROW_COL = 'row/col';
    return MetadataReference;
}());
exports.MetadataReference = MetadataReference;
//# sourceMappingURL=metadataReference.js.map