import { Dao } from '../../dao/dao';
import { MetadataReference } from './metadataReference';
import { DBValue } from '../../db/dbAdapter';
/**
 * Metadata Reference Data Access Object
 * @class
 * @extends Dao
 */
export declare class MetadataReferenceDao extends Dao<MetadataReference> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_REFERENCE_SCOPE: string;
    static readonly COLUMN_TABLE_NAME: string;
    static readonly COLUMN_COLUMN_NAME: string;
    static readonly COLUMN_ROW_ID: string;
    static readonly COLUMN_TIMESTAMP: string;
    static readonly COLUMN_MD_FILE_ID: string;
    static readonly COLUMN_MD_PARENT_ID: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    createObject(results?: Record<string, DBValue>): MetadataReference;
    /**
     * @param {Number} parentId
     * @return {Number} number of rows updated
     */
    removeMetadataParent(parentId: number): number;
    /**
     * @param {Number} fileId
     * @param {Number} parentId
     * @return {Iterable.<Object>}
     */
    queryByMetadataAndParent(fileId: number, parentId: number): IterableIterator<any>;
    /**
     * @param {Number} fileId
     * @return {Iterable.<Object>}
     */
    queryByMetadata(fileId: number): IterableIterator<any>;
    /**
     * @param {Number} parentId
     * @return {Iterable.<Object>}
     */
    queryByMetadataParent(parentId: number): IterableIterator<any>;
}
