import { TileMatrix } from '../matrix/tileMatrix';
import { TileMatrixSet } from '../matrixset/tileMatrixSet';
import { SpatialReferenceSystem } from '../../core/srs/spatialReferenceSystem';
import { BoundingBox } from '../../boundingBox';
export declare abstract class TileCreator {
    width: number;
    height: number;
    tileMatrix: TileMatrix;
    projectionFrom: string;
    projectionFromDefinition: string;
    projectionTo: string;
    tileBoundingBox: BoundingBox;
    tileMatrixSet: TileMatrixSet;
    chunks: any[];
    tileHeightUnitsPerPixel: number;
    tileWidthUnitsPerPixel: number;
    sameProjection: boolean;
    abstract initialize(): Promise<TileCreator>;
    abstract getCompleteTile(format?: string): Promise<any>;
    abstract addPixel(targetX: number, targetY: number, sourceX: number, sourceY: number): void;
    abstract addTile(tileData: any, gridColumn: number, gridRow: number): Promise<any>;
    static create(width: number, height: number, tileMatrix: TileMatrix, tileMatrixSet: TileMatrixSet, tileBoundingBox: BoundingBox, srs: SpatialReferenceSystem, projectionTo: string, canvas: any): Promise<TileCreator>;
    constructor(width: number, height: number, tileMatrix: TileMatrix, tileMatrixSet: TileMatrixSet, tileBoundingBox: BoundingBox, srs: SpatialReferenceSystem, projectionTo: string);
    projectTile(tileData: any, gridColumn: number, gridRow: number): Promise<any>;
    cutAndScale(tileData: any, tilePieceBoundingBox: BoundingBox): void;
    addChunk(chunk: any, position: any): void;
    reproject(tileData: any, tilePieceBoundingBox: BoundingBox): Promise<void>;
}
