"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var tileBoundingBoxUtils_1 = require("../tileBoundingBoxUtils");
var proj4_1 = __importDefault(require("proj4"));
var TileCreator = /** @class */ (function () {
    function TileCreator(width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo) {
        this.width = width;
        this.height = height;
        this.tileMatrix = tileMatrix;
        this.projectionFrom = srs.organization.toUpperCase() + ':' + srs.organization_coordsys_id;
        this.projectionFromDefinition = srs.definition;
        this.projectionTo = projectionTo.toUpperCase();
        this.tileBoundingBox = tileBoundingBox;
        this.tileMatrixSet = tileMatrixSet;
        this.chunks = [];
        this.tileHeightUnitsPerPixel = (tileBoundingBox.maxLatitude - tileBoundingBox.minLatitude) / height;
        this.tileWidthUnitsPerPixel = (tileBoundingBox.maxLongitude - tileBoundingBox.minLongitude) / width;
        // use this as a quick check if the projections are equal.  If they are we can shortcut some math
        // special cases 'EPSG:900913' =='EPSG:3857' == 'EPSG:102113'
        this.sameProjection =
            this.projectionFrom === this.projectionTo ||
                (this.projectionTo === 'EPSG:3857' &&
                    (this.projectionFrom === 'EPSG:900913' || this.projectionFrom === 'EPSG:102113'));
    }
    TileCreator.create = function (width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var isElectron, isNode, NodeTileCreator, creator, CanvasTileCreator, canvasCreator;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        isElectron = !!(typeof navigator !== 'undefined' && navigator.userAgent.toLowerCase().indexOf(' electron/') > -1);
                        isNode = typeof process !== 'undefined' && process.version;
                        if (!(isNode && !isElectron)) return [3 /*break*/, 2];
                        NodeTileCreator = require('./node').NodeTileCreator;
                        creator = new NodeTileCreator(width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo, canvas);
                        return [4 /*yield*/, creator.initialize()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, creator];
                    case 2:
                        CanvasTileCreator = require('./canvas').CanvasTileCreator;
                        canvasCreator = new CanvasTileCreator(width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo, canvas);
                        return [4 /*yield*/, canvasCreator.initialize()];
                    case 3:
                        _a.sent();
                        return [2 /*return*/, canvasCreator];
                }
            });
        });
    };
    TileCreator.prototype.projectTile = function (tileData, gridColumn, gridRow) {
        return __awaiter(this, void 0, void 0, function () {
            var bb;
            return __generator(this, function (_a) {
                bb = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileBoundingBox(this.tileMatrixSet.boundingBox, this.tileMatrix, gridColumn, gridRow);
                if (!this.sameProjection) {
                    return [2 /*return*/, this.reproject(tileData, bb)];
                }
                else {
                    return [2 /*return*/, this.cutAndScale(tileData, bb)];
                }
                return [2 /*return*/];
            });
        });
    };
    TileCreator.prototype.cutAndScale = function (tileData, tilePieceBoundingBox) {
        var position = tileBoundingBoxUtils_1.TileBoundingBoxUtils.determinePositionAndScale(tilePieceBoundingBox, this.tileMatrix.tile_height, this.tileMatrix.tile_width, this.tileBoundingBox, this.height, this.width);
        if (position.xPositionInFinalTileStart >= this.width || position.yPositionInFinalTileStart >= this.height) {
            // this tile doesn't belong just skip it
        }
        else {
            this.addChunk(tileData, position);
        }
    };
    TileCreator.prototype.addChunk = function (chunk, position) {
        this.chunks.push({
            chunk: chunk,
            position: position,
        });
    };
    TileCreator.prototype.reproject = function (tileData, tilePieceBoundingBox) {
        return __awaiter(this, void 0, void 0, function () {
            var y, x, height, width, proj4To, proj4From, conversion, latitude, rows, i, columns, i, row, column, longitude, projected, projectedLongitude, projectedLatitude, xPixel, yPixel;
            return __generator(this, function (_a) {
                y = 0;
                x = 0;
                height = this.height;
                width = this.width;
                proj4To = proj4_1.default(this.projectionTo);
                if (this.projectionFrom) {
                    try {
                        proj4From = proj4_1.default(this.projectionFrom);
                    }
                    catch (e) { }
                }
                if (!proj4From && this.projectionFromDefinition) {
                    proj4From = proj4_1.default(this.projectionFromDefinition);
                }
                try {
                    conversion = proj4_1.default(this.projectionTo, this.projectionFrom);
                }
                catch (e) { }
                if (!conversion) {
                    conversion = proj4_1.default(this.projectionTo, this.projectionFromDefinition);
                }
                rows = [];
                for (i = 0; i < height; i++) {
                    rows.push(i);
                }
                columns = [];
                for (i = 0; i < width; i++) {
                    columns.push(i);
                }
                for (row = 0; row < height; row++) {
                    latitude = this.tileBoundingBox.maxLatitude - row * this.tileHeightUnitsPerPixel;
                    for (column = 0; column < width; column++) {
                        longitude = this.tileBoundingBox.minLongitude + column * this.tileWidthUnitsPerPixel;
                        projected = conversion.forward([longitude, latitude]);
                        projectedLongitude = projected[0];
                        projectedLatitude = projected[1];
                        xPixel = this.tileMatrix.tile_width -
                            Math.round((tilePieceBoundingBox.maxLongitude - projectedLongitude) / this.tileMatrix.pixel_x_size);
                        yPixel = Math.round((tilePieceBoundingBox.maxLatitude - projectedLatitude) / this.tileMatrix.pixel_y_size);
                        if (xPixel >= 0 && xPixel < this.tileMatrix.tile_width && yPixel >= 0 && yPixel < this.tileMatrix.tile_height) {
                            this.addPixel(column, row, xPixel, yPixel);
                        }
                    }
                }
                return [2 /*return*/];
            });
        });
    };
    return TileCreator;
}());
exports.TileCreator = TileCreator;
//# sourceMappingURL=tileCreator.js.map