/// <reference types="node" />
import { CustomFeaturesTile } from './customFeaturesTile';
/**
 * Draws a tile which is shaded to indicate too many features. By default a
 * tile border is drawn and the tile is filled with 6.25% transparent black. The
 * paint objects for each draw type can be modified to or set to null (except
 * for the text paint object).
 */
export declare class ShadedFeaturesTile extends CustomFeaturesTile {
    constructor();
    /**
     * Get the tile border stroke width
     * @return {Number} tile border stroke width
     */
    getTileBorderStrokeWidth(): number;
    /**
     * Set the tile border stroke width
     *
     * @param {Number} tileBorderStrokeWidth tile border stroke width
     */
    setTileBorderStrokeWidth(tileBorderStrokeWidth: number): void;
    /**
     * Get the tile border color
     * @return {String} tile border color
     */
    getTileBorderColor(): string;
    /**
     * Set the tile border color
     * @param {String} tileBorderColor tile border color
     */
    setTileBorderColor(tileBorderColor: string): void;
    /**
     * Get the tile fill color
     * @return {String} tile fill color
     */
    getTileFillColor(): string;
    /**
     * Set the tile fill color
     * @param {String} tileFillColor tile fill color
     */
    setTileFillColor(tileFillColor: string): void;
    /**
     * Is the draw unindexed tiles option enabled
     * @return {Boolean} true if drawing unindexed tiles
     */
    isDrawUnindexedTiles(): boolean;
    /**
     * Set the draw unindexed tiles option
     * @param {Boolean} drawUnindexedTiles draw unindexed tiles flag
     */
    setDrawUnindexedTiles(drawUnindexedTiles: boolean): void;
    /**
     * Get the compression format
     * @return {String} the compression format (either png or jpeg)
     */
    getCompressFormat(): string;
    /**
     * Set the compression format
     * @param {String} compressFormat either 'png' or 'jpeg'
     */
    setCompressFormat(compressFormat: string): void;
    /**
     * Draw unindexed tile
     * @param tileWidth
     * @param tileHeight
     * @param canvas
     * @returns {Promise<String|Buffer>}
     */
    drawUnindexedTile(tileWidth: number, tileHeight: number, canvas?: any): Promise<string | Buffer | Uint8Array>;
    /**
     * Draw a tile with the provided text label in the middle
     * @param {Number} tileWidth
     * @param {Number} tileHeight
     * @param {String} text
     * @param tileCanvas
     * @return {Promise<String|Buffer>}
     */
    drawTile(tileWidth: number, tileHeight: number, text: string, tileCanvas: null): Promise<string | Buffer | Uint8Array>;
}
