"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * FeaturePaint module.
 * @module tiles/features
 */
var FeaturePaint = /** @class */ (function () {
    function FeaturePaint() {
        this.featurePaints = {};
    }
    /**
     * Get the feature paint for the featureDrawType
     * @param {module:tiles/features~FeatureDrawType} featureDrawType
     * @return {module:tiles/features~FeaturePaint} paint
     */
    FeaturePaint.prototype.getPaint = function (featureDrawType) {
        return this.featurePaints[featureDrawType];
    };
    /**
     * Set the feature paint for the featureDrawType
     * @param {module:tiles/features~FeatureDrawType} featureDrawType
     * @param {module:tiles/features~Paint} paint
     */
    FeaturePaint.prototype.setPaint = function (featureDrawType, paint) {
        this.featurePaints[featureDrawType] = paint;
    };
    return FeaturePaint;
}());
exports.FeaturePaint = FeaturePaint;
//# sourceMappingURL=featurePaint.js.map