"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = require("../../dao/dao");
var tileMatrixSet_1 = require("./tileMatrixSet");
/**
 * Tile Matrix Set Data Access Object
 * @class TileMatrixSetDao
 * @extends Dao
 */
var TileMatrixSetDao = /** @class */ (function (_super) {
    __extends(TileMatrixSetDao, _super);
    function TileMatrixSetDao(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.gpkgTableName = 'gpkg_tile_matrix_set';
        _this.idColumns = [TileMatrixSetDao.COLUMN_PK];
        _this.columns = [
            TileMatrixSetDao.COLUMN_TABLE_NAME,
            TileMatrixSetDao.COLUMN_SRS_ID,
            TileMatrixSetDao.COLUMN_MIN_X,
            TileMatrixSetDao.COLUMN_MIN_Y,
            TileMatrixSetDao.COLUMN_MAX_X,
            TileMatrixSetDao.COLUMN_MAX_Y,
        ];
        _this.columnToPropertyMap = {};
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_TABLE_NAME] = tileMatrixSet_1.TileMatrixSet.TABLE_NAME;
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_SRS_ID] = tileMatrixSet_1.TileMatrixSet.SRS_ID;
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_MIN_X] = tileMatrixSet_1.TileMatrixSet.MIN_X;
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_MIN_Y] = tileMatrixSet_1.TileMatrixSet.MIN_Y;
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_MAX_X] = tileMatrixSet_1.TileMatrixSet.MAX_X;
        _this.columnToPropertyMap[TileMatrixSetDao.COLUMN_MAX_Y] = tileMatrixSet_1.TileMatrixSet.MAX_Y;
        return _this;
    }
    TileMatrixSetDao.prototype.createObject = function (results) {
        var tms = new tileMatrixSet_1.TileMatrixSet();
        if (results) {
            tms.table_name = results.table_name;
            tms.srs_id = results.srs_id;
            tms.min_y = results.min_y;
            tms.min_x = results.min_x;
            tms.max_y = results.max_y;
            tms.max_x = results.max_x;
        }
        return tms;
    };
    /**
     * Get the tile table names
     * @returns {string[]} tile table names
     */
    TileMatrixSetDao.prototype.getTileTables = function () {
        var e_1, _a;
        var tableNames = [];
        try {
            for (var _b = __values(this.connection.each('select ' + TileMatrixSetDao.COLUMN_TABLE_NAME + ' from ' + TileMatrixSetDao.TABLE_NAME)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var result = _c.value;
                tableNames.push(result[TileMatrixSetDao.COLUMN_TABLE_NAME]);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return tableNames;
    };
    TileMatrixSetDao.prototype.getProjection = function (tileMatrixSet) {
        var srs = this.getSrs(tileMatrixSet);
        if (!srs)
            return;
        return this.geoPackage.spatialReferenceSystemDao.getProjection(srs);
    };
    /**
     * Get the Spatial Reference System of the Tile Matrix set
     * @param  {TileMatrixSet}   tileMatrixSet tile matrix set
     */
    TileMatrixSetDao.prototype.getSrs = function (tileMatrixSet) {
        return this.geoPackage.spatialReferenceSystemDao.queryForId(tileMatrixSet.srs_id);
    };
    /**
     * @param {TileMatrixSet} tileMatrixSet
     */
    TileMatrixSetDao.prototype.getContents = function (tileMatrixSet) {
        return this.geoPackage.contentsDao.queryForId(tileMatrixSet.table_name);
    };
    TileMatrixSetDao.TABLE_NAME = 'gpkg_tile_matrix_set';
    TileMatrixSetDao.COLUMN_PK = 'table_name';
    TileMatrixSetDao.COLUMN_TABLE_NAME = 'table_name';
    TileMatrixSetDao.COLUMN_SRS_ID = 'srs_id';
    TileMatrixSetDao.COLUMN_MIN_X = 'min_x';
    TileMatrixSetDao.COLUMN_MIN_Y = 'min_y';
    TileMatrixSetDao.COLUMN_MAX_X = 'max_x';
    TileMatrixSetDao.COLUMN_MAX_Y = 'max_y';
    return TileMatrixSetDao;
}(dao_1.Dao));
exports.TileMatrixSetDao = TileMatrixSetDao;
//# sourceMappingURL=tileMatrixSetDao.js.map