"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Tile grid with x and y ranges
 * @module tiles/tileGrid
 * @class
 */
var TileGrid = /** @class */ (function () {
    function TileGrid(min_x, max_x, min_y, max_y) {
        this.min_x = min_x;
        this.max_x = max_x;
        this.min_y = min_y;
        this.max_y = max_y;
    }
    TileGrid.prototype.count = function () {
        return (this.max_x + 1 - this.min_x) * (this.max_y + 1 - this.min_y);
    };
    TileGrid.prototype.equals = function (tileGrid) {
        if (!tileGrid)
            return false;
        return (this.min_x === tileGrid.min_x &&
            this.max_x === tileGrid.max_x &&
            this.min_y === tileGrid.min_y &&
            this.max_y === tileGrid.max_y);
    };
    return TileGrid;
}());
exports.TileGrid = TileGrid;
//# sourceMappingURL=tileGrid.js.map