/**
 * @module tiles/user/tileTable
 */
import { UserTable } from '../../user/userTable';
import { TileColumn } from './tileColumn';
/**
 * `TileTable` models [tile pyramid user tables](https://www.geopackage.org/spec121/index.html#tiles_user_tables).
 *
 * @class
 * @param {string} tableName
 * @param {module:tiles/user/tileColumn~TileColumn[]} columns
 */
export declare class TileTable extends UserTable {
    zoomLevelIndex: number;
    tileColumnIndex: number;
    tileRowIndex: number;
    tileDataIndex: number;
    constructor(tableName: string, columns: TileColumn[]);
    getZoomLevelColumn(): TileColumn;
    getTileColumnColumn(): TileColumn;
    getRowColumn(): TileColumn;
    getTileDataColumn(): TileColumn;
    getTableType(): string;
    static createRequiredColumns(): TileColumn[];
    static createRequiredColumnsWithStartingIndex(startingIndex: number): TileColumn[];
}
