"use strict";
/**
 * @module tiles/user/tileTable
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userTable_1 = require("../../user/userTable");
var tileColumn_1 = require("./tileColumn");
/**
 * `TileTable` models [tile pyramid user tables](https://www.geopackage.org/spec121/index.html#tiles_user_tables).
 *
 * @class
 * @param {string} tableName
 * @param {module:tiles/user/tileColumn~TileColumn[]} columns
 */
var TileTable = /** @class */ (function (_super) {
    __extends(TileTable, _super);
    function TileTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        var uniqueColumns = [];
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            var columnName = column.name;
            var columnIndex = column.index;
            switch (columnName) {
                case tileColumn_1.TileColumn.COLUMN_ZOOM_LEVEL:
                    _this.duplicateCheck(columnIndex, _this.zoomLevelIndex, tileColumn_1.TileColumn.COLUMN_ZOOM_LEVEL);
                    _this.zoomLevelIndex = columnIndex;
                    uniqueColumns.push(column);
                    break;
                case tileColumn_1.TileColumn.COLUMN_TILE_COLUMN:
                    _this.duplicateCheck(columnIndex, _this.tileColumnIndex, tileColumn_1.TileColumn.COLUMN_TILE_COLUMN);
                    _this.tileColumnIndex = columnIndex;
                    uniqueColumns.push(column);
                    break;
                case tileColumn_1.TileColumn.COLUMN_TILE_ROW:
                    _this.duplicateCheck(columnIndex, _this.tileRowIndex, tileColumn_1.TileColumn.COLUMN_TILE_ROW);
                    _this.tileRowIndex = columnIndex;
                    uniqueColumns.push(column);
                    break;
                case tileColumn_1.TileColumn.COLUMN_TILE_DATA:
                    _this.duplicateCheck(columnIndex, _this.tileDataIndex, tileColumn_1.TileColumn.COLUMN_TILE_DATA);
                    _this.tileDataIndex = columnIndex;
                    break;
            }
        }
        _this.uniqueConstraints = [{ columns: uniqueColumns }];
        _this.missingCheck(_this.zoomLevelIndex, tileColumn_1.TileColumn.COLUMN_ZOOM_LEVEL);
        _this.zoomLevelIndex = _this.zoomLevelIndex;
        _this.missingCheck(_this.tileColumnIndex, tileColumn_1.TileColumn.COLUMN_TILE_COLUMN);
        _this.tileColumnIndex = _this.tileColumnIndex;
        _this.missingCheck(_this.tileRowIndex, tileColumn_1.TileColumn.COLUMN_TILE_ROW);
        _this.tileRowIndex = _this.tileRowIndex;
        _this.missingCheck(_this.tileDataIndex, tileColumn_1.TileColumn.COLUMN_TILE_DATA);
        _this.tileDataIndex = _this.tileDataIndex;
        return _this;
    }
    TileTable.prototype.getZoomLevelColumn = function () {
        return this.getColumnWithIndex(this.zoomLevelIndex);
    };
    TileTable.prototype.getTileColumnColumn = function () {
        return this.getColumnWithIndex(this.tileColumnIndex);
    };
    TileTable.prototype.getRowColumn = function () {
        return this.getColumnWithIndex(this.tileRowIndex);
    };
    TileTable.prototype.getTileDataColumn = function () {
        return this.getColumnWithIndex(this.tileDataIndex);
    };
    TileTable.prototype.getTableType = function () {
        return userTable_1.UserTable.TILE_TABLE;
    };
    TileTable.createRequiredColumns = function () {
        return TileTable.createRequiredColumnsWithStartingIndex(0);
    };
    TileTable.createRequiredColumnsWithStartingIndex = function (startingIndex) {
        var columns = [];
        columns.push(tileColumn_1.TileColumn.createIdColumn(startingIndex++));
        columns.push(tileColumn_1.TileColumn.createZoomLevelColumn(startingIndex++));
        columns.push(tileColumn_1.TileColumn.createTileColumnColumn(startingIndex++));
        columns.push(tileColumn_1.TileColumn.createTileRowColumn(startingIndex++));
        columns.push(tileColumn_1.TileColumn.createTileDataColumn(startingIndex++));
        return columns;
    };
    return TileTable;
}(userTable_1.UserTable));
exports.TileTable = TileTable;
//# sourceMappingURL=tileTable.js.map