"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = require("../dao/dao");
var userTableReader_1 = require("./userTableReader");
var mediaTable_1 = require("../extension/relatedTables/mediaTable");
var simpleAttributesTable_1 = require("../extension/relatedTables/simpleAttributesTable");
var userRow_1 = require("./userRow");
var relationType_1 = require("../extension/relatedTables/relationType");
/**
 * Abstract User DAO for reading user tables
 * @class UserDao
 * @extends Dao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage        connection
 * @param  {string} table table name
 */
var UserDao = /** @class */ (function (_super) {
    __extends(UserDao, _super);
    function UserDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage) || this;
        _this.table = table;
        _this.table_name = table.table_name;
        _this.gpkgTableName = table.table_name;
        if (table.getPkColumn()) {
            _this.idColumns = [table.getPkColumn().name];
        }
        else {
            _this.idColumns = [];
        }
        _this.columns = table.columnNames;
        return _this;
    }
    /**
     * Creates a UserRow
     * @param  {Object} [results] results to create the row from if not specified, an empty row is created
     * @return {module:user/userRow~UserRow}
     */
    UserDao.prototype.createObject = function (results) {
        if (results) {
            return this.getRow(results);
        }
        return this.newRow();
    };
    /**
     * Create a new user row
     */
    UserDao.prototype.newRow = function () {
        return new userRow_1.UserRow(this.table);
    };
    /**
     * Sets the value in the row
     * @param  {module:user/userRow~UserRow} object      user row
     * @param  {Number} columnIndex index
     * @param  {Object} value       value
     */
    UserDao.prototype.setValueInObject = function (object, columnIndex, value) {
        object.setValueNoValidationWithIndex(columnIndex, value);
    };
    /**
     * Get a user row from the current results
     * @param  {Object} results result to create the row from
     * @return {module:user/userRow~UserRow}         the user row
     */
    UserDao.prototype.getRow = function (results) {
        if (results instanceof userRow_1.UserRow) {
            return results;
        }
        if (!this.table)
            return undefined;
        var columns = this.table.columnCount();
        var columnTypes = {};
        for (var i = 0; i < columns; i++) {
            var column = this.table.getColumnWithIndex(i);
            columnTypes[column.name] = column.dataType;
        }
        return this.newRowWithColumnTypes(columnTypes, results);
    };
    /**
     * Get the table for this dao
     * @return {module:user/userTable~UserTable}
     */
    UserDao.prototype.getTable = function () {
        return this.table;
    };
    /**
     * Create a user row
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:user/userRow~UserRow}             user row
     */
    UserDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new userRow_1.UserRow(this.table, columnTypes, values);
    };
    /**
     * Links related rows together
     * @param  {module:user/userRow~UserRow} userRow             user row
     * @param  {module:user/userRow~UserRow} relatedRow          related row
     * @param  {string} relationType        relation type
     * @param  {string|UserMappingTable} [mappingTable]        mapping table
     * @param  {module:dao/columnValues~ColumnValues} [mappingColumnValues] column values
     * @return {Promise}
     */
    UserDao.prototype.linkRelatedRow = function (userRow, relatedRow, relationType, mappingTable, mappingColumnValues) {
        return __awaiter(this, void 0, void 0, function () {
            var rte, baseTableName, relatedTableName, relationship, mappingTableName, userMappingDao, userMappingRow, column;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        rte = this.geoPackage.relatedTablesExtension;
                        baseTableName = userRow.table.table_name;
                        relatedTableName = relatedRow.table.table_name;
                        relationship = rte
                            .getRelationshipBuilder()
                            .setBaseTableName(baseTableName)
                            .setRelatedTableName(relatedTableName)
                            .setRelationType(relationType);
                        if (!mappingTable || typeof mappingTable === 'string') {
                            mappingTable = mappingTable || baseTableName + '_' + relatedTableName;
                            relationship.setMappingTableName(mappingTable);
                            mappingTableName = mappingTable;
                        }
                        else {
                            relationship.setUserMappingTable(mappingTable);
                            mappingTableName = mappingTable.table_name;
                        }
                        return [4 /*yield*/, rte.addRelationship(relationship)];
                    case 1:
                        _a.sent();
                        userMappingDao = rte.getMappingDao(mappingTableName);
                        userMappingRow = userMappingDao.newRow();
                        userMappingRow.setBaseId(userRow.id);
                        userMappingRow.setRelatedId(relatedRow.id);
                        for (column in mappingColumnValues) {
                            userMappingRow.setValueWithColumnName(column, mappingColumnValues[column]);
                        }
                        return [2 /*return*/, userMappingDao.create(userMappingRow)];
                }
            });
        });
    };
    /**
     * Links a user row to a feature row
     * @param  {module:user/userRow~UserRow} userRow             user row
     * @param  {module:features/user/featureRow~FeatureRow} featureRow          feature row
     * @param  {string|UserMappingTable} [mappingTable]        mapping table
     * @param  {module:dao/columnValues~ColumnValues} [mappingColumnValues] column values
     * @return {Promise}
     */
    UserDao.prototype.linkFeatureRow = function (userRow, featureRow, mappingTable, mappingColumnValues) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.linkRelatedRow(userRow, featureRow, relationType_1.RelationType.FEATURES, mappingTable, mappingColumnValues)];
            });
        });
    };
    /**
     * Links a user row to a media row
     * @param  {module:user/userRow~UserRow} userRow             user row
     * @param  {module:extension/relatedTables~MediaRow} mediaRow          media row
     * @param  {string|UserMappingTable} [mappingTable]        mapping table
     * @param  {module:dao/columnValues~ColumnValues} [mappingColumnValues] column values
     * @return {Promise}
     */
    UserDao.prototype.linkMediaRow = function (userRow, mediaRow, mappingTable, mappingColumnValues) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.linkRelatedRow(userRow, mediaRow, relationType_1.RelationType.MEDIA, mappingTable, mappingColumnValues)];
            });
        });
    };
    /**
     * Links a user row to a simpleAttributes row
     * @param  {module:user/userRow~UserRow} userRow             user row
     * @param  {module:extension/relatedTables~SimpleAttributesRow} simpleAttributesRow          simple attributes row
     * @param  {string|UserMappingTable} [mappingTable]        mapping table
     * @param  {module:dao/columnValues~ColumnValues} [mappingColumnValues] column values
     * @return {Promise}
     */
    UserDao.prototype.linkSimpleAttributesRow = function (userRow, simpleAttributesRow, mappingTable, mappingColumnValues) {
        return this.linkRelatedRow(userRow, simpleAttributesRow, relationType_1.RelationType.SIMPLE_ATTRIBUTES, mappingTable, mappingColumnValues);
    };
    /**
     * Get all media rows that are linked to this user row
     * @param  {module:user/userRow~UserRow} userRow user row
     * @return {module:extension/relatedTables~MediaRow[]}
     */
    UserDao.prototype.getLinkedMedia = function (userRow) {
        var mediaRelations = this.getMediaRelations();
        var rte = this.geoPackage.relatedTablesExtension;
        var linkedMedia = [];
        for (var i = 0; i < mediaRelations.length; i++) {
            var mediaRelation = mediaRelations[i];
            var mediaDao = rte.getMediaDao(mediaRelation);
            var userMappingDao = rte.getMappingDao(mediaRelation.mapping_table_name);
            var mappings = userMappingDao.queryByBaseId(userRow.id);
            for (var m = 0; m < mappings.length; m++) {
                var relatedId = mappings[m].related_id;
                linkedMedia.push(mediaDao.queryForId(relatedId));
            }
        }
        return linkedMedia;
    };
    /**
     * Get all simple attribute rows that are linked to this user row
     * @param  {module:user/userRow~UserRow} userRow user row
     * @return {module:extension/relatedTables~SimpleAttributeRow[]}
     */
    UserDao.prototype.getLinkedSimpleAttributes = function (userRow) {
        var simpleRelations = this.getSimpleAttributesRelations();
        var rte = this.geoPackage.relatedTablesExtension;
        var linkedSimpleAttributes = [];
        for (var i = 0; i < simpleRelations.length; i++) {
            var simpleRelation = simpleRelations[i];
            var simpleDao = rte.getSimpleAttributesDao(simpleRelation);
            var userMappingDao = rte.getMappingDao(simpleRelation.mapping_table_name);
            var mappings = userMappingDao.queryByBaseId(userRow.id);
            for (var m = 0; m < mappings.length; m++) {
                var relatedId = mappings[m].related_id;
                linkedSimpleAttributes.push(simpleDao.queryForId(relatedId));
            }
        }
        return linkedSimpleAttributes;
    };
    /**
     * Get all feature rows that are linked to this user row
     * @param  {module:user/userRow~UserRow} userRow user row
     * @return {module:features/user/featureRow~FeatureRow[]}
     */
    UserDao.prototype.getLinkedFeatures = function (userRow) {
        var featureRelations = this.getFeatureRelations();
        var rte = this.geoPackage.relatedTablesExtension;
        var linkedFeatures = [];
        for (var i = 0; i < featureRelations.length; i++) {
            var featureRelation = featureRelations[i];
            var featureDao = this.geoPackage.getFeatureDao(featureRelation.base_table_name);
            var userMappingDao = rte.getMappingDao(featureRelation.mapping_table_name);
            var mappings = userMappingDao.queryByBaseId(userRow.id);
            for (var m = 0; m < mappings.length; m++) {
                var relatedId = mappings[m].related_id;
                linkedFeatures.push(featureDao.queryForId(relatedId));
            }
        }
        return linkedFeatures;
    };
    /**
     * Get all simple attribute relations to this table
     * @return {Object[]}
     */
    UserDao.prototype.getSimpleAttributesRelations = function () {
        return this.getRelationsWithName(simpleAttributesTable_1.SimpleAttributesTable.RELATION_TYPE.name);
    };
    /**
     * Get all feature relations to this table
     * @return {Object[]}
     */
    UserDao.prototype.getFeatureRelations = function () {
        return this.getRelationsWithName(relationType_1.RelationType.FEATURES.name);
    };
    /**
     * Get all media relations to this table
     * @return {Object[]}
     */
    UserDao.prototype.getMediaRelations = function () {
        return this.getRelationsWithName(mediaTable_1.MediaTable.RELATION_TYPE.name);
    };
    /**
     * Get all relations to this table with the specified name
     * @param {string} name
     * @return {Object[]}
     */
    UserDao.prototype.getRelationsWithName = function (name) {
        return this.geoPackage.extendedRelationDao.getBaseTableRelationsWithName(this.table_name, name);
    };
    /**
     * Get all relations to this table
     * @return {Object[]}
     */
    UserDao.prototype.getRelations = function () {
        return this.geoPackage.extendedRelationDao.getBaseTableRelations(this.table_name);
    };
    /**
     * Gets the rows in this table by id
     * @param  {Number[]} ids ids to query for
     * @return {Object[]}
     */
    UserDao.prototype.getRows = function (ids) {
        var rows = [];
        for (var i = 0; i < ids.length; i++) {
            var row = this.queryForId(ids[i]);
            if (row) {
                rows.push(row);
            }
        }
        return rows;
    };
    /**
     *  Get the approximate zoom level of where the bounding box of the user data fits into the world
     *
     *  @return zoom level
     */
    UserDao.prototype.getZoomLevel = function () {
        return 0;
        // if(self.projection == nil){
        //     [NSException raise:@"No Projection" format:@"No projection was set which is required to determine the zoom level"];
        // }
        // GPKGBoundingBox * boundingBox = [self getBoundingBox];
        // if([self.projection.epsg intValue] == PROJ_EPSG_WORLD_GEODETIC_SYSTEM){
        //     boundingBox = [GPKGTileBoundingBoxUtils boundWgs84BoundingBoxWithWebMercatorLimits:boundingBox];
        // }
        // GPKGProjectionTransform * webMercatorTransform = [[GPKGProjectionTransform alloc] initWithFromProjection:self.projection andToEpsg:PROJ_EPSG_WEB_MERCATOR];
        // GPKGBoundingBox * webMercatorBoundingBox = [webMercatorTransform transformWithBoundingBox:boundingBox];
        // int zoomLevel = [GPKGTileBoundingBoxUtils getZoomLevelWithWebMercatorBoundingBox:webMercatorBoundingBox];
        // return zoomLevel;
    };
    /**
     * Get count of all rows in this table
     * @return {Number}
     */
    UserDao.prototype.getCount = function () {
        return this.connection.count(this.table_name);
    };
    /**
     * Reads the table specified from the geopackage
     * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
     * @param  {string} tableName       table name
     * @return {module:user/userDao~UserDao}
     */
    UserDao.readTable = function (geoPackage, tableName) {
        var reader = new userTableReader_1.UserTableReader(tableName);
        var userTable = reader.readTable(geoPackage.database);
        return new UserDao(geoPackage, userTable);
    };
    return UserDao;
}(dao_1.Dao));
exports.UserDao = UserDao;
//# sourceMappingURL=userDao.js.map