/**
 * userTableReader module.
 * @module user/userTableReader
 */
import { UserTable } from './userTable';
import { UserColumn } from './userColumn';
import { DBValue } from '../db/dbAdapter';
import { GeoPackageConnection } from '../db/geoPackageConnection';
/**
 * @class
 */
export declare class UserTableReader {
    table_name: string;
    requiredColumns?: string[];
    private static readonly GPKG_UTR_CID;
    private static readonly GPKG_UTR_NAME;
    private static readonly GPKG_UTR_TYPE;
    private static readonly GPKG_UTR_NOT_NULL;
    private static readonly GPKG_UTR_PK;
    private static readonly GPKG_UTR_DFLT_VALUE;
    /**
     * @param tableName name of the table
     * @param requiredColumns array of the required column nammes
     */
    constructor(table_name: string, requiredColumns?: string[]);
    /**
     * Read the table
     * @param  {object} db db connection
     * @return {module:user/userTable~UserTable}
     */
    readTable(db: GeoPackageConnection): UserTable;
    /**
     * Creates a user column
     * @param {Number} index        column index
     * @param {string} name         column name
     * @param {module:db/dataTypes~GPKGDataType} type         data type
     * @param {Number} max max value
     * @param {Boolean} notNull      not null
     * @param {Object} defaultValue default value or nil
     * @param {Boolean} primaryKey primary key
     * @return {module:user/custom~UserCustomColumn}
     */
    createColumn(index: number, name: string, type: string, max?: number, notNull?: boolean, defaultValue?: DBValue, primaryKey?: boolean): UserColumn;
    /**
     * Create the table
     * @param  {string} tableName table name
     * @param  {module:dao/columnValues~ColumnValues[]} columns   columns
     * @param  {string[]} [requiredColumns] required columns
     * @return {module:user/userTable~UserTable}           the user table
     *
     */
    createTable(tableName: string, columns: UserColumn[], requiredColumns?: string[]): UserTable;
}
