"use strict";
/**
 * WKB module.
 * @module wkb
 */
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var WKB = /** @class */ (function () {
    function WKB() {
    }
    /**
     * number from name
     * @param  {string} name name
     * @return {Number}      number corresponding to the wkb name
     */
    WKB.fromName = function (name) {
        name = name.toUpperCase();
        if (name === 'GEOMETRY') {
            return WKB.typeMap.wkb.GeometryCollection;
        }
        return WKB.wktToEnum[name];
    };
    WKB.typeMap = {
        wkt: {
            Point: 'POINT',
            LineString: 'LINESTRING',
            Polygon: 'POLYGON',
            MultiPoint: 'MULTIPOINT',
            MultiLineString: 'MULTILINESTRING',
            MultiPolygon: 'MULTIPOLYGON',
            GeometryCollection: 'GEOMETRYCOLLECTION',
        },
        wkb: {
            Point: 1,
            LineString: 2,
            Polygon: 3,
            MultiPoint: 4,
            MultiLineString: 5,
            MultiPolygon: 6,
            GeometryCollection: 7,
        },
    };
    WKB.wktToEnum = (_a = {},
        _a[WKB.typeMap.wkt.Point] = WKB.typeMap.wkb.Point,
        _a[WKB.typeMap.wkt.LineString] = WKB.typeMap.wkb.LineString,
        _a[WKB.typeMap.wkt.Polygon] = WKB.typeMap.wkb.Polygon,
        _a[WKB.typeMap.wkt.MultiPoint] = WKB.typeMap.wkb.MultiPoint,
        _a[WKB.typeMap.wkt.MultiLineString] = WKB.typeMap.wkb.MultiLineString,
        _a[WKB.typeMap.wkt.MultiPolygon] = WKB.typeMap.wkb.MultiPolygon,
        _a[WKB.typeMap.wkt.GeometryCollection] = WKB.typeMap.wkb.GeometryCollection,
        _a);
    return WKB;
}());
exports.WKB = WKB;
//# sourceMappingURL=index.js.map