(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.geopackage = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var crsWkt_1 = __importDefault(require("./lib/extension/crsWkt"));
exports.CrsWktExtension = crsWkt_1.default;
var geoPackageConnection_1 = __importDefault(require("./lib/db/geoPackageConnection"));
exports.GeoPackageConnection = geoPackageConnection_1.default;
var webp_1 = __importDefault(require("./lib/extension/webp"));
exports.WebPExtension = webp_1.default;
var rtreeIndex_1 = __importDefault(require("./lib/extension/rtree/rtreeIndex"));
exports.RTreeIndex = rtreeIndex_1.default;
var metadata_1 = __importDefault(require("./lib/extension/metadata"));
exports.MetadataExtension = metadata_1.default;
var dataColumnsDao_1 = __importDefault(require("./lib/dataColumns/dataColumnsDao"));
exports.DataColumnsDao = dataColumnsDao_1.default;
var mediaTable_1 = __importDefault(require("./lib/extension/relatedTables/mediaTable"));
exports.MediaTable = mediaTable_1.default;
var userMappingTable_1 = __importDefault(require("./lib/extension/relatedTables/userMappingTable"));
exports.UserMappingTable = userMappingTable_1.default;
var dataColumnConstraintsDao_1 = __importDefault(require("./lib/dataColumnConstraints/dataColumnConstraintsDao"));
exports.DataColumnConstraintsDao = dataColumnConstraintsDao_1.default;
var featureColumn_1 = __importDefault(require("./lib/features/user/featureColumn"));
exports.FeatureColumn = featureColumn_1.default;
var userColumn_1 = __importDefault(require("./lib/user/userColumn"));
exports.UserColumn = userColumn_1.default;
var tileColumn_1 = __importDefault(require("./lib/tiles/user/tileColumn"));
exports.TileColumn = tileColumn_1.default;
var dataColumns_1 = __importDefault(require("./lib/dataColumns/dataColumns"));
exports.DataColumns = dataColumns_1.default;
var dataTypes_1 = __importDefault(require("./lib/db/dataTypes"));
exports.DataTypes = dataTypes_1.default;
var schema_1 = __importDefault(require("./lib/extension/schema"));
exports.SchemaExtension = schema_1.default;
var geometryColumns_1 = __importDefault(require("./lib/features/columns/geometryColumns"));
exports.GeometryColumns = geometryColumns_1.default;
var metadataReference_1 = __importDefault(require("./lib/metadata/reference/metadataReference"));
exports.MetadataReference = metadataReference_1.default;
var geometryData_1 = require("./lib/geom/geometryData");
exports.GeometryData = geometryData_1.GeometryData;
var tableCreator_1 = require("./lib/db/tableCreator");
exports.TableCreator = tableCreator_1.TableCreator;
var dublinCoreType_1 = require("./lib/extension/relatedTables/dublinCoreType");
exports.DublinCoreType = dublinCoreType_1.DublinCoreType;
var boundingBox_1 = require("./lib/boundingBox");
exports.BoundingBox = boundingBox_1.BoundingBox;
var api_1 = require("./lib/api");
exports.GeoPackage = api_1.GeoPackageAPI;
var proj4Defs = require('./lib/proj4Defs');
exports.proj4Defs = proj4Defs;
var GeoPackageTileRetriever = require('./lib/tiles/retriever');
exports.GeoPackageTileRetriever = GeoPackageTileRetriever;
var TileUtilities = require('./lib/tiles/creator/tileUtilities');
exports.TileUtilities = TileUtilities;
var Metadata = require('./lib/metadata/metadata');
exports.Metadata = Metadata;
var FeatureTiles = require('./lib/tiles/features');
exports.FeatureTiles = FeatureTiles;
var NumberFeaturesTile = require('./lib/tiles/features/custom/numberFeaturesTile');
exports.NumberFeaturesTile = NumberFeaturesTile;
var ShadedFeaturesTile = require('./lib/tiles/features/custom/shadedFeaturesTile');
exports.ShadedFeaturesTile = ShadedFeaturesTile;

},{"./lib/api":2,"./lib/boundingBox":7,"./lib/dataColumnConstraints/dataColumnConstraintsDao":15,"./lib/dataColumns/dataColumns":16,"./lib/dataColumns/dataColumnsDao":17,"./lib/db/dataTypes":18,"./lib/db/geoPackageConnection":19,"./lib/db/tableCreator":23,"./lib/extension/crsWkt":28,"./lib/extension/metadata":36,"./lib/extension/relatedTables/dublinCoreType":37,"./lib/extension/relatedTables/mediaTable":43,"./lib/extension/relatedTables/userMappingTable":50,"./lib/extension/rtree/rtreeIndex":52,"./lib/extension/schema":54,"./lib/extension/webp":72,"./lib/features/columns/geometryColumns":73,"./lib/features/user/featureColumn":75,"./lib/geom/geometryData":83,"./lib/metadata/metadata":84,"./lib/metadata/reference/metadataReference":86,"./lib/proj4Defs":89,"./lib/tiles/creator/tileUtilities":94,"./lib/tiles/features":102,"./lib/tiles/features/custom/numberFeaturesTile":97,"./lib/tiles/features/custom/shadedFeaturesTile":98,"./lib/tiles/retriever":109,"./lib/tiles/user/tileColumn":112,"./lib/user/userColumn":121}],2:[function(require,module,exports){
(function (process){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var geoPackage_1 = __importDefault(require("./geoPackage"));
var geoPackageConnection_1 = __importDefault(require("./db/geoPackageConnection"));
var dataColumnsDao_1 = __importDefault(require("./dataColumns/dataColumnsDao"));
var mediaTable_1 = __importDefault(require("./extension/relatedTables/mediaTable"));
var simpleAttributesTable_1 = __importDefault(require("./extension/relatedTables/simpleAttributesTable"));
var relationType_1 = __importDefault(require("./extension/relatedTables/relationType"));
var userColumn_1 = __importDefault(require("./user/userColumn"));
var featureColumn_1 = __importDefault(require("./features/user/featureColumn"));
var dataColumns_1 = __importDefault(require("./dataColumns/dataColumns"));
var dataTypes_1 = __importDefault(require("./db/dataTypes"));
var geometryColumns_1 = __importDefault(require("./features/columns/geometryColumns"));
var geometryData_1 = require("./geom/geometryData");
var retriever_1 = require("./tiles/retriever");
var tileBoundingBoxUtils_1 = require("./tiles/tileBoundingBoxUtils");
var boundingBox_1 = require("./boundingBox");
var geoPackageValidate_1 = require("./validate/geoPackageValidate");
var features_1 = require("./tiles/features");
var wkx_1 = __importDefault(require("wkx"));
var reproject_1 = __importDefault(require("reproject"));
var path_1 = __importDefault(require("path"));
var fs_1 = __importDefault(require("fs"));
var geojson_vt_1 = __importDefault(require("geojson-vt"));
var vt_pbf_1 = __importDefault(require("vt-pbf"));
var pbf_1 = __importDefault(require("pbf"));
var vector_tile_1 = __importDefault(require("@mapbox/vector-tile"));
var point_to_line_distance_1 = __importDefault(require("@turf/point-to-line-distance"));
var polygon_to_line_1 = __importDefault(require("@turf/polygon-to-line"));
var boolean_point_in_polygon_1 = __importDefault(require("@turf/boolean-point-in-polygon"));
var distance_1 = __importDefault(require("@turf/distance"));
var helpers = __importStar(require("@turf/helpers"));
/**
 * This module is the entry point to the GeoPackage API, providing static
 * methods for opening and building GeoPackage files.
 */
var GeoPackageAPI = /** @class */ (function () {
    function GeoPackageAPI() {
    }
    /**
     * In Node, open a GeoPackage file at the given path, or in a browser, load an
     * in-memory GeoPackage from the given byte array.
     * @param  {String|Uint8Array|Buffer} gppathOrByteArray path to the GeoPackage file or `Uint8Array` of GeoPackage bytes
     * @return {Promise<GeoPackage>} promise that resolves with the open {@link module:geoPackage~GeoPackage} object or rejects with an `Error`
     */
    GeoPackageAPI.open = function (gppathOrByteArray) {
        return __awaiter(this, void 0, void 0, function () {
            var valid, connection, geoPackage;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        valid = (typeof gppathOrByteArray !== 'string') || (typeof gppathOrByteArray === 'string' &&
                            (gppathOrByteArray.indexOf('http') === 0 || !geoPackageValidate_1.GeoPackageValidate.validateGeoPackageExtension(gppathOrByteArray)));
                        if (!valid) {
                            throw new Error('Invalid GeoPackage - Invalid GeoPackage Extension');
                        }
                        return [4 /*yield*/, geoPackageConnection_1.default.connect(gppathOrByteArray)];
                    case 1:
                        connection = _a.sent();
                        if (gppathOrByteArray && typeof gppathOrByteArray === 'string') {
                            geoPackage = new geoPackage_1.default(path_1.default.basename(gppathOrByteArray), gppathOrByteArray, connection);
                        }
                        else {
                            geoPackage = new geoPackage_1.default('geopackage', undefined, connection);
                        }
                        if (geoPackageValidate_1.GeoPackageValidate.hasMinimumTables(geoPackage)) {
                            return [2 /*return*/, geoPackage];
                        }
                        else {
                            throw new Error('Invalid GeoPackage - GeoPackage does not have the minimum required tables');
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * In Node, create a GeoPackage file at the given file path, or in a browser,
     * create an in-memory GeoPackage.
     * @param  {String} gppath path of the created GeoPackage file; ignored in the browser
     * @return {Promise<typeof GeoPackage>} promise that resolves with the open {@link module:geoPackage~GeoPackage} object or rejects with an  `Error`
     */
    GeoPackageAPI.create = function (gppath) {
        return __awaiter(this, void 0, void 0, function () {
            var valid, connection, geopackage;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        valid = (typeof gppath !== 'string') || (typeof gppath === 'string' && !geoPackageValidate_1.GeoPackageValidate.validateGeoPackageExtension(gppath));
                        if (!valid) {
                            throw new Error('Invalid GeoPackage');
                        }
                        if (typeof (process) !== 'undefined' && process.version && gppath) {
                            try {
                                fs_1.default.mkdirSync(path_1.default.dirname(gppath));
                            }
                            catch (e) {
                                // it's fine if we can't create the directory
                            }
                        }
                        return [4 /*yield*/, geoPackageConnection_1.default.connect(gppath)];
                    case 1:
                        connection = _a.sent();
                        connection.setApplicationId();
                        if (gppath) {
                            geopackage = new geoPackage_1.default(path_1.default.basename(gppath), gppath, connection);
                        }
                        else {
                            geopackage = new geoPackage_1.default('geopackage', undefined, connection);
                        }
                        return [4 /*yield*/, geopackage.createRequiredTables()];
                    case 2:
                        _a.sent();
                        geopackage.createSupportedExtensions();
                        return [2 /*return*/, geopackage];
                }
            });
        });
    };
    /**
     * Create the [tables and rows](https://www.geopackage.org/spec121/index.html#tiles)
     * necessary to store tiles according to the ubiquitous [XYZ web/slippy-map tiles](https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames) scheme.
     * The extent for the [contents table]{@link module:core/contents~Contents} row,
     * `contentsBoundingBox`, is [informational only](https://www.geopackage.org/spec121/index.html#gpkg_contents_cols),
     * and need not match the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet}
     * extent, `tileMatrixSetBoundingBox`, which should be the precise bounding box
     * used to calculate the tile row and column coordinates of all tiles in the
     * tile set.  The two SRS ID parameters, `contentsSrsId` and `tileMatrixSetSrsId`,
     * must match, however.  See {@link module:tiles/matrixset~TileMatrixSet} for
     * more information about how GeoPackage consumers use the bouding boxes for a
     * tile set.
     *
     * @param {module:geoPackage~GeoPackage} geopackage the GeoPackage that will store the tiles
     * @param {string} tableName the name of the table that will store the tiles
     * @param {BoundingBox} contentsBoundingBox the bounds stored in the [`gpkg_contents`]{@link module:core/contents~Contents} table row for the tile matrix set
     * @param {SRSRef} contentsSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}; must match `tileMatrixSetSrsId`
     * @param {BoundingBox} tileMatrixSetBoundingBox the bounds stored in the [`gpkg_tile_matrix_set`]{@link module:tiles/matrixset~TileMatrixSet} table row
     * @param {SRSRef} tileMatrixSetSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}
     *   for the [tile matrix set](https://www.geopackage.org/spec121/index.html#_tile_matrix_set) table; must match `contentsSrsId`
     * @param {number} minZoom the zoom level of the lowest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
     * @param {number} maxZoom the zoom level of the highest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
     * @param tileSize the width and height in pixels of the tile images; defaults to 256
     * @returns {Promise} a `Promise` that resolves with the created {@link module:tiles/matrixset~TileMatrixSet} object, or rejects with an `Error`
     *
     * @todo make `tileMatrixSetSrsId` optional because it always has to be the same anyway
     */
    GeoPackageAPI.createStandardWebMercatorTileTable = function (geopackage, tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId, minZoom, maxZoom, tileSize) {
        if (tileSize === void 0) { tileSize = 256; }
        return __awaiter(this, void 0, void 0, function () {
            var tileMatrixSet;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, geopackage.createTileTableWithTableName(tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId)];
                    case 1:
                        tileMatrixSet = _a.sent();
                        geopackage.createStandardWebMercatorTileMatrix(tileMatrixSetBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize);
                        return [2 /*return*/, tileMatrixSet];
                }
            });
        });
    };
    GeoPackageAPI.createFeatureTable = function (geopackage, tableName, geometryColumn, featureColumns) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, GeoPackageAPI.createFeatureTableWithDataColumns(geopackage, tableName, geometryColumn, featureColumns, null)];
            });
        });
    };
    ;
    GeoPackageAPI.createFeatureTableWithDataColumns = function (geopackage, tableName, geometryColumn, featureColumns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var boundingBox;
            return __generator(this, function (_a) {
                boundingBox = new boundingBox_1.BoundingBox(-180, 180, -90, 90);
                return [2 /*return*/, GeoPackageAPI.createFeatureTableWithDataColumnsAndBoundingBox(geopackage, tableName, geometryColumn, featureColumns, dataColumns, boundingBox, 4326)];
            });
        });
    };
    ;
    GeoPackageAPI.createFeatureTableWithDataColumnsAndBoundingBox = function (geopackage, tableName, geometryColumn, featureColumns, dataColumns, boundingBox, boundingBoxSrsId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, geopackage.createFeatureTableWithGeometryColumnsAndDataColumns(geometryColumn, boundingBox, boundingBoxSrsId, featureColumns, dataColumns)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, geopackage.getFeatureDao(tableName)];
                }
            });
        });
    };
    /**
     * Create a feature table with the properties specified.
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @return {Promise}
     */
    GeoPackageAPI.createFeatureTableWithProperties = function (geopackage, tableName, properties) {
        return __awaiter(this, void 0, void 0, function () {
            var geometryColumns, boundingBox, columns, columnNumber, i, property;
            return __generator(this, function (_a) {
                geometryColumns = new geometryColumns_1.default();
                geometryColumns.table_name = tableName;
                geometryColumns.column_name = 'geometry';
                geometryColumns.geometry_type_name = 'GEOMETRY';
                geometryColumns.z = 0;
                geometryColumns.m = 0;
                boundingBox = new boundingBox_1.BoundingBox(-180, 180, -80, 80);
                columns = [];
                columnNumber = 0;
                columns.push(featureColumn_1.default.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
                columns.push(featureColumn_1.default.createGeometryColumn(columnNumber++, 'geometry', 'GEOMETRY', false, null));
                for (i = 0; i < properties.length; i++) {
                    property = properties[i];
                    columns.push(featureColumn_1.default.createColumnWithIndex(columnNumber++, property.name, dataTypes_1.default.fromName(property.dataType)));
                }
                return [2 /*return*/, geopackage.createFeatureTableWithGeometryColumns(geometryColumns, boundingBox, 4326, columns)];
            });
        });
    };
    ;
    /**
     * Create a feature table with the properties specified.
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param tableName name of the table to create
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @param {DataColumns} [properties.dataColumn] data column for the property
     * @return {Promise}
     */
    GeoPackageAPI.createAttributeTableWithProperties = function (geopackage, tableName, properties) {
        return __awaiter(this, void 0, void 0, function () {
            var columns, columnNumber, dataColumns, i, property, dc;
            return __generator(this, function (_a) {
                columns = [];
                columnNumber = 0;
                columns.push(userColumn_1.default.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
                dataColumns = [];
                for (i = 0; i < properties.length; i++) {
                    property = properties[i];
                    columns.push(userColumn_1.default.createColumnWithIndex(columnNumber++, property.name, dataTypes_1.default.fromName(property.dataType)));
                    if (property.dataColumn) {
                        dc = new dataColumns_1.default();
                        dc.table_name = property.dataColumn.table_name;
                        dc.column_name = property.dataColumn.column_name;
                        dc.name = property.dataColumn.name;
                        dc.title = property.dataColumn.title;
                        dc.description = property.dataColumn.description;
                        dc.mime_type = property.dataColumn.mime_type;
                        dc.constraint_name = property.dataColumn.constraint_name;
                        dataColumns.push(dc);
                    }
                }
                return [2 /*return*/, geopackage.createAttributeTable(tableName, columns, dataColumns)];
            });
        });
    };
    ;
    GeoPackageAPI.addAttributeRow = function (geopackage, tableName, row) {
        var attributeDao = geopackage.getAttributeDaoWithTableName(tableName);
        var attributeRow = attributeDao.getRow(row);
        return attributeDao.create(attributeRow);
    };
    ;
    /**
     * Create a simple attributes table with the properties specified.
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @return {Promise}
     */
    GeoPackageAPI.createSimpleAttributesTableWithProperties = function (geopackage, tableName, properties) {
        var relatedTables = geopackage.getRelatedTablesExtension();
        var columns = [];
        var columnNumber = simpleAttributesTable_1.default.numRequiredColumns();
        if (properties) {
            for (var i = 0; i < properties.length; i++) {
                var property = properties[i];
                columns.push(userColumn_1.default.createColumnWithIndex(columnNumber++, property.name, dataTypes_1.default.fromName(property.dataType), true));
            }
        }
        var simpleAttributesTable = simpleAttributesTable_1.default.create(tableName, columns);
        relatedTables.createRelatedTable(simpleAttributesTable);
        return relatedTables.getSimpleAttributesDao(simpleAttributesTable);
    };
    ;
    /**
     * Create a media table with the properties specified.  These properties are added to the required columns
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @return {Promise}
     */
    GeoPackageAPI.createMediaTableWithProperties = function (geopackage, tableName, properties) {
        var relatedTables = geopackage.getRelatedTablesExtension();
        var columns = [];
        var columnNumber = mediaTable_1.default.numRequiredColumns();
        if (properties) {
            for (var i = 0; i < properties.length; i++) {
                var property = properties[i];
                columns.push(userColumn_1.default.createColumnWithIndex(columnNumber++, property.name, dataTypes_1.default.fromName(property.dataType)));
            }
        }
        var mediaTable = mediaTable_1.default.create(tableName, columns);
        relatedTables.createRelatedTable(mediaTable);
        return relatedTables.getMediaDao(mediaTable);
    };
    ;
    GeoPackageAPI.addMedia = function (geopackage, tableName, dataBuffer, contentType, additionalProperties) {
        var relatedTables = geopackage.getRelatedTablesExtension();
        var mediaDao = relatedTables.getMediaDao(tableName);
        var row = mediaDao.newRow();
        row.setContentType(contentType);
        row.setData(dataBuffer);
        for (var key in additionalProperties) {
            row.setValueWithColumnName(key, additionalProperties[key]);
        }
        return mediaDao.create(row);
    };
    ;
    GeoPackageAPI.linkMedia = function (geopackage, baseTableName, baseId, mediaTableName, mediaId) {
        return __awaiter(this, void 0, void 0, function () {
            var relatedTables;
            return __generator(this, function (_a) {
                relatedTables = geopackage.getRelatedTablesExtension();
                return [2 /*return*/, relatedTables.linkRelatedIds(baseTableName, baseId, mediaTableName, mediaId, relationType_1.default.MEDIA)];
            });
        });
    };
    GeoPackageAPI.getLinkedMedia = function (geopackage, baseTableName, baseId) {
        var relationships = GeoPackageAPI.getRelatedRows(geopackage, baseTableName, baseId);
        var mediaRelationships = [];
        for (var i = 0; i < relationships.length; i++) {
            var relationship = relationships[i];
            if (relationship.relation_name === relationType_1.default.MEDIA.name) {
                for (var r = 0; r < relationship.mappingRows.length; r++) {
                    var row = relationship.mappingRows[r].row;
                    mediaRelationships.push(row);
                }
            }
        }
        return mediaRelationships;
    };
    ;
    GeoPackageAPI.getRelatedRows = function (geopackage, baseTableName, baseId) {
        return geopackage.getRelatedTablesExtension().getRelatedRows(baseTableName, baseId);
    };
    ;
    /**
     * Adds a GeoJSON feature to the GeoPackage
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {object}   feature    GeoJSON feature to add
     * @param  {String}   tableName  name of the table that will store the feature
     */
    GeoPackageAPI.addGeoJSONFeatureToGeoPackage = function (geopackage, feature, tableName) {
        var featureDao = geopackage.getFeatureDao(tableName);
        var srs = featureDao.getSrs();
        var featureRow = featureDao.newRow();
        var geometryData = new geometryData_1.GeometryData();
        geometryData.setSrsId(srs.srs_id);
        if (!(srs.organization === 'EPSG' && srs.organization_coordsys_id === 4326)) {
            feature = reproject_1.default.reproject(feature, 'EPSG:4326', featureDao.projection);
        }
        var featureGeometry = typeof feature.geometry === 'string' ? JSON.parse(feature.geometry) : feature.geometry;
        var geometry = wkx_1.default.Geometry.parseGeoJSON(featureGeometry);
        geometryData.setGeometry(geometry);
        featureRow.setGeometry(geometryData);
        for (var propertyKey in feature.properties) {
            if (Object.prototype.hasOwnProperty.call(feature.properties, propertyKey)) {
                featureRow.setValueWithColumnName(propertyKey, feature.properties[propertyKey]);
            }
        }
        return featureDao.create(featureRow);
    };
    ;
    /**
     * Adds a GeoJSON feature to the GeoPackage and updates the FeatureTableIndex extension if it exists
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {object}   feature    GeoJSON feature to add
     * @param  {String}   tableName  name of the table that will store the feature
     */
    GeoPackageAPI.addGeoJSONFeatureToGeoPackageAndIndex = function (geopackage, feature, tableName) {
        var featureDao = geopackage.getFeatureDao(tableName);
        if (!featureDao)
            throw new Error('No feature Dao for table ' + tableName);
        var srs = featureDao.getSrs();
        var featureRow = featureDao.newRow();
        var geometryData = new geometryData_1.GeometryData();
        geometryData.setSrsId(srs.srs_id);
        var reprojectedFeature = reproject_1.default.reproject(feature, 'EPSG:4326', featureDao.projection);
        var featureGeometry = typeof reprojectedFeature.geometry === 'string' ? JSON.parse(reprojectedFeature.geometry) : reprojectedFeature.geometry;
        var geometry = wkx_1.default.Geometry.parseGeoJSON(featureGeometry);
        geometryData.setGeometry(geometry);
        featureRow.setGeometry(geometryData);
        for (var propertyKey in feature.properties) {
            if (Object.prototype.hasOwnProperty.call(feature.properties, propertyKey)) {
                featureRow.setValueWithColumnName(propertyKey, feature.properties[propertyKey]);
            }
        }
        var id = featureDao.create(featureRow);
        var fti = featureDao.featureTableIndex;
        var tableIndex = fti.getTableIndex();
        if (!tableIndex)
            return id;
        fti.indexRow(tableIndex, id, geometryData);
        fti.updateLastIndexed(tableIndex);
        return id;
    };
    ;
    /**
     * Queries for GeoJSON features in a feature tables
     * @param  {String}   geoPackagePath  path to the GeoPackage file
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     */
    GeoPackageAPI.queryForGeoJSONFeaturesInTableFromPath = function (geoPackagePath, tableName, boundingBox) {
        return __awaiter(this, void 0, void 0, function () {
            var geoPackage, features;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, GeoPackageAPI.open(geoPackagePath)];
                    case 1:
                        geoPackage = _a.sent();
                        features = geoPackage.queryForGeoJSONFeaturesInTable(tableName, boundingBox);
                        geoPackage.close();
                        return [2 /*return*/, features];
                }
            });
        });
    };
    /**
     * Queries for GeoJSON features in a feature tables
     * @param  {module:geoPackage~GeoPackage}   geoPackage  open GeoPackage object
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     */
    GeoPackageAPI.queryForGeoJSONFeaturesInTable = function (geoPackage, tableName, boundingBox) {
        return geoPackage.queryForGeoJSONFeaturesInTable(tableName, boundingBox);
    };
    ;
    /**
     * Iterates GeoJSON features in a feature table that matches the bounding box
     * @param  {module:geoPackage~GeoPackage}   geoPackage  open GeoPackage object
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     */
    GeoPackageAPI.iterateGeoJSONFeaturesInTableWithinBoundingBox = function (geoPackage, tableName, boundingBox) {
        return geoPackage.iterateGeoJSONFeaturesInTableWithinBoundingBox(tableName, boundingBox);
    };
    ;
    /**
     * Iterates GeoJSON features in a feature table that matches the bounding box
     * @param  {String}   geoPackagePath  path to the GeoPackage file
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     */
    GeoPackageAPI.iterateGeoJSONFeaturesFromPathInTableWithinBoundingBox = function (geoPackagePath, tableName, boundingBox) {
        return __awaiter(this, void 0, void 0, function () {
            var geoPackage;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, GeoPackageAPI.open(geoPackagePath)];
                    case 1:
                        geoPackage = _a.sent();
                        return [2 /*return*/, geoPackage.iterateGeoJSONFeaturesInTableWithinBoundingBox(tableName, boundingBox)];
                }
            });
        });
    };
    GeoPackageAPI.createDataColumnMap = function (featureDao) {
        var columnMap = {};
        var dcd = new dataColumnsDao_1.default(featureDao.geoPackage);
        featureDao.table.columns.forEach(function (column) {
            var dataColumn = dcd.getDataColumns(featureDao.table.table_name, column.name);
            columnMap[column.name] = {
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType ? dataTypes_1.default.nameFromType(column.dataType) : '',
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn
            };
        }.bind(this));
        return columnMap;
    };
    ;
    /**
     * @typedef {Object} GeoJSONFeatureIterator
     * @property {SpatialReferenceSystem} srs SRS of the iterator
     * @property {FeatureDao} featureDao featureDao of the iterator objects
     * @property {IterableIterator<FeatureRow>} results iterator of results
     */
    /**
     * Iterate GeoJSON features from table
     * @param  {module:geoPackage~GeoPackage} geopackage      open GeoPackage object
     * @param  {String} table           Table name to Iterate
     * @return {GeoJSONFeatureIterator}
     */
    GeoPackageAPI.iterateGeoJSONFeaturesFromTable = function (geopackage, table) {
        var _a;
        var featureDao = geopackage.getFeatureDao(table);
        if (!featureDao) {
            throw new Error('No Table exists with the name ' + table);
        }
        var columnMap = GeoPackageAPI.createDataColumnMap(featureDao);
        var srs = featureDao.getSrs();
        var iterator = featureDao.queryForEach();
        return {
            srs: srs,
            featureDao: featureDao,
            results: (_a = {},
                _a[Symbol.iterator] = function () {
                    return this;
                },
                _a.next = function () {
                    var nextRow = iterator.next();
                    if (!nextRow.done) {
                        var featureRow;
                        var geometry;
                        while (!nextRow.done && !geometry) {
                            featureRow = featureDao.getRow(nextRow.value);
                            return {
                                value: GeoPackageAPI.parseFeatureRowIntoGeoJSON(featureRow, srs, columnMap),
                                done: false
                            };
                        }
                    }
                    return {
                        value: undefined,
                        done: true
                    };
                }.bind(this),
                _a)
        };
    };
    ;
    /**
     * Gets a GeoJSON feature from the table by id
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the table to get the feature from
     * @param  {Number}   featureId  ID of the feature
     */
    GeoPackageAPI.getFeature = function (geopackage, table, featureId) {
        var featureDao = geopackage.getFeatureDao(table);
        var srs = featureDao.getSrs();
        var feature = featureDao.queryForId(featureId);
        if (!feature) {
            var features = featureDao.queryForAllEq('_feature_id', featureId);
            if (features.length) {
                feature = featureDao.getRow(features[0]);
            }
            else {
                features = featureDao.queryForAllEq('_properties_id', featureId);
                if (features.length) {
                    feature = featureDao.getRow(features[0]);
                }
            }
        }
        if (feature) {
            return GeoPackageAPI.parseFeatureRowIntoGeoJSON(feature, srs);
        }
    };
    ;
    // eslint-disable-next-line complexity
    GeoPackageAPI.parseFeatureRowIntoGeoJSON = function (featureRow, srs, columnMap) {
        var geoJson = {
            type: "Feature",
            properties: {},
            id: undefined,
            geometry: undefined
        };
        var geometry = featureRow.getGeometry();
        if (geometry && geometry.geometry) {
            var geoJsonGeom = geometry.geometry.toGeoJSON();
            if (srs.definition && srs.definition !== 'undefined' && (srs.organization.toUpperCase() + ':' + srs.organization_coordsys_id) !== 'EPSG:4326') {
                geoJsonGeom = reproject_1.default.reproject(geoJsonGeom, srs.getProjection(), 'EPSG:4326');
            }
            geoJson.geometry = geoJsonGeom;
        }
        for (var key in featureRow.values) {
            if (Object.prototype.hasOwnProperty.call(featureRow.values, key) && key !== featureRow.getGeometryColumn().name && key !== 'id') {
                if (key.toLowerCase() === '_feature_id') {
                    geoJson.id = featureRow.values[key];
                }
                else if (key.toLowerCase() === '_properties_id') {
                    geoJson.properties[key.substring(12)] = featureRow.values[key];
                }
                else if (columnMap && columnMap[key]) {
                    geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
                }
                else {
                    geoJson.properties[key] = featureRow.values[key];
                }
            }
            else if (featureRow.getGeometryColumn().name === key) {
                // geoJson.properties[key] = geometry && !geometry.geometryError ? 'Valid' : geometry.geometryError;
            }
        }
        geoJson.id = geoJson.id || featureRow.getId();
        return geoJson;
    };
    ;
    /**
     * Gets a tile from the specified table
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the table to get the tile from
     * @param  {Number}   zoom       zoom level of the tile
     * @param  {Number}   tileRow    row of the tile
     * @param  {Number}   tileColumn column of the tile
     *
     * @todo jsdoc return value
     */
    GeoPackageAPI.getTileFromTable = function (geopackage, table, zoom, tileRow, tileColumn) {
        var tileDao = geopackage.getTileDao(table);
        return tileDao.queryForTile(tileColumn, tileRow, zoom);
    };
    ;
    /**
     * Gets the tiles in the EPSG:4326 bounding box
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the tile table
     * @param  {Number}   zoom       Zoom of the tiles to query for
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackageAPI.getTilesInBoundingBox = function (geopackage, table, zoom, west, east, south, north) {
        var e_1, _a;
        var tiles = {
            columns: [],
            srs: undefined,
            tiles: [],
            west: undefined,
            east: undefined,
            south: undefined,
            north: undefined,
            zoom: undefined
        };
        var tileDao = geopackage.getTileDao(table);
        if (zoom < tileDao.minZoom || zoom > tileDao.maxZoom) {
            return;
        }
        for (var i = 0; i < tileDao.table.columns.length; i++) {
            var column = tileDao.table.columns[i];
            tiles.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey
            });
        }
        var srs = tileDao.getSrs();
        tiles.srs = srs;
        tiles.tiles = [];
        var tms = tileDao.tileMatrixSet;
        var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
        if (!tm) {
            return tiles;
        }
        var mapBoundingBox = new boundingBox_1.BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
        tiles.west = Math.max(-180, west).toFixed(2);
        tiles.east = Math.min(east, 180).toFixed(2);
        tiles.south = south.toFixed(2);
        tiles.north = north.toFixed(2);
        tiles.zoom = zoom;
        mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);
        var grid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.getBoundingBox(), tm.matrix_width, tm.matrix_height, mapBoundingBox);
        var iterator = tileDao.queryByTileGrid(grid, zoom);
        try {
            for (var iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next(); !iterator_1_1.done; iterator_1_1 = iterator_1.next()) {
                var row = iterator_1_1.value;
                var tile = {};
                tile.tableName = table;
                tile.id = row.getId();
                var tileBB = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileBoundingBox(tms.getBoundingBox(), tm, row.getTileColumn(), row.getRow());
                tile.minLongitude = tileBB.minLongitude;
                tile.maxLongitude = tileBB.maxLongitude;
                tile.minLatitude = tileBB.minLatitude;
                tile.maxLatitude = tileBB.maxLatitude;
                tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
                tile.values = [];
                for (i = 0; i < tiles.columns.length; i++) {
                    var value = row.values[tiles.columns[i].name];
                    if (tiles.columns[i].name === 'tile_data') {
                        tile.values.push('data');
                    }
                    else if (value === null || value === 'null') {
                        tile.values.push('');
                    }
                    else {
                        tile.values.push(value.toString());
                        tile[tiles.columns[i].name] = value;
                    }
                }
                tiles.tiles.push(tile);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return tiles;
    };
    ;
    /**
     * Gets the tiles in the EPSG:4326 bounding box
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the tile table
     * @param  {Number}   webZoom       Zoom of the tiles to query for
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackageAPI.getTilesInBoundingBoxWebZoom = function (geopackage, table, webZoom, west, east, south, north) {
        var e_2, _a;
        var tiles = {
            columns: [],
            srs: undefined,
            tiles: [],
            west: undefined,
            east: undefined,
            south: undefined,
            north: undefined,
            zoom: undefined
        };
        var tileDao = geopackage.getTileDao(table);
        if (webZoom < tileDao.minWebMapZoom || webZoom > tileDao.minWebMapZoom) {
            return;
        }
        tiles.columns = [];
        for (var i = 0; i < tileDao.table.columns.length; i++) {
            var column = tileDao.table.columns[i];
            tiles.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey
            });
        }
        var srs = tileDao.getSrs();
        tiles.srs = srs;
        tiles.tiles = [];
        var zoom = tileDao.webZoomToGeoPackageZoom(webZoom);
        var tms = tileDao.tileMatrixSet;
        var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
        if (!tm) {
            return tiles;
        }
        var mapBoundingBox = new boundingBox_1.BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
        tiles.west = Math.max(-180, west).toFixed(2);
        tiles.east = Math.min(east, 180).toFixed(2);
        tiles.south = south.toFixed(2);
        tiles.north = north.toFixed(2);
        tiles.zoom = zoom;
        mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);
        var grid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.getBoundingBox(), tm.matrix_width, tm.matrix_height, mapBoundingBox);
        var iterator = tileDao.queryByTileGrid(grid, zoom);
        try {
            for (var iterator_2 = __values(iterator), iterator_2_1 = iterator_2.next(); !iterator_2_1.done; iterator_2_1 = iterator_2.next()) {
                var row = iterator_2_1.value;
                var tile = {
                    tableName: undefined,
                    id: undefined,
                    minLongitude: undefined,
                    maxLongitude: undefined,
                    minLatitude: undefined,
                    maxLatitude: undefined,
                    projection: undefined,
                    values: []
                };
                tile.tableName = table;
                tile.id = row.getId();
                var tileBB = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileBoundingBox(tms.getBoundingBox(), tm, row.getTileColumn(), row.getRow());
                tile.minLongitude = tileBB.minLongitude;
                tile.maxLongitude = tileBB.maxLongitude;
                tile.minLatitude = tileBB.minLatitude;
                tile.maxLatitude = tileBB.maxLatitude;
                tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
                tile.values = [];
                for (i = 0; i < tiles.columns.length; i++) {
                    var value = row.values[tiles.columns[i].name];
                    if (tiles.columns[i].name === 'tile_data') {
                        tile.values.push('data');
                    }
                    else if (value === null || value === 'null') {
                        tile.values.push('');
                    }
                    else {
                        tile.values.push(value.toString());
                        tile[tiles.columns[i].name] = value;
                    }
                }
                tiles.tiles.push(tile);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (iterator_2_1 && !iterator_2_1.done && (_a = iterator_2.return)) _a.call(iterator_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return tiles;
    };
    ;
    GeoPackageAPI.getFeatureTileFromXYZ = function (geopackage, table, x, y, z, width, height) {
        x = Number(x);
        y = Number(y);
        z = Number(z);
        width = Number(width);
        height = Number(height);
        var featureDao = geopackage.getFeatureDao(table);
        if (!featureDao)
            return;
        var ft = new features_1.FeatureTiles(featureDao, width, height);
        return ft.drawTile(x, y, z);
    };
    ;
    GeoPackageAPI.getClosestFeatureInXYZTile = function (geopackage, table, x, y, z, latitude, longitude) {
        var e_3, _a;
        x = Number(x);
        y = Number(y);
        z = Number(z);
        var featureDao = geopackage.getFeatureDao(table);
        if (!featureDao)
            return;
        var ft = new features_1.FeatureTiles(featureDao, 256, 256);
        var tileCount = ft.getFeatureCountXYZ(x, y, z);
        var boundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
        boundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
        if (tileCount > 10000) {
            // too many, send back the entire tile
            // add the goepackage name and table
            var gj = boundingBox.toGeoJSON();
            gj.feature_count = tileCount;
            gj.coverage = true;
            gj.gp_table = table;
            gj.gp_name = geopackage.name;
            return gj;
        }
        var ne = [boundingBox.maxLongitude, boundingBox.maxLatitude];
        var sw = [boundingBox.minLongitude, boundingBox.minLatitude];
        var width = (ne[0] - sw[0]);
        var widthPerPixel = width / 256;
        var tolerance = 10 * widthPerPixel;
        boundingBox.maxLongitude = longitude + tolerance;
        boundingBox.minLongitude = longitude - tolerance;
        boundingBox.maxLatitude = latitude + tolerance;
        boundingBox.minLatitude = latitude - tolerance;
        var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
        var features = [];
        var closestDistance = 100000000000;
        var closest;
        var centerPoint = helpers.point([longitude, latitude]);
        try {
            for (var iterator_3 = __values(iterator), iterator_3_1 = iterator_3.next(); !iterator_3_1.done; iterator_3_1 = iterator_3.next()) {
                var feature = iterator_3_1.value;
                feature.type = "Feature";
                var geometry = feature.geometry;
                if (geometry.type === 'Point') {
                    var distance = distance_1.default(centerPoint, geometry);
                    if (distance < closestDistance) {
                        closest = feature;
                        closestDistance = distance;
                    }
                    else if (distance === closestDistance && closest.type !== 'Point') {
                        closest = feature;
                        closestDistance = distance;
                    }
                }
                else if (geometry.type === 'LineString') {
                    distance = point_to_line_distance_1.default(centerPoint, geometry);
                    if (distance < closestDistance) {
                        closest = feature;
                        closestDistance = distance;
                    }
                    else if (distance === closestDistance && closest.type !== 'Point') {
                        closest = feature;
                        closestDistance = distance;
                    }
                }
                else if (geometry.type === 'MultiLineString') {
                    geometry.coordinates.forEach(function (lineString) {
                        var distance = point_to_line_distance_1.default(centerPoint, helpers.lineString(lineString));
                        if (distance < closestDistance) {
                            closest = feature;
                            closestDistance = distance;
                        }
                    });
                }
                else if (geometry.type === 'Polygon') {
                    if (boolean_point_in_polygon_1.default(centerPoint, geometry)) {
                        if (closestDistance !== 0) {
                            closest = feature;
                            closestDistance = 0;
                        }
                    }
                    else {
                        var line = polygon_to_line_1.default(geometry);
                        // @ts-ignore
                        if (line.geometry.type === 'LineString') {
                            // @ts-ignore
                            distance = point_to_line_distance_1.default(centerPoint, line);
                            if (distance < closestDistance) {
                                closest = feature;
                                closestDistance = distance;
                            }
                            // @ts-ignore
                        }
                        else if (line.geometry.type === 'MultiLineString') {
                            // @ts-ignore
                            line.geometry.coordinates.forEach(function (lineString) {
                                var distance = point_to_line_distance_1.default(centerPoint, lineString);
                                if (distance < closestDistance) {
                                    closest = feature;
                                    closestDistance = distance;
                                }
                            });
                        }
                    }
                }
                else if (geometry.type === 'MultiPolygon') {
                    if (boolean_point_in_polygon_1.default(centerPoint, geometry)) {
                        if (closestDistance !== 0) {
                            closest = feature;
                            closestDistance = 0;
                        }
                    }
                    else {
                        line = polygon_to_line_1.default(geometry);
                        if (line.type === 'FeatureCollection') {
                            line.features.forEach(function (line) {
                                if (line.geometry.type === 'LineString') {
                                    // @ts-ignore
                                    distance = point_to_line_distance_1.default(centerPoint, line);
                                    if (distance < closestDistance) {
                                        closest = feature;
                                        closestDistance = distance;
                                    }
                                }
                                else if (line.geometry.type === 'MultiLineString') {
                                    line.geometry.coordinates.forEach(function (lineString) {
                                        // @ts-ignore
                                        distance = point_to_line_distance_1.default(centerPoint, lineString);
                                        if (distance < closestDistance) {
                                            closest = feature;
                                            closestDistance = distance;
                                        }
                                    });
                                }
                            });
                        }
                        else {
                            if (line.geometry.type === 'LineString') {
                                // @ts-ignore
                                distance = point_to_line_distance_1.default(centerPoint, line);
                                if (distance < closestDistance) {
                                    closest = feature;
                                    closestDistance = distance;
                                }
                            }
                            else if (line.geometry.type === 'MultiLineString') {
                                line.geometry.coordinates.forEach(function (lineString) {
                                    // @ts-ignore
                                    distance = point_to_line_distance_1.default(centerPoint, lineString);
                                    if (distance < closestDistance) {
                                        closest = feature;
                                        closestDistance = distance;
                                    }
                                });
                            }
                        }
                    }
                }
                features.push(feature);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (iterator_3_1 && !iterator_3_1.done && (_a = iterator_3.return)) _a.call(iterator_3);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (closest) {
            closest.gp_table = table;
            closest.gp_name = geopackage.name;
            closest.distance = closestDistance;
        }
        return closest;
    };
    ;
    /**
     * Gets the features in the EPSG:3857 tile
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the feature table
     * @param  {Number}   x       x tile number
     * @param  {Number}   y       y tile number
     * @param  {Number}   z      z tile number
     * @param  {Boolean}   [skipVerification]      skip the extra verification to determine if the feature really is within the tile
     */
    GeoPackageAPI.getGeoJSONFeaturesInTile = function (geopackage, table, x, y, z, skipVerification) {
        if (skipVerification === void 0) { skipVerification = false; }
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, bb, featureDao, features, iterator, iterator_4, iterator_4_1, feature;
            var e_4, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
                        bb = webMercatorBoundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
                        return [4 /*yield*/, geopackage.indexFeatureTable(table)];
                    case 1:
                        _b.sent();
                        featureDao = geopackage.getFeatureDao(table);
                        if (!featureDao)
                            return [2 /*return*/];
                        features = [];
                        iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(bb, skipVerification);
                        try {
                            for (iterator_4 = __values(iterator), iterator_4_1 = iterator_4.next(); !iterator_4_1.done; iterator_4_1 = iterator_4.next()) {
                                feature = iterator_4_1.value;
                                features.push(feature);
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (iterator_4_1 && !iterator_4_1.done && (_a = iterator_4.return)) _a.call(iterator_4);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                        return [2 /*return*/, features];
                }
            });
        });
    };
    GeoPackageAPI.convertPBFToVectorTile = function (pbf) {
        return new vector_tile_1.default.VectorTile(new pbf_1.default(pbf));
    };
    ;
    /**
     * Gets a mapbox VectorTile for the x y z web mercator tile specified
     * @param  {module:geoPackage~GeoPackage} geopackage open GeoPackage object
     * @param  {String} table      table name
     * @param  {Number} x          x tile
     * @param  {Number} y          y tile
     * @param  {Number} z          web zoom
     * @return {typeof VectorTile}
     */
    GeoPackageAPI.getVectorTile = function (geopackage, table, x, y, z) {
        return __awaiter(this, void 0, void 0, function () {
            var pbf;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, GeoPackageAPI.getVectorTileProtobuf(geopackage, table, x, y, z)];
                    case 1:
                        pbf = _a.sent();
                        return [2 /*return*/, new vector_tile_1.default.VectorTile(new pbf_1.default(pbf))];
                }
            });
        });
    };
    ;
    /**
     * Gets a protobuf for the x y z web mercator tile specified
     * @param  {module:geoPackage~GeoPackage} geopackage open GeoPackage object
     * @param  {String} table      table name
     * @param  {Number} x          x tile
     * @param  {Number} y          y tile
     * @param  {Number} z          web zoom
     * @return {any}
     */
    GeoPackageAPI.getVectorTileProtobuf = function (geopackage, table, x, y, z) {
        return __awaiter(this, void 0, void 0, function () {
            var features, featureCollection, tileBuffer, tileIndex, tile, gjvt;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, GeoPackageAPI.getGeoJSONFeaturesInTile(geopackage, table, x, y, z, true)];
                    case 1:
                        features = _a.sent();
                        featureCollection = {
                            type: 'FeatureCollection',
                            features: features
                        };
                        tileBuffer = 8;
                        tileIndex = geojson_vt_1.default(featureCollection, { buffer: tileBuffer * 8, maxZoom: z });
                        tile = tileIndex.getTile(z, x, y);
                        gjvt = {};
                        if (tile) {
                            gjvt[table] = tile;
                        }
                        else {
                            gjvt[table] = { features: [] };
                        }
                        return [2 /*return*/, vt_pbf_1.default.fromGeojsonVt(gjvt)];
                }
            });
        });
    };
    /**
     * Gets the features in the EPSG:4326 bounding box
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the feature table
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackageAPI.getFeaturesInBoundingBox = function (geopackage, table, west, east, south, north) {
        return __awaiter(this, void 0, void 0, function () {
            var featureDao, bb, iterator;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, geopackage.indexFeatureTable(table)];
                    case 1:
                        _a.sent();
                        featureDao = geopackage.getFeatureDao(table);
                        if (!featureDao)
                            throw new Error('Unable to find table ' + table);
                        bb = new boundingBox_1.BoundingBox(west, east, south, north);
                        iterator = featureDao.queryIndexedFeaturesWithBoundingBox(bb);
                        return [2 /*return*/, iterator];
                }
            });
        });
    };
    ;
    /**
     * Gets a tile image for an XYZ tile pyramid location
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the table containing the tiles
     * @param  {Number}   x          x index of the tile
     * @param  {Number}   y          y index of the tile
     * @param  {Number}   z          zoom level of the tile
     * @param  {Number}   width      width of the resulting tile
     * @param  {Number}   height     height of the resulting tile
     * @return {Promise}
     */
    GeoPackageAPI.getTileFromXYZ = function (geopackage, table, x, y, z, width, height) {
        return __awaiter(this, void 0, void 0, function () {
            var tileDao, retriever;
            return __generator(this, function (_a) {
                x = Number(x);
                y = Number(y);
                z = Number(z);
                width = Number(width);
                height = Number(height);
                tileDao = geopackage.getTileDao(table);
                retriever = new retriever_1.GeoPackageTileRetriever(tileDao, width, height);
                return [2 /*return*/, retriever.getTile(x, y, z)];
            });
        });
    };
    ;
    /**
     * Draws an XYZ tile pyramid location into the provided canvas
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the table containing the tiles
     * @param  {Number}   x          x index of the tile
     * @param  {Number}   y          y index of the tile
     * @param  {Number}   z          zoom level of the tile
     * @param  {Number}   width      width of the resulting tile
     * @param  {Number}   height     height of the resulting tile
     * @param  {any}   canvas     canvas element to draw the tile into
     */
    GeoPackageAPI.drawXYZTileInCanvas = function (geopackage, table, x, y, z, width, height, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var tileDao, retriever;
            return __generator(this, function (_a) {
                x = Number(x);
                y = Number(y);
                z = Number(z);
                width = Number(width);
                height = Number(height);
                tileDao = geopackage.getTileDao(table);
                retriever = new retriever_1.GeoPackageTileRetriever(tileDao, width, height);
                return [2 /*return*/, retriever.drawTileIn(x, y, z, canvas)];
            });
        });
    };
    ;
    /**
     * Draws a tile specified by the bounds in EPSG:4326 into the canvas
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {String}   table      name of the table containing the tiles
     * @param  {Number}   minLat     minimum latitude bounds of tile
     * @param  {Number}   minLon     minimum longitude bounds of tile
     * @param  {Number}   maxLat     maximum latitude bounds of tile
     * @param  {Number}   maxLon     maximum longitude bounds of tile
     * @param  {Number}   z          zoom level of the tile
     * @param  {Number}   width      width of the resulting tile
     * @param  {Number}   height     height of the resulting tile
     * @param  {any}   canvas     canvas element to draw the tile into
     */
    GeoPackageAPI.draw4326TileInCanvas = function (geopackage, table, minLat, minLon, maxLat, maxLon, z, width, height, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var tileDao, retriever, bounds;
            return __generator(this, function (_a) {
                z = Number(z);
                width = Number(width);
                height = Number(height);
                tileDao = geopackage.getTileDao(table);
                retriever = new retriever_1.GeoPackageTileRetriever(tileDao, width, height);
                bounds = new boundingBox_1.BoundingBox(minLon, maxLon, minLat, maxLat);
                return [2 /*return*/, retriever.getTileWithWgs84BoundsInProjection(bounds, z, 'EPSG:4326', canvas)];
            });
        });
    };
    ;
    return GeoPackageAPI;
}());
exports.GeoPackageAPI = GeoPackageAPI;

}).call(this,require('_process'))
},{"./boundingBox":7,"./dataColumns/dataColumns":16,"./dataColumns/dataColumnsDao":17,"./db/dataTypes":18,"./db/geoPackageConnection":19,"./extension/relatedTables/mediaTable":43,"./extension/relatedTables/relationType":44,"./extension/relatedTables/simpleAttributesTable":47,"./features/columns/geometryColumns":73,"./features/user/featureColumn":75,"./geoPackage":80,"./geom/geometryData":83,"./tiles/features":102,"./tiles/retriever":109,"./tiles/tileBoundingBoxUtils":110,"./user/userColumn":121,"./validate/geoPackageValidate":126,"@mapbox/vector-tile":129,"@turf/boolean-point-in-polygon":134,"@turf/distance":137,"@turf/helpers":138,"@turf/point-to-line-distance":144,"@turf/polygon-to-line":145,"_process":318,"fs":192,"geojson-vt":260,"path":310,"pbf":311,"reproject":334,"vt-pbf":392,"wkx":407}],3:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module attributes/attributeDao
 */
var userDao_1 = __importDefault(require("../user/userDao"));
var attributeRow_1 = __importDefault(require("./attributeRow"));
/**
 * Attribute DAO for reading attribute user data tables
 * @class AttributeDao
 * @extends UserDao
 * @param  {module:geoPackage~GeoPackage} geoPackage              geopackage object
 * @param  {module:attributes/attributeTable~AttributeTable} table           attribute table
 */
var AttributeDao = /** @class */ (function (_super) {
    __extends(AttributeDao, _super);
    function AttributeDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        if (!table.contents) {
            throw new Error('Attributes table has null Contents');
        }
        _this.contents = table.contents;
        return _this;
    }
    /**
     * Create a new attribute row with the column types and values
     * @param  {Array} columnTypes column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:attributes/attributeRow~AttributeRow}             attribute row
     */
    AttributeDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new attributeRow_1.default(this.table, columnTypes, values);
    };
    /**
     * Create a new attribute row
     * @return {module:attributes/attributeRow~AttributeRow} attribute row
     */
    AttributeDao.prototype.newRow = function () {
        return new attributeRow_1.default(this.table);
    };
    return AttributeDao;
}(userDao_1.default));
exports.default = AttributeDao;

},{"../user/userDao":122,"./attributeRow":4}],4:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = __importDefault(require("../user/userRow"));
/**
 * AttributeRow module.
 * @module attributes/attributeRow
 */
/**
 * Attribute Row containing the values from a single result set row
 * @class AttributeRow
 * @param  {module:attributes/attributeTable~AttributeTable} attributeTable attribute table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var AttributeRow = /** @class */ (function (_super) {
    __extends(AttributeRow, _super);
    function AttributeRow(attributeTable, columnTypes, values) {
        return _super.call(this, attributeTable, columnTypes, values) || this;
    }
    return AttributeRow;
}(userRow_1.default));
exports.default = AttributeRow;

},{"../user/userRow":123}],5:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module attributes/attributeTable
 */
var contentsDao_1 = __importDefault(require("../core/contents/contentsDao"));
var userTable_1 = __importDefault(require("../user/userTable"));
/**
 * Represents a user attribute table
 * @class AttributeTable
 * @extends UserTable
 * @constructor
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 */
var AttributeTable = /** @class */ (function (_super) {
    __extends(AttributeTable, _super);
    function AttributeTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        /**
         * Contents of this AttributeTable
         * @member {module:core/contents~Contents}
         */
        _this.contents;
        return _this;
    }
    /**
     * Set the contents
     * @param  {module:core/contents~Contents} contents the contents
     */
    AttributeTable.prototype.setContents = function (contents) {
        this.contents = contents;
        if (contents.data_type !== contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME) {
            throw new Error('The Contents of an Attributes Table must have a data type of ' + contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME);
        }
    };
    return AttributeTable;
}(userTable_1.default));
exports.default = AttributeTable;

},{"../core/contents/contentsDao":9,"../user/userTable":124}],6:[function(require,module,exports){
"use strict";
/**
 * attributeTableReader module.
 * @module attributes/attributeTableReader
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userTableReader_1 = __importDefault(require("../user/userTableReader"));
var attributeTable_1 = __importDefault(require("./attributeTable"));
/**
* Reads the metadata from an existing attribute table
* @class AttributeTableReader
* @extends UserTableReader
* @classdesc Reads the metadata from an existing attributes table
*/
var AttributeTableReader = /** @class */ (function (_super) {
    __extends(AttributeTableReader, _super);
    function AttributeTableReader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @inheritdoc
     */
    AttributeTableReader.prototype.createTable = function (tableName, columns) {
        return new attributeTable_1.default(tableName, columns);
    };
    return AttributeTableReader;
}(userTableReader_1.default));
exports.default = AttributeTableReader;

},{"../user/userTableReader":125,"./attributeTable":5}],7:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var proj4_1 = __importDefault(require("proj4"));
/**
 * Create a new bounding box
 * @class BoundingBox
 */
var BoundingBox = /** @class */ (function () {
    /**
     * @param  {BoundingBox | Number} minLongitudeOrBoundingBox minimum longitude or bounding box to copy (west)
     * @param  {Number} [maxLongitude]              maximum longitude (east)
     * @param  {Number} [minLatitude]               Minimum latitude (south)
     * @param  {Number} [maxLatitude]               Maximum latitude (north)
     */
    function BoundingBox(minLongitudeOrBoundingBox, maxLongitude, minLatitude, maxLatitude) {
        // if there is a second argument the first argument is the minLongitude
        if (minLongitudeOrBoundingBox instanceof BoundingBox) {
            var boundingBox = minLongitudeOrBoundingBox;
            this.minLongitude = boundingBox.minLongitude;
            this.maxLongitude = boundingBox.maxLongitude;
            this.minLatitude = boundingBox.minLatitude;
            this.maxLatitude = boundingBox.maxLatitude;
        }
        else {
            this.minLongitude = minLongitudeOrBoundingBox;
            this.maxLongitude = maxLongitude;
            this.minLatitude = minLatitude;
            this.maxLatitude = maxLatitude;
        }
    }
    /**
     * Build a Geometry Envelope from the bounding box
     *
     * @return geometry envelope
     */
    BoundingBox.prototype.buildEnvelope = function () {
        return {
            minY: this.minLatitude,
            minX: this.minLongitude,
            maxY: this.maxLatitude,
            maxX: this.maxLongitude
        };
    };
    BoundingBox.prototype.toGeoJSON = function () {
        return {
            "type": "Feature",
            "properties": {},
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [this.minLongitude, this.minLatitude],
                        [this.maxLongitude, this.minLatitude],
                        [this.maxLongitude, this.maxLatitude],
                        [this.minLongitude, this.maxLatitude],
                        [this.minLongitude, this.minLatitude]
                    ]
                ]
            }
        };
    };
    /**
     * Determine if equal to the provided bounding box
     * @param  {BoundingBox} boundingBox bounding boundingBox
     * @return {Boolean}             true if equal, false if not
     */
    BoundingBox.prototype.equals = function (boundingBox) {
        if (!boundingBox) {
            return false;
        }
        if (this === boundingBox) {
            return true;
        }
        return this.maxLatitude === boundingBox.maxLatitude
            && this.minLatitude === boundingBox.minLatitude
            && this.maxLongitude === boundingBox.maxLongitude
            && this.maxLatitude === boundingBox.maxLatitude;
    };
    /**
     * Project the bounding box into a new projection
     *
     * @param {string} from
     * @param {string} to
     * @return {BoundingBox}
     */
    BoundingBox.prototype.projectBoundingBox = function (from, to) {
        if (from && from !== 'undefined' && to && to !== 'undefined') {
            if (to.toUpperCase && to.toUpperCase() === 'EPSG:3857' && from.toUpperCase && from.toUpperCase() === 'EPSG:4326') {
                this.maxLatitude = Math.min(this.maxLatitude, 85.0511);
                this.minLatitude = Math.max(this.minLatitude, -85.0511);
                this.minLongitude = Math.max(this.minLongitude, -180.0);
                this.maxLongitude = Math.min(this.maxLongitude, 180.0);
            }
            var min = proj4_1.default(from, to, [this.minLongitude, this.minLatitude]);
            var max = proj4_1.default(from, to, [this.maxLongitude, this.maxLatitude]);
            var projected = new BoundingBox(min[0], max[0], min[1], max[1]);
            return projected;
        }
        return this;
    };
    return BoundingBox;
}());
exports.BoundingBox = BoundingBox;

},{"proj4":319}],8:[function(require,module,exports){
"use strict";
/**
 * Contents module.
 * @module core/contents
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The Contents class models rows in the [`gpkg_contents`](https://www.geopackage.org/spec121/index.html#_contents)
 * table.  The contents table stores identifying and descriptive information
 * that an application can display to a user in a menu of geospatial data
 * available in a GeoPackage.
 * @class Contents
 * @see https://www.geopackage.org/spec121/index.html#_contents
 */
var Contents = /** @class */ (function () {
    function Contents() {
    }
    return Contents;
}());
exports.default = Contents;

},{}],9:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var tileMatrixDao_1 = __importDefault(require("../../tiles/matrix/tileMatrixDao"));
var tileMatrixSetDao_1 = __importDefault(require("../../tiles/matrixset/tileMatrixSetDao"));
var geometryColumnsDao_1 = __importDefault(require("../../features/columns/geometryColumnsDao"));
var contents_1 = __importDefault(require("./contents"));
var columnValues_1 = __importDefault(require("../../dao/columnValues"));
/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class ContentsDao
 * @extends Dao
 */
var ContentsDao = /** @class */ (function (_super) {
    __extends(ContentsDao, _super);
    function ContentsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ContentsDao.TABLE_NAME;
        _this.idColumns = [ContentsDao.COLUMN_PK];
        return _this;
    }
    /**
     * Creates a new Contents object
     * @return {module:core/contents~Contents} new Contents object
     */
    ContentsDao.prototype.createObject = function () {
        return new contents_1.default();
    };
    /**
     * Get table names by table type
     * @param  {string} [tableType] table type to query for
     * @return {string[]}           Array of table names
     */
    ContentsDao.prototype.getTables = function (tableType) {
        var results;
        if (tableType) {
            var fieldValues = new columnValues_1.default();
            fieldValues.addColumn(ContentsDao.COLUMN_DATA_TYPE, tableType);
            results = this.queryForColumns('table_name', fieldValues);
        }
        else {
            results = this.queryForColumns('table_name');
        }
        var tableNames = [];
        for (var i = 0; i < results.length; i++) {
            tableNames.push(results[i].table_name);
        }
        return tableNames;
    };
    /**
     * Returns the proj4 projection for the Contents
     * @param  {module:core/contents~Contents} contents Contents to get the projection from
     * @return {*}          proj4 projection
     */
    ContentsDao.prototype.getProjection = function (contents) {
        var srs = this.getSrs(contents);
        var srsDao = this.geoPackage.getSpatialReferenceSystemDao();
        return srsDao.getProjection(srs);
    };
    /**
     * Get the SpatialReferenceSystemDao for the Contents
     * @param  {module:core/contents~Contents} contents Contents to get the SpatialReferenceSystemDao from
     * @return {module:core/srs~SpatialReferenceSystemDao}
     */
    ContentsDao.prototype.getSrs = function (contents) {
        var dao = this.geoPackage.getSpatialReferenceSystemDao();
        return dao.queryForId(contents.srs_id);
    };
    /**
     * Get the GeometryColumns for the Contents
     * @param  {module:core/contents~Contents} contents Contents
     * @return {module:features/columns~GeometryColumns}
     */
    ContentsDao.prototype.getGeometryColumns = function (contents) {
        var dao = this.geoPackage.getGeometryColumnsDao();
        var results = dao.queryForAllEq(geometryColumnsDao_1.default.COLUMN_TABLE_NAME, contents.table_name);
        if (!results || !results.length)
            return;
        var gc = dao.createObject();
        dao.populateObjectFromResult(gc, results[0]);
        return gc;
    };
    /**
     * Get the TileMatrixSet for the Contents
     * @param  {module:core/contents~Contents} contents Contents
     * @return {module:tiles/matrixset~TileMatrixSet}
     */
    ContentsDao.prototype.getTileMatrixSet = function (contents) {
        var dao = this.geoPackage.getTileMatrixSetDao();
        var results = dao.queryForAllEq(tileMatrixSetDao_1.default.COLUMN_TABLE_NAME, contents.table_name);
        if (!results || !results.length)
            return;
        var gc = dao.createObject();
        dao.populateObjectFromResult(gc, results[0]);
        return gc;
    };
    /**
     * Get the TileMatrix for the Contents
     * @param  {module:core/contents~Contents} contents Contents
     * @return {module:tiles/matrix~TileMatrix}
     */
    ContentsDao.prototype.getTileMatrix = function (contents) {
        var dao = this.geoPackage.getTileMatrixDao();
        var results = dao.queryForAllEq(tileMatrixDao_1.default.COLUMN_TABLE_NAME, contents.table_name);
        if (!results || !results.length)
            return;
        var tileMatricies = [];
        for (var i = 0; i < results.length; i++) {
            var gc = dao.createObject();
            dao.populateObjectFromResult(gc, results[i]);
            tileMatricies.push(gc);
        }
        return tileMatricies;
    };
    ContentsDao.TABLE_NAME = "gpkg_contents";
    ContentsDao.COLUMN_PK = "table_name";
    ContentsDao.COLUMN_TABLE_NAME = "table_name";
    ContentsDao.COLUMN_DATA_TYPE = "data_type";
    ContentsDao.COLUMN_IDENTIFIER = "identifier";
    ContentsDao.COLUMN_DESCRIPTION = "description";
    ContentsDao.COLUMN_LAST_CHANGE = "last_change";
    ContentsDao.COLUMN_MIN_X = "min_x";
    ContentsDao.COLUMN_MIN_Y = "min_y";
    ContentsDao.COLUMN_MAX_X = "max_x";
    ContentsDao.COLUMN_MAX_Y = "max_y";
    ContentsDao.COLUMN_SRS_ID = "srs_id";
    ContentsDao.GPKG_CDT_FEATURES_NAME = "features";
    ContentsDao.GPKG_CDT_TILES_NAME = "tiles";
    ContentsDao.GPKG_CDT_ATTRIBUTES_NAME = "attributes";
    return ContentsDao;
}(dao_1.default));
exports.default = ContentsDao;

},{"../../dao/columnValues":12,"../../dao/dao":13,"../../features/columns/geometryColumnsDao":74,"../../tiles/matrix/tileMatrixDao":106,"../../tiles/matrixset/tileMatrixSetDao":108,"./contents":8}],10:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable camelcase */
/**
 * SpatialReferenceSystem module.
 * @module core/srs
 */
var proj4_1 = __importDefault(require("proj4"));
/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class SpatialReferenceSystem
 */
var SpatialReferenceSystem = /** @class */ (function () {
    function SpatialReferenceSystem() {
    }
    /**
     * Return the proj4 projection specified by this SpatialReferenceSystem
     * @return {*}
     */
    SpatialReferenceSystem.prototype.getProjection = function () {
        if (this.organization === 'NONE')
            return {};
        if (this.organization_coordsys_id === 4326 && (this.organization === 'EPSG' || this.organization === 'epsg')) {
            return proj4_1.default('EPSG:4326');
        }
        else if (this.definition_12_063 && this.definition_12_063 !== '' && this.definition_12_063 !== 'undefined') {
            return proj4_1.default(this.definition_12_063);
        }
        else if (this.definition && this.definition !== '' && this.definition !== 'undefined') {
            return proj4_1.default(this.definition);
        }
        else if (this.organization && this.organization_coordsys_id) {
            return proj4_1.default(this.organization.toUpperCase() + ':' + this.organization_coordsys_id);
        }
        return {};
    };
    SpatialReferenceSystem.TABLE_NAME = 'gpkg_spatial_ref_sys';
    return SpatialReferenceSystem;
}());
exports.default = SpatialReferenceSystem;

},{"proj4":319}],11:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var spatialReferenceSystem_1 = __importDefault(require("./spatialReferenceSystem"));
/**
 * Spatial Reference System Data Access Object
 * @extends Dao
 * @class SpatialReferenceSystemDao
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
var SpatialReferenceSystemDao = /** @class */ (function (_super) {
    __extends(SpatialReferenceSystemDao, _super);
    function SpatialReferenceSystemDao(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.idColumns = [SpatialReferenceSystemDao.COLUMN_SRS_ID];
        /**
         * Table Name
         * @type {String}
         */
        _this.gpkgTableName = SpatialReferenceSystemDao.TABLE_NAME;
        return _this;
    }
    /**
     * Create a new SpatialReferenceSystem object
     * @return {module:core/srs~SpatialReferenceSystem}
     */
    SpatialReferenceSystemDao.prototype.createObject = function () {
        return new spatialReferenceSystem_1.default();
    };
    /**
     * Get the Spatial Reference System for the provided id
     * @param  {Number}   srsId srs id
     * @return {module:core/srs~SpatialReferenceSystem}
     */
    SpatialReferenceSystemDao.prototype.getBySrsId = function (srsId) {
        return this.queryForId(srsId);
    };
    /**
     * Return the proj4 projection specified by this SpatialReferenceSystem
     * @return {typeof proj4}
     */
    SpatialReferenceSystemDao.prototype.getProjection = function (srs) {
        return srs.getProjection();
    };
    /**
     * Creates the required EPSG WGS84 Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    SpatialReferenceSystemDao.prototype.createWgs84 = function () {
        var srs = this.getBySrsId(4326);
        if (srs) {
            return srs;
        }
        srs = new spatialReferenceSystem_1.default();
        srs.srs_name = 'WGS 84 geodetic';
        srs.srs_id = 4326;
        srs.organization = 'EPSG';
        srs.organization_coordsys_id = 4326;
        srs.definition = 'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]';
        srs.description = 'longitude/latitude coordinates in decimal degrees on the WGS 84 spheroid';
        if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
            srs.definition_12_063 = 'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]';
        }
        return this.create(srs);
    };
    /**
     * Creates the required Undefined Cartesian Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    SpatialReferenceSystemDao.prototype.createUndefinedCartesian = function () {
        var srs = this.getBySrsId(-1);
        if (srs) {
            return srs;
        }
        srs = new spatialReferenceSystem_1.default();
        srs.srs_name = 'Undefined cartesian SRS';
        srs.srs_id = -1;
        srs.organization = 'NONE';
        srs.organization_coordsys_id = -1;
        srs.definition = 'undefined';
        srs.description = 'undefined cartesian coordinate reference system';
        if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
            srs.definition_12_063 = 'undefined';
        }
        return this.create(srs);
    };
    /**
     * Creates the required Undefined Geographic Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    SpatialReferenceSystemDao.prototype.createUndefinedGeographic = function () {
        var srs = this.getBySrsId(0);
        if (srs) {
            return srs;
        }
        srs = new spatialReferenceSystem_1.default();
        srs.srs_name = 'Undefined geographic SRS';
        srs.srs_id = 0;
        srs.organization = 'NONE';
        srs.organization_coordsys_id = 0;
        srs.definition = 'undefined';
        srs.description = 'undefined geographic coordinate reference system';
        if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
            srs.definition_12_063 = 'undefined';
        }
        return this.create(srs);
    };
    /**
     * Creates the Web Mercator Spatial Reference System if it does not already
     * exist
     * @return {Number} id of the created row
     */
    SpatialReferenceSystemDao.prototype.createWebMercator = function () {
        var srs = this.getBySrsId(3857);
        if (srs) {
            return srs;
        }
        srs = new spatialReferenceSystem_1.default();
        srs.srs_name = 'WGS 84 / Pseudo-Mercator';
        srs.srs_id = 3857;
        srs.organization = 'EPSG';
        srs.organization_coordsys_id = 3857;
        srs.definition = 'PROJCS["WGS 84 / Pseudo-Mercator",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Mercator_1SP"],PARAMETER["central_meridian",0],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],EXTENSION["PROJ4","+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs"],AUTHORITY["EPSG","3857"]]';
        srs.description = 'Spherical Mercator projection coordinate system';
        if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
            srs.definition_12_063 = 'PROJCS["WGS 84 / Pseudo-Mercator",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Mercator_1SP"],PARAMETER["central_meridian",0],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],EXTENSION["PROJ4","+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs"],AUTHORITY["EPSG","3857"]]';
        }
        return this.create(srs);
    };
    /**
     * Spatial Reference System Table Name
     * @type {String}
     */
    SpatialReferenceSystemDao.TABLE_NAME = 'gpkg_spatial_ref_sys';
    /**
     * srsName field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_SRS_NAME = "srs_name";
    /**
     * srsId field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_SRS_ID = "srs_id";
    /**
     * id field name, srsId
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_ID = SpatialReferenceSystemDao.COLUMN_SRS_ID;
    /**
     * organization field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_ORGANIZATION = "organization";
    /**
     * organizationCoordsysId field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_ORGANIZATION_COORDSYS_ID = "organization_coordsys_id";
    /**
     * definition field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_DEFINITION = "definition";
    /**
     * description field name
     * @type {String}
     */
    SpatialReferenceSystemDao.COLUMN_DESCRIPTION = "description";
    return SpatialReferenceSystemDao;
}(dao_1.default));
exports.default = SpatialReferenceSystemDao;

},{"../../dao/dao":13,"./spatialReferenceSystem":10}],12:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module dao/columnValues
 */
/**
 * Structure to define columns in a table
 * @class ColumnValues
 */
var ColumnValues = /** @class */ (function () {
    function ColumnValues() {
        this.values = {};
        this.columns = [];
    }
    /**
     * adds a column to the structure
     * @param  {string} columnName  name of column to add
     * @param  {module:user/userColumn~UserColumn} column column to add
     */
    ColumnValues.prototype.addColumn = function (columnName, column) {
        this.columns.push(columnName);
        this.values[columnName] = column;
    };
    /**
     * Gets the column by name
     * @param  {string} columnName name of column
     * @return {module:user/userColumn~UserColumn}            user column
     */
    ColumnValues.prototype.getValue = function (columnName) {
        return this.values[columnName];
    };
    return ColumnValues;
}());
exports.default = ColumnValues;

},{}],13:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var columnValues_1 = __importDefault(require("./columnValues"));
/**
 * Dao module.
 */
var sqliteQueryBuilder_1 = require("../db/sqliteQueryBuilder");
/**
 * Base DAO
 * @class Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
var Dao = /** @class */ (function () {
    function Dao(geoPackage) {
        this.geoPackage = geoPackage;
        this.connection = geoPackage.getDatabase();
    }
    /**
     * Copies object properties from result object to the object
     * @param  {Object} object object to copy properties to
     * @param  {Object} result object to copy properties from
     */
    Dao.prototype.populateObjectFromResult = function (object, result) {
        if (!result)
            return;
        for (var key in result) {
            object[key] = result[key];
        }
    };
    /**
     * Checks if the table exists
     */
    Dao.prototype.isTableExists = function () {
        var results = this.connection.isTableExists(this.gpkgTableName);
        return !!results;
    };
    /**
     * Refreshes the object by id
     * @param object object to refresh
     */
    Dao.prototype.refresh = function (object) {
        return this.queryForSameId(object);
    };
    /**
     * Query for object by id
     * @param  id ID of the object to query for
     * @return object created from the raw database object
     */
    Dao.prototype.queryForId = function (id) {
        var whereString = this.buildPkWhere(id);
        var whereArgs = this.buildPkWhereArgs(id);
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
        var result = this.connection.get(query, whereArgs);
        if (!result)
            return;
        var object = this.createObject(result);
        // TOOD something is wrong here
        this.populateObjectFromResult(object, result);
        return object;
    };
    Dao.prototype.queryForSameId = function (object) {
        var idArray = this.getMultiId(object);
        return this.queryForMultiId(idArray);
    };
    Dao.prototype.getMultiId = function (object) {
        var idValues = [];
        for (var i = 0; i < this.idColumns.length; i++) {
            var idValue = object.values ? object.values[this.idColumns[i]] : object[this.idColumns[i]];
            if (idValue !== undefined) {
                idValues.push(idValue);
            }
        }
        return idValues;
    };
    /**
     * Query for object by multi id
     * @param  idValues ColumnValues with the multi id
     * @return object created from the raw database object
     */
    Dao.prototype.queryForMultiId = function (idValues) {
        var whereString = this.buildPkWhere(idValues);
        var whereArgs = this.buildPkWhereArgs(idValues);
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
        var result = this.connection.get(query, whereArgs);
        if (!result)
            return;
        var object = this.createObject(result);
        this.populateObjectFromResult(object, result);
        return object;
    };
    /**
     * Queries for all matches and returns them in the callback.  Be aware this pulls all results into memory
     * @param  {string} [where]     Optional where clause
     * @param  {object[]} [whereArgs] Optional where args array
     * @return {Object[]} raw object array from the database
     */
    Dao.prototype.queryForAll = function (where, whereArgs) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where);
        return this.connection.all(query, whereArgs);
    };
    /**
     * Queries for all matches and returns them in the callback.  Be aware this pulls all results into memory
     * @param  {string} fieldName name of the field to query for
     * @param  {string} value     value of the like clause
     * @return {Object[]} raw object array from the database
     */
    Dao.prototype.queryForLike = function (fieldName, value) {
        var values = new columnValues_1.default();
        values.addColumn(fieldName, value);
        var where = this.buildWhereLike(values);
        var whereArgs = this.buildWhereArgs(value);
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where);
        return this.connection.all(query, whereArgs);
    };
    /**
     * Queries for all matches and returns them.  Only queries for the specified column name  Be aware this pulls all results into memory
     * @param {string}  columnName  name of the column to query for
     * @param {module:dao/columnValues~ColumnValues} [fieldValues] optional values to filter on
     * @return {Object[]} raw object array from the database
     */
    Dao.prototype.queryForColumns = function (columnName, fieldValues) {
        var where = undefined;
        var whereArgs = null;
        if (fieldValues) {
            where = this.buildWhere(fieldValues);
            whereArgs = this.buildWhereArgs(fieldValues);
        }
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", [columnName], where);
        return this.connection.all(query, whereArgs);
    };
    /**
     * Queries for all items in the table with a page size and page number
     * @param  {number} pageSize size of the chunk to query for
     * @param  {number} page     chunk number to query for
     * @return {Object[]} raw object array from the database
     */
    Dao.prototype.queryForChunk = function (pageSize, page) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, undefined, undefined, undefined, undefined, this.idColumns[0], pageSize, page * pageSize);
        return this.connection.all(query);
    };
    /**
     * Iterate all items in the table one at a time.  If no parameters are passed, iterates the entire table.  Returns an Iterable object
     * @param  {string} [field]   field to filter on
     * @param  {Object} [value]   value to filter on
     * @param  {string} [groupBy] group by clause
     * @param  {string} [having]  having clause
     * @param  {string} [orderBy] order by clause
     * @return {IterableIterator<any>} iterable of database objects
     */
    Dao.prototype.queryForEach = function (field, value, groupBy, having, orderBy) {
        if (!field) {
            var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, undefined, undefined, groupBy, having, orderBy);
            return this.connection.each(query);
        }
        else {
            var whereString = this.buildWhereWithFieldAndValue(field, value);
            var whereArgs = this.buildWhereArgs(value);
            query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString, undefined, groupBy, having, orderBy);
            return this.connection.each(query, whereArgs);
        }
    };
    /**
     * Iterate all objects in thet able that match the ColumnValues passed in
     * @param  {module:dao/columnValues~ColumnValues} fieldValues ColumnValues to query for
     * @return {IterableIterator<any>}
     */
    Dao.prototype.queryForFieldValues = function (fieldValues) {
        var whereString = this.buildWhere(fieldValues);
        var whereArgs = this.buildWhereArgs(fieldValues);
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
        return this.connection.each(query, whereArgs);
    };
    /**
     * Iterate all matching objects
     * @param  {string} join      join clause
     * @param  {string} where     where clause
     * @param  {Object[]} whereArgs array of where query values
     * @param  {string[]} columns   columns to query for
     * @return {IterableIterator<any>}
     */
    Dao.prototype.queryJoinWhereWithArgs = function (join, where, whereArgs, columns) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", columns, where, join);
        return this.connection.each(query, whereArgs);
    };
    /**
     * Count all matching objects
     * @param  {string} join      join clause
     * @param  {string} where     where clause
     * @param  {Object[]} whereArgs array of where query values
     * @return {number}
     */
    Dao.prototype.countJoinWhereWithArgs = function (join, where, whereArgs) {
        var query = "select COUNT(*) as count from '" + this.gpkgTableName + "' " + join + " where " + where;
        var result = this.connection.get(query, whereArgs);
        if (!result)
            return 0;
        return result.count;
    };
    /**
     * Iterate all distinct matching rows in the table
     * @param  {string} where     where clause
     * @param  {Object[]} whereArgs array of where query values
     * @return {IterableIterator<any>}
     */
    Dao.prototype.queryWhereWithArgsDistinct = function (where, whereArgs) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(true, "'" + this.gpkgTableName + "'", undefined, where);
        return this.connection.each(query, whereArgs);
    };
    /**
     * Iterate all matching rows
     * @param  {string} [where]     where clause
     * @param  {Object[]} [whereArgs] array of where query values
     * @param  {string} [groupBy]   group by clause
     * @param  {string} [having]    having clause
     * @param  {string} [orderBy]   order by clause
     * @param  {number} [limit]     limit clause
     * @return {IterableIterator<any>}
     */
    Dao.prototype.queryWhere = function (where, whereArgs, groupBy, having, orderBy, limit) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where, undefined, groupBy, having, orderBy, limit);
        return this.connection.each(query, whereArgs);
    };
    /**
     * Get the primary key where clause
     * @param  {Object|Object[]} idValue id
     * @return {string} primary key where clause
     */
    Dao.prototype.buildPkWhere = function (idValue) {
        if (Array.isArray(idValue)) {
            var idValuesArray = idValue;
            var idColumnValues = new columnValues_1.default();
            for (var i = 0; i < idValuesArray.length; i++) {
                idColumnValues.addColumn(this.idColumns[i], idValuesArray[i]);
            }
            return this.buildWhere(idColumnValues);
        }
        return this.buildWhereWithFieldAndValue(this.idColumns[0], idValue);
    };
    /**
     * Get the primary key where args
     * @param  {Object} idValue id
     * @return {Object[]} where args
     */
    Dao.prototype.buildPkWhereArgs = function (idValue) {
        if (Array.isArray(idValue)) {
            var idValuesArray = idValue;
            var values = [];
            for (var i = 0; i < idValuesArray.length; i++) {
                values = values.concat(this.buildWhereArgs(idValuesArray[i]));
            }
            return values;
        }
        return this.buildWhereArgs(idValue);
    };
    /**
     * Build where (or selection) LIKE statement for fields
     * @param  {module:dao/columnValues~ColumnValues} fields    columns and values
     * @param  {string} [operation] AND or OR
     * @return {string} where clause
     */
    Dao.prototype.buildWhereLike = function (fields, operation) {
        var whereString = '';
        for (var i = 0; i < fields.columns.length; i++) {
            var column = fields.columns[i];
            if (i) {
                whereString += ' ' + operation + ' ';
            }
            whereString += this.buildWhereWithFieldAndValue(column, fields.getValue(column), 'like');
        }
        return whereString;
    };
    /**
     * Build where or selection statement for fields
     * @param  fields    columns and values
     * @param  [operation=AND] AND or OR
     * @return where clause
     */
    Dao.prototype.buildWhere = function (fields, operation) {
        if (operation === void 0) { operation = 'and'; }
        var whereString = '';
        for (var i = 0; i < fields.columns.length; i++) {
            var column = fields.columns[i];
            if (i) {
                whereString += ' ' + operation + ' ';
            }
            whereString += this.buildWhereWithFieldAndValue(column, fields.getValue(column));
        }
        return whereString;
    };
    /**
     * Builds a where args array
     * @param {any[]|ColumnValues|any} values argument values to push
     * @returns {any[]}
     */
    Dao.prototype.buildWhereArgs = function (values) {
        var args = [];
        if (Array.isArray(values)) {
            args = this._buildWhereArgsWithArray(values);
        }
        else if (values.columns) {
            args = this._buildWhereArgsWithColumnValues(values);
        }
        else {
            if (values !== undefined || values !== null) {
                args.push(values);
            }
        }
        return args.length ? args : null;
    };
    /**
     * Builds a where args array
     * @param {any[]} values argument values to push
     * @returns {any[]}
     */
    Dao.prototype._buildWhereArgsWithArray = function (values) {
        var args = [];
        for (var i = 0; i < values.length; i++) {
            var value = values[i];
            if (value !== undefined && value !== null) {
                args.push(value);
            }
        }
        return args;
    };
    /**
     * Builds a where args array
     * @param {ColumnValues} values argument values to push
     * @returns {any[]}
     */
    Dao.prototype._buildWhereArgsWithColumnValues = function (values) {
        var args = [];
        for (var i = 0; i < values.columns.length; i++) {
            var column = values.columns[i];
            var value = values.getValue(column);
            if (value !== undefined && value !== null) {
                args.push(value);
            }
        }
        return args;
    };
    /**
     * Builds a where clause from the field and value with an optional operation.  If the value is empty, 'is null' is added to the query for the field
     * @param  {string} field     field name
     * @param  {Object} [value]     optional value to filter on
     * @param  {string} [operation='='] optional operation
     * @return {string} where clause
     */
    Dao.prototype.buildWhereWithFieldAndValue = function (field, value, operation) {
        if (operation === void 0) { operation = '='; }
        var whereString = '' + field + ' ';
        if (value === undefined || value === null) {
            whereString += "is null";
        }
        else {
            whereString += operation + ' ?';
        }
        return whereString;
    };
    /**
     * Query for all rows in the table that match
     * @param  {string} field   field to match
     * @param  {*} value   value to match
     * @param  {string} [groupBy] group by clause
     * @param  {string} [having]  having clause
     * @param  {string} [orderBy] order by clause
     * @return {Object[]} array of raw database objects
     */
    Dao.prototype.queryForAllEq = function (field, value, groupBy, having, orderBy) {
        var whereString = this.buildWhereWithFieldAndValue(field, value);
        var whereArgs = this.buildWhereArgs(value);
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString, undefined, groupBy, having, orderBy);
        return this.connection.all(query, whereArgs);
    };
    /**
     * Count rows in the table optionally filtered by the parameters specified
     * @param  {module:dao/columnValues~ColumnValues|string} [fields] Either a ColumnValues object or a string specifying a field name
     * @param  {Object} [value]  value to filter on if fields is a string
     * @return {number} count of objects
     */
    Dao.prototype.count = function (fields, value) {
        if (!fields) {
            return this.connection.count(this.gpkgTableName);
        }
        var where;
        var whereArgs;
        var query;
        if (fields instanceof columnValues_1.default) {
            where = this.buildWhere(fields, 'and');
            whereArgs = this.buildWhereArgs(fields);
            query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", where);
        }
        else {
            var whereString = this.buildWhereWithFieldAndValue(fields, value);
            whereArgs = this.buildWhereArgs(value);
            query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", whereString);
        }
        var result = this.connection.get(query, whereArgs);
        if (!result)
            return 0;
        return result.count;
    };
    /**
     * Count rows in the table optionally filtered by the parameters specified
     * @param  {string} where where string
     * @param  {any[]} whereArgs arguments to filter on
     * @return {number} count of objects
     */
    Dao.prototype.countWhere = function (where, whereArgs) {
        var query = sqliteQueryBuilder_1.SqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", where);
        var result = this.connection.get(query, whereArgs);
        if (!result)
            return 0;
        return result.count;
    };
    /**
     * Get the min of the column
     * @param  {string} column    column name
     * @param  {string} [where]     where clause
     * @param  {Object[]} [whereArgs] where args
     * @return {number}
     */
    Dao.prototype.minOfColumn = function (column, where, whereArgs) {
        return this.connection.minOfColumn("'" + this.gpkgTableName + "'", column, where, whereArgs);
    };
    /**
     * Get the max of the column
     * @param  {string} column    column name
     * @param  {string} [where]     where clause
     * @param  {Object[]} [whereArgs] where args
     * @return {number}
     */
    Dao.prototype.maxOfColumn = function (column, where, whereArgs) {
        return this.connection.maxOfColumn("'" + this.gpkgTableName + "'", column, where, whereArgs);
    };
    /**
     * Delete the object passed in.  Object is deleted by id
     * @param  {Object} object object to delete
     * @return {number} number of objects deleted
     */
    Dao.prototype.delete = function (object) {
        if (object.getId) {
            return this.deleteById(object.getId());
        }
        return this.deleteByMultiId(this.getMultiId(object));
    };
    /**
     * Delete the object specified by the id
     * @param  {Object} idValue id value
     * @return {number} number of objects deleted
     */
    Dao.prototype.deleteById = function (idValue) {
        var where = this.buildPkWhere(idValue);
        var whereArgs = this.buildPkWhereArgs(idValue);
        return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
    };
    /**
     * Delete the object specified by the ids
     * @param  {module:dao/columnValues~ColumnValues} idValues id values
     * @return {number} number of objects deleted
     */
    Dao.prototype.deleteByMultiId = function (idValues) {
        var where = this.buildPkWhere(idValues);
        var whereArgs = this.buildPkWhereArgs(idValues);
        return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
    };
    /**
     * Delete objects that match the query
     * @param  {string} where     where clause
     * @param  {Object[]} whereArgs where arguments
     * @return {number} number of objects deleted
     */
    Dao.prototype.deleteWhere = function (where, whereArgs) {
        return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
    };
    /**
     * Delete all objects in the table
     * @return {number} number of objects deleted
     */
    Dao.prototype.deleteAll = function () {
        return this.connection.delete("'" + this.gpkgTableName + "'", '', []);
    };
    /**
     * Insert the object into the table
     * @param  {Object} object object to be inserted
     * @return {number} id of the inserted object
     */
    Dao.prototype.create = function (object) {
        var sql = sqliteQueryBuilder_1.SqliteQueryBuilder.buildInsert("'" + this.gpkgTableName + "'", object);
        var insertObject = sqliteQueryBuilder_1.SqliteQueryBuilder.buildUpdateOrInsertObject(object);
        return this.connection.insert(sql, insertObject);
    };
    /**
     * Update all rows that match the query
     * @param  {module:dao/columnValues~ColumnValues} values    values to insert
     * @param  {string} where     where clause
     * @param  {Object[]} whereArgs where arguments
     * @return {number} number of objects updated
     */
    //TODO this return value
    Dao.prototype.updateWithValues = function (values, where, whereArgs) {
        var update = sqliteQueryBuilder_1.SqliteQueryBuilder.buildUpdate("'" + this.gpkgTableName + "'", values, where, whereArgs);
        return this.connection.run(update.sql, update.args);
    };
    /**
     * Update the object specified
     * @param  {Object} object object with updated values
     * @return {number} number of objects updated
     */
    //TODO this return value
    Dao.prototype.update = function (object) {
        var updateValues = sqliteQueryBuilder_1.SqliteQueryBuilder.buildUpdateOrInsertObject(object);
        var update = sqliteQueryBuilder_1.SqliteQueryBuilder.buildObjectUpdate("'" + this.gpkgTableName + "'", object);
        var multiId = this.getMultiId(object);
        if (multiId.length) {
            var where = ' where ';
            for (var i = 0; i < multiId.length; i++) {
                where += '"' + this.idColumns[i] + '" = $' + sqliteQueryBuilder_1.SqliteQueryBuilder.fixColumnName(this.idColumns[i]);
                updateValues[sqliteQueryBuilder_1.SqliteQueryBuilder.fixColumnName(this.idColumns[i])] = multiId[i];
            }
            update += where;
        }
        return this.connection.run(update, updateValues);
    };
    /**
     * Queries for the object by id, and if it exists, updates it, otherwise creates a new object
     * @param  {Object} object object to update or create
     * @return {number} number of objects modified
     */
    // TODO this return value
    Dao.prototype.createOrUpdate = function (object) {
        var existing = this.queryForSameId(object);
        if (!existing) {
            return this.create(object);
        }
        else {
            return this.update(object);
        }
    };
    /**
     * Drops this table
     * @return {boolean} results of the drop
     */
    Dao.prototype.dropTable = function () {
        return this.connection.dropTable(this.gpkgTableName);
    };
    /**
     * Rename the table
     * @param {string} newName
     */
    Dao.prototype.rename = function (newName) {
        this.connection.run('ALTER TABLE ' + '"' + this.gpkgTableName + '" RENAME TO "' + newName + '"');
        this.gpkgTableName = newName;
    };
    return Dao;
}());
exports.default = Dao;

},{"../db/sqliteQueryBuilder":21,"./columnValues":12}],14:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Contains data to specify restrictions on basic data type column values
 * @class DataColumnConstraints
 */
var DataColumnConstraints = /** @class */ (function () {
    function DataColumnConstraints() {
    }
    return DataColumnConstraints;
}());
exports.default = DataColumnConstraints;

},{}],15:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../dao/dao"));
var dataColumnConstraints_1 = __importDefault(require("./dataColumnConstraints"));
/**
 * DataColumnConstraints module.
 * @module dataColumnConstraints
 */
/**
 * Data Column Constraints Data Access Object
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
var DataColumnConstraintsDao = /** @class */ (function (_super) {
    __extends(DataColumnConstraintsDao, _super);
    function DataColumnConstraintsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = DataColumnConstraintsDao.TABLE_NAME;
        _this.idColumns = [DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME, DataColumnConstraintsDao.COLUMN_CONSTRAINT_TYPE, DataColumnConstraintsDao.COLUMN_VALUE];
        return _this;
    }
    /**
     * Creates a new DataColumnConstraints object
     * @return {module:dataColumnConstraints~DataColumnConstraints}
     */
    DataColumnConstraintsDao.prototype.createObject = function () {
        return new dataColumnConstraints_1.default();
    };
    /**
     * query by constraint name
     * @param  {String} constraintName     constraint name
     * @return {Iterable}
     */
    DataColumnConstraintsDao.prototype.queryByConstraintName = function (constraintName) {
        return this.queryForEach(DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME, constraintName);
    };
    /**
     * Query by the unique column values
     * @param  {String} constraintName     constraint name
     * @param  {String} constraintType     constraint type
     * @param  {String} value              value
     * @return {module:dataColumnConstraints~DataColumnConstraints}
     */
    DataColumnConstraintsDao.prototype.queryUnique = function (constraintName, constraintType, value) {
        var dataColumnConstraints = new dataColumnConstraints_1.default();
        dataColumnConstraints.constraint_name = constraintName;
        dataColumnConstraints.constraint_type = constraintType;
        dataColumnConstraints.value = value;
        return this.queryForSameId(dataColumnConstraints);
    };
    DataColumnConstraintsDao.TABLE_NAME = "gpkg_data_column_constraints";
    DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME = "constraint_name";
    DataColumnConstraintsDao.COLUMN_CONSTRAINT_TYPE = "constraint_type";
    DataColumnConstraintsDao.COLUMN_VALUE = "value";
    DataColumnConstraintsDao.COLUMN_MIN = "min";
    DataColumnConstraintsDao.COLUMN_MIN_IS_INCLUSIVE = "min_is_inclusive";
    DataColumnConstraintsDao.COLUMN_MAX = "max";
    DataColumnConstraintsDao.COLUMN_MAX_IS_INCLUSIVE = "max_is_inclusive";
    DataColumnConstraintsDao.COLUMN_DESCRIPTION = "description";
    DataColumnConstraintsDao.ENUM_TYPE = 'enum';
    DataColumnConstraintsDao.GLOB_TYPE = 'glob';
    DataColumnConstraintsDao.RANGE_TYPE = 'range';
    return DataColumnConstraintsDao;
}(dao_1.default));
exports.default = DataColumnConstraintsDao;

},{"../dao/dao":13,"./dataColumnConstraints":14}],16:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Stores minimal application schema identifying, descriptive and MIME type
 * information about columns in user vector feature and tile matrix data tables
 * that supplements the data available from the SQLite sqlite_master table and
 * pragma table_info(table_name) SQL function. The gpkg_data_columns data CAN be
 * used to provide more specific column data types and value ranges and
 * application specific structural and semantic information to enable more
 * informative user menu displays and more effective user decisions on the
 * suitability of GeoPackage contents for specific purposes.
 * @class DataColumns
 */
var DataColumns = /** @class */ (function () {
    /**
     *
     * @param {object} [object] object containing properties to apply to this
     */
    function DataColumns(object) {
        object = object || {};
        this.table_name = object.table_name;
        this.column_name = object.column_name;
        this.name = object.name;
        this.title = object.title;
        this.description = object.description;
        this.mime_type = object.mime_type;
        this.constraint_name = object.constraint_name;
    }
    return DataColumns;
}());
exports.default = DataColumns;

},{}],17:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../dao/dao"));
var contentsDao_1 = __importDefault(require("../core/contents/contentsDao"));
var dataColumns_1 = __importDefault(require("./dataColumns"));
/**
 * DataColumns module.
 * @module dataColumns
 */
/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
var DataColumnsDao = /** @class */ (function (_super) {
    __extends(DataColumnsDao, _super);
    function DataColumnsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = DataColumnsDao.TABLE_NAME;
        _this.idColumns = [DataColumnsDao.COLUMN_PK1, DataColumnsDao.COLUMN_PK2];
        return _this;
    }
    /**
     * Creates a new {module:dataColumns~DataColumns} object
     * @return {module:dataColumns~DataColumns}
     */
    DataColumnsDao.prototype.createObject = function () {
        return new dataColumns_1.default();
    };
    /**
     * Get the Contents from the Data Columns
     * @param  {module:dataColumns~DataColumns} dataColumns data columns
     * @return {module:core/contents~Contents}             contents
     */
    DataColumnsDao.prototype.getContents = function (dataColumns) {
        var cd = new contentsDao_1.default(this.geoPackage);
        return cd.queryForId(dataColumns.table_name);
    };
    /**
     * Query by constraint name
     * @param  {String} constraintName     constraint name
     * @return {Iterable.<Object>} iterator of database objects
     */
    DataColumnsDao.prototype.queryByConstraintName = function (constraintName) {
        return this.queryForEach(DataColumnsDao.COLUMN_CONSTRAINT_NAME, constraintName);
    };
    /**
     * Get DataColumn by column name and table name
     * @param  {String} tableName  table name
     * @param  {String} columnName column name
     * @return {module:dataColumns~DataColumns}
     */
    DataColumnsDao.prototype.getDataColumns = function (tableName, columnName) {
        var e_1, _a;
        var exists = this.isTableExists();
        if (!exists) {
            return;
        }
        var where = this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_TABLE_NAME, tableName) +
            ' and ' +
            this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_COLUMN_NAME, columnName);
        var values = [tableName, columnName];
        var dataColumn;
        try {
            for (var _b = __values(this.queryWhere(where, values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                dataColumn = row;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return dataColumn;
    };
    DataColumnsDao.TABLE_NAME = "gpkg_data_columns";
    DataColumnsDao.COLUMN_PK1 = "table_name";
    DataColumnsDao.COLUMN_PK2 = "column_name";
    DataColumnsDao.COLUMN_TABLE_NAME = "table_name";
    DataColumnsDao.COLUMN_COLUMN_NAME = "column_name";
    DataColumnsDao.COLUMN_NAME = "name";
    DataColumnsDao.COLUMN_TITLE = "title";
    DataColumnsDao.COLUMN_DESCRIPTION = "description";
    DataColumnsDao.COLUMN_MIME_TYPE = "mime_type";
    DataColumnsDao.COLUMN_CONSTRAINT_NAME = "constraint_name";
    return DataColumnsDao;
}(dao_1.default));
exports.default = DataColumnsDao;

},{"../core/contents/contentsDao":9,"../dao/dao":13,"./dataColumns":16}],18:[function(require,module,exports){
"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module db/dataTypes
 */
var DataTypes = /** @class */ (function () {
    function DataTypes() {
    }
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_BOOLEAN_NAME] = 0;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_TINYINT_NAME] = 1;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_SMALLINT_NAME] = 2;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_MEDIUMINT_NAME] = 3;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_INT_NAME] = 4;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_INTEGER_NAME] = 5;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_FLOAT_NAME] = 6;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_DOUBLE_NAME] = 7;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_REAL_NAME] = 8;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_TEXT_NAME] = 9;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_BLOB_NAME] = 10;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_DATE_NAME] = 11;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_DATETIME_NAME] = 12;
    // public static readonly GPKGDataType[DataTypes.GPKG_DT_GEOMETRY_NAME] = 13;
    // public static readonly GPKGDataType.GPKG_DT_BOOLEAN = 0;
    // public static readonly GPKGDataType.GPKG_DT_TINYINT = 1;
    // public static readonly GPKGDataType.GPKG_DT_SMALLINT = 2;
    // public static readonly GPKGDataType.GPKG_DT_MEDIUMINT = 3;
    // public static readonly GPKGDataType.GPKG_DT_INT = 4;
    // public static readonly GPKGDataType.GPKG_DT_INTEGER = 5;
    // public static readonly GPKGDataType.GPKG_DT_FLOAT = 6;
    // public static readonly GPKGDataType.GPKG_DT_DOUBLE = 7;
    // public static readonly GPKGDataType.GPKG_DT_REAL = 8;
    // public static readonly GPKGDataType.GPKG_DT_TEXT = 9;
    // public static readonly GPKGDataType.GPKG_DT_BLOB = 10;
    // public static readonly GPKGDataType.GPKG_DT_DATE = 11;
    // public static readonly GPKGDataType.GPKG_DT_DATETIME = 12;
    // public static readonly GPKGDataType.GPKG_DT_GEOMETRY = 13;
    /**
     * Return the name of the given data type.
     *
     * @param  {module:db/dataTypes~GPKGDataType} dataType the enum to retrieve the name for
     * @return {String} the string name of the given data type enum
     */
    DataTypes.nameFromType = function (dataType) {
        var name = undefined;
        switch (dataType) {
            case DataTypes.GPKGDataType.GPKG_DT_BOOLEAN:
                name = DataTypes.GPKG_DT_BOOLEAN_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_TINYINT:
                name = DataTypes.GPKG_DT_TINYINT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_SMALLINT:
                name = DataTypes.GPKG_DT_SMALLINT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_MEDIUMINT:
                name = DataTypes.GPKG_DT_MEDIUMINT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_INT:
                name = DataTypes.GPKG_DT_INT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_INTEGER:
                name = DataTypes.GPKG_DT_INTEGER_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_FLOAT:
                name = DataTypes.GPKG_DT_FLOAT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_DOUBLE:
                name = DataTypes.GPKG_DT_DOUBLE_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_REAL:
                name = DataTypes.GPKG_DT_REAL_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_TEXT:
                name = DataTypes.GPKG_DT_TEXT_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_BLOB:
                name = DataTypes.GPKG_DT_BLOB_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_DATE:
                name = DataTypes.GPKG_DT_DATE_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_DATETIME:
                name = DataTypes.GPKG_DT_DATETIME_NAME;
                break;
            case DataTypes.GPKGDataType.GPKG_DT_GEOMETRY:
                name = DataTypes.GPKG_DT_GEOMETRY_NAME;
                break;
        }
        return name;
    };
    /**
     * A boolean value representing true or false.
     * @type {String}
     */
    DataTypes.GPKG_DT_BOOLEAN_NAME = "BOOLEAN";
    /**
     * 8-bit signed two’s complement integer.
     * @type {String}
     */
    DataTypes.GPKG_DT_TINYINT_NAME = "TINYINT";
    /**
     * 16-bit signed two’s complement integer.
     * @type {String}
     */
    DataTypes.GPKG_DT_SMALLINT_NAME = "SMALLINT";
    /**
     * 32-bit signed two’s complement integer.
     * @type {String}
     */
    DataTypes.GPKG_DT_MEDIUMINT_NAME = "MEDIUMINT";
    /**
     * 64-bit signed two’s complement integer.
     * @type {String}
     */
    DataTypes.GPKG_DT_INT_NAME = "INT";
    /**
     * 64-bit signed two’s complement integer.
     * @type {String}
     */
    DataTypes.GPKG_DT_INTEGER_NAME = "INTEGER";
    /**
     * 32-bit IEEE floating point number.
     * @type {String}
     */
    DataTypes.GPKG_DT_FLOAT_NAME = "FLOAT";
    /**
     * 64-bit IEEE floating point number.
     * @type {String}
     */
    DataTypes.GPKG_DT_DOUBLE_NAME = "DOUBLE";
    /**
     * 64-bit IEEE floating point number.
     * @type {String}
     */
    DataTypes.GPKG_DT_REAL_NAME = "REAL";
    /**
     * TEXT{(maxchar_count)}: Variable length string encoded in either UTF-8 or UTF-16, determined by PRAGMA encoding; see http://www.sqlite.org/pragma.html#pragma_encoding.
     * @type {String}
     */
    DataTypes.GPKG_DT_TEXT_NAME = "TEXT";
    /**
     * BLOB{(max_size)}: Variable length binary data.
     * @type {String}
     */
    DataTypes.GPKG_DT_BLOB_NAME = "BLOB";
    /**
     * ISO-8601 date string in the form YYYY-MM-DD encoded in either UTF-8 or UTF-16.
     * @type {String}
     */
    DataTypes.GPKG_DT_DATE_NAME = "DATE";
    /**
     * ISO-8601 date/time string in the form YYYY-MM-DDTHH:MM:SS.SSSZ with T separator character and Z suffix for coordinated universal time (UTC) encoded in either UTF-8 or UTF-16.
     * @type {String}
     */
    DataTypes.GPKG_DT_DATETIME_NAME = "DATETIME";
    DataTypes.GPKG_DT_GEOMETRY_NAME = "GEOMETRY";
    /**
     * DataType enumeration
     * @typedef {object} GPKGDataType
     */
    DataTypes.GPKGDataType = (_a = {},
        _a[DataTypes.GPKG_DT_BOOLEAN_NAME] = 0,
        _a.GPKG_DT_BOOLEAN = 0,
        _a[DataTypes.GPKG_DT_TINYINT_NAME] = 1,
        _a.GPKG_DT_TINYINT = 1,
        _a[DataTypes.GPKG_DT_SMALLINT_NAME] = 2,
        _a.GPKG_DT_SMALLINT = 2,
        _a[DataTypes.GPKG_DT_MEDIUMINT_NAME] = 3,
        _a.GPKG_DT_MEDIUMINT = 3,
        _a[DataTypes.GPKG_DT_INT_NAME] = 4,
        _a.GPKG_DT_INT = 4,
        _a[DataTypes.GPKG_DT_INTEGER_NAME] = 5,
        _a.GPKG_DT_INTEGER = 5,
        _a[DataTypes.GPKG_DT_FLOAT_NAME] = 6,
        _a.GPKG_DT_FLOAT = 6,
        _a[DataTypes.GPKG_DT_DOUBLE_NAME] = 7,
        _a.GPKG_DT_DOUBLE = 7,
        _a[DataTypes.GPKG_DT_REAL_NAME] = 8,
        _a.GPKG_DT_REAL = 8,
        _a[DataTypes.GPKG_DT_TEXT_NAME] = 9,
        _a.GPKG_DT_TEXT = 9,
        _a[DataTypes.GPKG_DT_BLOB_NAME] = 10,
        _a.GPKG_DT_BLOB = 10,
        _a[DataTypes.GPKG_DT_DATE_NAME] = 11,
        _a.GPKG_DT_DATE = 11,
        _a[DataTypes.GPKG_DT_DATETIME_NAME] = 12,
        _a.GPKG_DT_DATETIME = 12,
        _a[DataTypes.GPKG_DT_GEOMETRY_NAME] = 13,
        _a.GPKG_DT_GEOMETRY = 13,
        _a);
    /**
     * Return the data type enum value for the given name, ignoring case.
     *
     * @param  {String} name the name of the data type enum
     * @return {module:db/dataTypes~GPKGDataType} the enum value
     */
    DataTypes.fromName = function (name) {
        DataTypes.GPKGDataType['test'] = 5;
        var value = 9;
        if (name) {
            name = name.toUpperCase();
            value = DataTypes.GPKGDataType[name];
        }
        return value;
    };
    return DataTypes;
}());
exports.default = DataTypes;

},{}],19:[function(require,module,exports){
(function (process,Buffer){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var geoPackageConstants_1 = require("../geoPackageConstants");
/**
 * Connection to the SQLite file
 * @module db/geoPackageConnection
 */
if (typeof (process) !== 'undefined' && process.version && !process.env.FORCE_SQLJS) {
    console.log('Better SQLite');
}
else {
    console.log('SQL.js');
}
/**
 * Represents a connection to the GeoPackage database
 */
var GeoPackageConnection = /** @class */ (function () {
    /**
     * Construct a new connection to the GeoPackage SQLite file
     * @param filePath path to the sqlite file
     */
    function GeoPackageConnection(filePath) {
        this.filePath = filePath;
    }
    /**
     * Creates a connection to the SQLite file and when connected, returns a promise that resolves the connection.
     * This will create a {module:db/sqliteAdapter~Adapter} if running in node and the FORCE_SQLJS environment variable is not set.
     * This will create a {module:db/sqljsAdapter~Adapter} if running in the browser or the FORCE_SQLJS environment variable is set
     * @return {Promise<GeoPackageConnection>}
     */
    GeoPackageConnection.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var SqliteAdapter_1, SqljsAdapter_1, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 6, , 7]);
                        if (!(typeof (process) !== 'undefined' && process.version && !process.env.FORCE_SQLJS)) return [3 /*break*/, 2];
                        return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('./sqliteAdapter')); })];
                    case 1:
                        SqliteAdapter_1 = (_a.sent()).SqliteAdapter;
                        this.adapterCreator = SqliteAdapter_1;
                        this.adapter = new SqliteAdapter_1(this.filePath);
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('./sqljsAdapter')); })];
                    case 3:
                        SqljsAdapter_1 = (_a.sent()).SqljsAdapter;
                        this.adapterCreator = SqljsAdapter_1;
                        this.adapter = new SqljsAdapter_1(this.filePath);
                        _a.label = 4;
                    case 4: return [4 /*yield*/, this.adapter.initialize()];
                    case 5:
                        _a.sent();
                        return [3 /*break*/, 7];
                    case 6:
                        e_1 = _a.sent();
                        console.log('Failed to create adapter', e_1);
                        throw e_1;
                    case 7: return [2 /*return*/, this];
                }
            });
        });
    };
    /**
     * Close the database.
     */
    GeoPackageConnection.prototype.close = function () {
        this.adapter.close();
    };
    /**
     * exports the GeoPackage as a file
     * @param  {Function} callback called with an err and the buffer containing the contents of the file
     */
    GeoPackageConnection.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.adapter.export()];
            });
        });
    };
    /**
     * Gets the raw connection to the database
     * @return {any}
     */
    GeoPackageConnection.prototype.getDBConnection = function () {
        return this.adapter.db;
    };
    /**
     * Connects to a GeoPackage database
     * @param  {any} db database to connect to
     */
    GeoPackageConnection.prototype.setDBConnection = function (db) {
        this.adapter = new this.adapterCreator();
        this.adapter.db = db;
    };
    /**
    * Registers the given function so that it can be used by SQL statements
    * @param  {string} name               name of function to register
    * @param  {Function} functionDefinition function to register
    * @return {DBAdapter} the adapter in use
    */
    GeoPackageConnection.prototype.registerFunction = function (name, functionDefinition) {
        this.adapter.registerFunction(name, functionDefinition);
        return this.adapter;
    };
    /**
     * Gets the first result from the query
     * @param  {string} sql    sql query to run
     * @param  {Array|Object} [params] array of substitution parameters
     * @return {any}
     */
    GeoPackageConnection.prototype.get = function (sql, params) {
        return this.adapter.get(sql, params);
    };
    /**
     * Checks if table exists in database
     * @param {string} tableName
     * @returns {Boolean}
     */
    GeoPackageConnection.prototype.isTableExists = function (tableName) {
        return this.adapter.isTableExists(tableName);
    };
    /**
     * Run the given SQL and return the results.
     * @param  {string} sql    sql to run
     * @param  {Array|Object} [params] array of substitution parameters
     * @return {{changes: number, lastInsertRowid: number}} object: `{ "changes": number, "lastInsertROWID": number }`
     * * `changes`: number of rows the statement changed
     * * `lastInsertROWID`: ID of the last inserted row
     */
    GeoPackageConnection.prototype.run = function (sql, params) {
        return this.adapter.run(sql, params);
    };
    /**
     * Executes the query and returns all results in an array
     * @param  {string} sql sql to run
     * @param  {Array|Object} [params] substitution parameters
     * @return {any[]}
     */
    GeoPackageConnection.prototype.all = function (sql, params) {
        return this.adapter.all(sql, params);
    };
    /**
     * Executes the query and returns an Iterable object of results
     * @param  {string} sql    sql to run
     * @param  {Array|Object} [params] substitution parameters
     * @return {IterableIterator<Object>}
     */
    GeoPackageConnection.prototype.each = function (sql, params) {
        return this.adapter.each(sql, params);
    };
    /**
     * Gets the minimum value from the column
     * @param  {string} table     table to query
     * @param  {string} column    column to get the min value from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.minOfColumn = function (table, column, where, whereArgs) {
        var minStatement = 'select min(' + column + ') as min from ' + table;
        if (where) {
            minStatement += ' ';
            if (where.indexOf('where')) {
                where = 'where ' + where;
            }
            minStatement += where;
        }
        return this.adapter.get(minStatement, whereArgs).min;
    };
    /**
     * Gets the maximum value from the column
     * @param  {string} table     table to query
     * @param  {string} column    column to get the max value from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.maxOfColumn = function (table, column, where, whereArgs) {
        var maxStatement = 'select max(' + column + ') as max from ' + table;
        if (where) {
            maxStatement += ' ';
            if (where.indexOf('where')) {
                where = 'where ' + where;
            }
            maxStatement += where;
        }
        return this.adapter.get(maxStatement, whereArgs).max;
    };
    /**
     * Return the count of objects in the table
     * @param  {string} table table name
     * @param  {string} [where] where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.count = function (table, where, whereArgs) {
        return this.adapter.count(table, where, whereArgs);
    };
    /**
     * Executes an insert statement and returns the last id inserted
     * @param  {string} sql    sql to insert
     * @param  {Array|Object} params substitution parameters
     * @return {Object} last row id inserted
     */
    GeoPackageConnection.prototype.insert = function (sql, params) {
        return this.adapter.insert(sql, params);
    };
    /**
     * Delete from the table
     * @param  {string} tableName table name to delete from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number} number of rows deleted
     */
    GeoPackageConnection.prototype.delete = function (tableName, where, whereArgs) {
        var deleteStatement = 'DELETE FROM ' + tableName + '';
        if (where) {
            deleteStatement += ' WHERE ' + where;
        }
        return this.adapter.delete(deleteStatement, whereArgs);
    };
    /**
     * Drops the table specified
     * @param  {string} tableName table to drop
     * @return {Boolean} results of table drop
     */
    GeoPackageConnection.prototype.dropTable = function (tableName) {
        return this.adapter.dropTable(tableName);
    };
    /**
     * Gets information about the table specified.  If data is returned, the table exists
     * @param  {string} tableName table to check
     * @return {Object}
     */
    GeoPackageConnection.prototype.tableExists = function (tableName) {
        return this.adapter.get('SELECT name FROM sqlite_master WHERE type="table" AND name=?', [tableName]);
    };
    /**
     * Checks if a table and column exist
     * @param  {string} tableName  table to check
     * @param  {string} columnName column to check
     * @return {Boolean}
     */
    GeoPackageConnection.prototype.columnAndTableExists = function (tableName, columnName) {
        var columns = this.adapter.all('PRAGMA table_info(\'' + tableName + '\')');
        for (var i = 0; i < columns.length; i++) {
            if (columns[i].name === columnName) {
                return true;
            }
        }
        return false;
    };
    /**
     * Sets the APPLICATION_ID and user_version for GeoPackage
     */
    GeoPackageConnection.prototype.setApplicationId = function () {
        var buff = Buffer.from(geoPackageConstants_1.GeoPackageConstants.APPLICATION_ID);
        var applicationId = buff.readUInt32BE(0);
        this.adapter.run('PRAGMA application_id = ' + applicationId);
        this.adapter.run('PRAGMA user_version = ' + geoPackageConstants_1.GeoPackageConstants.USER_VERSION);
    };
    /**
     * gets the application_id from the sqlite file
     * @return {number}
     */
    GeoPackageConnection.prototype.getApplicationId = function () {
        return this.adapter.get('PRAGMA application_id').application_id;
    };
    /**
     * Convenience method
     * @see {module:db/geoPackageConnection~GeoPackageConnection}
     * @see {module:db/sqliteAdapter~Adapter}
     * @see {module:db/sqljsAdapter~Adapter}
     * @param  {string|Buffer|Uint8Array} filePath string path to an existing file or a path to where a new file will be created or a Buffer containing the contents of the file, if undefined, an in memory database is created
     * @return {Promise} that resolves
     */
    GeoPackageConnection.connect = function (filePath) {
        return new GeoPackageConnection(filePath).init();
    };
    /**
     * Convenience method
     * @param  {Object}   db       open database to connect to
     * @return {Promise}
     */
    GeoPackageConnection.connectWithDatabase = function (db) {
        return new GeoPackageConnection(undefined).init()
            .then(function (connection) {
            connection.setDBConnection(db);
        });
    };
    return GeoPackageConnection;
}());
exports.default = GeoPackageConnection;

}).call(this,require('_process'),require("buffer").Buffer)
},{"../geoPackageConstants":81,"./sqliteAdapter":20,"./sqljsAdapter":22,"_process":318,"buffer":197}],20:[function(require,module,exports){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs_1 = __importDefault(require("fs"));
var path_1 = __importDefault(require("path"));
var http_1 = __importDefault(require("http"));
var os_1 = __importDefault(require("os"));
/**
 * This adapter uses better-sqlite3 to execute queries against the GeoPackage database
 * @see {@link https://github.com/JoshuaWise/better-sqlite3|better-sqlite3}
 */
/**
 * Class which adapts generic GeoPackage queries to better-sqlite3 queries
 */
var SqliteAdapter = /** @class */ (function () {
    // /**
    //  * Creates an adapter from an already established better-sqlite3 database connection
    //  * @param  {*} db better-sqlite3 database connection
    //  * @return {module:db/sqliteAdapter~Adapter}
    //  */
    // static createAdapterFromDb(db) {
    //   return new SqliteAdapter(db);
    // };
    function SqliteAdapter(filePath) {
        this.filePath = filePath;
    }
    /**
     * Returns a Promise which, when resolved, returns a DBAdapter which has connected to the GeoPackage database file
     */
    SqliteAdapter.prototype.initialize = function () {
        return __awaiter(this, void 0, void 0, function () {
            var bettersqlite, Database, url_1, byteArray, tmpPath;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('better-sqlite3')); })];
                    case 1:
                        bettersqlite = _a.sent();
                        Database = bettersqlite.default;
                        try {
                            if (this.filePath && typeof this.filePath === 'string') {
                                if (this.filePath.indexOf('http') === 0) {
                                    url_1 = this.filePath;
                                    return [2 /*return*/, new Promise(function (resolve, reject) {
                                            http_1.default.get(url_1, function (response) {
                                                if (response.statusCode !== 200) {
                                                    reject(new Error('Unable to reach url: ' + _this.filePath));
                                                }
                                                var tmpPath = path_1.default.join(os_1.default.tmpdir(), Date.now() + Math.floor(Math.random() * 100) + '.gpkg');
                                                var writeStream = fs_1.default.createWriteStream(tmpPath);
                                                response.pipe(writeStream);
                                                writeStream.on('close', function () {
                                                    try {
                                                        _this.db = new Database(tmpPath);
                                                        // verify that this is an actual database
                                                        _this.db.pragma('journal_mode = WAL');
                                                        _this.filePath = tmpPath;
                                                        resolve(_this);
                                                    }
                                                    catch (err) {
                                                        console.log('error', err);
                                                        reject(err);
                                                    }
                                                });
                                            })
                                                .on('error', function (e) {
                                                reject(e);
                                            });
                                        })];
                                }
                                else {
                                    this.db = new Database(this.filePath);
                                    return [2 /*return*/, this];
                                }
                            }
                            else if (this.filePath) {
                                byteArray = this.filePath;
                                tmpPath = path_1.default.join(os_1.default.tmpdir(), Date.now() + '.gpkg');
                                return [2 /*return*/, new Promise(function (resolve, reject) {
                                        fs_1.default.writeFile(tmpPath, byteArray, function () {
                                            _this.db = new Database(tmpPath);
                                            // verify that this is an actual database
                                            try {
                                                _this.db.pragma('journal_mode = WAL');
                                            }
                                            catch (err) {
                                                console.log('error', err);
                                                reject(err);
                                            }
                                            _this.filePath = tmpPath;
                                            resolve(_this);
                                        });
                                    })];
                            }
                            else {
                                console.log('create in memory');
                                this.db = new Database("memory", {
                                    memory: !this.filePath
                                });
                                return [2 /*return*/, this];
                            }
                        }
                        catch (err) {
                            console.log('Error opening database', err);
                            throw err;
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    ;
    /**
     * Closes the connection to the GeoPackage
     */
    SqliteAdapter.prototype.close = function () {
        this.db.close();
    };
    /**
     * Get the connection to the database file
     * @return {*}
     */
    SqliteAdapter.prototype.getDBConnection = function () {
        return this.db;
    };
    /**
     * Returns a Buffer containing the contents of the database as a file
     */
    SqliteAdapter.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) {
                        return fs_1.default.readFile(_this.filePath, function (err, data) {
                            resolve(data);
                        });
                    })];
            });
        });
    };
    /**
     * Registers the given function so that it can be used by SQL statements
     * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#registeroptions-function---this|better-sqlite3 register}
     * @param  {string} name               name of function to register
     * @param  {Function} functionDefinition function to register
     * @return {module:db/sqliteAdapter~Adapter} this
     */
    SqliteAdapter.prototype.registerFunction = function (name, functionDefinition) {
        this.db.function(name, functionDefinition);
        return this;
    };
    /**
     * Gets one row of results from the statement
     * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#getbindparameters---row|better-sqlite3 get}
     * @param  {string} sql    statement to run
     * @param  {Array|Object} [params] bind parameters
     * @return {Object}
     */
    SqliteAdapter.prototype.get = function (sql, params) {
        var statement = this.db.prepare(sql);
        if (params) {
            return statement.get(params);
        }
        else {
            return statement.get();
        }
    };
    /**
     * Determines if a tableName exists in the database
     * @param {String} tableName
     * @returns {Boolean}
     */
    SqliteAdapter.prototype.isTableExists = function (tableName) {
        var statement = this.db.prepare("SELECT name FROM sqlite_master WHERE type='table' AND name=:name");
        var result;
        result = statement.get({ name: tableName });
        return !!result;
    };
    /**
     * Gets all results from the statement in an array
     * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#allbindparameters---array-of-rows|better-sqlite3 all}
     * @param  {String} sql    statement to run
     * @param  {Array|Object} [params] bind parameters
     * @return {Object[]}
     */
    SqliteAdapter.prototype.all = function (sql, params) {
        var statement = this.db.prepare(sql);
        if (params) {
            return statement.all(params);
        }
        else {
            return statement.all();
        }
    };
    /**
     * Returns an `Iterable` with results from the query
     * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#iteratebindparameters---iterator|better-sqlite3 iterate}
     * @param  {String} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {Iterable.<Object>}
     */
    SqliteAdapter.prototype.each = function (sql, params) {
        var statement = this.db.prepare(sql);
        if (params) {
            return statement.iterate(params);
        }
        else {
            return statement.iterate();
        }
    };
    /**
     * Run the given statement, returning information about what changed.
     *
     * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#runbindparameters---object|better-sqlite3}
     * @param  {String} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {{changes: number, lastInsertROWID: number}} object: `{ "changes": number, "lastInsertROWID": number }`
     * * `changes`: number of rows the statement changed
     * * `lastInsertROWID`: ID of the last inserted row
     */
    SqliteAdapter.prototype.run = function (sql, params) {
        var statement = this.db.prepare(sql);
        if (params) {
            return statement.run(params);
        }
        else {
            return statement.run();
        }
    };
    /**
     * Runs the specified insert statement and returns the last inserted id or undefined if no insert happened
     * @param  {String} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {Number} last inserted row id
     */
    SqliteAdapter.prototype.insert = function (sql, params) {
        var statement = this.db.prepare(sql);
        return statement.run(params).lastInsertRowid;
    };
    /**
     * Runs the specified delete statement and returns the number of deleted rows
     * @param  {String} sql    statement to run
     * @param  {Object|Array} params bind parameters
     * @return {Number} deleted rows
     */
    SqliteAdapter.prototype.delete = function (sql, params) {
        var statement = this.db.prepare(sql);
        return statement.run(params).changes;
    };
    /**
     * Drops the table
     * @param  {String} table table name
     * @return {Boolean} indicates if the table was dropped
     */
    SqliteAdapter.prototype.dropTable = function (table) {
        try {
            var statement = this.db.prepare('DROP TABLE IF EXISTS "' + table + '"');
            var result = statement.run();
            var vacuum = this.db.prepare('VACUUM');
            vacuum.run();
            return result.changes === 0;
        }
        catch (e) {
            console.log('Drop Table Error', e);
            return false;
        }
    };
    /**
     * Counts rows that match the query
     * @param  {string} tableName table name from which to count
     * @param  {string} [where]     where clause
     * @param  {Object|Array} [whereArgs] where args
     * @return {Number} count
     */
    SqliteAdapter.prototype.count = function (tableName, where, whereArgs) {
        var sql = 'SELECT COUNT(*) as count FROM "' + tableName + '"';
        if (where) {
            sql += ' where ' + where;
        }
        var statement = this.db.prepare(sql);
        if (whereArgs) {
            return statement.get(whereArgs).count;
        }
        else {
            return statement.get().count;
        }
    };
    return SqliteAdapter;
}());
exports.SqliteAdapter = SqliteAdapter;

},{"better-sqlite3":undefined,"fs":192,"http":362,"os":304,"path":310}],21:[function(require,module,exports){
"use strict";
/**
 * SQLite query builder module.
 * @module db/sqliteQueryBuilder
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Utility class to build sql queries
 * @class
 */
var SqliteQueryBuilder = /** @class */ (function () {
    function SqliteQueryBuilder() {
    }
    /**
     * Replaces all whitespace in a column name with underscores
     * @param  {string} columnName column name to fix
     * @return {string}
     */
    SqliteQueryBuilder.fixColumnName = function (columnName) {
        return columnName.replace(/\W+/g, '_');
    };
    /**
     * Builds a query
     * @param  {Boolean} distinct whether query should be distinct or not
     * @param  {string} tables   table names to query, added to the query from clause
     * @param  {string[]} [columns]  columns to query for
     * @param  {string} [where]    where clause
     * @param  {string} [join]     join clause
     * @param  {string} [groupBy]  group by clause
     * @param  {string} [having]   having clause
     * @param  {string} [orderBy]  order by clause
     * @param  {Number} [limit]    limit
     * @param  {Number} [offset]   offset
     * @return {string}
     */
    SqliteQueryBuilder.buildQuery = function (distinct, tables, columns, where, join, groupBy, having, orderBy, limit, offset) {
        var query = '';
        if (SqliteQueryBuilder.isEmpty(groupBy) && !SqliteQueryBuilder.isEmpty(having)) {
            throw new Error('Illegal Arguments: having clauses require a groupBy clause');
        }
        query += 'select ';
        if (distinct) {
            query += 'distinct ';
        }
        if (columns && columns.length) {
            query = SqliteQueryBuilder.appendColumnsToString(columns, query);
        }
        else {
            query += '* ';
        }
        query += 'from ' + tables;
        if (join) {
            query += ' ' + join;
        }
        query = SqliteQueryBuilder.appendClauseToString(query, ' where ', where);
        query = SqliteQueryBuilder.appendClauseToString(query, ' group by ', groupBy);
        query = SqliteQueryBuilder.appendClauseToString(query, ' having ', having);
        query = SqliteQueryBuilder.appendClauseToString(query, ' order by ', orderBy);
        query = SqliteQueryBuilder.appendClauseToString(query, ' limit ', limit);
        query = SqliteQueryBuilder.appendClauseToString(query, ' offset ', offset);
        return query;
    };
    /**
     * Builds a count statement
     * @param  {string} tables table names to query for
     * @param  {string} [where]  where clause
     * @return {string} count statement
     */
    SqliteQueryBuilder.buildCount = function (tables, where) {
        var query = 'select count(*) as count from ' + tables;
        query = SqliteQueryBuilder.appendClauseToString(query, ' where ', where);
        return query;
    };
    ;
    /**
     * Builds an insert statement using the properties of the object
     * @param  {string} table  table to insert into
     * @param  {Object} object object to insert
     * @return {string} insert statement
     */
    SqliteQueryBuilder.buildInsert = function (table, object) {
        if (object.getColumnNames) {
            return SqliteQueryBuilder.buildInsertFromColumnNames(table, object);
        }
        var insert = 'insert into ' + table + ' (';
        var keys = '';
        var values = '';
        var first = true;
        for (var key in object) {
            if (Object.prototype.hasOwnProperty.call(object, key) && object[key] !== undefined) {
                if (!first) {
                    keys += ',';
                    values += ',';
                }
                first = false;
                keys += key;
                values += '$' + SqliteQueryBuilder.fixColumnName(key);
            }
        }
        insert += keys + ') values (' + values + ')';
        return insert;
    };
    /**
     * Builds an insert statement from the object.getColumnNames method
     * @param  {string} table  table to insert into
     * @param  {Object} object object with a getColumnNames method
     * @return {string} insert statement
     */
    SqliteQueryBuilder.buildInsertFromColumnNames = function (table, object) {
        var insert = 'insert into ' + table + ' (';
        var keys = '';
        var values = '';
        var first = true;
        var columnNames = object.getColumnNames();
        for (var i = 0; i < columnNames.length; i++) {
            var key = columnNames[i];
            if (!first) {
                keys += ',';
                values += ',';
            }
            first = false;
            keys += '"' + key + '"';
            values += '$' + SqliteQueryBuilder.fixColumnName(key);
        }
        insert += keys + ') values (' + values + ')';
        return insert;
    };
    /**
     * Builds an update or insert object to bind to a statement
     * @param  {Object} object object to create bind parameters from
     * @return {Object} bind parameters
     */
    SqliteQueryBuilder.buildUpdateOrInsertObject = function (object) {
        var insertOrUpdate = {};
        if (object.getColumnNames) {
            var columnNames = object.getColumnNames();
            for (var i = 0; i < columnNames.length; i++) {
                insertOrUpdate[SqliteQueryBuilder.fixColumnName(columnNames[i])] = object.toDatabaseValue(columnNames[i]);
            }
        }
        else {
            for (var key in object) {
                if (Object.prototype.hasOwnProperty.call(object, key) && object[key] !== undefined) {
                    if (object.toDatabaseValue) {
                        insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object.toDatabaseValue(key);
                    }
                    else {
                        if (typeof object[key] === 'boolean') {
                            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object[key] ? 1 : 0;
                        }
                        else if (object[key] instanceof Date) {
                            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = new Date(object[key]).toISOString();
                        }
                        else {
                            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object[key];
                        }
                    }
                }
            }
        }
        return insertOrUpdate;
    };
    /**
     * Builds an update statement
     * @param  {string} table     table to update
     * @param  {Object} values    object with values to update
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] where bind parameters
     * @return {Object} object with a sql property containing the update statement and an args property with bind arguments
     */
    SqliteQueryBuilder.buildUpdate = function (table, values, where, whereArgs) {
        var args = [];
        var update = 'update ' + table + ' set ';
        var first = true;
        for (var columnName in values) {
            if (!first) {
                update += ', ';
            }
            first = false;
            update += '"' + columnName + '"';
            args.push(values[columnName]);
            update += '=?';
        }
        if (whereArgs) {
            for (var i = 0; i < whereArgs.length; i++) {
                args.push(whereArgs[i]);
            }
        }
        if (where) {
            update += ' where ';
            update += where;
        }
        return {
            sql: update,
            args: args
        };
    };
    /**
     * Builds an update from an object
     * @param  {string} table  table name to update
     * @param  {Object} object object with values to update
     * @return {string} update statement
     */
    SqliteQueryBuilder.buildObjectUpdate = function (table, object) {
        var update = 'update ' + table + ' set ';
        var first = true;
        if (object.getColumnNames) {
            var columnNames = object.getColumnNames();
            for (var i = 0; i < columnNames.length; i++) {
                var key = columnNames[i];
                if (!first) {
                    update += ', ';
                }
                first = false;
                update += '"' + key + '"=';
                update += '$' + SqliteQueryBuilder.fixColumnName(key);
            }
        }
        else {
            for (var prop in object) {
                if (!first) {
                    update += ', ';
                }
                first = false;
                if (Object.prototype.hasOwnProperty.call(object, prop)) {
                    update += '"' + prop + '"=';
                    update += '$' + SqliteQueryBuilder.fixColumnName(prop);
                }
            }
        }
        return update;
    };
    SqliteQueryBuilder.appendClauseToString = function (string, name, clause) {
        if (clause) {
            string += name + clause;
        }
        return string;
    };
    SqliteQueryBuilder.appendColumnsToString = function (columns, string) {
        if (!columns || !columns.length)
            return string;
        string += SqliteQueryBuilder.columnToAppend(columns[0]);
        for (var i = 1; i < columns.length; i++) {
            string += ', ' + SqliteQueryBuilder.columnToAppend(columns[i]);
        }
        string += ' ';
        return string;
    };
    SqliteQueryBuilder.columnToAppend = function (column) {
        return column.indexOf('*') !== -1 ? column : '"' + column + '"';
    };
    SqliteQueryBuilder.isEmpty = function (string) {
        return !string || string.length === 0;
    };
    return SqliteQueryBuilder;
}());
exports.SqliteQueryBuilder = SqliteQueryBuilder;

},{}],22:[function(require,module,exports){
(function (process,Buffer){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * This adapter uses sql.js to execute queries against the GeoPackage database
 * @module db/sqljsAdapter
 * @see {@link http://kripken.github.io/sql.js/documentation/|sqljs}
 */
var sqljs = require('rtree-sql.js/dist/sql-asm-memory-growth.js');
// var sqljs = require('sql.js/js/sql.js');
/**
 * Class which adapts generic GeoPackage queries to sqljs queries
 */
var SqljsAdapter = /** @class */ (function () {
    // /**
    //  * Creates an adapter from an already established better-sqlite3 database connection
    //  * @param  {any} db sqljs database connection
    //  * @return {module:db/sqljsAdapter~Adapter}
    //  */
    // static createAdapterFromDb(db) {
    //   return new SqljsAdapter(db);
    // }
    /**
    * @param  {string|Buffer|Uint8Array} [filePath] string path to an existing file or a path to where a new file will be created or a url from which to download a GeoPackage or a Uint8Array containing the contents of the file, if undefined, an in memory database is created
    */
    function SqljsAdapter(filePath) {
        this.filePath = filePath;
    }
    /**
     * Returns a Promise which, when resolved, returns a DBAdapter which has connected to the GeoPackage database file
     */
    SqljsAdapter.prototype.initialize = function () {
        var _this = this;
        var promise = new Promise(function (resolve, reject) {
            sqljs().then(function (SQL) {
                if (_this.filePath && typeof _this.filePath === 'string') {
                    if (typeof (process) !== 'undefined' && process.version) {
                        var fs = require('fs');
                        if (_this.filePath.indexOf('http') === 0) {
                            var http = require('http');
                            http.get(_this.filePath, function (response) {
                                if (response.statusCode !== 200) {
                                    return reject(new Error('Unable to reach url: ' + _this.filePath));
                                }
                                var body = [];
                                response.on('data', function (chunk) { return body.push(chunk); });
                                response.on('end', function () {
                                    var t = new Uint8Array(Buffer.concat(body));
                                    _this.db = new SQL.Database(t);
                                    resolve(_this);
                                });
                            })
                                .on('error', function (e) {
                                return reject(e);
                            });
                        }
                        else {
                            try {
                                fs.statSync(_this.filePath);
                            }
                            catch (e) {
                                _this.db = new SQL.Database();
                                // var adapter = new SqljsAdapter(db);
                                return resolve(_this);
                            }
                            var filebuffer = fs.readFileSync(_this.filePath);
                            var t = new Uint8Array(filebuffer);
                            _this.db = new SQL.Database(t);
                            // console.log('setting wal mode');
                            // var walMode = db.exec('PRAGMA journal_mode=DELETE');
                            // console.log('walMode', walMode);
                            // adapter = new SqljsAdapter(db);
                            return resolve(_this);
                        }
                    }
                    else {
                        // eslint-disable-next-line no-undef
                        var xhr = new XMLHttpRequest();
                        xhr.open('GET', _this.filePath, true);
                        xhr.responseType = 'arraybuffer';
                        xhr.onload = function () {
                            if (xhr.status !== 200) {
                                return reject(new Error('Unable to reach url: ' + _this.filePath));
                            }
                            var uInt8Array = new Uint8Array(xhr.response);
                            _this.db = new SQL.Database(uInt8Array);
                            return resolve(_this);
                        };
                        xhr.onerror = function () {
                            return reject(new Error('Error reaching url: ' + _this.filePath));
                        };
                        xhr.send();
                    }
                }
                else if (_this.filePath) {
                    var byteArray = _this.filePath;
                    _this.db = new SQL.Database(byteArray);
                    return resolve(_this);
                }
                else {
                    _this.db = new SQL.Database();
                    return resolve(_this);
                }
            });
        });
        return promise;
    };
    /**
     * Closes the connection to the GeoPackage
     */
    SqljsAdapter.prototype.close = function () {
        this.db.close();
    };
    /**
     * Get the connection to the database file
     * @return {any}
     */
    SqljsAdapter.prototype.getDBConnection = function () {
        return this.db;
    };
    /**
     * Returns a Uint8Array containing the contents of the database as a file
     */
    SqljsAdapter.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.db.export()];
            });
        });
    };
    /**
     * Registers the given function so that it can be used by SQL statements
     * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Database.html#create_function-dynamic|sqljs create_function}
     * @param  {string} name               name of function to register
     * @param  {Function} functionDefinition function to register
     * @return {module:db/sqljsAdapter~Adapter} this
     */
    SqljsAdapter.prototype.registerFunction = function (name, functionDefinition) {
        this.db.create_function(name, functionDefinition);
        return this;
    };
    /**
     * Gets one row of results from the statement
     * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#get-dynamic|sqljs get}
     * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#getAsObject-dynamic|sqljs getAsObject}
     * @param  {String} sql    statement to run
     * @param  {Array|Object} [params] substitution parameters
     * @return {Object}
     */
    SqljsAdapter.prototype.get = function (sql, params) {
        params = params || [];
        var statement = this.db.prepare(sql);
        statement.bind(params);
        var hasResult = statement.step();
        var row;
        if (hasResult) {
            row = statement.getAsObject();
        }
        statement.free();
        return row;
    };
    /**
     * Determines if a tableName exists in the database
     * @param {String} tableName
     * @returns {Boolean}
     */
    SqljsAdapter.prototype.isTableExists = function (tableName) {
        var statement = this.db.prepare("SELECT name FROM sqlite_master WHERE type='table' AND name=:name");
        statement.bind([tableName]);
        var hasResult = statement.step();
        var row;
        if (hasResult) {
            row = statement.getAsObject();
        }
        statement.free();
        return !!row;
    };
    /**
     * Gets all results from the statement in an array
     * @param  {String} sql    statement to run
     * @param  {Array|Object} [params] bind parameters
     * @return {Object[]}
     */
    SqljsAdapter.prototype.all = function (sql, params) {
        var e_1, _a;
        var rows = [];
        var iterator = this.each(sql, params);
        try {
            for (var iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next(); !iterator_1_1.done; iterator_1_1 = iterator_1.next()) {
                var row = iterator_1_1.value;
                rows.push(row);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return rows;
    };
    /**
     * Returns an Iterable with results from the query
     * @param  {string} sql    statement to run
     * @param  {Object|Array} params bind parameters
     * @return {IterableIterator<Object>}
     */
    SqljsAdapter.prototype.each = function (sql, params) {
        var _a;
        var statement = this.db.prepare(sql);
        statement.bind(params);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                if (statement.step()) {
                    return {
                        value: statement.getAsObject(),
                        done: false
                    };
                }
                else {
                    statement.free();
                    return {
                        value: undefined,
                        done: true
                    };
                }
            },
            _a;
    };
    /**
     * Runs the statement specified, returning information about what changed
     * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#run-dynamic|sqljs run}
     * @param  {string} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {Object} object containing a changes property indicating the number of rows changed and a lastInsertROWID indicating the last inserted row
     */
    SqljsAdapter.prototype.run = function (sql, params) {
        if (params) {
            for (var key in params) {
                params['$' + key] = params[key];
            }
        }
        this.db.run(sql, params);
        var lastId = this.db.exec('select last_insert_rowid();');
        var lastInsertedId;
        if (lastId) {
            lastInsertedId = lastId[0].values[0][0];
        }
        return {
            lastInsertRowid: lastInsertedId,
            changes: this.db.getRowsModified()
        };
    };
    /**
     * Runs the specified insert statement and returns the last inserted id or undefined if no insert happened
     * @param  {String} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {Number} last inserted row id
     */
    SqljsAdapter.prototype.insert = function (sql, params) {
        if (params) {
            for (var key in params) {
                params['$' + key] = params[key];
            }
        }
        var statement = this.db.prepare(sql, params);
        statement.step();
        statement.free();
        var lastId = this.db.exec('select last_insert_rowid();');
        if (lastId) {
            return lastId[0].values[0][0];
        }
        else {
            return;
        }
    };
    /**
     * Runs the specified delete statement and returns the number of deleted rows
     * @param  {String} sql    statement to run
     * @param  {Object|Array} [params] bind parameters
     * @return {Number} deleted rows
     */
    SqljsAdapter.prototype.delete = function (sql, params) {
        var rowsModified = 0;
        var statement = this.db.prepare(sql, params);
        statement.step();
        rowsModified = this.db.getRowsModified();
        statement.free();
        return rowsModified;
    };
    /**
     * Drops the table
     * @param  {String} table table name
     * @return {Boolean} indicates if the table was dropped
     */
    SqljsAdapter.prototype.dropTable = function (table) {
        var response = this.db.exec('DROP TABLE IF EXISTS "' + table + '"');
        this.db.exec('VACUUM');
        return !!response;
    };
    /**
     * Counts rows that match the query
     * @param  {String} tableName table name from which to count
     * @param  {String} [where]     where clause
     * @param  {Object|Array} [whereArgs] where args
     * @return {Number} count
     */
    SqljsAdapter.prototype.count = function (tableName, where, whereArgs) {
        var sql = 'SELECT COUNT(*) as count FROM "' + tableName + '"';
        if (where) {
            sql += ' where ' + where;
        }
        return this.get(sql, whereArgs).count;
    };
    return SqljsAdapter;
}());
exports.SqljsAdapter = SqljsAdapter;

}).call(this,require('_process'),require("buffer").Buffer)
},{"_process":318,"buffer":197,"fs":192,"http":362,"rtree-sql.js/dist/sql-asm-memory-growth.js":336}],23:[function(require,module,exports){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var spatialReferenceSystemDao_1 = __importDefault(require("../core/srs/spatialReferenceSystemDao"));
var dataTypes_1 = __importDefault(require("./dataTypes"));
/**
 * Creates tables necessary for GeoPackages
 * @module db/tableCreator
 */
/**
 * `TableCreator` provides methods for creating the various standard tables in
 * a GeoPackage database.
 *
 * @class
 * @param {module:geoPackage~GeoPackage} geopackage GeoPackage object
 */
var TableCreator = /** @class */ (function () {
    function TableCreator(geopackage) {
        this.geopackage = geopackage;
        this.connection = geopackage.getDatabase();
    }
    /**
     * Creates all required tables and Spatial Reference Systems, in addition to EPSG:3857
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createRequired = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dao = new spatialReferenceSystemDao_1.default(this.geopackage);
                        return [4 /*yield*/, Promise.all([this.createSpatialReferenceSystem(), this.createContents()])];
                    case 1:
                        _a.sent();
                        // Create the required Spatial Reference Systems (spec Requirement 11)
                        dao.createUndefinedGeographic();
                        dao.createWgs84();
                        dao.createUndefinedCartesian();
                        // not required but very common
                        dao.createWebMercator();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Creates the spatial reference system tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createSpatialReferenceSystem = function () {
        return this.createTable('spatial_reference_system');
    };
    /**
     * Creates the contents tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createContents = function () {
        return this.createTable('contents');
    };
    /**
     * Creates the geometry columns tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createGeometryColumns = function () {
        return this.createTable('geometry_columns');
    };
    /**
     * Creates the tile matrix set tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createTileMatrixSet = function () {
        return this.createTable('tile_matrix_set');
    };
    /**
     * Creates the tile matrix tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createTileMatrix = function () {
        return this.createTable('tile_matrix');
    };
    /**
     * Creates the data columns tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createDataColumns = function () {
        return this.createTable('data_columns');
    };
    /**
     * Creates the data column constraints tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createDataColumnConstraints = function () {
        return this.createTable('data_column_constraints');
    };
    /**
     * Creates the metadata tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createMetadata = function () {
        return this.createTable('metadata');
    };
    /**
     * Creates the metadata reference tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createMetadataReference = function () {
        return this.createTable('metadata_reference');
    };
    /**
     * Creates the extensions tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createExtensions = function () {
        return this.createTable('extensions');
    };
    /**
     * Creates the table index tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createTableIndex = function () {
        return this.createTable('table_index');
    };
    /**
     * Creates the geometry index tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createGeometryIndex = function () {
        return this.createTable('geometry_index');
    };
    /**
     * Creates the feature tile link tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createFeatureTileLink = function () {
        return this.createTable('feature_tile_link');
    };
    /**
     * Creates the extended relations tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createExtendedRelations = function () {
        return this.createTable('extended_relations');
    };
    /**
     * Creates the contentsId tables
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createContentsId = function () {
        return this.createTable('contents_id');
    };
    /**
     * Creates all tables necessary for the specified table creation script name in the GeoPackage
     * @param  {string} creationScriptName creation scripts to run
     * @return {Promise<Boolean>}
     */
    TableCreator.prototype.createTable = function (creationScriptName) {
        return __awaiter(this, void 0, void 0, function () {
            var success, scripts, i, sql;
            return __generator(this, function (_a) {
                success = true;
                scripts = TableCreator.tableCreationScripts[creationScriptName];
                for (i = 0; i < scripts.length; i++) {
                    sql = scripts[i];
                    try {
                        success = success && !!this.connection.run(sql);
                    }
                    catch (error) {
                        if (error.message.indexOf('already exists') === -1) {
                            throw error;
                        }
                    }
                }
                return [2 /*return*/, success];
            });
        });
    };
    /**
     * Create the given user table.
     *
     * @param {UserTable} userTable user table to create
     * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
     * @throws {Error} if the table already exists
     */
    TableCreator.prototype.createUserTable = function (userTable) {
        var connection = this.connection;
        var result = connection.tableExists(userTable.table_name);
        if (result) {
            throw new Error('Table already exists and cannot be created: ' + userTable.table_name);
        }
        var check = '';
        var sql = 'create table \'' + userTable.table_name + '\' (';
        for (var i = 0; i < userTable.columns.length; i++) {
            var tc = userTable.columns[i];
            if (i) {
                sql += ', ';
            }
            sql += '\n\'' + tc.name + '\' ' + tc.getTypeName();
            if (tc.max !== null && tc.max !== undefined) {
                sql += '(' + tc.max + ')';
                if (check.length) {
                    check += ' AND\n';
                }
                check += '\tlength("' + tc.name + '") <= ' + tc.max;
            }
            if (tc.notNull) {
                sql += ' not null';
            }
            if (tc.primaryKey) {
                sql += ' primary key autoincrement';
            }
            if (tc.defaultValue) {
                if (tc.dataType === dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT) {
                    sql += ' default \'' + tc.defaultValue + '\'';
                }
                else {
                    sql += ' default ' + tc.defaultValue;
                }
            }
        }
        for (i = 0; i < userTable.uniqueConstraints.length; i++) {
            var uniqueConstraint = userTable.uniqueConstraints[i];
            sql += ',\n unique (';
            for (var j = 0; j < uniqueConstraint.columns.length; j++) {
                var uniqueColumn = uniqueConstraint.columns[j];
                if (j) {
                    sql += ', ';
                }
                sql += uniqueColumn.name;
            }
            sql += ')';
        }
        if (check.length) {
            sql += '\nCHECK(\n' + check + '\n)';
        }
        sql += '\n);';
        return connection.run(sql);
    };
    TableCreator.tableCreationScripts = {
        spatial_reference_system: [
            'CREATE TABLE gpkg_spatial_ref_sys (' +
                '  srs_name TEXT NOT NULL,' +
                '  srs_id INTEGER NOT NULL PRIMARY KEY,' +
                '  organization TEXT NOT NULL,' +
                '  organization_coordsys_id INTEGER NOT NULL,' +
                '  definition  TEXT NOT NULL,' +
                '  description TEXT,' +
                '  definition_12_063 TEXT NOT NULL DEFAULT "undefined"' +
                ')',
            'CREATE VIEW st_spatial_ref_sys AS' +
                ' SELECT' +
                '   srs_name,' +
                '   srs_id,' +
                '   organization,' +
                '   organization_coordsys_id,' +
                '   definition,' +
                '   description' +
                ' FROM gpkg_spatial_ref_sys',
            'CREATE VIEW spatial_ref_sys AS' +
                ' SELECT' +
                '   srs_id AS srid,' +
                '   organization AS auth_name,' +
                '   organization_coordsys_id AS auth_srid,' +
                '   definition AS srtext' +
                ' FROM gpkg_spatial_ref_sys'
        ],
        contents: [
            'CREATE TABLE gpkg_contents (' +
                ' table_name TEXT NOT NULL PRIMARY KEY,' +
                ' data_type TEXT NOT NULL,' +
                ' identifier TEXT UNIQUE,' +
                " description TEXT DEFAULT ''," +
                " last_change DATETIME NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now'))," +
                ' min_x DOUBLE,' +
                ' min_y DOUBLE,' +
                ' max_x DOUBLE,' +
                ' max_y DOUBLE,' +
                ' srs_id INTEGER,' +
                ' CONSTRAINT fk_gc_r_srs_id FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys(srs_id)' +
                ')'
        ],
        geometry_columns: [
            'CREATE TABLE gpkg_geometry_columns (' +
                '  table_name TEXT NOT NULL,' +
                '  column_name TEXT NOT NULL,' +
                '  geometry_type_name TEXT NOT NULL,' +
                '  srs_id INTEGER NOT NULL,' +
                '  z TINYINT NOT NULL,' +
                '  m TINYINT NOT NULL,' +
                '  CONSTRAINT pk_geom_cols PRIMARY KEY (table_name, column_name),' +
                '  CONSTRAINT uk_gc_table_name UNIQUE (table_name),' +
                '  CONSTRAINT fk_gc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name),' +
                '  CONSTRAINT fk_gc_srs FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys (srs_id)' +
                ')',
            'CREATE VIEW st_geometry_columns AS' +
                '  SELECT' +
                '    table_name,' +
                '    column_name,' +
                '    "ST_" || geometry_type_name AS geometry_type_name,' +
                '    g.srs_id,' +
                '    srs_name' +
                '  FROM gpkg_geometry_columns as g JOIN gpkg_spatial_ref_sys AS s' +
                '  WHERE g.srs_id = s.srs_id',
            'CREATE VIEW geometry_columns AS' +
                '  SELECT' +
                '    table_name AS f_table_name,' +
                '    column_name AS f_geometry_column,' +
                '    (CASE geometry_type_name' +
                '    	WHEN "GEOMETRY" THEN 0' +
                '    	WHEN "POINT" THEN 1' +
                '    	WHEN "LINESTRING" THEN 2' +
                '    	WHEN "POLYGON" THEN 3' +
                '    	WHEN "MULTIPOINT" THEN 4' +
                '    	WHEN "MULTILINESTRING" THEN 5' +
                '    	WHEN "MULTIPOLYGON" THEN 6' +
                '    	WHEN "GEOMETRYCOLLECTION" THEN 7' +
                '    	WHEN "CIRCULARSTRING" THEN 8' +
                '    	WHEN "COMPOUNDCURVE" THEN 9' +
                '    	WHEN "CURVEPOLYGON" THEN 10' +
                '    	WHEN "MULTICURVE" THEN 11' +
                '    	WHEN "MULTISURFACE" THEN 12' +
                '    	WHEN "CURVE" THEN 13' +
                '    	WHEN "SURFACE" THEN 14' +
                '    	WHEN "POLYHEDRALSURFACE" THEN 15' +
                '    	WHEN "TIN" THEN 16' +
                '    	WHEN "TRIANGLE" THEN 17' +
                '    	ELSE 0 END) AS geometry_type,' +
                '    2 + (CASE z WHEN 1 THEN 1 WHEN 2 THEN 1 ELSE 0 END) + (CASE m WHEN 1 THEN 1 WHEN 2 THEN 1 ELSE 0 END) AS coord_dimension,' +
                '    srs_id AS srid' +
                '  FROM gpkg_geometry_columns'
        ],
        tile_matrix_set: [
            'CREATE TABLE gpkg_tile_matrix_set (' +
                '  table_name TEXT NOT NULL PRIMARY KEY,' +
                '  srs_id INTEGER NOT NULL,' +
                '  min_x DOUBLE NOT NULL,' +
                '  min_y DOUBLE NOT NULL,' +
                '  max_x DOUBLE NOT NULL,' +
                '  max_y DOUBLE NOT NULL,' +
                '  CONSTRAINT fk_gtms_table_name FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name),' +
                '  CONSTRAINT fk_gtms_srs FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys (srs_id)' +
                ')'
        ],
        tile_matrix: [
            'CREATE TABLE gpkg_tile_matrix (' +
                '  table_name TEXT NOT NULL,' +
                '  zoom_level INTEGER NOT NULL,' +
                '  matrix_width INTEGER NOT NULL,' +
                '  matrix_height INTEGER NOT NULL,' +
                '  tile_width INTEGER NOT NULL,' +
                '  tile_height INTEGER NOT NULL,' +
                '  pixel_x_size DOUBLE NOT NULL,' +
                '  pixel_y_size DOUBLE NOT NULL,' +
                '  CONSTRAINT pk_ttm PRIMARY KEY (table_name, zoom_level),' +
                '  CONSTRAINT fk_tmm_table_name FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)' +
                ')',
            "CREATE TRIGGER 'gpkg_tile_matrix_zoom_level_insert'" +
                "BEFORE INSERT ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: zoom_level cannot be less than 0')" +
                "WHERE (NEW.zoom_level < 0);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_zoom_level_update'" +
                "BEFORE UPDATE of zoom_level ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: zoom_level cannot be less than 0')" +
                "WHERE (NEW.zoom_level < 0);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_matrix_width_insert'" +
                "BEFORE INSERT ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: matrix_width cannot be less than 1')" +
                "WHERE (NEW.matrix_width < 1);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_matrix_width_update'" +
                "BEFORE UPDATE OF matrix_width ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: matrix_width cannot be less than 1')" +
                "WHERE (NEW.matrix_width < 1);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_matrix_height_insert'" +
                "BEFORE INSERT ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: matrix_height cannot be less than 1')" +
                "WHERE (NEW.matrix_height < 1);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_matrix_height_update'" +
                "BEFORE UPDATE OF matrix_height ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: matrix_height cannot be less than 1')" +
                "WHERE (NEW.matrix_height < 1);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_pixel_x_size_insert'" +
                "BEFORE INSERT ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: pixel_x_size must be greater than 0')" +
                "WHERE NOT (NEW.pixel_x_size > 0);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_pixel_x_size_update'" +
                "BEFORE UPDATE OF pixel_x_size ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: pixel_x_size must be greater than 0')" +
                "WHERE NOT (NEW.pixel_x_size > 0);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_pixel_y_size_insert'" +
                "BEFORE INSERT ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: pixel_y_size must be greater than 0')" +
                "WHERE NOT (NEW.pixel_y_size > 0);" +
                "END",
            "CREATE TRIGGER 'gpkg_tile_matrix_pixel_y_size_update'" +
                "BEFORE UPDATE OF pixel_y_size ON 'gpkg_tile_matrix'" +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: pixel_y_size must be greater than 0')" +
                "WHERE NOT (NEW.pixel_y_size > 0);" +
                "END"
        ],
        data_columns: [
            'CREATE TABLE gpkg_data_columns (' +
                '  table_name TEXT NOT NULL,' +
                '  column_name TEXT NOT NULL,' +
                '  name TEXT,' +
                '  title TEXT,' +
                '  description TEXT,' +
                '  mime_type TEXT,' +
                '  constraint_name TEXT,' +
                '  CONSTRAINT pk_gdc PRIMARY KEY (table_name, column_name),' +
                '  CONSTRAINT fk_gdc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)' +
                ')'
        ],
        data_column_constraints: [
            'CREATE TABLE gpkg_data_column_constraints (' +
                '  constraint_name TEXT NOT NULL,' +
                '  constraint_type TEXT NOT NULL, /* "range" | "enum" | "glob" */' +
                '  value TEXT,' +
                '  min NUMERIC,' +
                '  min_is_inclusive BOOLEAN, /* 0 = false, 1 = true */' +
                '  max NUMERIC,' +
                '  max_is_inclusive BOOLEAN, /* 0 = false, 1 = true */' +
                '  description TEXT,' +
                '  CONSTRAINT gdcc_ntv UNIQUE (constraint_name, constraint_type, value)' +
                ')'
        ],
        metadata: [
            'CREATE TABLE gpkg_metadata (' +
                '  id INTEGER CONSTRAINT m_pk PRIMARY KEY ASC NOT NULL UNIQUE,' +
                '  md_scope TEXT NOT NULL DEFAULT "dataset",' +
                '  md_standard_uri TEXT NOT NULL,' +
                '  mime_type TEXT NOT NULL DEFAULT "text/xml",' +
                '  metadata TEXT NOT NULL' +
                ')',
            "CREATE TRIGGER 'gpkg_metadata_md_scope_insert' " +
                "BEFORE INSERT ON 'gpkg_metadata' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata violates " +
                "constraint: md_scope must be one of undefined | fieldSession | " +
                "collectionSession | series | dataset | featureType | feature | " +
                "attributeType | attribute | tile | model | catalogue | schema | " +
                "taxonomy software | service | collectionHardware | " +
                "nonGeographicDataset | dimensionGroup') " +
                "WHERE NOT(NEW.md_scope IN " +
                "('undefined','fieldSession','collectionSession','series','dataset', " +
                "'featureType','feature','attributeType','attribute','tile','model', " +
                "'catalogue','schema','taxonomy','software','service', " +
                "'collectionHardware','nonGeographicDataset','dimensionGroup')); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_md_scope_update' " +
                "BEFORE UPDATE OF 'md_scope' ON 'gpkg_metadata' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata violates " +
                "constraint: md_scope must be one of undefined | fieldSession | " +
                "collectionSession | series | dataset | featureType | feature | " +
                "attributeType | attribute | tile | model | catalogue | schema | " +
                "taxonomy software | service | collectionHardware | " +
                "nonGeographicDataset | dimensionGroup') " +
                "WHERE NOT(NEW.md_scope IN " +
                "('undefined','fieldSession','collectionSession','series','dataset', " +
                "'featureType','feature','attributeType','attribute','tile','model', " +
                "'catalogue','schema','taxonomy','software','service', " +
                "'collectionHardware','nonGeographicDataset','dimensionGroup')); " +
                "END"
        ],
        metadata_reference: [
            "CREATE TABLE gpkg_metadata_reference (" +
                "  reference_scope TEXT NOT NULL," +
                "  table_name TEXT," +
                "  column_name TEXT," +
                "  row_id_value INTEGER," +
                "  timestamp DATETIME NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now'))," +
                "  md_file_id INTEGER NOT NULL," +
                "  md_parent_id INTEGER," +
                "  CONSTRAINT crmr_mfi_fk FOREIGN KEY (md_file_id) REFERENCES gpkg_metadata(id)," +
                "  CONSTRAINT crmr_mpi_fk FOREIGN KEY (md_parent_id) REFERENCES gpkg_metadata(id)" +
                ")",
            "CREATE TRIGGER 'gpkg_metadata_reference_reference_scope_insert' " +
                "BEFORE INSERT ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference " +
                "violates constraint: reference_scope must be one of \"geopackage\", " +
                "table\", \"column\", \"row\", \"row/col\"') " +
                "WHERE NOT NEW.reference_scope IN " +
                "('geopackage','table','column','row','row/col'); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_reference_scope_update' " +
                "BEFORE UPDATE OF 'reference_scope' ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference " +
                "violates constraint: referrence_scope must be one of \"geopackage\", " +
                "\"table\", \"column\", \"row\", \"row/col\"') " +
                "WHERE NOT NEW.reference_scope IN " +
                "('geopackage','table','column','row','row/col'); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_column_name_insert' " +
                "BEFORE INSERT ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference " +
                "violates constraint: column name must be NULL when reference_scope " +
                "is \"geopackage\", \"table\" or \"row\"') " +
                "WHERE (NEW.reference_scope IN ('geopackage','table','row') " +
                "AND NEW.column_name IS NOT NULL); " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference " +
                "violates constraint: column name must be defined for the specified " +
                "table when reference_scope is \"column\" or \"row/col\"') " +
                "WHERE (NEW.reference_scope IN ('column','row/col') " +
                "AND NOT NEW.table_name IN ( " +
                "SELECT name FROM SQLITE_MASTER WHERE type = 'table' " +
                "AND name = NEW.table_name " +
                "AND sql LIKE ('%' || NEW.column_name || '%'))); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_column_name_update' " +
                "BEFORE UPDATE OF column_name ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference " +
                "violates constraint: column name must be NULL when reference_scope " +
                "is \"geopackage\", \"table\" or \"row\"') " +
                "WHERE (NEW.reference_scope IN ('geopackage','table','row') " +
                "AND NEW.column_nameIS NOT NULL); " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference " +
                "violates constraint: column name must be defined for the specified " +
                "table when reference_scope is \"column\" or \"row/col\"') " +
                "WHERE (NEW.reference_scope IN ('column','row/col') " +
                "AND NOT NEW.table_name IN ( " +
                "SELECT name FROM SQLITE_MASTER WHERE type = 'table' " +
                "AND name = NEW.table_name " +
                "AND sql LIKE ('%' || NEW.column_name || '%'))); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_row_id_value_insert' " +
                "BEFORE INSERT ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference " +
                "violates constraint: row_id_value must be NULL when reference_scope " +
                "is \"geopackage\", \"table\" or \"column\"') " +
                "WHERE NEW.reference_scope IN ('geopackage','table','column') " +
                "AND NEW.row_id_value IS NOT NULL; " +
                "END ",
            "CREATE TRIGGER 'gpkg_metadata_reference_row_id_value_update' " +
                "BEFORE UPDATE OF 'row_id_value' ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference " +
                "violates constraint: row_id_value must be NULL when reference_scope " +
                "is \"geopackage\", \"table\" or \"column\"') " +
                "WHERE NEW.reference_scope IN ('geopackage','table','column') " +
                "AND NEW.row_id_value IS NOT NULL; " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_timestamp_insert' " +
                "BEFORE INSERT ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference " +
                "violates constraint: timestamp must be a valid time in ISO 8601 " +
                "\"yyyy-mm-ddThh:mm:ss.cccZ\" form') " +
                "WHERE NOT (NEW.timestamp GLOB " +
                "'[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9].[0-9][0-9][0-9]Z' " +
                "AND strftime('%s',NEW.timestamp) NOT NULL); " +
                "END",
            "CREATE TRIGGER 'gpkg_metadata_reference_timestamp_update' " +
                "BEFORE UPDATE OF 'timestamp' ON 'gpkg_metadata_reference' " +
                "FOR EACH ROW BEGIN " +
                "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference " +
                "violates constraint: timestamp must be a valid time in ISO 8601 " +
                "\"yyyy-mm-ddThh:mm:ss.cccZ\" form') " +
                "WHERE NOT (NEW.timestamp GLOB " +
                "'[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9].[0-9][0-9][0-9]Z' " +
                "AND strftime('%s',NEW.timestamp) NOT NULL); " +
                "END "
        ],
        extensions: [
            'CREATE TABLE gpkg_extensions (' +
                '  table_name TEXT,' +
                '  column_name TEXT,' +
                '  extension_name TEXT NOT NULL,' +
                '  definition TEXT NOT NULL,' +
                '  scope TEXT NOT NULL,' +
                '  CONSTRAINT ge_tce UNIQUE (table_name, column_name, extension_name)' +
                ')'
        ],
        table_index: [
            'CREATE TABLE nga_table_index (' +
                '  table_name TEXT NOT NULL PRIMARY KEY,' +
                '  last_indexed DATETIME' +
                ')'
        ],
        geometry_index: [
            'CREATE TABLE nga_geometry_index (' +
                '  table_name TEXT NOT NULL,' +
                '  geom_id INTEGER NOT NULL,' +
                '  min_x DOUBLE NOT NULL,' +
                '  max_x DOUBLE NOT NULL,' +
                '  min_y DOUBLE NOT NULL,' +
                '  max_y DOUBLE NOT NULL,' +
                '  min_z DOUBLE,' +
                '  max_z DOUBLE,' +
                '  min_m DOUBLE,' +
                '  max_m DOUBLE,' +
                '  CONSTRAINT pk_ngi PRIMARY KEY (table_name, geom_id),' +
                '  CONSTRAINT fk_ngi_nti_tn FOREIGN KEY (table_name) REFERENCES nga_table_index(table_name)' +
                ')'
        ],
        feature_tile_link: [
            'CREATE TABLE nga_feature_tile_link (' +
                '  feature_table_name TEXT NOT NULL,' +
                '  tile_table_name TEXT NOT NULL,' +
                '  CONSTRAINT pk_nftl PRIMARY KEY (feature_table_name, tile_table_name)' +
                ')'
        ],
        extended_relations: [
            'CREATE TABLE gpkgext_relations (' +
                '  id INTEGER PRIMARY KEY AUTOINCREMENT,' +
                '  base_table_name TEXT NOT NULL,' +
                '  base_primary_column TEXT NOT NULL DEFAULT \'id\',' +
                '  related_table_name TEXT NOT NULL,' +
                '  related_primary_column TEXT NOT NULL DEFAULT \'id\',' +
                '  relation_name TEXT NOT NULL,' +
                '  mapping_table_name TEXT NOT NULL UNIQUE' +
                ')'
        ],
        contents_id: [
            'CREATE TABLE nga_contents_id (' +
                '  id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,' +
                '  table_name TEXT NOT NULL,' +
                '  CONSTRAINT uk_nci_table_name UNIQUE (table_name),' +
                '  CONSTRAINT fk_nci_gc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)' +
                ')'
        ]
    };
    return TableCreator;
}());
exports.TableCreator = TableCreator;

},{"../core/srs/spatialReferenceSystemDao":11,"./dataTypes":18}],24:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var extension_1 = __importDefault(require("./extension"));
/**
 * Base Extension
 */
/**
 * Abstract base GeoPackage extension
 */
var BaseExtension = /** @class */ (function () {
    /**
     * @param {module:geoPackage~GeoPackage} geoPackage
     */
    function BaseExtension(geoPackage) {
        this.geoPackage = geoPackage;
        this.connection = geoPackage.connection;
        this.extensionsDao = geoPackage.getExtensionDao();
    }
    /**
     * Get the extension or create as needed
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @param  {String}   definition    extension definition
     * @param  {String}   scopeType     extension scope type
     * @return {Promise<Extension>}
     */
    BaseExtension.prototype.getOrCreate = function (extensionName, tableName, columnName, definition, scopeType) {
        var extension = this.getExtension(extensionName, tableName, columnName);
        if (extension.length) {
            return Promise.resolve(extension[0]);
        }
        return this.extensionsDao.createTable()
            .then(function () {
            return this.createExtension(extensionName, tableName, columnName, definition, scopeType);
        }.bind(this));
    };
    /**
     * Get the extension for the name, table name and column name
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @return {Extension[]}
     */
    BaseExtension.prototype.getExtension = function (extensionName, tableName, columnName) {
        if (!this.extensionsDao.isTableExists()) {
            return [];
        }
        return this.extensionsDao.queryByExtensionAndTableNameAndColumnName(extensionName, tableName, columnName);
    };
    /**
     * Determine if the GeoPackage has the extension
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @returns {Boolean} if the extension exists
     */
    BaseExtension.prototype.hasExtension = function (extensionName, tableName, columnName) {
        return !!this.getExtension(extensionName, tableName, columnName).length;
    };
    /**
     * Create the extension
     * @param {string} extensionName
     * @param {string} tableName
     * @param {string} columnName
     * @param {string} definition
     * @param {string} scopeType
     */
    BaseExtension.prototype.createExtension = function (extensionName, tableName, columnName, definition, scopeType) {
        var extension = new extension_1.default();
        extension.table_name = tableName;
        extension.column_name = columnName;
        extension.extension_name = extensionName;
        extension.definition = definition;
        extension.scope = scopeType;
        return this.extensionsDao.create(extension);
    };
    return BaseExtension;
}());
exports.default = BaseExtension;

},{"./extension":29}],25:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/contents
 * @class ContentsId
 */
/**
 * Contents Id object, for maintaining a unique identifier for contents tables
 * @constructor
 */
var ContentsId = /** @class */ (function () {
    function ContentsId() {
    }
    return ContentsId;
}());
exports.default = ContentsId;

},{}],26:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
/**
 * @memberOf module:extension/contents
 * @class ContentsIdDao
 */
var contentsId_1 = __importDefault(require("./contentsId"));
/**
 * Contents Id Data Access Object
 * @constructor
 * @extends Dao
 */
var ContentsIdDao = /** @class */ (function (_super) {
    __extends(ContentsIdDao, _super);
    function ContentsIdDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ContentsIdDao.TABLE_NAME;
        _this.idColumns = ['id'];
        return _this;
    }
    /**
     * Create a {module:extension/contents.ContentsId} object
     * @return {module:extension/contents.ContentsId}
     */
    ContentsIdDao.prototype.createObject = function () {
        return new contentsId_1.default();
    };
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    ContentsIdDao.prototype.createTable = function () {
        return this.geoPackage.getTableCreator().createContentsId();
    };
    /**
     * Get all the table names
     * @return {string[]}
     */
    ContentsIdDao.prototype.getTableNames = function () {
        var tableNames = [];
        var tableNameColumns = this.queryForColumns('table_name');
        for (var i = 0; i < tableNameColumns.length; i++) {
            tableNames.push(tableNameColumns[i].table_name);
        }
        return tableNames;
    };
    /**
     * Query by table name
     * @param  {string} tableName name of the table
     * @return {module:extension/contents.ContentsId}
     */
    ContentsIdDao.prototype.queryForTableName = function (tableName) {
        var contentsIds = this.queryForAll(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
        if (contentsIds.length > 0) {
            return contentsIds[0];
        }
        else {
            return null;
        }
    };
    /**
     * Delete by tableName
     * @param  {string} tableName the table name to delete by
     * @return {number} number of deleted rows
     */
    ContentsIdDao.prototype.deleteByTableName = function (tableName) {
        return this.deleteWhere(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
    };
    ContentsIdDao.TABLE_NAME = 'nga_contents_id';
    ContentsIdDao.COLUMN_ID = 'id';
    ContentsIdDao.COLUMN_TABLE_NAME = 'table_name';
    return ContentsIdDao;
}(dao_1.default));
exports.default = ContentsIdDao;

},{"../../dao/dao":13,"./contentsId":25}],27:[function(require,module,exports){
"use strict";
/**
 * @module extension/contents
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var contentsIdDao_1 = __importDefault(require("./contentsIdDao"));
var contentsDao_1 = __importDefault(require("../../core/contents/contentsDao"));
/**
 * Style extension
 */
var ContentsIdExtension = /** @class */ (function (_super) {
    __extends(ContentsIdExtension, _super);
    function ContentsIdExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.contentsIdDao = geoPackage.getContentsIdDao();
        return _this;
    }
    /**
       * Get or create the contents id extension
       * @return {Promise}
       */
    ContentsIdExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(ContentsIdExtension.EXTENSION_NAME, null, null, ContentsIdExtension.EXTENSION_DEFINITION, extension_1.default.READ_WRITE)
            .then(function () {
            return this.contentsIdDao.createTable();
        }.bind(this));
    };
    /**
       * Get the ContentsIdDao
       * @returns {module:extension/contents.ContentsIdDao}
       */
    ContentsIdExtension.prototype.getDao = function () {
        return this.contentsIdDao;
    };
    ContentsIdExtension.prototype.has = function () {
        return this.hasExtension(ContentsIdExtension.EXTENSION_NAME, null, null) && this.contentsIdDao.isTableExists();
    };
    /**
       * Get the ContentsId object
       * @param contents {module:core/contents.Contents}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.get = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
       * Get the ContentsId object
       * @param tableName
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.getByTableName = function (tableName) {
        var contentsId = null;
        if (this.contentsIdDao.isTableExists()) {
            contentsId = this.contentsIdDao.queryForTableName(tableName);
        }
        return contentsId;
    };
    /**
       * Get the ContentsId id
       * @param contents {module:core/contents.Contents}
       * @returns {Number}
       */
    ContentsIdExtension.prototype.getId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getIdByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
       * Get the ContentsId id
       * @param tableName
       * @returns {Number}
       */
    ContentsIdExtension.prototype.getIdByTableName = function (tableName) {
        var id = null;
        if (this.contentsIdDao.isTableExists()) {
            var contentsId = this.contentsIdDao.queryForTableName(tableName);
            if (contentsId) {
                id = contentsId.id;
            }
        }
        return id;
    };
    /**
       * Creates contentsId for contents
       * @param contents {module:core/contents.Contents}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.create = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.createWithTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
       * Creates contentsId for contents
       * @param tableName
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.createWithTableName = function (tableName) {
        var contentsId = this.contentsIdDao.createObject();
        contentsId.table_name = tableName;
        contentsId.id = this.contentsIdDao.create(contentsId);
        return contentsId;
    };
    /**
       * Creates contentsId for contents
       * @param contents {module:core/contents.Contents}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.createId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.createIdWithTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
       * Creates contentsId for contents
       * @param tableName {string}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.createIdWithTableName = function (tableName) {
        return this.createWithTableName(tableName);
    };
    /**
       * Gets or creates contentsId for contents
       * @param contents {module:core/contents.Contents}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.getOrCreateId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getOrCreateIdByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
       * Gets or creates contentsId for table name
       * @param tableName {string}
       * @returns {module:extension/contents.ContentsId}
       */
    ContentsIdExtension.prototype.getOrCreateIdByTableName = function (tableName) {
        var contentId = this.getByTableName(tableName);
        if (contentId == null) {
            contentId = this.createWithTableName(tableName);
        }
        return contentId;
    };
    /**
       * Deletes contentsId for contents
       * @param contents {module:core/contents.Contents}
       */
    ContentsIdExtension.prototype.deleteId = function (contents) {
        var deleted = 0;
        if (contents && contents.table_name) {
            deleted = this.deleteIdByTableName(contents.table_name);
        }
        return deleted;
    };
    /**
       * Deletes contentId for table name
       * @param tableName {string}
       */
    ContentsIdExtension.prototype.deleteIdByTableName = function (tableName) {
        return this.contentsIdDao.deleteByTableName(tableName);
    };
    /**
       * Number of contentsIds
       * @returns {number}
       */
    ContentsIdExtension.prototype.count = function () {
        var count = 0;
        if (this.has()) {
            count = this.contentsIdDao.count();
        }
        return count;
    };
    /**
       * Create contentsIds for contents of type passed in
       * @param type defaults to ""
       * @returns {number}
       */
    ContentsIdExtension.prototype.createIds = function (type) {
        if (type === void 0) { type = ""; }
        var missing = this.getMissing(type);
        for (var i = 0; i < missing.length; i++) {
            this.getOrCreateIdByTableName(missing[i].table_name);
        }
        return missing.length;
    };
    /**
       * Deletes ids by type
       * @param type
       * @returns {number}
       */
    ContentsIdExtension.prototype.deleteIds = function (type) {
        if (type === void 0) { type = ""; }
        var deleted = 0;
        if (this.has()) {
            if (type.length === 0) {
                deleted = this.contentsIdDao.deleteAll();
            }
            else {
                var ids = this.getIdsByType(type);
                for (var i = 0; i < ids.length; i++) {
                    deleted += this.contentsIdDao.deleteById(ids[i].id);
                }
            }
        }
        return deleted;
    };
    ContentsIdExtension.prototype.getIdsByType = function (type) {
        if (type === void 0) { type = ""; }
        var contentIds = [];
        if (this.has()) {
            var query = "SELECT ";
            query += contentsIdDao_1.default.COLUMN_ID;
            query += ", ";
            query += contentsIdDao_1.default.COLUMN_TABLE_NAME;
            query += " FROM " + contentsIdDao_1.default.TABLE_NAME;
            query += " WHERE ";
            query += contentsIdDao_1.default.COLUMN_TABLE_NAME;
            query += " IN (SELECT ";
            query += contentsDao_1.default.COLUMN_TABLE_NAME;
            query += " FROM ";
            query += contentsDao_1.default.TABLE_NAME;
            var where = "";
            var params = [];
            if (type != null && type.length > 0) {
                where += contentsDao_1.default.COLUMN_DATA_TYPE;
                where += " = ?";
                params.push(type);
            }
            if (where.length > 0) {
                query += " WHERE " + where;
            }
            query += ")";
            contentIds = this.connection.all(query, params);
        }
        return contentIds;
    };
    /**
     * @typedef ContentsTableName
     * @type {Object}
     * @property {string} table_name the table name
     *
       * Get contents without contents ids
       * @param type
       * @returns {ContentsTableName[]} contentsTableNames
       */
    ContentsIdExtension.prototype.getMissing = function (type) {
        if (type === void 0) { type = ""; }
        var query = "SELECT " + contentsDao_1.default.COLUMN_TABLE_NAME + " FROM " + contentsDao_1.default.TABLE_NAME;
        var where = "";
        var params = [];
        if (type != null && type.length > 0) {
            where += contentsDao_1.default.COLUMN_DATA_TYPE;
            where += " = ?";
            params.push(type);
        }
        if (this.has()) {
            if (where.length > 0) {
                where += " AND ";
            }
            where += contentsDao_1.default.COLUMN_TABLE_NAME;
            where += " NOT IN (SELECT ";
            where += contentsIdDao_1.default.COLUMN_TABLE_NAME;
            where += " FROM ";
            where += contentsIdDao_1.default.TABLE_NAME;
            where += ")";
        }
        if (where.length > 0) {
            query += " WHERE " + where;
        }
        return this.connection.all(query, params);
    };
    /**
       * Remove contents id extension
       */
    ContentsIdExtension.prototype.removeExtension = function () {
        if (this.contentsIdDao.isTableExists()) {
            this.geoPackage.deleteTable(contentsIdDao_1.default.TABLE_NAME);
        }
        if (this.extensionsDao.isTableExists()) {
            this.extensionsDao.deleteByExtension(ContentsIdExtension.EXTENSION_NAME);
        }
    };
    ContentsIdExtension.EXTENSION_NAME = 'nga_contents_id';
    ContentsIdExtension.EXTENSION_AUTHOR = 'nga';
    ContentsIdExtension.EXTENSION_NAME_NO_AUTHOR = 'contents_id';
    ContentsIdExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/contents-id.html';
    return ContentsIdExtension;
}(baseExtension_1.default));
exports.default = ContentsIdExtension;

},{"../../core/contents/contentsDao":9,"../baseExtension":24,"../extension":29,"./contentsIdDao":26}],28:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var extension_1 = __importDefault(require("../extension"));
var baseExtension_1 = __importDefault(require("../baseExtension"));
/**
 * OGC Well known text representation of Coordinate Reference Systems extensionName
 */
var CrsWktExtension = /** @class */ (function (_super) {
    __extends(CrsWktExtension, _super);
    /**
     * OGC Well known text representation of Coordinate Reference Systems extensionName
     */
    function CrsWktExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = CrsWktExtension.EXTENSION_NAME;
        _this.extensionDefinition = CrsWktExtension.EXTENSION_CRS_WKT_DEFINITION;
        return _this;
    }
    /**
     * Get or create the extension
     */
    CrsWktExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, extension_1.default.READ_WRITE);
    };
    CrsWktExtension.EXTENSION_NAME = 'gpkg_crs_wkt';
    CrsWktExtension.EXTENSION_CRS_WKT_AUTHOR = 'gpkg';
    CrsWktExtension.EXTENSION_CRS_WKT_NAME_NO_AUTHOR = 'crs_wkt';
    CrsWktExtension.EXTENSION_CRS_WKT_DEFINITION = 'http://www.geopackage.org/spec/#extension_crs_wkt';
    return CrsWktExtension;
}(baseExtension_1.default));
exports.default = CrsWktExtension;

},{"../baseExtension":24,"../extension":29}],29:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
  * Indicates that a particular extension applies to a GeoPackage, a table in a
  * GeoPackage or a column of a table in a GeoPackage. An application that access
  * a GeoPackage can query the gpkg_extensions table instead of the contents of
  * all the user data tables to determine if it has the required capabilities to
  * read or write to tables with extensions, and to “fail fast” and return an
  * error message if it does not.
 */
var Extension = /** @class */ (function () {
    function Extension() {
    }
    Extension.prototype.setExtensionName = function (author, extensionName) {
        this.extension_name = Extension.buildExtensionName(author, extensionName);
    };
    Extension.prototype.getAuthor = function () {
        return Extension.getAuthorWithExtensionName(this.extension_name);
    };
    Extension.prototype.getExtensionNameNoAuthor = function () {
        return Extension.getExtensionNameNoAuthor(this.extension_name);
    };
    Extension.buildExtensionName = function (author, extensionName) {
        return author + Extension.EXTENSION_NAME_DIVIDER + extensionName;
    };
    Extension.getAuthorWithExtensionName = function (extensionName) {
        return extensionName.split(Extension.EXTENSION_NAME_DIVIDER)[0];
    };
    Extension.getExtensionNameNoAuthor = function (extensionName) {
        return extensionName.slice(extensionName.indexOf(Extension.EXTENSION_NAME_DIVIDER) + 1);
    };
    Extension.EXTENSION_NAME_DIVIDER = "_";
    Extension.READ_WRITE = "read-write";
    Extension.WRITE_ONLY = "write-only";
    return Extension;
}());
exports.default = Extension;

},{}],30:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var extension_1 = __importDefault(require("./extension"));
var dao_1 = __importDefault(require("../dao/dao"));
var columnValues_1 = __importDefault(require("../dao/columnValues"));
var tableCreator_1 = require("../db/tableCreator");
/**
 * Extension Data Access Object
 * @class
 * @extends Dao
 */
var ExtensionDao = /** @class */ (function (_super) {
    __extends(ExtensionDao, _super);
    function ExtensionDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ExtensionDao.TABLE_NAME;
        _this.idColumns = [ExtensionDao.COLUMN_TABLE_NAME, ExtensionDao.COLUMN_COLUMN_NAME, ExtensionDao.COLUMN_EXTENSION_NAME];
        return _this;
    }
    /**
     * Creates an Extension object from the raw database row
     * @param {object} row raw database row
     * @returns {Extension}
     */
    ExtensionDao.prototype.createObject = function (row) {
        var e = new extension_1.default();
        for (var key in row) {
            e[key] = row[key];
        }
        return e;
    };
    /**
     * Query by extension name and return the first result
     * @param {String} extensionName extension name
     * @returns {Extension}
     */
    ExtensionDao.prototype.queryByExtension = function (extensionName) {
        var results = this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        if (!results[0])
            return;
        var e = this.createObject(results[0]);
        return e;
    };
    /**
     * Query by extension name and return all results
     * @param {String} extensionName extension name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryAllByExtension = function (extensionName) {
        var e_1, _a;
        var extensions = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return extensions;
    };
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryByExtensionAndTableName = function (extensionName, tableName) {
        var e_2, _a;
        var values = new columnValues_1.default();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        var extensions = [];
        try {
            for (var _b = __values(this.queryForFieldValues(values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (extensions.length) {
            return extensions;
        }
        else {
            return;
        }
    };
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @param {String} columnName column name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryByExtensionAndTableNameAndColumnName = function (extensionName, tableName, columnName) {
        var e_3, _a;
        var values = new columnValues_1.default();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        values.addColumn(ExtensionDao.COLUMN_COLUMN_NAME, columnName);
        var extensions = [];
        try {
            for (var _b = __values(this.queryForFieldValues(values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return extensions;
    };
    /**
     * Creates the extensions table
     */
    ExtensionDao.prototype.createTable = function () {
        var tc = new tableCreator_1.TableCreator(this.geoPackage);
        return tc.createExtensions();
    };
    /**
     * Deletes all extension entries with this name
     * @param {String} extensionName extension name to delete
     * @returns {Number} Number of extensions deleted
     */
    ExtensionDao.prototype.deleteByExtension = function (extensionName) {
        var values = new columnValues_1.default();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        return this.deleteWhere(this.buildWhere(values, '='), this.buildWhereArgs(values));
    };
    /**
     * Deletes all extension entries with this name and table name
     * @param {String} extensionName extension name to delete
     * @param {String} tableName table name to delete
     * @returns {Number} Number of extensions deleted
     */
    ExtensionDao.prototype.deleteByExtensionAndTableName = function (extensionName, tableName) {
        var values = new columnValues_1.default();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        return this.deleteWhere(this.buildWhere(values, 'and'), this.buildWhereArgs(values));
    };
    ExtensionDao.TABLE_NAME = "gpkg_extensions";
    ExtensionDao.COLUMN_TABLE_NAME = "table_name";
    ExtensionDao.COLUMN_COLUMN_NAME = "column_name";
    ExtensionDao.COLUMN_EXTENSION_NAME = "extension_name";
    ExtensionDao.COLUMN_DEFINITION = "definition";
    ExtensionDao.COLUMN_SCOPE = "scope";
    return ExtensionDao;
}(dao_1.default));
exports.default = ExtensionDao;

},{"../dao/columnValues":12,"../dao/dao":13,"../db/tableCreator":23,"./extension":29}],31:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Feature Table Index
 * @module extension/index
 */
var rtreeIndex_1 = __importDefault(require("../rtree/rtreeIndex"));
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var tableIndex_1 = __importDefault(require("./tableIndex"));
var geometryIndexDao_1 = __importDefault(require("./geometryIndexDao"));
var rtreeIndexDao_1 = __importDefault(require("../rtree/rtreeIndexDao"));
var envelopeBuilder_1 = __importDefault(require("../../geom/envelopeBuilder"));
/**
 * This class will either use the RTree index if it exists, or the
 * Feature Table Index NGA Extension implementation. This extension is used to
 * index Geometries within a feature table by their minimum bounding box for
 * bounding box queries.
 * @class
 * @extends BaseExtension
 */
var FeatureTableIndex = /** @class */ (function (_super) {
    __extends(FeatureTableIndex, _super);
    function FeatureTableIndex(geoPackage, featureDao) {
        var _this = _super.call(this, geoPackage) || this;
        _this.progress;
        /**
         * Feature Dao to index
         * @type {module:features/user/featureDao~FeatureDao}
         */
        _this.featureDao = featureDao;
        _this.extensionName = extension_1.default.buildExtensionName(FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_AUTHOR, FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_NAME_NO_AUTHOR);
        _this.extensionDefinition = FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_DEFINITION;
        _this.tableName = featureDao.table_name;
        _this.columnName = featureDao.getGeometryColumnName();
        _this.tableIndexDao = geoPackage.getTableIndexDao();
        _this.geometryIndexDao = geoPackage.getGeometryIndexDao(featureDao);
        _this.rtreeIndexDao = new rtreeIndexDao_1.default(geoPackage, featureDao);
        _this.rtreeIndexDao.gpkgTableName = 'rtree_' + _this.tableName + '_' + _this.columnName;
        _this.rtreeIndex = new rtreeIndex_1.default(geoPackage, featureDao);
        /**
         * true if the table is indexed with an RTree
         * @type {Boolean}
         */
        _this.rtreeIndexed = _this.hasExtension('gpkg_rtree_index', _this.tableName, _this.columnName);
        return _this;
    }
    /**
     * Index the table if not already indexed
     * @param  {Function} progress function which is called with progress while indexing
     * @return {Promise<Boolean>} promise resolved when the indexing is complete
     */
    FeatureTableIndex.prototype.index = function (progress) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.indexWithForce(false, progress)];
            });
        });
    };
    /**
     * Index the table if not already indexed or force is true
     * @param  {Boolean} force force index even if the table is already indexed
     * @param  {Function} progress function which is called with progress while indexing
     * @return {Promise<Boolean>} promise resolved when the indexing is complete
     */
    FeatureTableIndex.prototype.indexWithForce = function (force, progress) {
        return __awaiter(this, void 0, void 0, function () {
            var indexed, tableIndex;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        progress = progress || function () { };
                        this.progress = function (message) {
                            setTimeout(progress, 0, message);
                        };
                        indexed = this.isIndexed();
                        if (!(force || !indexed)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.getOrCreateExtension()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.getOrCreateTableIndex()];
                    case 2:
                        tableIndex = _a.sent();
                        return [4 /*yield*/, this.createOrClearGeometryIndicies()];
                    case 3:
                        _a.sent();
                        return [2 /*return*/, this.indexTable(tableIndex)];
                    case 4: return [2 /*return*/, indexed];
                }
            });
        });
    };
    /**
     * Check if the table is indexed either with an RTree or the NGA Feature Table Index
     * @return {Boolean}
     */
    FeatureTableIndex.prototype.isIndexed = function () {
        if (this.rtreeIndexed)
            return true;
        try {
            var result = this.getFeatureTableIndexExtension();
            if (result) {
                var contentsDao = this.geoPackage.getContentsDao();
                var contents = contentsDao.queryForId(this.tableName);
                if (!contents)
                    return false;
                var lastChange = new Date(contents.last_change);
                var tableIndex = this.tableIndexDao.queryForId(this.tableName);
                if (!tableIndex || !tableIndex.last_indexed) {
                    return false;
                }
                var lastIndexed = new Date(tableIndex.last_indexed);
                return lastIndexed >= lastChange;
            }
            else {
                return false;
            }
        }
        catch (e) {
            return false;
        }
    };
    /**
     * Returns the feature table index extension for this table and column name if exists
     * @return {module:extension~Extension}
     */
    FeatureTableIndex.prototype.getFeatureTableIndexExtension = function () {
        return this.getExtension(this.extensionName, this.tableName, this.columnName);
    };
    /**
     * Get or create the extension for this table name and column name
     * @return {module:extension~Extension}
     */
    FeatureTableIndex.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, this.tableName, this.columnName, this.extensionDefinition, extension_1.default.READ_WRITE);
    };
    /**
     * Get or create if needed the table index
     * @return {Promise<TableIndex>}
     */
    FeatureTableIndex.prototype.getOrCreateTableIndex = function () {
        var tableIndex = this.getTableIndex();
        if (tableIndex)
            return Promise.resolve(tableIndex);
        return this.tableIndexDao.createTable()
            .then(function () {
            this.createTableIndex();
            return this.getTableIndex();
        }.bind(this));
    };
    /**
     * Create the table index
     * @return {module:extension/index~TableIndex}
     */
    FeatureTableIndex.prototype.createTableIndex = function () {
        var ti = new tableIndex_1.default();
        ti.table_name = this.tableName;
        ti.last_indexed = new Date();
        return this.tableIndexDao.create(ti);
    };
    /**
     * Get the table index
     * @return {module:extension/index~TableIndex}
     */
    FeatureTableIndex.prototype.getTableIndex = function () {
        if (this.tableIndexDao.isTableExists()) {
            return this.tableIndexDao.queryForId(this.tableName);
        }
        else {
            return;
        }
    };
    /**
     * Clear the geometry indices or create the table if needed
     * @return {Promise} resolved when complete
     */
    FeatureTableIndex.prototype.createOrClearGeometryIndicies = function () {
        return this.geometryIndexDao.createTable()
            .then(function () {
            return this.clearGeometryIndicies();
        }.bind(this));
    };
    /**
     * Clears the geometry indices
     * @return {Number} number of rows deleted
     */
    FeatureTableIndex.prototype.clearGeometryIndicies = function () {
        var where = this.geometryIndexDao.buildWhereWithFieldAndValue(geometryIndexDao_1.default.COLUMN_TABLE_NAME, this.tableName);
        var whereArgs = this.geometryIndexDao.buildWhereArgs(this.tableName);
        return this.geometryIndexDao.deleteWhere(where, whereArgs);
    };
    /**
     * Indexes the table
     * @param  {module:extension/index~TableIndex} tableIndex TableIndex
     * @return {Promise} resolved when complete
     */
    FeatureTableIndex.prototype.indexTable = function (tableIndex) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        setTimeout(function () {
                            this.indexChunk(0, tableIndex, resolve, reject);
                        }.bind(this));
                    }.bind(this))
                        .then(function () {
                        return this.updateLastIndexed(tableIndex).changes === 1;
                    }.bind(this))];
            });
        });
    };
    /**
     * Indexes a chunk of 100 rows
     * @param  {Number} page       page to start on
     * @param  {module:extension/index~TableIndex} tableIndex TableIndex
     * @param  {Function} resolve    function to call when all chunks are indexed
     * @param  {Function} reject     called if there is an error
     */
    FeatureTableIndex.prototype.indexChunk = function (page, tableIndex, resolve, reject) {
        var rows = this.featureDao.queryForChunk(100, page);
        if (rows.length) {
            this.progress('Indexing ' + (page * 100) + ' to ' + ((page + 1) * 100));
            console.log('Indexing ' + (page * 100) + ' to ' + ((page + 1) * 100));
            rows.forEach(function (row) {
                var fr = this.featureDao.getRow(row);
                this.indexRow(tableIndex, fr.getId(), fr.getGeometry());
            }.bind(this));
            setTimeout(function () {
                this.indexChunk(++page, tableIndex, resolve, reject);
            }.bind(this));
        }
        else {
            resolve();
        }
    };
    /**
     * Indexes a row
     * @param  {module:extension/index~TableIndex} tableIndex TableIndex`
     * @param  {Number} geomId     id of the row
     * @param  {module:geom/geometryData~GeometryData} geomData   GeometryData to index
     * @return {Boolean} success
     */
    FeatureTableIndex.prototype.indexRow = function (tableIndex, geomId, geomData) {
        if (!geomData)
            return false;
        var envelope = geomData.envelope;
        if (!envelope) {
            var geometry = geomData.geometry;
            if (geometry) {
                envelope = envelopeBuilder_1.default.buildEnvelopeWithGeometry(geometry);
            }
        }
        if (envelope) {
            var geometryIndex = this.geometryIndexDao.populate(tableIndex, geomId, envelope);
            return this.geometryIndexDao.createOrUpdate(geometryIndex);
        }
        else {
            return false;
        }
    };
    /**
     * Update the last time this feature table was indexed
     * @param  {module:extension/index~TableIndex} tableIndex TableIndex
     * @return {Object} update status
     */
    FeatureTableIndex.prototype.updateLastIndexed = function (tableIndex) {
        if (!tableIndex) {
            tableIndex = new tableIndex_1.default();
            tableIndex.table_name = this.tableName;
        }
        tableIndex.last_indexed = new Date().toISOString();
        var updateIndex = this.tableIndexDao.createOrUpdate(tableIndex);
        return updateIndex;
    };
    /**
     * Query the index with the specified bounding box and projection
     * @param  {module:boundingBox~BoundingBox} boundingBox bounding box to query for
     * @param  {string} projection  projection the boundingBox is in
     * @return {IterableIterator}
     */
    FeatureTableIndex.prototype.queryWithBoundingBox = function (boundingBox, projection) {
        var projectedBoundingBox = boundingBox.projectBoundingBox(projection, this.featureDao.projection);
        var envelope = projectedBoundingBox.buildEnvelope();
        return this.queryWithGeometryEnvelope(envelope);
    };
    /**
     * Query witha geometry envelope
     * @param  {any} envelope envelope
     * @return {IterableIterator<any>}
     */
    FeatureTableIndex.prototype.queryWithGeometryEnvelope = function (envelope) {
        if (this.rtreeIndexed) {
            return this.rtreeIndexDao.queryWithGeometryEnvelope(envelope);
        }
        else {
            return this.geometryIndexDao.queryWithGeometryEnvelope(envelope);
        }
    };
    /**
     * Count the index with the specified bounding box and projection
     * @param  {module:boundingBox~BoundingBox} boundingBox bounding box to query for
     * @param  {string} projection  projection the boundingBox is in
     * @return {Number}
     */
    FeatureTableIndex.prototype.countWithBoundingBox = function (boundingBox, projection) {
        var projectedBoundingBox = boundingBox.projectBoundingBox(projection, this.featureDao.projection);
        var envelope = projectedBoundingBox.buildEnvelope();
        return this.countWithGeometryEnvelope(envelope);
    };
    /**
     * Count with a geometry envelope
     * @param  {any} envelope envelope
     * @return {Number}
     */
    FeatureTableIndex.prototype.countWithGeometryEnvelope = function (envelope) {
        if (this.rtreeIndexed) {
            return this.rtreeIndexDao.countWithGeometryEnvelope(envelope);
        }
        else {
            return this.geometryIndexDao.countWithGeometryEnvelope(envelope);
        }
    };
    FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_AUTHOR = 'nga';
    FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_NAME_NO_AUTHOR = 'geometry_index';
    FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/geometry-index.html';
    return FeatureTableIndex;
}(baseExtension_1.default));
exports.default = FeatureTableIndex;

},{"../../geom/envelopeBuilder":82,"../baseExtension":24,"../extension":29,"../rtree/rtreeIndex":52,"../rtree/rtreeIndexDao":53,"./geometryIndexDao":33,"./tableIndex":34}],32:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Geometry Index object, for indexing data within user tables
 * @class
 */
var GeometryIndex = /** @class */ (function () {
    function GeometryIndex() {
    }
    GeometryIndex.prototype.setTableIndex = function (tableIndex) {
        this.table_name = tableIndex.table_name;
    };
    return GeometryIndex;
}());
exports.default = GeometryIndex;

},{}],33:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var geometryIndex_1 = __importDefault(require("./geometryIndex"));
var tableCreator_1 = require("../../db/tableCreator");
/**
 * Geometry Index Data Access Object
 * @class
 * @extends Dao
 */
var GeometryIndexDao = /** @class */ (function (_super) {
    __extends(GeometryIndexDao, _super);
    function GeometryIndexDao(geoPackage, featureDao) {
        var _this = _super.call(this, geoPackage) || this;
        _this.gpkgTableName = GeometryIndexDao.TABLE_NAME;
        _this.idColumns = ['table_name', 'geom_id'];
        _this.featureDao = featureDao;
        return _this;
    }
    GeometryIndexDao.prototype.createObject = function () {
        return new geometryIndex_1.default();
    };
    /**
     * Get the Table Index of the Geometry Index
     *
     * @param {module:extension/index~GeometryIndex} geometryIndex geometry index
     * @return {module:extension/index~TableIndex}
     */
    GeometryIndexDao.prototype.getTableIndex = function (geometryIndex) {
        var dao = this.geoPackage.getTableIndexDao();
        return dao.queryForId(geometryIndex.tableName);
    };
    /**
     * Query by table name
     * @param  {string} tableName table name
     * @return {Iterable}
     */
    GeometryIndexDao.prototype.queryForTableName = function (tableName) {
        return this.queryForEach(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
    };
    /**
     *  Count by table name
     *
     *  @param tableName table name
     *
     *  @return count
     */
    /**
     * Count by table name
     * @param  {string}   tableName table name
     * @return {Number}
     */
    GeometryIndexDao.prototype.countByTableName = function (tableName) {
        return this.count(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
    };
    /**
     * Populate a new goemetry index from an envelope
     * @param  {module:extension/index~TableIndex} tableIndex TableIndex
     * @param  {Number} geometryId id of the geometry
     * @param  {Object} envelope   envelope to store
     * @return {module:extension/index~GeometryIndex}
     */
    GeometryIndexDao.prototype.populate = function (tableIndex, geometryId, envelope) {
        var geometryIndex = new geometryIndex_1.default();
        geometryIndex.setTableIndex(tableIndex);
        geometryIndex.geom_id = geometryId;
        geometryIndex.min_x = envelope.minX;
        geometryIndex.min_y = envelope.minY;
        geometryIndex.max_x = envelope.maxX;
        geometryIndex.max_y = envelope.maxY;
        if (envelope.hasZ) {
            geometryIndex.min_z = envelope.minZ;
            geometryIndex.max_z = envelope.maxZ;
        }
        if (envelope.hasM) {
            geometryIndex.min_m = envelope.minM;
            geometryIndex.max_m = envelope.maxM;
        }
        return geometryIndex;
    };
    /**
     * Create the GeometryIndex table
     * @return {Promise}
     */
    GeometryIndexDao.prototype.createTable = function () {
        var exists = this.isTableExists();
        if (exists)
            return Promise.resolve(true);
        var tc = new tableCreator_1.TableCreator(this.geoPackage);
        return tc.createGeometryIndex();
    };
    /**
     * Query the index with an envelope
     * @param  {Object} envelope envelope
     * @param  {Number} envelope.minX min x
     * @param  {Number} envelope.maxX max x
     * @param  {Number} envelope.minY min y
     * @param  {Number} envelope.maxY max y
     * @param  {Number} envelope.minZ min z
     * @param  {Number} envelope.maxZ max z
     * @param  {Number} envelope.minM min m
     * @param  {Number} envelope.maxM max m
     * @param  {Boolean} envelope.hasM has m
     * @param  {Boolean} envelope.hasZ has z
     * @return {Object}
     */
    GeometryIndexDao.prototype._generateGeometryEnvelopeQuery = function (envelope) {
        var tableName = this.featureDao.gpkgTableName;
        var where = '';
        where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
        where += ' and ';
        var minXLessThanMaxX = envelope.minX < envelope.maxX;
        if (minXLessThanMaxX) {
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.maxX, '<=');
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.minX, '>=');
        }
        else {
            where += '(';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.maxX, '<=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.minX, '>=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.minX, '>=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.maxX, '<=');
            where += ')';
        }
        where += ' and ';
        where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_Y, envelope.maxY, '<=');
        where += ' and ';
        where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_Y, envelope.minY, '>=');
        var whereArgs = [tableName, envelope.maxX, envelope.minX];
        if (!minXLessThanMaxX) {
            whereArgs.push(envelope.minX, envelope.maxX);
        }
        whereArgs.push(envelope.maxY, envelope.minY);
        if (envelope.hasZ) {
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_Z, envelope.minZ, '<=');
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_Z, envelope.maxZ, '>=');
            whereArgs.push(envelope.maxZ, envelope.minZ);
        }
        if (envelope.hasM) {
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_M, envelope.minM, '<=');
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_M, envelope.maxM, '>=');
            whereArgs.push(envelope.maxM, envelope.minM);
        }
        return {
            join: 'inner join "' + tableName + '" on "' + tableName + '".' + this.featureDao.idColumns[0] + ' = ' + GeometryIndexDao.COLUMN_GEOM_ID,
            where: where,
            whereArgs: whereArgs,
            tableNameArr: ['"' + tableName + '".*']
        };
    };
    /**
     * @param  {Object} envelope envelope
     * @param  {Number} envelope.minX min x
     * @param  {Number} envelope.maxX max x
     * @param  {Number} envelope.minY min y
     * @param  {Number} envelope.maxY max y
     * @param  {Number} envelope.minZ min z
     * @param  {Number} envelope.maxZ max z
     * @param  {Number} envelope.minM min m
     * @param  {Number} envelope.maxM max m
     * @param  {Boolean} envelope.hasM has m
     * @param  {Boolean} envelope.hasZ has z
     */
    GeometryIndexDao.prototype.queryWithGeometryEnvelope = function (envelope) {
        var result = this._generateGeometryEnvelopeQuery(envelope);
        return this.queryJoinWhereWithArgs(result.join, result.where, result.whereArgs, result.tableNameArr);
    };
    /**
     * @param  {Object} envelope envelope
     * @param  {Number} envelope.minX min x
     * @param  {Number} envelope.maxX max x
     * @param  {Number} envelope.minY min y
     * @param  {Number} envelope.maxY max y
     * @param  {Number} envelope.minZ min z
     * @param  {Number} envelope.maxZ max z
     * @param  {Number} envelope.minM min m
     * @param  {Number} envelope.maxM max m
     * @param  {Boolean} envelope.hasM has m
     * @param  {Boolean} envelope.hasZ has z
     */
    GeometryIndexDao.prototype.countWithGeometryEnvelope = function (envelope) {
        var result = this._generateGeometryEnvelopeQuery(envelope);
        return this.countJoinWhereWithArgs(result.join, result.where, result.whereArgs);
    };
    GeometryIndexDao.TABLE_NAME = "nga_geometry_index";
    GeometryIndexDao.COLUMN_TABLE_NAME = GeometryIndexDao.TABLE_NAME + ".table_name";
    GeometryIndexDao.COLUMN_GEOM_ID = GeometryIndexDao.TABLE_NAME + ".geom_id";
    GeometryIndexDao.COLUMN_MIN_X = GeometryIndexDao.TABLE_NAME + ".min_x";
    GeometryIndexDao.COLUMN_MAX_X = GeometryIndexDao.TABLE_NAME + ".max_x";
    GeometryIndexDao.COLUMN_MIN_Y = GeometryIndexDao.TABLE_NAME + ".min_y";
    GeometryIndexDao.COLUMN_MAX_Y = GeometryIndexDao.TABLE_NAME + ".max_y";
    GeometryIndexDao.COLUMN_MIN_Z = GeometryIndexDao.TABLE_NAME + ".min_z";
    GeometryIndexDao.COLUMN_MAX_Z = GeometryIndexDao.TABLE_NAME + ".max_z";
    GeometryIndexDao.COLUMN_MIN_M = GeometryIndexDao.TABLE_NAME + ".min_m";
    GeometryIndexDao.COLUMN_MAX_M = GeometryIndexDao.TABLE_NAME + ".max_m";
    return GeometryIndexDao;
}(dao_1.default));
exports.default = GeometryIndexDao;

},{"../../dao/dao":13,"../../db/tableCreator":23,"./geometryIndex":32}],34:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Table Index object, for indexing data within user tables
 */
var TableIndex = /** @class */ (function () {
    function TableIndex() {
    }
    return TableIndex;
}());
exports.default = TableIndex;

},{}],35:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var tableCreator_1 = require("../../db/tableCreator");
var tableIndex_1 = __importDefault(require("./tableIndex"));
/**
 * Table Index Data Access Object
 * @class
 * @extends Dao
 * @param {module:geoPackage~GeoPackage}  geoPackage The GeoPackage object
 */
var TableIndexDao = /** @class */ (function (_super) {
    __extends(TableIndexDao, _super);
    function TableIndexDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = TableIndexDao.TABLE_NAME;
        _this.idColumns = [TableIndexDao.COLUMN_TABLE_NAME];
        return _this;
    }
    /**
     * Create a new TableIndex object
     * @return {module:extension/index~TableIndex}
     */
    TableIndexDao.prototype.createObject = function () {
        return new tableIndex_1.default();
    };
    TableIndexDao.prototype.getGeometryIndices = function () {
    };
    TableIndexDao.prototype.getGeometryIndexCount = function () {
    };
    /**
     * Creates the tables necessary
     * @return {Promise}
     */
    TableIndexDao.prototype.createTable = function () {
        var tc = new tableCreator_1.TableCreator(this.geoPackage);
        return tc.createTableIndex();
    };
    TableIndexDao.TABLE_NAME = "nga_table_index";
    TableIndexDao.COLUMN_TABLE_NAME = "table_name";
    TableIndexDao.COLUMN_LAST_INDEXED = "last_indexed";
    return TableIndexDao;
}(dao_1.default));
exports.default = TableIndexDao;

},{"../../dao/dao":13,"../../db/tableCreator":23,"./tableIndex":34}],36:[function(require,module,exports){
"use strict";
/**
 * MetadataExtension module.
 * @module extension/metadata
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
/**
 * Metadata extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class
 * @extends BaseExtension
 */
var MetadataExtension = /** @class */ (function (_super) {
    __extends(MetadataExtension, _super);
    function MetadataExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = MetadataExtension.EXTENSION_NAME;
        _this.extensionDefinition = MetadataExtension.EXTENSION_Metadata_DEFINITION;
        return _this;
    }
    /**
     * Get or create the metadata extension
     */
    MetadataExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, extension_1.default.READ_WRITE);
    };
    MetadataExtension.EXTENSION_NAME = 'gpkg_metadata';
    MetadataExtension.EXTENSION_Metadata_AUTHOR = 'gpkg';
    MetadataExtension.EXTENSION_Metadata_NAME_NO_AUTHOR = 'metadata';
    MetadataExtension.EXTENSION_Metadata_DEFINITION = 'http://www.geopackage.org/spec/#extension_metadata';
    return MetadataExtension;
}(baseExtension_1.default));
exports.default = MetadataExtension;

},{"../baseExtension":24,"../extension":29}],37:[function(require,module,exports){
"use strict";
/**
 * @module  extension/relatedTables
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Dublin Core Metadata Initiative term types
 * @class
 */
var DublinCoreType = /** @class */ (function () {
    function DublinCoreType(name, synonyms) {
        this.name = name;
        this.synonyms = synonyms;
    }
    /**
     * Get the Dublin Core Type from the name
     * @param  {string} name name
     * @return {module:extension/relatedTables~DublinCoreType}
     */
    DublinCoreType.fromName = function (name) {
        for (var prop in DublinCoreType) {
            var type = DublinCoreType[prop];
            if (type.name === name) {
                return type;
            }
        }
        for (var prop in DublinCoreType) {
            var type = DublinCoreType[prop];
            if (type.synonyms) {
                for (var i = 0; i < type.synonyms.length; i++) {
                    if (type.synonyms[i] === name) {
                        return type;
                    }
                }
            }
        }
    };
    /**
     * A point or period of time associated with an event in the lifecycle of
     * the resource.
     * @type {Object}
     */
    DublinCoreType.DATE = new DublinCoreType('date');
    /**
     * An account of the resource.
     * @type {Object}
     */
    DublinCoreType.DESCRIPTION = new DublinCoreType('description');
    /**
     * The file format, physical medium, or dimensions of the resource.
     * @type {Object}
     */
    DublinCoreType.FORMAT = new DublinCoreType('format', ['content_type']);
    /**
     * An unambiguous reference to the resource within a given context.
     * @type {Object}
     */
    DublinCoreType.IDENTIFIER = new DublinCoreType('identifier', ['id']);
    /**
     * A related resource from which the described resource is derived.
     * @type {Object}
     */
    DublinCoreType.SOURCE = new DublinCoreType('source');
    /**
     * A name given to the resource.
     * @type {Object}
     */
    DublinCoreType.TITLE = new DublinCoreType('title');
    return DublinCoreType;
}());
exports.DublinCoreType = DublinCoreType;

},{}],38:[function(require,module,exports){
"use strict";
/**
 * @module extension/relatedTables
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Describes the relationships between a base table, a related data table, and a
 * mapping table
 * @class ExtendedRelation
 */
var ExtendedRelation = /** @class */ (function () {
    function ExtendedRelation() {
    }
    return ExtendedRelation;
}());
exports.default = ExtendedRelation;

},{}],39:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var columnValues_1 = __importDefault(require("../../dao/columnValues"));
var extendedRelation_1 = __importDefault(require("./extendedRelation"));
/**
 * Extended Relations Data Access Object
 * @class ExtendedRelationDao
 * @extends Dao
 */
var ExtendedRelationDao = /** @class */ (function (_super) {
    __extends(ExtendedRelationDao, _super);
    function ExtendedRelationDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ExtendedRelationDao.TABLE_NAME;
        _this.idColumns = ['id'];
        return _this;
    }
    /**
     * Create a {module:extension/relatedTables~ExtendedRelation} object
     * @return {module:extension/relatedTables~ExtendedRelation}
     */
    ExtendedRelationDao.prototype.createObject = function (result) {
        var er = new extendedRelation_1.default();
        if (result) {
            er.base_table_name = result.base_table_name;
            er.base_primary_column = result.base_primary_column;
            er.related_table_name = result.base_primary_column;
            er.related_table_name = result.related_table_name;
            er.relation_name = result.relation_name;
            er.mapping_table_name = result.mapping_table_name;
            er.related_primary_column = result.related_primary_column;
            er.id = result.id;
        }
        return er;
    };
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    ExtendedRelationDao.prototype.createTable = function () {
        var tc = this.geoPackage.getTableCreator();
        return tc.createExtendedRelations();
    };
    /**
     * Get all the base table names
     * @return {string[]}
     */
    ExtendedRelationDao.prototype.getBaseTables = function () {
        var baseTables = [];
        var baseTableColumns = this.queryForColumns('base_table_name');
        for (var i = 0; i < baseTableColumns.length; i++) {
            baseTables.push(baseTableColumns[i].base_table_name);
        }
        return baseTables;
    };
    /**
     * Get all the related table names
     * @return {string[]}
     */
    ExtendedRelationDao.prototype.getRelatedTables = function () {
        var relatedTables = [];
        var relatedTableColumns = this.queryForColumns('related_table_name');
        for (var i = 0; i < relatedTableColumns.length; i++) {
            relatedTables.push(relatedTableColumns[i].related_table_name);
        }
        return relatedTables;
    };
    /**
     * Get all relations for the given base table name
     * @param  {string} baseTable base table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getBaseTableRelations = function (baseTable) {
        var e_1, _a;
        var results = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return results;
    };
    /**
     * Get all relations for the given related table name
     * @param  {string} relatedTable related table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getRelatedTableRelations = function (relatedTable) {
        var e_2, _a;
        var results = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTable)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return results;
    };
    /**
     * Get all relations for the base table with the relation name
     * @param  {string} baseTable base table name
     * @param  {string} name      relation name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getBaseTableRelationsWithName = function (baseTable, name) {
        var e_3, _a;
        var fields = new columnValues_1.default();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATION_NAME, name);
        var where = this.buildWhere(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return results;
    };
    /**
     * Get all relations to the table.  Returns relations where the table is the base table and relations where the table is the related table.
     * @param  {string} table table name to query for
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getTableRelations = function (table) {
        var e_4, _a;
        var fields = new columnValues_1.default();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, table);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, table);
        var where = this.buildWhere(fields, 'or');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return results;
    };
    /**
     * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
     * @param {String} [baseTableName] base table name
     * @param {String} [relatedTableName] related table name
     * @param {String} [mappingTableName] mapping table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getRelations = function (baseTableName, relatedTableName, mappingTableName) {
        var e_5, _a;
        var fields = new columnValues_1.default();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTableName);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTableName);
        fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
        var where = this.buildWhereLike(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return results;
    };
    /**
     * Get all relations by the mapping table name
     * @param  {string} mappingTableName name of the mapping table
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.queryByMappingTableName = function (mappingTableName) {
        var e_6, _a;
        var fields = new columnValues_1.default();
        fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
        var where = this.buildWhere(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return results;
    };
    ExtendedRelationDao.TABLE_NAME = 'gpkgext_relations';
    ExtendedRelationDao.COLUMN_ID = ExtendedRelationDao.TABLE_NAME + '.id';
    ExtendedRelationDao.COLUMN_BASE_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.base_table_name';
    ExtendedRelationDao.COLUMN_BASE_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.base_primary_column';
    ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.related_table_name';
    ExtendedRelationDao.COLUMN_RELATED_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.related_primary_column';
    ExtendedRelationDao.COLUMN_RELATION_NAME = ExtendedRelationDao.TABLE_NAME + '.relation_name';
    ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.mapping_table_name';
    return ExtendedRelationDao;
}(dao_1.default));
exports.default = ExtendedRelationDao;

},{"../../dao/columnValues":12,"../../dao/dao":13,"./extendedRelation":38}],40:[function(require,module,exports){
"use strict";
/**
 * RelatedTablesExtension module.
 * @module extension/relatedTables
 * @see module:extension/BaseExtension
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var mediaDao_1 = __importDefault(require("./mediaDao"));
var mediaTable_1 = __importDefault(require("./mediaTable"));
var simpleAttributesDao_1 = __importDefault(require("./simpleAttributesDao"));
var simpleAttributesTable_1 = __importDefault(require("./simpleAttributesTable"));
var userMappingTable_1 = __importDefault(require("./userMappingTable"));
var userMappingDao_1 = __importDefault(require("./userMappingDao"));
var userCustomDao_1 = __importDefault(require("../../user/custom/userCustomDao"));
var userDao_1 = __importDefault(require("../../user/userDao"));
var userTableReader_1 = __importDefault(require("../../user/userTableReader"));
var extendedRelationDao_1 = __importDefault(require("./extendedRelationDao"));
var relationType_1 = __importDefault(require("./relationType"));
var contents_1 = __importDefault(require("../../core/contents/contents"));
var columnValues_1 = __importDefault(require("../../dao/columnValues"));
var extendedRelation_1 = __importDefault(require("./extendedRelation"));
var optionBuilder_1 = require("../../optionBuilder");
/**
 * Related Tables Extension
 * @param  {module:geoPackage~GeoPackage} geoPackage the GeoPackage object
 * @class
 * @extends BaseExtension
 */
var RelatedTablesExtension = /** @class */ (function (_super) {
    __extends(RelatedTablesExtension, _super);
    function RelatedTablesExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extendedRelationDao = geoPackage.getExtendedRelationDao();
        return _this;
    }
    /**
     * Get or create the extension
     * @return {Promise}
     */
    RelatedTablesExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(RelatedTablesExtension.EXTENSION_NAME, 'gpkgext_relations', undefined, RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION, extension_1.default.READ_WRITE)
            .then(function () {
            return this.extendedRelationDao.createTable();
        }.bind(this));
    };
    /**
     * Get or create the extension for the mapping table
     * @param  {string} mappingTableName user mapping table
     * @return {Promise}
     */
    RelatedTablesExtension.prototype.getOrCreateMappingTable = function (mappingTableName) {
        return this.getOrCreateExtension()
            .then(function () {
            return this.getOrCreate(RelatedTablesExtension.EXTENSION_NAME, mappingTableName, undefined, RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION, extension_1.default.READ_WRITE);
        }.bind(this));
    };
    /**
     * Set the contents in the UserRelatedTable
     * @param  {module:extension/relatedTables~UserRelatedTable} userRelatedTable user related table
     */
    RelatedTablesExtension.prototype.setContents = function (userRelatedTable) {
        var contents = this.geoPackage.getContentsDao().queryForId(userRelatedTable.table_name);
        userRelatedTable.setContents(contents);
    };
    /**
     * Reads the user table and creates a UserCustomDao
     * @param  {string} tableName       table name to reader
     * @param  {string[]} requiredColumns required columns
     * @return {module:user/custom~UserCustomDao}
     */
    RelatedTablesExtension.prototype.getUserDao = function (tableName, requiredColumns) {
        return userCustomDao_1.default.readTable(this.geoPackage, tableName, requiredColumns);
    };
    /**
     * Gets the UserMappingDao from the mapping table name
     * @param  {string | ExtendedRelation} tableName user mapping table name or ExtendedRelation object
     * @return {module:extension/relatedTables~UserMappingDao}
     */
    RelatedTablesExtension.prototype.getMappingDao = function (tableName) {
        var mappingTableName;
        if (tableName instanceof extendedRelation_1.default) {
            mappingTableName = tableName.mapping_table_name;
        }
        else {
            mappingTableName = tableName;
        }
        return new userMappingDao_1.default(this.getUserDao(mappingTableName, userMappingTable_1.default.requiredColumns()), this.geoPackage);
    };
    /**
     * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
     * @param {String} [baseTableName] base table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    RelatedTablesExtension.prototype.getRelationships = function (baseTableName) {
        if (this.extendedRelationDao.isTableExists()) {
            if (baseTableName) {
                return this.geoPackage.getExtendedRelationDao().getBaseTableRelations(baseTableName);
            }
            return this.extendedRelationDao.queryForAll();
        }
        return [];
    };
    /**
     * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
     * @param {String} [baseTableName] base table name
     * @param {String} [relatedTableName] related table name
     * @param {String} [mappingTableName] mapping table name
     * @return {Boolean}
     */
    RelatedTablesExtension.prototype.hasRelations = function (baseTableName, relatedTableName, mappingTableName) {
        var relations = [];
        if (this.extendedRelationDao.isTableExists()) {
            relations = this.extendedRelationDao.getRelations(baseTableName, relatedTableName, mappingTableName);
        }
        return !!relations.length;
    };
    RelatedTablesExtension.prototype.getRelatedRows = function (baseTableName, baseId) {
        var relationships = this.getRelationships(baseTableName);
        for (var i = 0; i < relationships.length; i++) {
            var relation = relationships[i];
            var mappingRows = this.getMappingRowsForBase(relation.mapping_table_name, baseId);
            relation.mappingRows = mappingRows;
            var userDao;
            // TODO do this for all known types
            if (relation.relation_name === 'media') {
                userDao = mediaDao_1.default.readTable(this.geoPackage, relation.related_table_name);
            }
            else {
                userDao = userDao_1.default.readTable(this.geoPackage, relation.related_table_name);
            }
            for (var m = 0; m < mappingRows.length; m++) {
                var mappingRow = mappingRows[m];
                mappingRow.row = userDao.queryForId(mappingRow.related_id);
            }
        }
        return relationships;
    };
    /**
     * Convience object to build a Relationship object for querying and adding
     * @typedef {Object} module:extension/relatedTables~Relationship
     * @property  {module:extension/relatedTables~RelationType} relationType type of relationship
     * @property  {string} baseTableName base table name
     * @property  {string} relatedTableName related table name
     * @property  {string} relationAuthor relationship author
     * @property  {string} mappingTableName mapping table name
     * @property  {module:extension/relatedTables~UserMappingTable} userMappingTable UserMappingTable
     * @property  {module:extension/relatedTables~UserRelatedTable} relatedTable UserRelatedTable
     */
    RelatedTablesExtension.prototype.getRelationshipBuilder = function () {
        return RelatedTablesExtension.RelationshipBuilder();
    };
    /**
     * Adds a relationship to the GeoPackage
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation | undefined>}
     */
    RelatedTablesExtension.prototype.addRelationship = function (relationship) {
        var extendedRelation = this.extendedRelationDao.createObject();
        var userMappingTable = relationship.userMappingTable;
        if (Object.prototype.hasOwnProperty.call(relationship, 'base_table_name')) {
            extendedRelation = relationship;
            userMappingTable = userMappingTable_1.default.create(extendedRelation.mapping_table_name);
        }
        else {
            if (relationship.relationType) {
                relationship.relationName = relationship.relationType.name;
            }
            if (relationship.relationAuthor) {
                relationship.relationName = this.buildRelationName(relationship.relationAuthor, relationship.relationName);
            }
            if (relationship.mappingTableName) {
                userMappingTable = userMappingTable_1.default.create(relationship.mappingTableName);
            }
            if (relationship.relatedTable) {
                this.createRelatedTable(relationship.relatedTable);
                relationship.relatedTableName = relationship.relatedTable.table_name;
                relationship.relationName = relationship.relatedTable.relation_name;
            }
            extendedRelation.base_table_name = relationship.baseTableName;
            extendedRelation.base_primary_column = this.getPrimaryKeyColumnName(relationship.baseTableName);
            extendedRelation.related_table_name = relationship.relatedTableName;
            extendedRelation.related_primary_column = this.getPrimaryKeyColumnName(relationship.relatedTableName);
            extendedRelation.mapping_table_name = userMappingTable.table_name;
            extendedRelation.relation_name = relationship.relationName;
        }
        if (!this.validateRelationship(extendedRelation.base_table_name, extendedRelation.related_table_name, extendedRelation.relation_name)) {
            return Promise.resolve(undefined);
        }
        return this.createUserMappingTable(userMappingTable)
            .then(function () {
            var mappingTableRelations = this.extendedRelationDao.queryByMappingTableName(extendedRelation.mapping_table_name);
            if (mappingTableRelations.length) {
                return mappingTableRelations[0];
            }
            this.extendedRelationDao.create(extendedRelation);
            return extendedRelation;
        }.bind(this));
    };
    /**
     * Get the primary key column name from the specified table
     * @param  {string} tableName table name
     * @return {string}
     */
    RelatedTablesExtension.prototype.getPrimaryKeyColumnName = function (tableName) {
        var reader = new userTableReader_1.default(tableName);
        var table = reader.readTable(this.geoPackage.getDatabase());
        return table.getPkColumn().name;
    };
    /**
     * Adds a features relationship between the base feature and related feature
     * table. Creates a default user mapping table if needed.
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation>}
     */
    RelatedTablesExtension.prototype.addFeaturesRelationship = function (relationship) {
        if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
            relationship.relation_name = relationship.relation_name || relationType_1.default.FEATURES.name;
        }
        else {
            relationship.relationType = relationType_1.default.FEATURES;
        }
        return this.addRelationship(relationship);
    };
    /**
     * Adds a tiles relationship between the base table and related tile
     * table. Creates a default user mapping table if needed.
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation>}
     */
    RelatedTablesExtension.prototype.addTilesRelationship = function (relationship) {
        if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
            relationship.relation_name = relationship.relation_name || relationType_1.default.TILES.name;
        }
        else {
            relationship.relationType = relationType_1.default.TILES;
        }
        return this.addRelationship(relationship);
    };
    /**
     * Adds an attributes relationship between the base table and related attribute
     * table. Creates a default user mapping table if needed.
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation>}
     */
    RelatedTablesExtension.prototype.addAttributesRelationship = function (relationship) {
        if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
            relationship.relation_name = relationship.relation_name || relationType_1.default.ATTRIBUTES.name;
        }
        else {
            relationship.relationType = relationType_1.default.ATTRIBUTES;
        }
        return this.addRelationship(relationship);
    };
    /**
     * Adds a simple attributes relationship between the base table and user
     * simple attributes related table. Creates a default user mapping table and
     * the simple attributes table if needed.
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation>}
     */
    RelatedTablesExtension.prototype.addSimpleAttributesRelationship = function (relationship) {
        if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
            relationship.relation_name = relationship.relation_name || relationType_1.default.SIMPLE_ATTRIBUTES.name;
        }
        else {
            relationship.relationType = relationType_1.default.SIMPLE_ATTRIBUTES;
        }
        return this.addRelationship(relationship);
    };
    /**
     * Adds a media relationship between the base table and user media related
     * table. Creates a default user mapping table and the media table if
     * needed.
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
     * @return {Promise<ExtendedRelation>}
     */
    RelatedTablesExtension.prototype.addMediaRelationship = function (relationship) {
        if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
            relationship.relation_name = relationship.relation_name || relationType_1.default.MEDIA.name;
        }
        else {
            relationship.relationType = relationType_1.default.MEDIA;
        }
        return this.addRelationship(relationship);
    };
    /**
     * Remove a specific relationship from the GeoPackage
     * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to remove
     * @return {Number} number of relationships removed
     */
    RelatedTablesExtension.prototype.removeRelationship = function (relationship) {
        var e_1, _a;
        // this is an ExtendedRelation
        if (Object.prototype.hasOwnProperty.call(relationship, 'base_table_name')) {
            relationship.baseTableName = relationship.base_table_name;
            relationship.relatedTableName = relationship.related_table_name;
            relationship.relationName = relationship.relation_name;
            relationship.userMappingTable = relationship.mapping_table_name;
        }
        if (relationship.relationType) {
            relationship.relationName = relationship.relationType.name;
        }
        if (relationship.relationAuthor) {
            relationship.relationName = this.buildRelationName(relationship.relationAuthor, relationship.relationName);
        }
        if (this.extendedRelationDao.isTableExists()) {
            var values = new columnValues_1.default();
            values.addColumn(extendedRelationDao_1.default.COLUMN_BASE_TABLE_NAME, relationship.baseTableName);
            values.addColumn(extendedRelationDao_1.default.COLUMN_RELATED_TABLE_NAME, relationship.relatedTableName);
            values.addColumn(extendedRelationDao_1.default.COLUMN_RELATION_NAME, relationship.relationName);
            var iterator = this.extendedRelationDao.queryForFieldValues(values);
            var tablesToDelete = [];
            try {
                for (var iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next(); !iterator_1_1.done; iterator_1_1 = iterator_1.next()) {
                    var extendedRelation = iterator_1_1.value;
                    tablesToDelete.push(extendedRelation.mapping_table_name);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            tablesToDelete.forEach(function (table) {
                this.geoPackage.deleteTable(table);
            }.bind(this));
            this.extensionsDao.deleteByExtensionAndTableName(RelatedTablesExtension.EXTENSION_NAME, relationship.userMappingTable);
            return this.extendedRelationDao.delete(extendedRelation);
        }
        return 0;
    };
    /**
     * Create a default user mapping table and extension row if either does not
     * exist. When not created, there is no guarantee that an existing table has
     * the same schema as the provided tabled.
     * @param  {string | UserMappingTable} userMappingTableOrName user mapping table or name
     * @return {Promise<Boolean>}
     */
    RelatedTablesExtension.prototype.createUserMappingTable = function (userMappingTableOrName) {
        var umt;
        if (userMappingTableOrName instanceof userMappingTable_1.default) {
            umt = userMappingTableOrName;
        }
        else {
            umt = userMappingTable_1.default.create(userMappingTableOrName);
        }
        return this.getOrCreateMappingTable(umt.table_name)
            .then(function () {
            if (!this.geoPackage.isTable(umt.table_name)) {
                return this.geoPackage.tableCreator.createUserTable(umt);
            }
            return true;
        }.bind(this));
    };
    /**
     * Create a user related table if it does not exist. When not created, there
     * is no guarantee that an existing table has the same schema as the
     * provided tabled.
     * @param  {module:extension/relatedTables~UserRelatedTable} relatedTable user related table
     * @return {Boolean} true if the table now exists
     */
    RelatedTablesExtension.prototype.createRelatedTable = function (relatedTable) {
        if (!this.geoPackage.isTable(relatedTable.table_name)) {
            this.geoPackage.tableCreator.createUserTable(relatedTable);
            var contents = new contents_1.default();
            contents.table_name = relatedTable.table_name;
            contents.data_type = relatedTable.data_type;
            contents.identifier = relatedTable.table_name;
            this.geoPackage.getContentsDao().create(contents);
            var refreshed = this.geoPackage.getContentsDao().refresh(contents);
            relatedTable.setContents(refreshed);
        }
        return true;
    };
    /**
     * Validate that the relation name is valid between the base and related tables
     * @param  {string} baseTableName    base table name
     * @param  {string} relatedTableName related table name
     * @param  {string} relationName     relation name
     * @return {Boolean}
     */
    RelatedTablesExtension.prototype.validateRelationship = function (baseTableName, relatedTableName, relationName) {
        // Verify the base and related tables exist
        if (!this.geoPackage.isTable(baseTableName)) {
            console.log('Base relationship table does not exist: ' + baseTableName + ', Relation: ' + relationName);
            return false;
        }
        if (!this.geoPackage.isTable(relatedTableName)) {
            console.log('Related relationship table does not exist: ' + relatedTableName + ', Relation: ' + relationName);
            return false;
        }
        // Verify spec defined relation types
        var relationType = relationType_1.default.fromName(relationName);
        if (relationType) {
            if (!this.geoPackage.isTableType(relationType.dataType, relatedTableName)) {
                console.log('The related table must be a ' + relationType.dataType + ' table.  Related Table: ' + relatedTableName + ', Type: ' + this.geoPackage.getTableType(relatedTableName));
                return false;
            }
            return true;
        }
        return true;
    };
    /**
     * Link related Ids
     * @param  {string} baseTableName    base table name
     * @param  {Number} baseId           base row id
     * @param  {string} relatedTableName related table name
     * @param  {Number} relatedId        related row id
     * @param  {module:extension/relatedTables~RelationType} relationType     relation type
     * @return {Promise}
     */
    RelatedTablesExtension.prototype.linkRelatedIds = function (baseTableName, baseId, relatedTableName, relatedId, relationType) {
        return __awaiter(this, void 0, void 0, function () {
            var baseDao, relatedDao, baseRow, relatedRow;
            return __generator(this, function (_a) {
                baseDao = userDao_1.default.readTable(this.geoPackage, baseTableName);
                relatedDao = userDao_1.default.readTable(this.geoPackage, relatedTableName);
                baseRow = baseDao.queryForId(baseId);
                relatedRow = relatedDao.queryForId(relatedId);
                return [2 /*return*/, baseDao.linkRelatedRow(baseRow, relatedRow, relationType)];
            });
        });
    };
    /**
     * Get the related id mappings for the base id
     * @param  {string} mappingTableName mapping table name
     * @param  {Number} baseId           base id
     * @return {Number[]} ids of related items
     */
    RelatedTablesExtension.prototype.getMappingsForBase = function (mappingTableName, baseId) {
        var mappingDao = this.getMappingDao(mappingTableName);
        var results = mappingDao.queryByBaseId(baseId);
        var relatedIds = [];
        for (var i = 0; i < results.length; i++) {
            var row = mappingDao.getUserMappingRow(results[i]);
            relatedIds.push(row.getRelatedId());
        }
        return relatedIds;
    };
    /**
     * Get the related id mapping rows for the base id
     * @param  {string} mappingTableName mapping table name
     * @param  {Number} baseId           base id
     * @return {module:extension/relatedTables~UserMappingRow[]} user mapping rows
     */
    RelatedTablesExtension.prototype.getMappingRowsForBase = function (mappingTableName, baseId) {
        var mappingDao = this.getMappingDao(mappingTableName);
        return mappingDao.queryByBaseId(baseId);
    };
    /**
     * Get the base id mappings for the base id
     * @param  {string} mappingTableName mapping table name
     * @param  {Number} relatedId           related id
     * @return {Number[]} ids of base items
     */
    RelatedTablesExtension.prototype.getMappingsForRelated = function (mappingTableName, relatedId) {
        var mappingDao = this.getMappingDao(mappingTableName);
        var results = mappingDao.queryByRelatedId(relatedId);
        var baseIds = [];
        for (var i = 0; i < results.length; i++) {
            var row = mappingDao.getUserMappingRow(results[i]);
            baseIds.push(row.getBaseId());
        }
        return baseIds;
    };
    /**
     * Returns a {module:extension/relatedTables~MediaDao} from the table specified
     * @param  {string|MediaTable|ExtendedRelation} tableName either a table name or a MediaTable
     * @return {module:extension/relatedTables~MediaDao}
     */
    RelatedTablesExtension.prototype.getMediaDao = function (tableName) {
        var table;
        if (tableName instanceof mediaTable_1.default) {
            table = tableName.table_name;
        }
        else if (tableName instanceof extendedRelation_1.default) {
            table = tableName.related_table_name;
        }
        else if (typeof tableName === 'string') {
            table = tableName;
        }
        var reader = new userTableReader_1.default(table, mediaTable_1.default.requiredColumns());
        var userTable = reader.readTable(this.geoPackage.getDatabase());
        table = new mediaTable_1.default(userTable.table_name, userTable.columns, mediaTable_1.default.requiredColumns());
        table.setContents(this.geoPackage.getContentsDao().queryForId(table.table_name));
        return new mediaDao_1.default(this.geoPackage, table);
    };
    /**
     * Returns a {module:extension/relatedTables~SimpleAttributesDao} from the table specified
     * @param  {string|SimpleAttributesDao|ExtendedRelation} tableName either a table name or a SimpleAttributesDao
     * @return {module:extension/relatedTables~SimpleAttributesDao}
     */
    RelatedTablesExtension.prototype.getSimpleAttributesDao = function (tableName) {
        var table;
        if (tableName instanceof simpleAttributesTable_1.default && tableName.TABLE_TYPE === 'simple_attributes') {
            table = tableName;
        }
        else {
            if (tableName instanceof extendedRelation_1.default) {
                table = tableName.related_table_name;
            }
            var reader = new userTableReader_1.default(table, simpleAttributesTable_1.default.requiredColumns());
            var userTable = reader.readTable(this.geoPackage.getDatabase());
            table = new simpleAttributesTable_1.default(userTable.table_name, userTable.columns, simpleAttributesTable_1.default.requiredColumns());
            table.setContents(this.geoPackage.getContentsDao().queryForId(table.table_name));
        }
        return new simpleAttributesDao_1.default(this.geoPackage, table);
    };
    /**
     * Builds the custom relation name with the author
     * @param  {string} author author
     * @param  {string} name   name
     * @return {string}
     */
    RelatedTablesExtension.prototype.buildRelationName = function (author, name) {
        return 'x-' + author + '_' + name;
    };
    /**
     * Remove all traces of the extension
     */
    RelatedTablesExtension.prototype.removeExtension = function () {
        if (this.extendedRelationDao.isTableExists()) {
            var extendedRelations = this.extendedRelationDao.queryForAll();
            extendedRelations.forEach(function (relation) {
                this.geoPackage.deleteTable(relation.mapping_table_name);
            }.bind(this));
            this.geoPackage.deleteTable(extendedRelationDao_1.default.TABLE_NAME);
        }
        if (this.extensionsDao.isTableExists()) {
            this.extensionsDao.deleteByExtension(RelatedTablesExtension.EXTENSION_NAME);
        }
    };
    /**
     * Determine if the GeoPackage has the extension
     * @param  {String} [mappingTableName] mapping table name to check, if not specified, this checks for any mapping table name
     * @return {Boolean}
     */
    RelatedTablesExtension.prototype.has = function (mappingTableName) {
        if (mappingTableName) {
            return this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, extendedRelationDao_1.default.TABLE_NAME, null)
                && this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, mappingTableName, null);
        }
        return this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, extendedRelationDao_1.default.TABLE_NAME, null);
    };
    RelatedTablesExtension.RelationshipBuilder = function () {
        return optionBuilder_1.OptionBuilder.build([
            'baseTableName',
            'relatedTableName',
            'userMappingTable',
            'mappingTableName',
            'relationName',
            'relationAuthor',
            'relationType',
            'relatedTable'
        ]);
    };
    RelatedTablesExtension.EXTENSION_NAME = 'related_tables';
    RelatedTablesExtension.EXTENSION_RELATED_TABLES_AUTHOR = 'gpkg';
    RelatedTablesExtension.EXTENSION_RELATED_TABLES_NAME_NO_AUTHOR = 'related_tables';
    RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION = 'TBD';
    return RelatedTablesExtension;
}(baseExtension_1.default));
exports.default = RelatedTablesExtension;

},{"../../core/contents/contents":8,"../../dao/columnValues":12,"../../optionBuilder":88,"../../user/custom/userCustomDao":118,"../../user/userDao":122,"../../user/userTableReader":125,"../baseExtension":24,"../extension":29,"./extendedRelation":38,"./extendedRelationDao":39,"./mediaDao":41,"./mediaTable":43,"./relationType":44,"./simpleAttributesDao":45,"./simpleAttributesTable":47,"./userMappingDao":48,"./userMappingTable":50}],41:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userDao_1 = __importDefault(require("../../user/userDao"));
var userTableReader_1 = __importDefault(require("../../user/userTableReader"));
var mediaRow_1 = __importDefault(require("./mediaRow"));
/**
 * MediaDao module.
 * @module extension/relatedTables
 */
/**
 * User Media DAO for reading user media data tables
 * @class
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
var MediaDao = /** @class */ (function (_super) {
    __extends(MediaDao, _super);
    function MediaDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.mediaTable = table;
        return _this;
    }
    /**
     * Create a new media row
     * @return {module:extension/relatedTables~MediaRow}
     */
    MediaDao.prototype.newRow = function () {
        return new mediaRow_1.default(this.mediaTable);
    };
    /**
     * Create a media row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~MediaRow}             media row
     */
    MediaDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new mediaRow_1.default(this.mediaTable, columnTypes, values);
    };
    /**
     * Gets the media table
     * @return {module:extension/relatedTables~MediaTable}
     */
    MediaDao.prototype.getTable = function () {
        return this.mediaTable;
    };
    /**
     * Reads the table specified from the geopackage
     * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
     * @param  {string} tableName       table name
     * @return {module:user/userDao~UserDao}
     */
    MediaDao.readTable = function (geoPackage, tableName) {
        var reader = new userTableReader_1.default(tableName);
        var userTable = reader.readTable(geoPackage.getDatabase());
        return new MediaDao(geoPackage, userTable);
    };
    return MediaDao;
}(userDao_1.default));
exports.default = MediaDao;

},{"../../user/userDao":122,"../../user/userTableReader":125,"./mediaRow":42}],42:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = __importDefault(require("../../user/userRow"));
var imageUtils_1 = require("../../tiles/imageUtils");
/**
 * MediaRow module.
 * @module extension/relatedTables
 */
/**
 * User Media Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~MediaTable} mediaTable  media table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var MediaRow = /** @class */ (function (_super) {
    __extends(MediaRow, _super);
    function MediaRow(mediaTable, columnTypes, values) {
        var _this = _super.call(this, mediaTable, columnTypes, values) || this;
        _this.mediaTable = mediaTable;
        return _this;
    }
    /**
     * Gets the id column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getIdColumn = function () {
        return this.mediaTable.getIdColumn();
    };
    /**
     * Gets the id
     * @return {Number}
     */
    MediaRow.prototype.getId = function () {
        return this.getValueWithColumnName(this.getIdColumn().name);
    };
    /**
     * Get the data column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getDataColumn = function () {
        return this.mediaTable.getDataColumn();
    };
    /**
     * Gets the data
     * @return {Buffer}
     */
    MediaRow.prototype.getData = function () {
        return this.getValueWithColumnName(this.getDataColumn().name);
    };
    /**
     * Get the data image
     *
     * @return {Promise<Image>}
     */
    MediaRow.prototype.getDataImage = function () {
        return imageUtils_1.ImageUtils.getImage(this.getData(), this.getContentType());
    };
    /**
     * Get the scaled data image
     * @param {Number} scale
     * @return {Promise<Image>}
     */
    MediaRow.prototype.getScaledDataImage = function (scale) {
        return imageUtils_1.ImageUtils.getScaledImage(this.getData(), scale);
    };
    /**
     * Sets the data for the row
     * @param  {Buffer} data data
     */
    MediaRow.prototype.setData = function (data) {
        this.setValueWithColumnName(this.getDataColumn().name, data);
    };
    /**
     * Get the content type column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getContentTypeColumn = function () {
        return this.mediaTable.getContentTypeColumn();
    };
    /**
     * Gets the content type
     * @return {string}
     */
    MediaRow.prototype.getContentType = function () {
        return this.getValueWithColumnName(this.getContentTypeColumn().name);
    };
    /**
     * Sets the content type for the row
     * @param  {string} contentType contentType
     */
    MediaRow.prototype.setContentType = function (contentType) {
        this.setValueWithColumnName(this.getContentTypeColumn().name, contentType);
    };
    return MediaRow;
}(userRow_1.default));
exports.default = MediaRow;

},{"../../tiles/imageUtils":104,"../../user/userRow":123}],43:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * mediaTable module.
 * @module extension/relatedTables
 */
var userRelatedTable_1 = __importDefault(require("./userRelatedTable"));
var relationType_1 = __importDefault(require("./relationType"));
var userColumn_1 = __importDefault(require("../../user/userColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Media Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
var MediaTable = /** @class */ (function (_super) {
    __extends(MediaTable, _super);
    function MediaTable(tableName, columns, requiredColumns) {
        var _this = _super.call(this, tableName, MediaTable.RELATION_TYPE.name, MediaTable.RELATION_TYPE.dataType, columns, requiredColumns) || this;
        _this.TABLE_TYPE = 'media';
        return _this;
    }
    /**
     * Get the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.prototype.getIdColumn = function () {
        return this.getPkColumn();
    };
    /**
     * Get the data column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.prototype.getDataColumn = function () {
        return this.getColumnWithColumnName(MediaTable.COLUMN_DATA);
    };
    /**
     * Get the content type column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.prototype.getContentTypeColumn = function () {
        return this.getColumnWithColumnName(MediaTable.COLUMN_CONTENT_TYPE);
    };
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @param  {string} tableName         name of the table
     * @param  {module:user/userColumn~UserColumn[]} [additionalColumns] additional columns
     * @return {module:extension/relatedTables~MediaTable}
     */
    MediaTable.create = function (tableName, additionalColumns) {
        var columns = MediaTable.createRequiredColumns();
        if (additionalColumns) {
            columns = columns.concat(additionalColumns);
        }
        return new MediaTable(tableName, columns, MediaTable.requiredColumns());
    };
    /**
     * Get the required columns
     * @param  {string} [idColumnName=id] id column name
     * @return {string[]}
     */
    MediaTable.requiredColumns = function (idColumnName) {
        if (idColumnName === void 0) { idColumnName = MediaTable.COLUMN_ID; }
        var requiredColumns = [];
        requiredColumns.push(idColumnName);
        requiredColumns.push(MediaTable.COLUMN_DATA);
        requiredColumns.push(MediaTable.COLUMN_CONTENT_TYPE);
        return requiredColumns;
    };
    /**
     * Get the number of required columns
     * @return {Number}
     */
    MediaTable.numRequiredColumns = function () {
        return MediaTable.requiredColumns().length;
    };
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @param  {string} [idColumnName=id]  id column name
     * @return {module:user/userColumn~UserColumn[]}
     */
    MediaTable.createRequiredColumns = function (startingIndex, idColumnName) {
        if (startingIndex === void 0) { startingIndex = 0; }
        if (idColumnName === void 0) { idColumnName = MediaTable.COLUMN_ID; }
        return [
            MediaTable.createIdColumn(startingIndex++, idColumnName),
            MediaTable.createDataColumn(startingIndex++),
            MediaTable.createContentTypeColumn(startingIndex++)
        ];
    };
    /**
     * Create the primary key id column
     * @param  {Number} index        index of the column
     * @param  {string} idColumnName name of the id column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.createIdColumn = function (index, idColumnName) {
        return userColumn_1.default.createPrimaryKeyColumnWithIndexAndName(index, idColumnName);
    };
    /**
     * Create the data column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.createDataColumn = function (index) {
        return userColumn_1.default.createColumnWithIndex(index, MediaTable.COLUMN_DATA, dataTypes_1.default.GPKGDataType.GPKG_DT_BLOB, true);
    };
    /**
     * Create the content type column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaTable.createContentTypeColumn = function (index) {
        return userColumn_1.default.createColumnWithIndex(index, MediaTable.COLUMN_CONTENT_TYPE, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, true);
    };
    MediaTable.RELATION_TYPE = relationType_1.default.MEDIA;
    MediaTable.COLUMN_ID = 'id';
    MediaTable.COLUMN_DATA = 'data';
    MediaTable.COLUMN_CONTENT_TYPE = 'content_type';
    return MediaTable;
}(userRelatedTable_1.default));
exports.default = MediaTable;

},{"../../db/dataTypes":18,"../../user/userColumn":121,"./relationType":44,"./userRelatedTable":51}],44:[function(require,module,exports){
"use strict";
/**
 * @module extension/relatedTables
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var contentsDao_1 = __importDefault(require("../../core/contents/contentsDao"));
/**
 * Spec supported User-Defined Related Data Tables
 * @class
 */
var RelationType = /** @class */ (function () {
    function RelationType(name, dataType) {
        this.name = name;
        this.dataType = dataType;
    }
    /**
     * Get the relation type from the name
     * @param  {string} name name
     * @return {module:extension/relatedTables~RelationType}
     */
    RelationType.fromName = function (name) {
        return RelationType[name.toUpperCase()];
    };
    /**
     * Link features with other features
     * @type {Object}
     */
    RelationType.FEATURES = new RelationType('features', contentsDao_1.default.GPKG_CDT_FEATURES_NAME);
    /**
     * Relate sets of tabular text or numeric data
     * @type {Object}
     */
    RelationType.SIMPLE_ATTRIBUTES = new RelationType('simple_attributes', contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Relate features or attributes to multimedia files such as pictures and videos
     * @type {Object}
     */
    RelationType.MEDIA = new RelationType('media', contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Attribute type relation
     * @type {Object}
     */
    RelationType.ATTRIBUTES = new RelationType('attributes', contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Tile type relation
     * @type {Object}
     */
    RelationType.TILES = new RelationType('tiles', contentsDao_1.default.GPKG_CDT_TILES_NAME);
    return RelationType;
}());
exports.default = RelationType;

},{"../../core/contents/contentsDao":9}],45:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * SimpleAttributesDao module.
 * @module extension/relatedTables
 */
var userDao_1 = __importDefault(require("../../user/userDao"));
var simpleAttributesRow_1 = __importDefault(require("./simpleAttributesRow"));
/**
 * User Simple Attributes DAO for reading user simple attributes data tables
 * @class
 * @extends UserDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
var SimpleAttributesDao = /** @class */ (function (_super) {
    __extends(SimpleAttributesDao, _super);
    function SimpleAttributesDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.simpleAttributesTable = table;
        return _this;
    }
    /**
     * Create a new {module:extension/relatedTables~SimpleAttributesRow}
     * @return {module:extension/relatedTables~SimpleAttributesRow}
     */
    SimpleAttributesDao.prototype.newRow = function () {
        return new simpleAttributesRow_1.default(this.simpleAttributesTable);
    };
    /**
     * Create a new {module:extension/relatedTables~SimpleAttributesRow} with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~SimpleAttributesRow}             simple attributes row
     */
    SimpleAttributesDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new simpleAttributesRow_1.default(this.simpleAttributesTable, columnTypes, values);
    };
    /**
     * Gets the {module:extension/relatedTables~SimpleAttributesTable}
     * @return {module:extension/relatedTables~SimpleAttributesTable}
     */
    SimpleAttributesDao.prototype.getTable = function () {
        return this.simpleAttributesTable;
    };
    /**
     * Get the simple attributes rows from this table by ids
     * @param  {Number[]} ids array of ids
     * @return {module:extension/relatedTables~SimpleAttributesRow[]}
     */
    SimpleAttributesDao.prototype.getRows = function (ids) {
        var simpleAttributesRows = [];
        for (var i = 0; i < ids.length; i++) {
            var row = this.queryForId(ids[i]);
            if (row) {
                simpleAttributesRows.push(row);
            }
        }
        return simpleAttributesRows;
    };
    return SimpleAttributesDao;
}(userDao_1.default));
exports.default = SimpleAttributesDao;

},{"../../user/userDao":122,"./simpleAttributesRow":46}],46:[function(require,module,exports){
"use strict";
/**
 * SimpleAttributesRow module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = __importDefault(require("../../user/userRow"));
/**
 * User Simple Attributes Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~SimpleAttributesTable} simpleAttributesTable simple attributes table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var SimpleAttributesRow = /** @class */ (function (_super) {
    __extends(SimpleAttributesRow, _super);
    function SimpleAttributesRow(simpleAttributesTable, columnTypes, values) {
        var _this = _super.call(this, simpleAttributesTable, columnTypes, values) || this;
        _this.simpleAttributesTable = simpleAttributesTable;
        return _this;
    }
    /**
     * Gets the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesRow.prototype.getIdColumn = function () {
        return this.simpleAttributesTable.getIdColumn();
    };
    /**
     * Gets the id
     * @return {Number}
     */
    SimpleAttributesRow.prototype.getId = function () {
        return this.getValueWithColumnName(this.getIdColumn().name);
    };
    return SimpleAttributesRow;
}(userRow_1.default));
exports.default = SimpleAttributesRow;

},{"../../user/userRow":123}],47:[function(require,module,exports){
"use strict";
/**
 * simpleAttributesTable module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRelatedTable_1 = __importDefault(require("./userRelatedTable"));
var relationType_1 = __importDefault(require("./relationType"));
var userColumn_1 = __importDefault(require("../../user/userColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Simple Attributes Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 * @param {string[]} requiredColumns required column names
 */
var SimpleAttributesTable = /** @class */ (function (_super) {
    __extends(SimpleAttributesTable, _super);
    function SimpleAttributesTable(tableName, columns, requiredColumns) {
        var _this = _super.call(this, tableName, SimpleAttributesTable.RELATION_TYPE.name, SimpleAttributesTable.RELATION_TYPE.dataType, columns, requiredColumns) || this;
        _this.TABLE_TYPE = 'simple_attributes';
        _this.validateColumns();
        return _this;
    }
    /**
     * Validate that Simple Attributes columns to verify at least one non id
     * column exists and that all columns are simple data types
     */
    SimpleAttributesTable.prototype.validateColumns = function () {
        var columns = this.columns;
        if (columns.length < 2) {
            throw new Error('Simple Attributes Tables require at least one non id column');
        }
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            if (!SimpleAttributesTable.isSimple(column)) {
                throw new Error('Simple Attributes Tables only support simple data types. Column: ' + column.name + ', Non Simple Data Type: ' + column.dataType);
            }
        }
    };
    /**
     * Get the column index of the id column
     * @return {Number}
     */
    SimpleAttributesTable.prototype.getIdColumnIndex = function () {
        return this.pkIndex;
    };
    /**
     * Get the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesTable.prototype.getIdColumn = function () {
        return this.getPkColumn();
    };
    /**
     * Create a simple attributes table with the columns
     * @param  {string} tableName name of the table
     * @param  {module:user/userColumn~UserColumn[]} additionalColumns additional columns
     * @return {module:extension/relatedTables~SimpleAttributesTable}
     */
    SimpleAttributesTable.create = function (tableName, additionalColumns) {
        var tableColumns = SimpleAttributesTable.createRequiredColumns(0);
        if (additionalColumns) {
            tableColumns = tableColumns.concat(additionalColumns);
        }
        return new SimpleAttributesTable(tableName, tableColumns, SimpleAttributesTable.requiredColumns());
    };
    /**
     * Get the required columns
     * @param  {string} [idColumnName=id] id column name
     * @return {string[]}
     */
    SimpleAttributesTable.requiredColumns = function (idColumnName) {
        if (idColumnName === void 0) { idColumnName = SimpleAttributesTable.COLUMN_ID; }
        var requiredColumns = [];
        requiredColumns.push(idColumnName);
        return requiredColumns;
    };
    /**
     * Get the number of required columns
     * @return {Number}
     */
    SimpleAttributesTable.numRequiredColumns = function () {
        return SimpleAttributesTable.requiredColumns().length;
    };
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @param  {string} [idColumnName=id]  id column name
     * @return {module:user/userColumn~UserColumn[]}
     */
    SimpleAttributesTable.createRequiredColumns = function (startingIndex, idColumnName) {
        if (startingIndex === void 0) { startingIndex = 0; }
        if (idColumnName === void 0) { idColumnName = 'id'; }
        return [SimpleAttributesTable.createIdColumn(startingIndex++, idColumnName || SimpleAttributesTable.COLUMN_ID)];
    };
    /**
     * Create the primary key id column
     * @param  {Number} index        index of the column
     * @param  {string} idColumnName name of the id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesTable.createIdColumn = function (index, idColumnName) {
        return userColumn_1.default.createPrimaryKeyColumnWithIndexAndName(index, idColumnName);
    };
    /**
     * Determine if the column is a simple column
     * @param  {module:user/userColumn~UserColumn} column column to check
     * @return {Boolean}
     */
    SimpleAttributesTable.isSimple = function (column) {
        return column.notNull && SimpleAttributesTable.isSimpleDataType(column.dataType);
    };
    /**
     * Determine if the data type is a simple type: TEXT, INTEGER, or REAL
     * @param {module:db/dataTypes~GPKGDataType} dataType
     * @return {Boolean}
     */
    SimpleAttributesTable.isSimpleDataType = function (dataType) {
        return dataType !== dataTypes_1.default.GPKGDataType.GPKG_DT_BLOB && dataType !== dataTypes_1.default.GPKGDataType.GPKG_DT_GEOMETRY;
    };
    SimpleAttributesTable.RELATION_TYPE = relationType_1.default.SIMPLE_ATTRIBUTES;
    SimpleAttributesTable.COLUMN_ID = 'id';
    return SimpleAttributesTable;
}(userRelatedTable_1.default));
exports.default = SimpleAttributesTable;

},{"../../db/dataTypes":18,"../../user/userColumn":121,"./relationType":44,"./userRelatedTable":51}],48:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module extension/relatedTables
 */
var userCustomDao_1 = __importDefault(require("../../user/custom/userCustomDao"));
var userMappingTable_1 = __importDefault(require("./userMappingTable"));
var userMappingRow_1 = __importDefault(require("./userMappingRow"));
var columnValues_1 = __importDefault(require("../../dao/columnValues"));
/**
 * User Mapping DAO for reading user mapping data tables
 * @class
 * @param  {string} table table name
 * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
 * @param {UserMappingTable} [userMappingTable]
 */
var UserMappingDao = /** @class */ (function (_super) {
    __extends(UserMappingDao, _super);
    function UserMappingDao(userCustomDao, geoPackage, userMappingTable) {
        return _super.call(this, geoPackage, userMappingTable || new userMappingTable_1.default(userCustomDao.table.table_name, userCustomDao.table.columns)) || this;
    }
    /**
     * Create a new {module:user/custom~UserCustomTable}
     * @param  {module:user/custom~UserCustomDao} userCustomDao
     * @return {module:user/custom~UserCustomTable} userCustomTable user custom table
     */
    UserMappingDao.prototype.createMappingTable = function (userCustomDao) {
        return new userMappingTable_1.default(userCustomDao.table.table_name, userCustomDao.table.columns);
    };
    /**
     * Create a new {module:extension/relatedTables~UserMappingRow}
     * @return {module:extension/relatedTables~UserMappingRow}
     */
    UserMappingDao.prototype.newRow = function () {
        return new userMappingRow_1.default(this.table);
    };
    /**
     * Gets the {module:extension/relatedTables~UserMappingTable}
     * @return {module:extension/relatedTables~UserMappingTable}
     */
    UserMappingDao.prototype.getTable = function () {
        return this.table;
    };
    /**
     * Create a user mapping row
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~UserMappingRow}             user mapping row
     */
    UserMappingDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new userMappingRow_1.default(this.table, columnTypes, values);
    };
    /**
     * Gets the user mapping row from the result
     * @param  {Object} result db result
     * @return {module:extension/relatedTables~UserMappingRow}             user mapping row
     */
    UserMappingDao.prototype.getUserMappingRow = function (result) {
        return this.getRow(result);
    };
    /**
     * Query by base id
     * @param  {(UserMappingRow | Number)} baseId base id
     * @return {Object[]}
     */
    UserMappingDao.prototype.queryByBaseId = function (baseId) {
        return this.queryForAllEq(userMappingTable_1.default.COLUMN_BASE_ID, baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId);
    };
    /**
     * Query by related id
     * @param  {(Number & UserMappingRow)} relatedId related id
     * @return {Object[]}
     */
    UserMappingDao.prototype.queryByRelatedId = function (relatedId) {
        return this.queryForAllEq(userMappingTable_1.default.COLUMN_RELATED_ID, relatedId.getRelatedId ? relatedId.getRelatedId() : relatedId);
    };
    /**
     * Query by base id and related id
     * @param  {(UserMappingRow | Number)} baseId base id
     * @param  {(UserMappingRow | Number)} [relatedId] related id
     * @return {Iterable<any>}
     */
    UserMappingDao.prototype.queryByIds = function (baseId, relatedId) {
        var values = new columnValues_1.default();
        values.addColumn(userMappingTable_1.default.COLUMN_BASE_ID, baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId);
        if (relatedId !== undefined) {
            values.addColumn(userMappingTable_1.default.COLUMN_RELATED_ID, relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId);
        }
        return this.queryForFieldValues(values);
    };
    /**
     * The unique related ids
     * @return {Number[]}
     */
    UserMappingDao.prototype.uniqueRelatedIds = function () {
        var query = 'SELECT DISTINCT ';
        query += userMappingTable_1.default.COLUMN_RELATED_ID;
        query += ' FROM ';
        query += "'" + this.gpkgTableName + "'";
        return this.connection.all(query);
    };
    /**
     * Count user mapping rows by base id and related id
     * @param  {(UserMappingRow | Number)} baseId    base id
     * @param  {(UserMappingRow | Number)} [relatedId] related id
     * @return {Number}
     */
    UserMappingDao.prototype.countByIds = function (baseId, relatedId) {
        var values = new columnValues_1.default();
        values.addColumn(userMappingTable_1.default.COLUMN_BASE_ID, baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId);
        if (relatedId !== undefined) {
            values.addColumn(userMappingTable_1.default.COLUMN_RELATED_ID, relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId);
        }
        return this.count(values);
    };
    /**
     * Delete by base id
     * @param  {(UserMappingRow | Number)} baseId base id
     * @return {Number} number of deleted rows
     */
    UserMappingDao.prototype.deleteByBaseId = function (baseId) {
        var where = '';
        where += this.buildWhereWithFieldAndValue(userMappingTable_1.default.COLUMN_BASE_ID, baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId);
        var whereArgs = this.buildWhereArgs([baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId]);
        return this.deleteWhere(where, whereArgs);
    };
    /**
     * Delete by related id
     * @param  {(UserMappingRow | Number)} relatedId related id
     * @return {Number} number of deleted rows
     */
    UserMappingDao.prototype.deleteByRelatedId = function (relatedId) {
        var where = '';
        where += this.buildWhereWithFieldAndValue(userMappingTable_1.default.COLUMN_RELATED_ID, relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId);
        var whereArgs = this.buildWhereArgs([relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId]);
        return this.deleteWhere(where, whereArgs);
    };
    /**
     * Delete by base id and related id
     * @param  {(UserMappingRow | Number)} baseId    base id
     * @param  {(UserMappingRow | Number)} [relatedId] related id
     * @return {Number} number of deleted rows
     */
    UserMappingDao.prototype.deleteByIds = function (baseId, relatedId) {
        var where = '';
        var whereParams = [baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId];
        where += this.buildWhereWithFieldAndValue(userMappingTable_1.default.COLUMN_BASE_ID, baseId instanceof userMappingRow_1.default ? baseId.getBaseId() : baseId);
        if (relatedId !== undefined) {
            where += ' and ';
            where += this.buildWhereWithFieldAndValue(userMappingTable_1.default.COLUMN_RELATED_ID, relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId);
            whereParams.push(relatedId instanceof userMappingRow_1.default ? relatedId.getRelatedId() : relatedId);
        }
        var whereArgs = this.buildWhereArgs(whereParams);
        return this.deleteWhere(where, whereArgs);
    };
    return UserMappingDao;
}(userCustomDao_1.default));
exports.default = UserMappingDao;

},{"../../dao/columnValues":12,"../../user/custom/userCustomDao":118,"./userMappingRow":49,"./userMappingTable":50}],49:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = __importDefault(require("../../user/userRow"));
/**
 * UserMappingRow module.
 * @module extension/relatedTables
 */
/**
 * User Mapping Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~UserMappingTable} table user mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var UserMappingRow = /** @class */ (function (_super) {
    __extends(UserMappingRow, _super);
    function UserMappingRow(table, columnTypes, values) {
        var _this = _super.call(this, table, columnTypes, values) || this;
        _this.table = table;
        return _this;
    }
    /**
     * Get the base id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingRow.prototype.getBaseIdColumn = function () {
        return this.table.getBaseIdColumn();
    };
    /**
     * Gets the base id
     * @return {Number}
     */
    UserMappingRow.prototype.getBaseId = function () {
        return this.getValueWithColumnName(this.getBaseIdColumn().name);
    };
    /**
     * Sets the base id
     * @param  {Number} baseId base id
     */
    UserMappingRow.prototype.setBaseId = function (baseId) {
        this.setValueWithColumnName(this.getBaseIdColumn().name, baseId);
    };
    /**
     * Get the related id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingRow.prototype.getRelatedIdColumn = function () {
        return this.table.getRelatedIdColumn();
    };
    /**
     * Gets the related id
     * @return {Number}
     */
    UserMappingRow.prototype.getRelatedId = function () {
        return this.getValueWithColumnName(this.getRelatedIdColumn().name);
    };
    /**
     * Sets the related id
     * @param  {Number} relatedId related id
     */
    UserMappingRow.prototype.setRelatedId = function (relatedId) {
        this.setValueWithColumnName(this.getRelatedIdColumn().name, relatedId);
    };
    return UserMappingRow;
}(userRow_1.default));
exports.default = UserMappingRow;

},{"../../user/userRow":123}],50:[function(require,module,exports){
"use strict";
/**
 * userMappingTable module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userTable_1 = __importDefault(require("../../user/userTable"));
var userCustomColumn_1 = __importDefault(require("../../user/custom/userCustomColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Contains user mapping table factory and utility methods
 * @class
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   user mapping columns
 */
var UserMappingTable = /** @class */ (function (_super) {
    __extends(UserMappingTable, _super);
    function UserMappingTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Get the base id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingTable.prototype.getBaseIdColumn = function () {
        return this.getColumnWithColumnName(UserMappingTable.COLUMN_BASE_ID);
    };
    /**
     * Get the related id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingTable.prototype.getRelatedIdColumn = function () {
        return this.getColumnWithColumnName(UserMappingTable.COLUMN_RELATED_ID);
    };
    /**
     * Creates a user mapping table with the minimum required columns followed by the additional columns
     * @param  {string} tableName name of the table
     * @param  {module:user/userColumn~UserColumn[]} [columns] additional columns
     * @return {module:extension/relatedTables~UserMappingTable}
     */
    UserMappingTable.create = function (tableName, columns) {
        var allColumns = UserMappingTable.createRequiredColumns(0);
        if (columns) {
            allColumns = allColumns.concat(columns);
        }
        return new UserMappingTable(tableName, allColumns);
    };
    /**
     * Get the number of required columns
     * @return {Number}
     */
    UserMappingTable.numRequiredColumns = function () {
        return UserMappingTable.createRequiredColumns(0).length;
    };
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    UserMappingTable.createRequiredColumns = function (startingIndex) {
        if (startingIndex === void 0) { startingIndex = 0; }
        return [
            UserMappingTable.createBaseIdColumn(startingIndex++),
            UserMappingTable.createRelatedIdColumn(startingIndex)
        ];
    };
    /**
     * Create the base id column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingTable.createBaseIdColumn = function (index) {
        var baseIdColumn = userCustomColumn_1.default.createColumn(index, UserMappingTable.COLUMN_BASE_ID, dataTypes_1.default.GPKGDataType.GPKG_DT_INTEGER, undefined, true);
        return baseIdColumn;
    };
    /**
     * Create the related id column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingTable.createRelatedIdColumn = function (index) {
        return userCustomColumn_1.default.createColumn(index, UserMappingTable.COLUMN_RELATED_ID, dataTypes_1.default.GPKGDataType.GPKG_DT_INTEGER, undefined, true);
    };
    /**
     * Get the required columns
     * @return {string[]}
     */
    UserMappingTable.requiredColumns = function () {
        return [UserMappingTable.COLUMN_BASE_ID, UserMappingTable.COLUMN_RELATED_ID];
    };
    UserMappingTable.COLUMN_BASE_ID = 'base_id';
    UserMappingTable.COLUMN_RELATED_ID = 'related_id';
    return UserMappingTable;
}(userTable_1.default));
exports.default = UserMappingTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":117,"../../user/userTable":124}],51:[function(require,module,exports){
"use strict";
/**
 * userRelatedTable module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userTable_1 = __importDefault(require("../../user/userTable"));
/**
 * User Defined Related Table
 * @param  {string} tableName table name
 * @param  {array} columns   attribute columns
 */
/**
 * User Defined Related Table
 * @param  {string} tableName       table name
 * @param  {string} relationName    relation name
 * @param  {string} dataType        Contents data type
 * @param  {module:user/userColumn~UserColumn} columns         columns
 * @param  {string[]} [requiredColumns] required columns
 * @return {module:extension/relatedTables~UserRelatedTable}
 */
var UserRelatedTable = /** @class */ (function (_super) {
    __extends(UserRelatedTable, _super);
    function UserRelatedTable(tableName, relationName, dataType, columns, requiredColumns) {
        var _this = _super.call(this, tableName, columns, requiredColumns) || this;
        // eslint-disable-next-line camelcase
        _this.relation_name = relationName;
        _this.data_type = dataType;
        return _this;
    }
    /**
     * Sets the contents
     * @param  {module:core/contents~Contents} contents contents
     * @throw Error if the contents data type does not match this data type
     */
    UserRelatedTable.prototype.setContents = function (contents) {
        this.contents = contents;
        // verify the contents have a relation name data type
        if (!contents.data_type || contents.data_type !== this.data_type) {
            throw new Error('The contents of this related table must have a data type of ' + this.data_type);
        }
    };
    return UserRelatedTable;
}(userTable_1.default));
exports.default = UserRelatedTable;

},{"../../user/userTable":124}],52:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var rtreeIndexDao_1 = __importDefault(require("./rtreeIndexDao"));
var envelopeBuilder_1 = __importDefault(require("../../geom/envelopeBuilder"));
var geometryData_1 = require("../../geom/geometryData");
/**
 * RTreeIndex extension
 * @class RTreeIndex
 * @extends BaseExtension
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
var RTreeIndex = /** @class */ (function (_super) {
    __extends(RTreeIndex, _super);
    function RTreeIndex(geoPackage, featureDao) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = extension_1.default.buildExtensionName(rtreeIndexDao_1.default.EXTENSION_RTREE_INDEX_AUTHOR, rtreeIndexDao_1.default.EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR);
        _this.extensionDefinition = rtreeIndexDao_1.default.EXTENSION_RTREE_INDEX_DEFINITION;
        _this.tableName = featureDao.table_name;
        _this.primaryKeyColumn = featureDao.idColumns[0];
        _this.columnName = featureDao.getGeometryColumnName();
        _this.featureCount = featureDao.count();
        _this.rtreeIndexDao = new rtreeIndexDao_1.default(geoPackage, featureDao);
        _this.extensionExists = _this.hasExtension(_this.extensionName, _this.tableName, _this.columnName);
        return _this;
    }
    RTreeIndex.prototype.getRTreeIndexExtension = function () {
        return this.getExtension(this.extensionName, this.tableName, this.columnName);
    };
    RTreeIndex.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, this.tableName, this.columnName, this.extensionDefinition, extension_1.default.WRITE_ONLY);
    };
    /**
     *
     * @param {Function} [progress] progress function
     * @returns {Promise}
     */
    RTreeIndex.prototype.create = function (progress) {
        var safeProgress = progress || function () { };
        if (this.extensionExists) {
            return Promise.resolve(this.getRTreeIndexExtension());
        }
        return this.getOrCreate(this.extensionName, this.tableName, this.columnName, rtreeIndexDao_1.default.EXTENSION_RTREE_INDEX_DEFINITION, extension_1.default.WRITE_ONLY)
            .then(function () {
            this.createAllFunctions();
            this.createRTreeIndex();
            safeProgress({
                description: 'Creating Feature Index',
                count: 0,
                totalCount: this.featureCount,
                layer: this.tableName
            });
            this.loadRTreeIndex();
            this.createAllTriggers();
            return this.getRTreeIndexExtension();
        }.bind(this));
    };
    RTreeIndex.prototype.createAllTriggers = function () {
        var insertTrigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_insert AFTER INSERT ON ' + this.tableName +
            '  WHEN (new.' + this.columnName + ' NOT NULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
            'BEGIN ' +
            '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
            '    NEW.' + this.primaryKeyColumn + ',' +
            '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
            '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ') ' +
            '  ); ' +
            'END;';
        var update1Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update1 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
            '  WHEN OLD.' + this.primaryKeyColumn + ' = NEW.' + this.primaryKeyColumn + ' AND ' +
            '     (NEW.' + this.columnName + ' NOTNULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
            'BEGIN ' +
            '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
            '    NEW.' + this.primaryKeyColumn + ',' +
            '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
            '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ') ' +
            '  ); ' +
            'END;';
        var update2Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update2 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
            '  WHEN OLD.' + this.primaryKeyColumn + ' = NEW.' + this.primaryKeyColumn + ' AND ' +
            '       (NEW.' + this.columnName + ' ISNULL OR ST_IsEmpty(NEW.' + this.columnName + ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
            'END;';
        var update3Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update3 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
            '  WHEN OLD.' + this.primaryKeyColumn + ' != NEW.' + this.primaryKeyColumn + ' AND ' +
            '       (NEW.' + this.columnName + ' NOTNULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
            '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
            '    NEW.' + this.primaryKeyColumn + ', ' +
            '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
            '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ')' +
            '  ); ' +
            'END;';
        var update4Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update4 AFTER UPDATE ON ' + this.tableName +
            '  WHEN OLD.' + this.primaryKeyColumn + ' != NEW.' + this.primaryKeyColumn + ' AND ' +
            '       (NEW.' + this.columnName + ' ISNULL OR ST_IsEmpty(NEW.' + this.columnName + ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id IN (OLD.' + this.primaryKeyColumn + ', NEW.' + this.primaryKeyColumn + '); ' +
            'END;';
        var deleteTrigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_delete AFTER DELETE ON ' + this.tableName +
            '  WHEN old.' + this.columnName + ' NOT NULL ' +
            'BEGIN' +
            '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
            'END;';
        this.connection.run(insertTrigger);
        this.connection.run(update1Trigger);
        this.connection.run(update2Trigger);
        this.connection.run(update3Trigger);
        this.connection.run(update4Trigger);
        this.connection.run(deleteTrigger);
    };
    RTreeIndex.prototype.loadRTreeIndex = function () {
        this.connection.run('INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' SELECT ' + this.primaryKeyColumn + ', st_minx(' + this.columnName + '), st_maxx(' + this.columnName + '), st_miny(' + this.columnName + '), st_maxy(' + this.columnName + ') FROM ' + this.tableName);
    };
    RTreeIndex.prototype.createRTreeIndex = function () {
        this.connection.run('CREATE VIRTUAL TABLE rtree_' + this.tableName + '_' + this.columnName + ' USING rtree(id, minx, maxx, miny, maxy)');
    };
    RTreeIndex.prototype.createAllFunctions = function () {
        this.createMinXFunction();
        this.createMaxXFunction();
        this.createMinYFunction();
        this.createMaxYFunction();
        this.createIsEmptyFunction();
    };
    RTreeIndex.prototype.createMinXFunction = function () {
        this.connection.registerFunction('ST_MinX', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.default.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.minX;
        });
    };
    RTreeIndex.prototype.createMinYFunction = function () {
        this.connection.registerFunction('ST_MinY', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.default.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.minY;
        });
    };
    RTreeIndex.prototype.createMaxXFunction = function () {
        this.connection.registerFunction('ST_MaxX', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.default.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.maxX;
        });
    };
    RTreeIndex.prototype.createMaxYFunction = function () {
        this.connection.registerFunction('ST_MaxY', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.default.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.maxY;
        });
    };
    RTreeIndex.prototype.createIsEmptyFunction = function () {
        this.connection.registerFunction('ST_IsEmpty', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            return !geom || geom.empty || !geom.geometry;
        });
    };
    return RTreeIndex;
}(baseExtension_1.default));
exports.default = RTreeIndex;

},{"../../geom/envelopeBuilder":82,"../../geom/geometryData":83,"../baseExtension":24,"../extension":29,"./rtreeIndexDao":53}],53:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var rtreeIndex_1 = __importDefault(require("./rtreeIndex"));
var sqliteQueryBuilder_1 = require("../../db/sqliteQueryBuilder");
/**
 * RTree module.
 */
/**
 * RTree Index Data Access Object
 * @class
 * @extends Dao
 */
var RTreeIndexDao = /** @class */ (function (_super) {
    __extends(RTreeIndexDao, _super);
    function RTreeIndexDao(geoPackage, featureDao) {
        var _this = _super.call(this, geoPackage) || this;
        _this.gpkgTableName = RTreeIndexDao.TABLE_NAME;
        _this.featureDao = featureDao;
        return _this;
    }
    RTreeIndexDao.prototype.createObject = function () {
        return new rtreeIndex_1.default(this.geoPackage, this.featureDao);
    };
    /**
     * Generate query components
     * @param envelope
     * @returns {{whereArgs: Array, where: string, join: string, tableNameArr: string[]}}
     * @private
     */
    RTreeIndexDao.prototype._generateGeometryEnvelopeQuery = function (envelope) {
        var tableName = this.featureDao.gpkgTableName;
        var where = '';
        var minXLessThanMaxX = envelope.minX < envelope.maxX;
        if (minXLessThanMaxX) {
            where += this.buildWhereWithFieldAndValue('minx', envelope.maxX, '<=');
            where += ' and ';
            where += this.buildWhereWithFieldAndValue('maxx', envelope.minX, '>=');
        }
        else {
            where += '(';
            where += this.buildWhereWithFieldAndValue('minx', envelope.maxX, '<=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue('maxx', envelope.minX, '>=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue('minx', envelope.minX, '>=');
            where += ' or ';
            where += this.buildWhereWithFieldAndValue('maxx', envelope.maxX, '<=');
            where += ')';
        }
        where += ' and ';
        where += this.buildWhereWithFieldAndValue('miny', envelope.maxY, '<=');
        where += ' and ';
        where += this.buildWhereWithFieldAndValue('maxy', envelope.minY, '>=');
        var whereArgs = [];
        whereArgs.push(envelope.maxX, envelope.minX);
        if (!minXLessThanMaxX) {
            whereArgs.push(envelope.minX, envelope.maxX);
        }
        whereArgs.push(envelope.maxY, envelope.minY);
        return {
            join: 'inner join ' + tableName + ' on ' + tableName + '.' + this.featureDao.idColumns[0] + ' = ' + this.gpkgTableName + '.id',
            where: where,
            whereArgs: whereArgs,
            tableNameArr: [tableName + '.*']
        };
    };
    /**
     * Query witha geometry envelope
     * @param  {any} envelope envelope
     * @return {IterableIterator<any>}
     */
    RTreeIndexDao.prototype.queryWithGeometryEnvelope = function (envelope) {
        var result = this._generateGeometryEnvelopeQuery(envelope);
        return this.queryJoinWhereWithArgs(result.join, result.where, result.whereArgs, result.tableNameArr);
    };
    RTreeIndexDao.prototype.countWithGeometryEnvelope = function (envelope) {
        var result = this._generateGeometryEnvelopeQuery(envelope);
        return this.connection.get(sqliteQueryBuilder_1.SqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", result.where), result.whereArgs).count;
    };
    RTreeIndexDao.TABLE_NAME = "rtree";
    RTreeIndexDao.COLUMN_TABLE_NAME = RTreeIndexDao.TABLE_NAME + ".table_name";
    RTreeIndexDao.COLUMN_GEOM_ID = RTreeIndexDao.TABLE_NAME + ".geom_id";
    RTreeIndexDao.COLUMN_MIN_X = RTreeIndexDao.TABLE_NAME + ".minx";
    RTreeIndexDao.COLUMN_MAX_X = RTreeIndexDao.TABLE_NAME + ".maxx";
    RTreeIndexDao.COLUMN_MIN_Y = RTreeIndexDao.TABLE_NAME + ".miny";
    RTreeIndexDao.COLUMN_MAX_Y = RTreeIndexDao.TABLE_NAME + ".maxy";
    RTreeIndexDao.COLUMN_MIN_Z = RTreeIndexDao.TABLE_NAME + ".minz";
    RTreeIndexDao.COLUMN_MAX_Z = RTreeIndexDao.TABLE_NAME + ".maxz";
    RTreeIndexDao.COLUMN_MIN_M = RTreeIndexDao.TABLE_NAME + ".minm";
    RTreeIndexDao.COLUMN_MAX_M = RTreeIndexDao.TABLE_NAME + ".maxm";
    RTreeIndexDao.EXTENSION_NAME = 'gpkg_rtree_index';
    RTreeIndexDao.EXTENSION_RTREE_INDEX_AUTHOR = 'gpkg';
    RTreeIndexDao.EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR = 'rtree_index';
    RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION = 'http://www.geopackage.org/spec/#extension_rtree';
    return RTreeIndexDao;
}(dao_1.default));
exports.default = RTreeIndexDao;

},{"../../dao/dao":13,"../../db/sqliteQueryBuilder":21,"./rtreeIndex":52}],54:[function(require,module,exports){
"use strict";
/**
 * SchemaExtension module.
 * @module SchemaExtension
 * @see module:extension/BaseExtension
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var SchemaExtension = /** @class */ (function (_super) {
    __extends(SchemaExtension, _super);
    function SchemaExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = SchemaExtension.EXTENSION_NAME;
        _this.extensionDefinition = SchemaExtension.EXTENSION_SCHEMA_DEFINITION;
        return _this;
    }
    SchemaExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, extension_1.default.READ_WRITE);
    };
    SchemaExtension.EXTENSION_NAME = 'gpkg_schema';
    SchemaExtension.EXTENSION_SCHEMA_AUTHOR = 'gpkg';
    SchemaExtension.EXTENSION_SCHEMA_NAME_NO_AUTHOR = 'schema';
    SchemaExtension.EXTENSION_SCHEMA_DEFINITION = 'http://www.geopackage.org/spec/#extension_schema';
    return SchemaExtension;
}(baseExtension_1.default));
exports.default = SchemaExtension;

},{"../baseExtension":24,"../extension":29}],55:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class FeatureStyle
 */
/**
 * FeatureStyle constructor
 * @param {module:extension/style.StyleRow} styleRow
 * @param {module:extension/style.IconRow} iconRow
 * @constructor
 */
var FeatureStyle = /** @class */ (function () {
    function FeatureStyle(styleRow, iconRow) {
        this.styleRow = styleRow;
        this.iconRow = iconRow;
    }
    /**
     * Set style
     * @param {module:extension/style.StyleRow} styleRow
     */
    FeatureStyle.prototype.setStyle = function (styleRow) {
        this.styleRow = styleRow;
    };
    /**
     * Get style
     * @returns {module:extension/style.StyleRow}
     */
    FeatureStyle.prototype.getStyle = function () {
        return this.styleRow;
    };
    /**
     * Returns true if has style
     * @returns {Boolean}
     */
    FeatureStyle.prototype.hasStyle = function () {
        return !!this.styleRow;
    };
    /**
     * Set icon
     * @param {module:extension/style.IconRow} iconRow
     */
    FeatureStyle.prototype.setIcon = function (iconRow) {
        this.iconRow = iconRow;
    };
    /**
     * Get icon
     * @returns {module:extension/style.IconRow}
     */
    FeatureStyle.prototype.getIcon = function () {
        return this.iconRow;
    };
    /**
     * Returns true if has icon
     * @returns {Boolean}
     */
    FeatureStyle.prototype.hasIcon = function () {
        return !!this.iconRow;
    };
    return FeatureStyle;
}());
module.exports = FeatureStyle;

},{}],56:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class FeatureStyles
 */
/**
 * FeatureStyles constructor
 * @param {module:extension/style.Styles} styles
 * @param {module:extension/style.Icons} icons
 * @constructor
 */
var FeatureStyles = /** @class */ (function () {
    function FeatureStyles(styles, icons) {
        if (styles === void 0) { styles = null; }
        if (icons === void 0) { icons = null; }
        this.styles = styles;
        this.icons = icons;
    }
    /**
     * Set style
     * @param {module:extension/style.Styles} styles
     */
    FeatureStyles.prototype.setStyles = function (styles) {
        this.styles = styles;
    };
    /**
     * Get style
     * @returns {module:extension/style.Styles}
     */
    FeatureStyles.prototype.getStyles = function () {
        return this.styles;
    };
    /**
     * Set icon
     * @param {module:extension/style.Icons} icons
     */
    FeatureStyles.prototype.setIcons = function (icons) {
        this.icons = icons;
    };
    /**
     * Get icon
     * @returns {module:extension/style.Icons}
     */
    FeatureStyles.prototype.getIcons = function () {
        return this.icons;
    };
    return FeatureStyles;
}());
module.exports = FeatureStyles;

},{}],57:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class FeatureStyleExtension
 */
var featureStyles_1 = __importDefault(require("./featureStyles"));
var featureStyle_1 = __importDefault(require("./featureStyle"));
var styles_1 = __importDefault(require("./styles"));
var icons_1 = __importDefault(require("./icons"));
/**
 * Feature Table Styles, styles and icons for an individual feature table
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @param {String} tableName
 * @constructor
 */
var FeatureTableStyles = /** @class */ (function () {
    function FeatureTableStyles(geoPackage, tableName) {
        this.featureStyleExtension = geoPackage.getFeatureStyleExtension();
        this.cachedTableFeatureStyles = new featureStyles_1.default();
        this.tableName = tableName;
    }
    /**
       * Get the feature style extension
       * @return {module:extension/style.FeatureStyleExtension} feature style extension
       */
    FeatureTableStyles.prototype.getFeatureStyleExtension = function () {
        return this.featureStyleExtension;
    };
    /**
       * Get the feature table name
       * @return {String} feature table name
       */
    FeatureTableStyles.prototype.getTableName = function () {
        return this.tableName;
    };
    /**
       * Determine if the GeoPackage has the extension for the table
       * @return {Boolean} true if has extension
       */
    FeatureTableStyles.prototype.has = function () {
        return this.featureStyleExtension.has(this.tableName);
    };
    /**
       * Create style, icon, table style, and table icon relationships for the
       * feature table
       * @return {Promise}
       */
    FeatureTableStyles.prototype.createRelationships = function () {
        return this.featureStyleExtension.createRelationships(this.tableName);
    };
    /**
       * Check if feature table has a style, icon, table style, or table icon
       * relationships
       * @return {Boolean} true if has a relationship
       */
    FeatureTableStyles.prototype.hasRelationship = function () {
        return this.featureStyleExtension.hasRelationship(this.tableName);
    };
    /**
       * Create a style relationship for the feature table
       * @return {Promise}
       */
    FeatureTableStyles.prototype.createStyleRelationship = function () {
        return this.featureStyleExtension.createStyleRelationship(this.tableName);
    };
    /**
       * Determine if a style relationship exists for the feature table
       * @return {Boolean} true if relationship exists
       */
    FeatureTableStyles.prototype.hasStyleRelationship = function () {
        return this.featureStyleExtension.hasStyleRelationship(this.tableName);
    };
    /**
       * Create a feature table style relationship
       * @return {Promise}
       */
    FeatureTableStyles.prototype.createTableStyleRelationship = function () {
        return this.featureStyleExtension.createTableStyleRelationship(this.tableName);
    };
    /**
       * Determine if feature table style relationship exists
       *
       * @return {Boolean} true if relationship exists
       */
    FeatureTableStyles.prototype.hasTableStyleRelationship = function () {
        return this.featureStyleExtension.hasTableStyleRelationship(this.tableName);
    };
    /**
       * Create an icon relationship for the feature table
       * @return {Promise}
       */
    FeatureTableStyles.prototype.createIconRelationship = function () {
        return this.featureStyleExtension.createIconRelationship(this.tableName);
    };
    /**
       * Determine if an icon relationship exists for the feature table
       * @return {Boolean} true if relationship exists
       */
    FeatureTableStyles.prototype.hasIconRelationship = function () {
        return this.featureStyleExtension.hasIconRelationship(this.tableName);
    };
    /**
       * Create a feature table icon relationship
       * @return {Promise}
       */
    FeatureTableStyles.prototype.createTableIconRelationship = function () {
        return this.featureStyleExtension.createTableIconRelationship(this.tableName);
    };
    /**
       * Determine if feature table icon relationship exists
       * @return {Boolean} true if relationship exists
       */
    FeatureTableStyles.prototype.hasTableIconRelationship = function () {
        return this.featureStyleExtension.hasTableIconRelationship(this.tableName);
    };
    /**
       * Delete the style and icon table and row relationships for the feature
       * table
       */
    FeatureTableStyles.prototype.deleteRelationships = function () {
        this.featureStyleExtension.deleteRelationships(this.tableName);
    };
    /**
       * Delete a style relationship for the feature table
       */
    FeatureTableStyles.prototype.deleteStyleRelationship = function () {
        this.featureStyleExtension.deleteStyleRelationship(this.tableName);
    };
    /**
       * Delete a table style relationship for the feature table
       */
    FeatureTableStyles.prototype.deleteTableStyleRelationship = function () {
        this.featureStyleExtension.deleteTableStyleRelationship(this.tableName);
    };
    /**
       * Delete a icon relationship for the feature table
       */
    FeatureTableStyles.prototype.deleteIconRelationship = function () {
        this.featureStyleExtension.deleteIconRelationship(this.tableName);
    };
    /**
       * Delete a table icon relationship for the feature table
       */
    FeatureTableStyles.prototype.deleteTableIconRelationship = function () {
        this.featureStyleExtension.deleteTableIconRelationship(this.tableName);
    };
    /**
       * Get a Style Mapping DAO
       * @return {module:extension/style.StyleMappingDao} style mapping DAO
       */
    FeatureTableStyles.prototype.getStyleMappingDao = function () {
        return this.featureStyleExtension.getStyleMappingDao(this.tableName);
    };
    /**
       * Get a Table Style Mapping DAO
       * @return {module:extension/style.StyleMappingDao} table style mapping DAO
       */
    FeatureTableStyles.prototype.getTableStyleMappingDao = function () {
        return this.featureStyleExtension.getTableStyleMappingDao(this.tableName);
    };
    /**
       * Get a Icon Mapping DAO
       * @return {module:extension/style.StyleMappingDao} icon mapping DAO
       */
    FeatureTableStyles.prototype.getIconMappingDao = function () {
        return this.featureStyleExtension.getIconMappingDao(this.tableName);
    };
    /**
       * Get a Table Icon Mapping DAO
       * @return {module:extension/style.StyleMappingDao} table icon mapping DAO
       */
    FeatureTableStyles.prototype.getTableIconMappingDao = function () {
        return this.featureStyleExtension.getTableIconMappingDao(this.tableName);
    };
    /**
       * Get a style DAO
       * @return {module:extension/style.StyleDao} style DAO
       */
    FeatureTableStyles.prototype.getStyleDao = function () {
        return this.featureStyleExtension.getStyleDao();
    };
    /**
       * Get a icon DAO
       * @return {module:extension/style.IconDao} icon DAO
       */
    FeatureTableStyles.prototype.getIconDao = function () {
        return this.featureStyleExtension.getIconDao();
    };
    /**
       * Get the table feature styles
       * @return {module:extension/style.FeatureStyles} table feature styles or null
       */
    FeatureTableStyles.prototype.getTableFeatureStyles = function () {
        return this.featureStyleExtension.getTableFeatureStyles(this.tableName);
    };
    /**
       * Get the table styles
       * @return {module:extension/style.Styles} table styles or null
       */
    FeatureTableStyles.prototype.getTableStyles = function () {
        return this.featureStyleExtension.getTableStyles(this.tableName);
    };
    /**
       * Get the cached table styles, querying and caching if needed
       * @return {module:extension/style.Styles} cached table styles
       */
    FeatureTableStyles.prototype.getCachedTableStyles = function () {
        var styles = this.cachedTableFeatureStyles.getStyles();
        if (styles === null) {
            styles = this.cachedTableFeatureStyles.getStyles();
            if (styles === null) {
                styles = this.getTableStyles();
                if (styles === null) {
                    styles = new styles_1.default();
                }
                this.cachedTableFeatureStyles.setStyles(styles);
            }
        }
        if (styles.isEmpty()) {
            styles = null;
        }
        return styles;
    };
    /**
       * Get the table style of the geometry type
       * @param {String} geometryType geometry type
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getTableStyle = function (geometryType) {
        return this.featureStyleExtension.getTableStyle(this.tableName, geometryType);
    };
    /**
       * Get the table style default
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getTableStyleDefault = function () {
        return this.featureStyleExtension.getTableStyleDefault(this.tableName);
    };
    /**
       * Get the table icons
       * @return {module:extension/style.Icons} table icons or null
       */
    FeatureTableStyles.prototype.getTableIcons = function () {
        return this.featureStyleExtension.getTableIcons(this.tableName);
    };
    /**
       * Get the cached table icons, querying and caching if needed
       * @return {module:extension/style.Icons} cached table icons
       */
    FeatureTableStyles.prototype.getCachedTableIcons = function () {
        var icons = this.cachedTableFeatureStyles.getIcons();
        if (icons === null) {
            icons = this.cachedTableFeatureStyles.getIcons();
            if (icons === null) {
                icons = this.getTableIcons();
                if (icons === null) {
                    icons = new icons_1.default();
                }
                this.cachedTableFeatureStyles.setIcons(icons);
            }
        }
        if (icons.isEmpty()) {
            icons = null;
        }
        return icons;
    };
    /**
       * Get the table icon of the geometry type
       * @param {String} geometryType geometry type
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getTableIcon = function (geometryType) {
        return this.featureStyleExtension.getTableIcon(this.tableName, geometryType);
    };
    /**
       * Get the table icon default
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getTableIconDefault = function () {
        return this.featureStyleExtension.getTableIconDefault(this.tableName);
    };
    /**
       * Get the feature styles for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyles} feature styles or null
       */
    FeatureTableStyles.prototype.getFeatureStylesForFeatureRow = function (featureRow) {
        return this.featureStyleExtension.getFeatureStylesForFeatureRow(featureRow);
    };
    /**
       * Get the feature styles for the feature id
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.FeatureStyles} feature styles or null
       */
    FeatureTableStyles.prototype.getFeatureStyles = function (featureId) {
        return this.featureStyleExtension.getFeatureStyles(this.tableName, featureId);
    };
    /**
       * Get the feature style (style and icon) of the feature row, searching in
       * order: feature geometry type style or icon, feature default style or
       * icon, table geometry type style or icon, table default style or icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureTableStyles.prototype.getFeatureStyleForFeatureRow = function (featureRow) {
        return this.getFeatureStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
       * Get the feature style (style and icon) of the feature row with the
       * provided geometry type, searching in order: feature geometry type style
       * or icon, feature default style or icon, table geometry type style or
       * icon, table default style or icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureTableStyles.prototype.getFeatureStyleForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        return this.getFeatureStyle(featureRow.getId(), geometryType);
    };
    /**
       * Get the feature style default (style and icon) of the feature row,
       * searching in order: feature default style or icon, table default style or
       * icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureTableStyles.prototype.getFeatureStyleDefaultForFeatureRow = function (featureRow) {
        return this.getFeatureStyle(featureRow.getId(), null);
    };
    /**
       * Get the feature style (style and icon) of the feature, searching in
       * order: feature geometry type style or icon, feature default style or
       * icon, table geometry type style or icon, table default style or icon
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureTableStyles.prototype.getFeatureStyle = function (featureId, geometryType) {
        var featureStyle = null;
        var style = this.getStyle(featureId, geometryType);
        var icon = this.getIcon(featureId, geometryType);
        if (style != null || icon != null) {
            featureStyle = new featureStyle_1.default(style, icon);
        }
        return featureStyle;
    };
    /**
       * Get the feature style (style and icon) of the feature, searching in
       * order: feature geometry type style or icon, feature default style or
       * icon, table geometry type style or icon, table default style or icon
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureTableStyles.prototype.getFeatureStyleDefault = function (featureId) {
        return this.getFeatureStyle(featureId, null);
    };
    /**
       * Get the styles for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.Styles} styles or null
       */
    FeatureTableStyles.prototype.getStylesForFeatureRow = function (featureRow) {
        return this.featureStyleExtension.getStylesForFeatureRow(featureRow);
    };
    /**
       * Get the styles for the feature id
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.Styles}  styles or null
       */
    FeatureTableStyles.prototype.getStylesForFeatureId = function (featureId) {
        return this.featureStyleExtension.getStylesForFeatureId(this.tableName, featureId);
    };
    /**
       * Get the style of the feature row, searching in order: feature geometry
       * type style, feature default style, table geometry type style, table
       * default style
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getStyleForFeatureRow = function (featureRow) {
        return this.getStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
       * Get the style of the feature row with the provided geometry type,
       * searching in order: feature geometry type style, feature default style,
       * table geometry type style, table default style
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getStyleForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        return this.getStyle(featureRow.getId(), geometryType);
    };
    /**
       * Get the default style of the feature row, searching in order: feature
       * default style, table default style
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getStyleDefaultForFeatureRow = function (featureRow) {
        return this.getStyle(featureRow.getId(), null);
    };
    /**
       * Get the style of the feature, searching in order: feature geometry type
       * style, feature default style, table geometry type style, table default
       * style
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getStyle = function (featureId, geometryType) {
        var styleRow = this.featureStyleExtension.getStyle(this.tableName, featureId, geometryType, false);
        if (styleRow === null) {
            // Table Style
            var styles = this.getCachedTableStyles();
            if (styles != null) {
                styleRow = styles.getStyle(geometryType);
            }
        }
        return styleRow;
    };
    /**
       * Get the default style of the feature, searching in order: feature default
       * style, table default style
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureTableStyles.prototype.getStyleDefault = function (featureId) {
        return this.getStyle(featureId, null);
    };
    /**
       * Get the icons for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.Icons} icons or null
       */
    FeatureTableStyles.prototype.getIconsForFeatureRow = function (featureRow) {
        return this.featureStyleExtension.getIconsForFeatureRow(featureRow);
    };
    /**
       * Get the icons for the feature id
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.Icons} icons or null
       */
    FeatureTableStyles.prototype.getIconsForFeatureId = function (featureId) {
        return this.featureStyleExtension.getIconsForFeatureId(this.tableName, featureId);
    };
    /**
       * Get the icon of the feature row, searching in order: feature geometry
       * type icon, feature default icon, table geometry type icon, table default
       * icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getIconForFeatureRow = function (featureRow) {
        return this.getIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
       * Get the icon of the feature row with the provided geometry type,
       * searching in order: feature geometry type icon, feature default icon,
       * table geometry type icon, table default icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getIconForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        return this.getIcon(featureRow.getId(), geometryType);
    };
    /**
       * Get the default icon of the feature row, searching in order: feature
       * default icon, table default icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getIconDefaultForFeatureRow = function (featureRow) {
        return this.getIcon(featureRow.getId(), null);
    };
    /**
       * Get the icon of the feature, searching in order: feature geometry type
       * icon, feature default icon, table geometry type icon, table default icon
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getIcon = function (featureId, geometryType) {
        var iconRow = this.featureStyleExtension.getIcon(this.tableName, featureId, geometryType, false);
        if (iconRow === null) {
            // Table Icon
            var icons = this.getCachedTableIcons();
            if (icons != null) {
                iconRow = icons.getIcon(geometryType);
            }
        }
        return iconRow;
    };
    /**
       * Get the default icon of the feature, searching in order: feature default
       * icon, table default icon
       *
       * @param {Number} featureId feature id
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureTableStyles.prototype.getIconDefault = function (featureId) {
        return this.getIcon(featureId, null);
    };
    /**
       * Set the feature table default feature styles
       *
       * @param {module:extension/style.FeatureStyles} featureStyles default feature styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableFeatureStyles = function (featureStyles) {
        return this.featureStyleExtension.setTableFeatureStyles(this.tableName, featureStyles).then(function () {
            this.clearCachedTableFeatureStyles();
        }.bind(this));
    };
    /**
       * Set the feature table default styles
       *
       * @param {module:extension/style.Styles} styles default styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableStyles = function (styles) {
        return this.featureStyleExtension.setTableStyles(this.tableName, styles).then(function () {
            this.clearCachedTableStyles();
        }.bind(this));
    };
    /**
       * Set the feature table style default
       *
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableStyleDefault = function (style) {
        return this.featureStyleExtension.setTableStyleDefault(this.tableName, style).then(function () {
            this.clearCachedTableStyles();
        }.bind(this));
    };
    /**
       * Set the feature table style for the geometry type
       *
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableStyle = function (geometryType, style) {
        return this.featureStyleExtension.setTableStyle(this.tableName, geometryType, style).then(function () {
            this.clearCachedTableStyles();
        }.bind(this));
    };
    /**
       * Set the feature table default icons
       *
       * @param {module:extension/style.Icons} icons default icons
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableIcons = function (icons) {
        return this.featureStyleExtension.setTableIcons(this.tableName, icons).then(function () {
            this.clearCachedTableIcons();
        }.bind(this));
    };
    /**
       * Set the feature table icon default
       *
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableIconDefault = function (icon) {
        return this.featureStyleExtension.setTableIconDefault(this.tableName, icon).then(function () {
            this.clearCachedTableIcons();
        }.bind(this));
    };
    /**
       * Set the feature table icon for the geometry type
       *
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setTableIcon = function (geometryType, icon) {
        return this.featureStyleExtension.setTableIcon(this.tableName, geometryType, icon).then(function () {
            this.clearCachedTableIcons();
        }.bind(this));
    };
    /**
       * Set the feature styles for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyles} featureStyles feature styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStylesForFeatureRow = function (featureRow, featureStyles) {
        return this.featureStyleExtension.setFeatureStylesForFeatureRow(featureRow, featureStyles);
    };
    /**
       * Set the feature styles for the feature table and feature id
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.FeatureStyles} featureStyles feature styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyles = function (featureId, featureStyles) {
        return this.featureStyleExtension.setFeatureStyles(this.tableName, featureId, featureStyles);
    };
    /**
       * Set the feature style (style and icon) of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyleForFeatureRow = function (featureRow, featureStyle) {
        return this.featureStyleExtension.setFeatureStyleForFeatureRow(featureRow, featureStyle);
    };
    /**
       * Set the feature style (style and icon) of the feature row for the
       * specified geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, featureStyle) {
        return this.featureStyleExtension.setFeatureStyleForFeatureRowAndGeometryType(featureRow, geometryType, featureStyle);
    };
    /**
       * Set the feature style default (style and icon) of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyleDefaultForFeatureRow = function (featureRow, featureStyle) {
        return this.featureStyleExtension.setFeatureStyleDefaultForFeatureRow(featureRow, featureStyle);
    };
    /**
       * Set the feature style (style and icon) of the feature
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyle = function (featureId, geometryType, featureStyle) {
        return this.featureStyleExtension.setFeatureStyle(this.tableName, featureId, geometryType, featureStyle);
    };
    /**
       * Set the feature style (style and icon) of the feature
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setFeatureStyleDefault = function (featureId, featureStyle) {
        return this.featureStyleExtension.setFeatureStyleDefault(this.tableName, featureId, featureStyle);
    };
    /**
       * Set the styles for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.StyleRow} styles styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStylesForFeatureRow = function (featureRow, styles) {
        return this.featureStyleExtension.setStylesForFeatureRow(featureRow, styles);
    };
    /**
       * Set the styles for the feature table and feature id
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.Styles} styles styles
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyles = function (featureId, styles) {
        return this.featureStyleExtension.setStyles(this.tableName, featureId, styles);
    };
    /**
       * Set the style of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyleForFeatureRow = function (featureRow, style) {
        return this.featureStyleExtension.setStyleForFeatureRow(featureRow, style);
    };
    /**
       * Set the style of the feature row for the specified geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, style) {
        return this.featureStyleExtension.setStyleForFeatureRowAndGeometryType(featureRow, geometryType, style);
    };
    /**
       * Set the default style of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyleDefaultForFeatureRow = function (featureRow, style) {
        return this.featureStyleExtension.setStyleDefaultForFeatureRow(featureRow, style);
    };
    /**
       * Set the style of the feature
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyle = function (featureId, geometryType, style) {
        return this.featureStyleExtension.setStyle(this.tableName, featureId, geometryType, style);
    };
    /**
       * Set the default style of the feature
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setStyleDefault = function (featureId, style) {
        return this.featureStyleExtension.setStyleDefault(this.tableName, featureId, style);
    };
    /**
       * Set the icons for the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.Icons} icons icons
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIconsForFeatureRow = function (featureRow, icons) {
        return this.featureStyleExtension.setIconsForFeatureRow(featureRow, icons);
    };
    /**
       * Set the icons for the feature table and feature id
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.Icons} icons icons
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIcons = function (featureId, icons) {
        return this.featureStyleExtension.setIcons(this.tableName, featureId, icons);
    };
    /**
       * Set the icon of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIconForFeatureRow = function (featureRow, icon) {
        return this.featureStyleExtension.setIconForFeatureRow(featureRow, icon);
    };
    /**
       * Set the icon of the feature row for the specified geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIconForFeatureRowAndGeometryType = function (featureRow, geometryType, icon) {
        return this.featureStyleExtension.setIconForFeatureRowAndGeometryType(featureRow, geometryType, icon);
    };
    /**
       * Set the default icon of the feature row
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIconDefaultForFeatureRow = function (featureRow, icon) {
        return this.featureStyleExtension.setIconDefaultForFeatureRow(featureRow, icon);
    };
    /**
       * Get the icon of the feature, searching in order: feature geometry type
       * icon, feature default icon, table geometry type icon, table default icon
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIcon = function (featureId, geometryType, icon) {
        return this.featureStyleExtension.setIcon(this.tableName, featureId, geometryType, icon);
    };
    /**
       * Set the default icon of the feature
       *
       * @param {Number} featureId feature id
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureTableStyles.prototype.setIconDefault = function (featureId, icon) {
        return this.featureStyleExtension.setIconDefault(this.tableName, featureId, icon);
    };
    /**
       * Delete all feature styles including table styles, table icons, style, and
       * icons
       */
    FeatureTableStyles.prototype.deleteAllFeatureStyles = function () {
        this.featureStyleExtension.deleteAllFeatureStyles(this.tableName);
        this.clearCachedTableFeatureStyles();
    };
    /**
       * Delete all styles including table styles and feature row styles
       */
    FeatureTableStyles.prototype.deleteAllStyles = function () {
        this.featureStyleExtension.deleteAllStyles(this.tableName);
        this.clearCachedTableStyles();
    };
    /**
       * Delete all icons including table icons and feature row icons
       */
    FeatureTableStyles.prototype.deleteAllIcons = function () {
        this.featureStyleExtension.deleteAllIcons(this.tableName);
        this.clearCachedTableIcons();
    };
    /**
       * Delete the feature table feature styles
       */
    FeatureTableStyles.prototype.deleteTableFeatureStyles = function () {
        this.featureStyleExtension.deleteTableFeatureStyles(this.tableName);
        this.clearCachedTableFeatureStyles();
    };
    /**
       * Delete the feature table styles
       */
    FeatureTableStyles.prototype.deleteTableStyles = function () {
        this.featureStyleExtension.deleteTableStyles(this.tableName);
        this.clearCachedTableStyles();
    };
    /**
       * Delete the feature table default style
       */
    FeatureTableStyles.prototype.deleteTableStyleDefault = function () {
        this.featureStyleExtension.deleteTableStyleDefault(this.tableName);
        this.clearCachedTableStyles();
    };
    /**
       * Delete the feature table style for the geometry type
       *
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteTableStyle = function (geometryType) {
        this.featureStyleExtension.deleteTableStyle(this.tableName, geometryType);
        this.clearCachedTableStyles();
    };
    /**
       * Delete the feature table icons
       */
    FeatureTableStyles.prototype.deleteTableIcons = function () {
        this.featureStyleExtension.deleteTableIcons(this.tableName);
        this.clearCachedTableIcons();
    };
    /**
       * Delete the feature table default icon
       */
    FeatureTableStyles.prototype.deleteTableIconDefault = function () {
        this.featureStyleExtension.deleteTableIconDefault(this.tableName);
        this.clearCachedTableIcons();
    };
    /**
       * Delete the feature table icon for the geometry type
       *
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteTableIcon = function (geometryType) {
        this.featureStyleExtension.deleteTableIcon(this.tableName, geometryType);
        this.clearCachedTableIcons();
    };
    /**
       * Clear the cached table feature styles
       */
    FeatureTableStyles.prototype.clearCachedTableFeatureStyles = function () {
        this.cachedTableFeatureStyles.setStyles(null);
        this.cachedTableFeatureStyles.setIcons(null);
    };
    /**
       * Clear the cached table styles
       */
    FeatureTableStyles.prototype.clearCachedTableStyles = function () {
        this.cachedTableFeatureStyles.setStyles(null);
    };
    /**
       * Clear the cached table icons
       */
    FeatureTableStyles.prototype.clearCachedTableIcons = function () {
        this.cachedTableFeatureStyles.setIcons(null);
    };
    /**
       * Delete all feature styles
       */
    FeatureTableStyles.prototype.deleteFeatureStyles = function () {
        this.featureStyleExtension.deleteFeatureStyles(this.tableName);
    };
    /**
       * Delete all styles
       */
    FeatureTableStyles.prototype.deleteStyles = function () {
        this.featureStyleExtension.deleteStyles(this.tableName);
    };
    /**
       * Delete feature row styles
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteStylesForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteStylesForFeatureRow(featureRow);
    };
    /**
       * Delete feature row styles
       *
       * @param {Number} featureId feature id
       */
    FeatureTableStyles.prototype.deleteStylesForFeatureId = function (featureId) {
        this.featureStyleExtension.deleteStylesForFeatureId(this.tableName, featureId);
    };
    /**
       * Delete the feature row default style
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteStyleDefaultForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteStyleDefaultForFeatureRow(featureRow);
    };
    /**
       * Delete the feature row default style
       *
       * @param {Number} featureId feature id
       */
    FeatureTableStyles.prototype.deleteStyleDefault = function (featureId) {
        this.featureStyleExtension.deleteStyleDefault(this.tableName, featureId);
    };
    /**
       * Delete the feature row style for the feature row geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteStyleForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteStyleForFeatureRow(featureRow);
    };
    /**
       * Delete the feature row style for the geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteStyleForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        this.featureStyleExtension.deleteStyleForFeatureRowAndGeometryType(featureRow, geometryType);
    };
    /**
       * Delete the feature row style for the geometry type
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteStyle = function (featureId, geometryType) {
        this.featureStyleExtension.deleteStyle(this.tableName, featureId, geometryType);
    };
    /**
       * Delete all icons
       */
    FeatureTableStyles.prototype.deleteIcons = function () {
        this.featureStyleExtension.deleteIcons(this.tableName);
    };
    /**
       * Delete feature row icons
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteIconsForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteIconsForFeatureRow(featureRow);
    };
    /**
       * Delete feature row icons
       *
       * @param {Number} featureId feature id
       */
    FeatureTableStyles.prototype.deleteIconsForFeatureId = function (featureId) {
        this.featureStyleExtension.deleteIconsForFeatureId(this.tableName, featureId);
    };
    /**
       * Delete the feature row default icon
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteIconDefaultForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteIconDefaultForFeatureRow(featureRow);
    };
    /**
       * Delete the feature row default icon
       *
       * @param {Number} featureId feature id
       */
    FeatureTableStyles.prototype.deleteIconDefault = function (featureId) {
        this.featureStyleExtension.deleteIconDefault(this.tableName, featureId);
    };
    /**
       * Delete the feature row icon for the feature row geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureTableStyles.prototype.deleteIconForFeatureRow = function (featureRow) {
        this.featureStyleExtension.deleteIconForFeatureRow(featureRow);
    };
    /**
       * Delete the feature row icon for the geometry type
       *
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteIconForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        this.featureStyleExtension.deleteIconForFeatureRowAndGeometryType(featureRow, geometryType);
    };
    /**
       * Delete the feature row icon for the geometry type
       *
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       */
    FeatureTableStyles.prototype.deleteIcon = function (featureId, geometryType) {
        this.featureStyleExtension.deleteIcon(this.tableName, featureId, geometryType);
    };
    /**
       * Get all the unique style row ids the table maps to
       *
       * @return {module:extension/style.StyleRow} style row ids
       */
    FeatureTableStyles.prototype.getAllTableStyleIds = function () {
        return this.featureStyleExtension.getAllTableStyleIds(this.tableName);
    };
    /**
       * Get all the unique icon row ids the table maps to
       *
       * @return {module:extension/style.IconRow} icon row ids
       */
    FeatureTableStyles.prototype.getAllTableIconIds = function () {
        return this.featureStyleExtension.getAllTableIconIds(this.tableName);
    };
    /**
       * Get all the unique style row ids the features map to
       *
       * @return {module:extension/style.StyleRow} style row ids
       */
    FeatureTableStyles.prototype.getAllStyleIds = function () {
        return this.featureStyleExtension.getAllStyleIds(this.tableName);
    };
    /**
       * Get all the unique icon row ids the features map to
       *
       * @return {module:extension/style.IconRow} icon row ids
       */
    FeatureTableStyles.prototype.getAllIconIds = function () {
        return this.featureStyleExtension.getAllIconIds(this.tableName);
    };
    return FeatureTableStyles;
}());
exports.FeatureTableStyles = FeatureTableStyles;

},{"./featureStyle":55,"./featureStyles":56,"./icons":62,"./styles":71}],58:[function(require,module,exports){
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
/**
 * @memberOf module:extension/style
 * @class IconCache
 */
/**
 * Constructor, created with cache size of {@link #IconCache.DEFAULT_CACHE_SIZE}
 * @constructor
 */
var IconCache = /** @class */ (function () {
    function IconCache(size) {
        if (size === void 0) { size = null; }
        this.cacheSize = size !== null ? size : IconCache.DEFAULT_CACHE_SIZE;
        this.iconCache = {};
        this.accessHistory = [];
    }
    /**
     * Get the cached image for the icon row or null if not cached
     * @param {module:extension/style.IconRow} iconRow icon row
     * @return {Image} icon image or null
     */
    IconCache.prototype.getIconForIconRow = function (iconRow) {
        return this.get(iconRow.getId());
    };
    /**
     * Get the cached image for the icon row id or null if not cached
     * @param {Number} iconRowId icon row id
     * @return {Image} icon image or null
     */
    IconCache.prototype.get = function (iconRowId) {
        var image = this.iconCache[iconRowId];
        if (image) {
            var index = this.accessHistory.indexOf(iconRowId);
            if (index > -1) {
                this.accessHistory.splice(index, 1);
            }
            this.accessHistory.push(iconRowId);
        }
        return image;
    };
    /**
     * Cache the icon image for the icon row
     * @param {module:extension/style.IconRow} iconRow icon row
     * @param {Image} image icon image
     * @return {Image} previous cached icon image or null
     */
    IconCache.prototype.putIconForIconRow = function (iconRow, image) {
        return this.put(iconRow.getId(), image);
    };
    /**
     * Cache the icon image for the icon row id
     * @param {Number} iconRowId icon row id
     * @param {Image} image icon image
     * @return {Image} previous cached icon image or null
     */
    IconCache.prototype.put = function (iconRowId, image) {
        var previous = this.iconCache[iconRowId];
        this.iconCache[iconRowId] = image;
        if (previous) {
            var index = this.accessHistory.indexOf(iconRowId);
            if (index > -1) {
                this.accessHistory.splice(index, 1);
            }
        }
        this.accessHistory.push(iconRowId);
        if (Object.keys(this.iconCache).length > this.cacheSize) {
            var iconId = this.accessHistory.shift();
            if (iconId) {
                delete this.iconCache[iconId];
            }
        }
        return previous;
    };
    /**
     * Remove the cached image for the icon row
     * @param {module:extension/style.IconRow} iconRow icon row
     * @return {Image} removed icon image or null
     */
    IconCache.prototype.removeIconForIconRow = function (iconRow) {
        return this.remove(iconRow.getId());
    };
    /**
     * Remove the cached image for the icon row id
     * @param {Number} iconRowId icon row id
     * @return {Image} removed icon image or null
     */
    IconCache.prototype.remove = function (iconRowId) {
        var removed = this.iconCache[iconRowId];
        delete this.iconCache[iconRowId];
        if (removed) {
            var index = this.accessHistory.indexOf(iconRowId);
            if (index > -1) {
                this.accessHistory.splice(index, 1);
            }
        }
        return removed;
    };
    /**
     * Clear the cache
     */
    IconCache.prototype.clear = function () {
        this.iconCache = {};
        this.accessHistory = [];
    };
    /**
     * Resize the cache
     * @param {Number} maxSize max size
     */
    IconCache.prototype.resize = function (maxSize) {
        this.cacheSize = maxSize;
        var keys = Object.keys(this.iconCache);
        if (keys.length > maxSize) {
            var numberToRemove = keys.length - maxSize;
            for (var i = 0; i < numberToRemove; i++) {
                delete this.iconCache[this.accessHistory.shift()];
            }
        }
    };
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createIcon = function (icon) {
        return this.createAndCacheIcon(icon, this);
    };
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {Number} scale scale factor
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createScaledIcon = function (icon, scale) {
        return this.createAndCacheScaledIcon(icon, scale, this);
    };
    /**
     * Create an icon image for the icon row without caching
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createIconNoCache = function (icon) {
        return this.createScaledIconNoCache(icon, 1.0);
    };
    /**
     * Create an icon image for the icon row without caching
     * @param icon icon row
     * @param scale scale factor
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createScaledIconNoCache = function (icon, scale) {
        return this.createAndCacheScaledIcon(icon, scale, null);
    };
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {module:extension/style.IconCache} iconCache icon cache
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createAndCacheIcon = function (icon, iconCache) {
        return this.createAndCacheScaledIcon(icon, 1.0, iconCache);
    };
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {Number} scale scale factor
     * @param {module:extension/style.IconCache} iconCache icon cache
     * @return {Promise<Image>} icon image
     */
    IconCache.prototype.createAndCacheScaledIcon = function (icon, scale, iconCache) {
        return __awaiter(this, void 0, void 0, function () {
            var iconImage, iconId, iconScaledWidth, iconScaledHeight;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        iconImage = null;
                        if (!(icon != null)) return [3 /*break*/, 3];
                        iconId = icon.getId();
                        if (iconCache !== null) {
                            iconImage = iconCache.get(iconId);
                        }
                        iconScaledWidth = Math.round(icon.getWidth() * scale);
                        iconScaledHeight = Math.round(icon.getHeight() * scale);
                        if (!(!iconImage || iconImage.width !== iconScaledWidth || iconImage.height !== iconScaledHeight)) return [3 /*break*/, 2];
                        return [4 /*yield*/, icon.getScaledDataImage(scale)];
                    case 1:
                        iconImage = _a.sent();
                        _a.label = 2;
                    case 2:
                        if (iconCache !== null) {
                            iconCache.putIconForIconRow(icon, iconImage);
                        }
                        _a.label = 3;
                    case 3: return [2 /*return*/, iconImage];
                }
            });
        });
    };
    return IconCache;
}());
IconCache.DEFAULT_CACHE_SIZE = 100;
module.exports = IconCache;

},{}],59:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class IconDao
 */
var mediaDao_1 = __importDefault(require("../relatedTables/mediaDao"));
var iconRow_1 = __importDefault(require("./iconRow"));
/**
 * Icon DAO for reading user icon data tables
 * @extends MediaDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage connection
 * @param  {string} table table name
 * @constructor
 */
var IconDao = /** @class */ (function (_super) {
    __extends(IconDao, _super);
    function IconDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.mediaTable = table;
        return _this;
    }
    /**
     * Create a new icon row
     * @return {module:extension/style.IconRow}
     */
    IconDao.prototype.newRow = function () {
        return new iconRow_1.default(this.table);
    };
    /**
     * Create a icon row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/style.IconRow}             icon row
     */
    IconDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new iconRow_1.default(this.table, columnTypes, values);
    };
    return IconDao;
}(mediaDao_1.default));
exports.default = IconDao;

},{"../relatedTables/mediaDao":41,"./iconRow":60}],60:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mediaRow_1 = __importDefault(require("../relatedTables/mediaRow"));
var imageUtils_1 = require("../../tiles/imageUtils");
/**
 * @memberOf module:extension/style
 * @class IconRow
 */
/**
 * Icon Row
 * @extends MediaRow
 * @param  {module:extension/style.IconTable} iconTable  icon table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
var IconRow = /** @class */ (function (_super) {
    __extends(IconRow, _super);
    function IconRow(iconTable, columnTypes, values) {
        var _this = _super.call(this, iconTable, columnTypes, values) || this;
        _this.iconTable = iconTable;
        return _this;
    }
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getNameColumn = function () {
        return this.iconTable.getNameColumn();
    };
    /**
     * Gets the name
     * @return {String}
     */
    IconRow.prototype.getName = function () {
        return this.getValueWithColumnName(this.getNameColumn().name);
    };
    /**
     * Sets the name for the row
     * @param {String} name name
     */
    IconRow.prototype.setName = function (name) {
        this.setValueWithColumnName(this.getNameColumn().name, name);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getDescriptionColumn = function () {
        return this.iconTable.getDescriptionColumn();
    };
    /**
     * Gets the description
     * @return {String}
     */
    IconRow.prototype.getDescription = function () {
        return this.getValueWithColumnName(this.getDescriptionColumn().name);
    };
    /**
     * Sets the description for the row
     * @param {string} description description
     */
    IconRow.prototype.setDescription = function (description) {
        this.setValueWithColumnName(this.getDescriptionColumn().name, description);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getWidthColumn = function () {
        return this.iconTable.getWidthColumn();
    };
    /**
     * Gets the width
     * @return {Number}
     */
    IconRow.prototype.getWidth = function () {
        return this.getValueWithColumnName(this.getWidthColumn().name);
    };
    /**
     * Sets the width for the row
     * @param {Number} width width
     */
    IconRow.prototype.setWidth = function (width) {
        this.setValueWithColumnName(this.getWidthColumn().name, width);
    };
    /**
     * Get the width or derived width from the icon data and scaled as needed
     * for the height
     *
     * @return {Number}  derived width
     */
    IconRow.prototype.getDerivedWidth = function () {
        var width = this.getWidth();
        if (width === undefined || width === null) {
            width = this.getDerivedDimensions()[0];
        }
        return width;
    };
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getHeightColumn = function () {
        return this.iconTable.getHeightColumn();
    };
    /**
     * Gets the height
     * @return {Number}
     */
    IconRow.prototype.getHeight = function () {
        return this.getValueWithColumnName(this.getHeightColumn().name);
    };
    /**
     * Sets the height for the row
     * @param {Number} height height
     */
    IconRow.prototype.setHeight = function (height) {
        this.setValueWithColumnName(this.getHeightColumn().name, height);
    };
    /**
     * Get the height or derived height from the icon data and scaled as needed
     * for the width
     *
     * @return {Number} derived height
     */
    IconRow.prototype.getDerivedHeight = function () {
        var height = this.getHeight();
        if (height === undefined || height === null) {
            height = this.getDerivedDimensions()[1];
        }
        return height;
    };
    /**
     * Get the derived width and height from the values and icon data, scaled as needed
     * @return {Number[]} derived dimensions array with two values, width at index 0, height at index 1
     */
    IconRow.prototype.getDerivedDimensions = function () {
        var width = this.getWidth();
        var height = this.getHeight();
        if (width === undefined || width === null || height === undefined || height === null) {
            var dataWidth;
            var dataHeight;
            var imageSize = imageUtils_1.ImageUtils.getImageSize(this.getData());
            dataWidth = imageSize.width;
            dataHeight = imageSize.height;
            if (width === undefined || width === null) {
                width = dataWidth;
                if (height !== undefined && height !== null) {
                    width *= (height / dataHeight);
                }
            }
            if (height === undefined || height === null) {
                height = dataHeight;
                if (width !== undefined && width !== null) {
                    height *= (width / dataWidth);
                }
            }
        }
        return [width, height];
    };
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getAnchorUColumn = function () {
        return this.iconTable.getAnchorUColumn();
    };
    /**
     * Gets the anchor_u
     * @return {Number}
     */
    IconRow.prototype.getAnchorU = function () {
        return this.getValueWithColumnName(this.getAnchorUColumn().name);
    };
    /**
     * Sets the anchor_u for the row
     * @param {Number} anchor_u anchor_u
     */
    IconRow.prototype.setAnchorU = function (anchor_u) {
        this.validateAnchor(anchor_u);
        this.setValueWithColumnName(this.getAnchorUColumn().name, anchor_u);
    };
    /**
     * Get the anchor u value or the default value of 0.5
     * @return {Number} anchor u value
     */
    IconRow.prototype.getAnchorUOrDefault = function () {
        var anchorU = this.getAnchorU();
        if (anchorU == null) {
            anchorU = 0.5;
        }
        return anchorU;
    };
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getAnchorVColumn = function () {
        return this.iconTable.getAnchorVColumn();
    };
    /**
     * Gets the anchor_v
     * @return {Number}
     */
    IconRow.prototype.getAnchorV = function () {
        return this.getValueWithColumnName(this.getAnchorVColumn().name);
    };
    /**
     * Sets the anchor_v for the row
     * @param {Number} anchor_v anchor_v
     */
    IconRow.prototype.setAnchorV = function (anchor_v) {
        this.validateAnchor(anchor_v);
        this.setValueWithColumnName(this.getAnchorVColumn().name, anchor_v);
    };
    /**
     * Get the anchor v value or the default value of 1.0
     * @return {Number} anchor v value
     */
    IconRow.prototype.getAnchorVOrDefault = function () {
        var anchorV = this.getAnchorV();
        if (anchorV == null) {
            anchorV = 1.0;
        }
        return anchorV;
    };
    /**
     * Validate the anchor value
     * @param {Number} anchor anchor
     */
    IconRow.prototype.validateAnchor = function (anchor) {
        if (anchor != null && (anchor < 0.0 || anchor > 1.0)) {
            throw new Error("Anchor must be set inclusively between 0.0 and 1.0, invalid value: " + anchor);
        }
    };
    return IconRow;
}(mediaRow_1.default));
exports.default = IconRow;

},{"../../tiles/imageUtils":104,"../relatedTables/mediaRow":42}],61:[function(require,module,exports){
"use strict";
/**
 * @memberOf module:extension/style
 * @class IconTable
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mediaTable_1 = __importDefault(require("../relatedTables/mediaTable"));
var userCustomColumn_1 = __importDefault(require("../../user/custom/userCustomColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Icon Requirements Class Media Table
 * @class
 * @extends {MediaTable}
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
var IconTable = /** @class */ (function (_super) {
    __extends(IconTable, _super);
    function IconTable(tableName, columns, requiredColumns) {
        var _this = _super.call(this, tableName, columns, requiredColumns) || this;
        _this.TABLE_TYPE = 'media';
        return _this;
    }
    /**
     * Get the name column index
     * @return int
     */
    IconTable.prototype.getNameColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_NAME);
    };
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getNameColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_NAME);
    };
    /**
     * Get the description column index
     * @return int
     */
    IconTable.prototype.getDescriptionColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getDescriptionColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the width column index
     * @return int
     */
    IconTable.prototype.getWidthColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_WIDTH);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getWidthColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_WIDTH);
    };
    /**
     * Get the height column index
     * @return int
     */
    IconTable.prototype.getHeightColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_HEIGHT);
    };
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getHeightColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_HEIGHT);
    };
    /**
     * Get the anchor_u column index
     * @return int
     */
    IconTable.prototype.getAnchorUColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_ANCHOR_U);
    };
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getAnchorUColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_U);
    };
    /**
     * Get the anchor_v column index
     * @return int
     */
    IconTable.prototype.getAnchorVColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_ANCHOR_V);
    };
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getAnchorVColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_V);
    };
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/relatedTables~MediaTable}
     */
    IconTable.create = function () {
        return new IconTable(IconTable.TABLE_NAME, IconTable.createColumns(), IconTable.requiredColumns());
    };
    IconTable.createRequiredColumns = function () {
        return mediaTable_1.default.createRequiredColumns();
    };
    /**
     * Get the required columns
     * @return {string[]}
     */
    IconTable.requiredColumns = function () {
        return mediaTable_1.default.requiredColumns();
    };
    /**
     * Create the columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    IconTable.createColumns = function () {
        var columns = IconTable.createRequiredColumns();
        var index = columns.length;
        columns.push(userCustomColumn_1.default.createColumn(index++, IconTable.COLUMN_NAME, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, IconTable.COLUMN_DESCRIPTION, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, IconTable.COLUMN_WIDTH, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, IconTable.COLUMN_HEIGHT, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, IconTable.COLUMN_ANCHOR_U, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index, IconTable.COLUMN_ANCHOR_V, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        return columns;
    };
    IconTable.TABLE_NAME = 'nga_icon';
    IconTable.COLUMN_NAME = 'name';
    IconTable.COLUMN_DESCRIPTION = 'description';
    IconTable.COLUMN_WIDTH = 'width';
    IconTable.COLUMN_HEIGHT = 'height';
    IconTable.COLUMN_ANCHOR_U = 'anchor_u';
    IconTable.COLUMN_ANCHOR_V = 'anchor_v';
    return IconTable;
}(mediaTable_1.default));
exports.default = IconTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":117,"../relatedTables/mediaTable":43}],62:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class Icons
 */
/**
 * Icons constructor
 * @constructor
 */
var Icons = /** @class */ (function () {
    function Icons() {
        this.defaultIcon = null;
        this.icons = {};
    }
    Icons.prototype.setDefault = function (iconRow) {
        this.defaultIcon = iconRow;
    };
    Icons.prototype.getDefault = function () {
        return this.defaultIcon;
    };
    Icons.prototype.setIcon = function (iconRow, geometryType) {
        if (geometryType != null) {
            if (iconRow != null) {
                this.icons[geometryType] = iconRow;
            }
            else {
                delete this.icons[geometryType];
            }
        }
        else {
            this.setDefault(iconRow);
        }
    };
    Icons.prototype.getIcon = function (geometryType) {
        var iconRow = null;
        if (geometryType != null) {
            iconRow = this.icons[geometryType];
        }
        if (iconRow === null || geometryType === null) {
            iconRow = this.getDefault();
        }
        return iconRow;
    };
    Icons.prototype.isEmpty = function () {
        return Object.keys(this.icons).length === 0 && this.defaultIcon === null;
    };
    return Icons;
}());
module.exports = Icons;

},{}],63:[function(require,module,exports){
"use strict";
/**
 * @module extension/style
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var contentsIdDao_1 = __importDefault(require("../contents/contentsIdDao"));
var iconTable_1 = __importDefault(require("./iconTable"));
var iconDao_1 = __importDefault(require("./iconDao"));
var styleTable_1 = __importDefault(require("./styleTable"));
var styleDao_1 = __importDefault(require("./styleDao"));
var styleMappingTable_1 = __importDefault(require("./styleMappingTable"));
var styleMappingDao_1 = __importDefault(require("./styleMappingDao"));
var userMappingTable_1 = __importDefault(require("../relatedTables/userMappingTable"));
var styleTableReader_1 = __importDefault(require("./styleTableReader"));
var userTableReader_1 = __importDefault(require("../../user/userTableReader"));
var featureStyles_1 = __importDefault(require("./featureStyles"));
var featureStyle_1 = __importDefault(require("./featureStyle"));
var styles_1 = __importDefault(require("./styles"));
var icons_1 = __importDefault(require("./icons"));
/**
 * Style extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @extends BaseExtension
 * @constructor
 */
var FeatureStyleExtension = /** @class */ (function (_super) {
    __extends(FeatureStyleExtension, _super);
    function FeatureStyleExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.relatedTablesExtension = geoPackage.getRelatedTablesExtension();
        _this.contentsIdExtension = geoPackage.getContentsIdExtension();
        return _this;
    }
    /**
       * Get or create the metadata extension
       *  @param {module:features/user/featureTable|String} featureTable, defaults to null
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.getOrCreateExtension = function (featureTable) {
        return this.getOrCreate(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null, FeatureStyleExtension.EXTENSION_DEFINITION, extension_1.default.READ_WRITE);
    };
    /**
       * Determine if the GeoPackage has the extension or has the extension for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {Boolean}
       */
    FeatureStyleExtension.prototype.has = function (featureTable) {
        return this.hasExtension(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null);
    };
    /**
       * Gets featureTables
       * @returns {String[]}
       */
    FeatureStyleExtension.prototype.getTables = function () {
        var tables = [];
        if (this.extensionsDao.isTableExists()) {
            var extensions = this.extensionsDao.queryAllByExtension(FeatureStyleExtension.EXTENSION_NAME);
            for (var i = 0; i < extensions.length; i++) {
                tables.push(extensions[i].table_name);
            }
        }
        return tables;
    };
    /**
       * Get the related tables extension
       * @returns {module:extension/relatedTables~RelatedTablesExtension}
       */
    FeatureStyleExtension.prototype.getRelatedTables = function () {
        return this.relatedTablesExtension;
    };
    /**
       * Get the contentsId extension
       * @returns {module:extension/contents~ContentsIdExtension}
       */
    FeatureStyleExtension.prototype.getContentsId = function () {
        return this.contentsIdExtension;
    };
    /**
       * Create style, icon, table style, and table icon relationships for the
       * feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.createRelationships = function (featureTable) {
        var promises = [];
        promises.push(this.createStyleRelationship(featureTable));
        promises.push(this.createTableStyleRelationship(featureTable));
        promises.push(this.createIconRelationship(featureTable));
        promises.push(this.createTableIconRelationship(featureTable));
        return Promise.all(promises);
    };
    /**
       * Check if feature table has a style, icon, table style, or table icon
       * relationships
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {boolean}
       */
    FeatureStyleExtension.prototype.hasRelationship = function (featureTable) {
        return this.hasStyleRelationship(featureTable)
            || this.hasTableStyleRelationship(featureTable)
            || this.hasIconRelationship(featureTable)
            || this.hasTableIconRelationship(featureTable);
    };
    /**
       * Create a style relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.createStyleRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), styleTable_1.default.TABLE_NAME);
    };
    /**
       * Determine if a style relationship exists for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {boolean}
       */
    FeatureStyleExtension.prototype.hasStyleRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), styleTable_1.default.TABLE_NAME);
    };
    /**
       * Create a feature table style relationship
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.createTableStyleRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), this.getFeatureTableName(featureTable), contentsIdDao_1.default.TABLE_NAME, styleTable_1.default.TABLE_NAME);
    };
    /**
       * Determine if a feature table style relationship exists
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {boolean} true if relationship exists
       */
    FeatureStyleExtension.prototype.hasTableStyleRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), contentsIdDao_1.default.TABLE_NAME, styleTable_1.default.TABLE_NAME);
    };
    /**
       * Create an icon relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.createIconRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), iconTable_1.default.TABLE_NAME);
    };
    /**
       * Determine if an icon relationship exists for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {boolean} true if relationship exists
       */
    FeatureStyleExtension.prototype.hasIconRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), iconTable_1.default.TABLE_NAME);
    };
    /**
       * Create a feature table icon relationship
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.createTableIconRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), this.getFeatureTableName(featureTable), contentsIdDao_1.default.TABLE_NAME, iconTable_1.default.TABLE_NAME);
    };
    /**
       * Determine if a feature table icon relationship exists
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @returns {Boolean} true if relationship exists
       */
    FeatureStyleExtension.prototype.hasTableIconRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), contentsIdDao_1.default.TABLE_NAME, iconTable_1.default.TABLE_NAME);
    };
    /**
       * Get the mapping table name
       * @param tablePrefix table name prefix
       * @param {module:features/user/featureTable|String} featureTable feature table name
       * @returns {String} mapping table name
       */
    FeatureStyleExtension.prototype.getMappingTableName = function (tablePrefix, featureTable) {
        return tablePrefix + this.getFeatureTableName(featureTable);
    };
    /**
       * Check if the style extension relationship between a feature table and
       * style extension table exists
       * @param {String} mappingTableName mapping table name
       * @param {String} baseTable base table name
       * @param {String} relatedTable related table name
       * @returns {boolean} true if relationship exists
       */
    FeatureStyleExtension.prototype._hasStyleRelationship = function (mappingTableName, baseTable, relatedTable) {
        return this.relatedTablesExtension.hasRelations(baseTable, relatedTable, mappingTableName);
    };
    /**
       * Create a style extension relationship between a feature table and style
       * extension table
       * @param {String} mappingTableName mapping table name
       * @param {String} featureTable feature table
       * @param {String} baseTable base table name
       * @param {String} relatedTable related table name
       * @return {Promise}
       * @private
       */
    FeatureStyleExtension.prototype._createStyleRelationship = function (mappingTableName, featureTable, baseTable, relatedTable) {
        if (!this._hasStyleRelationship(mappingTableName, baseTable, relatedTable)) {
            // Create the extension
            return this.getOrCreateExtension(featureTable).then(function () {
                if (baseTable === contentsIdDao_1.default.TABLE_NAME && !this.contentsIdExtension.has()) {
                    return this.contentsIdExtension.getOrCreateExtension().then(function () {
                        return this._handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable);
                    }.bind(this));
                }
                else {
                    return this._handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable);
                }
            }.bind(this));
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Private function to aid in creation of the a style extension relationship between a feature table and style extension table
       * @param {String} mappingTableName
       * @param {String} baseTable
       * @param {String} relatedTable
       * @return {Promise}
       * @private
       */
    FeatureStyleExtension.prototype._handleCreateStyleRelationship = function (mappingTableName, baseTable, relatedTable) {
        if (relatedTable === styleTable_1.default.TABLE_NAME) {
            return this.relatedTablesExtension.addAttributesRelationship(this.geoPackage.getRelatedTablesExtension().getRelationshipBuilder()
                .setBaseTableName(baseTable)
                .setUserMappingTable(styleMappingTable_1.default.create(mappingTableName))
                .setRelatedTable(styleTable_1.default.create()));
        }
        else {
            return this.relatedTablesExtension.addMediaRelationship(this.geoPackage.getRelatedTablesExtension().getRelationshipBuilder()
                .setBaseTableName(baseTable)
                .setUserMappingTable(styleMappingTable_1.default.create(mappingTableName))
                .setRelatedTable(iconTable_1.default.create()));
        }
    };
    /**
       * Delete the style and icon table and row relationships for all feature
       * tables
       */
    FeatureStyleExtension.prototype.deleteAllRelationships = function () {
        var tables = this.getTables();
        for (var i = 0; i < tables.length; i++) {
            this.deleteRelationships(tables[i]);
        }
    };
    /**
       * Delete the style and icon table and row relationships for the feature
       * table
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteRelationships = function (featureTable) {
        this.deleteStyleRelationship(featureTable);
        this.deleteTableStyleRelationship(featureTable);
        this.deleteIconRelationship(featureTable);
        this.deleteTableIconRelationship(featureTable);
    };
    /**
       * Delete a style relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteStyleRelationship = function (featureTable) {
        this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), featureTable);
    };
    /**
       * Delete a table style relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableStyleRelationship = function (featureTable) {
        this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), featureTable);
    };
    /**
       * Delete a icon relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteIconRelationship = function (featureTable) {
        this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), featureTable);
    };
    /**
       * Delete a table icon relationship for the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableIconRelationship = function (featureTable) {
        this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), featureTable);
    };
    /**
       * Delete a style extension feature table relationship and the mapping table
       * @param {String} mappingTableName
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @private
       */
    FeatureStyleExtension.prototype._deleteStyleRelationship = function (mappingTableName, featureTable) {
        var relationships = this.geoPackage.getExtendedRelationDao().queryByMappingTableName(mappingTableName);
        for (var i = 0; i < relationships.length; i++) {
            this.relatedTablesExtension.removeRelationship(relationships[i]);
        }
        if (!this.hasRelationship(featureTable)) {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtensionAndTableName(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable));
            }
        }
    };
    /**
       * Get a Style Mapping DAO
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleMappingDao} style mapping DAO
       */
    FeatureStyleExtension.prototype.getStyleMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable);
    };
    /**
       * Get a Table Style Mapping DAO
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleMappingDao} table style mapping DAO
       */
    FeatureStyleExtension.prototype.getTableStyleMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable);
    };
    /**
       * Get a Icon Mapping DAO
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleMappingDao} icon mapping DAO
       */
    FeatureStyleExtension.prototype.getIconMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable);
    };
    /**
       * Get a Table Icon Mapping DAO
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleMappingDao} table icon mapping DAO
       */
    FeatureStyleExtension.prototype.getTableIconMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable);
    };
    /**
       * Get a Style Mapping DAO from a table name
       * @param {String} tablePrefix table name prefix
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleMappingDao} style mapping dao
       * @private
       */
    FeatureStyleExtension.prototype._getMappingDao = function (tablePrefix, featureTable) {
        var featureTableName = this.getFeatureTableName(featureTable);
        var tableName = tablePrefix + featureTableName;
        var dao = null;
        if (this.geoPackage.isTable(tableName)) {
            dao = new styleMappingDao_1.default(this.relatedTablesExtension.getUserDao(tableName, userMappingTable_1.default.requiredColumns()), this.geoPackage);
        }
        return dao;
    };
    /**
       * Get a style DAO
       * @return {module:extension/style.StyleDao} style DAO
       */
    FeatureStyleExtension.prototype.getStyleDao = function () {
        var styleDao = null;
        if (this.geoPackage.isTable(styleTable_1.default.TABLE_NAME)) {
            var dao = this.geoPackage.getContentsDao();
            var contents = dao.queryForId(styleTable_1.default.TABLE_NAME);
            if (contents) {
                var reader = new styleTableReader_1.default(contents.table_name);
                var table = reader.readTable(this.geoPackage.connection);
                this.relatedTablesExtension.setContents(table);
                styleDao = new styleDao_1.default(this.geoPackage, table);
            }
        }
        return styleDao;
    };
    /**
       * Get a icon DAO
       * @return {module:extension/style.IconDao}
       */
    FeatureStyleExtension.prototype.getIconDao = function () {
        var iconDao = null;
        if (this.geoPackage.isTable(iconTable_1.default.TABLE_NAME)) {
            var reader = new userTableReader_1.default(iconTable_1.default.TABLE_NAME, iconTable_1.default.requiredColumns());
            var userTable = reader.readTable(this.geoPackage.getDatabase());
            var table = new iconTable_1.default(userTable.table_name, userTable.columns, iconTable_1.default.requiredColumns());
            table.setContents(this.geoPackage.getContentsDao().queryForId(iconTable_1.default.TABLE_NAME));
            iconDao = new iconDao_1.default(this.geoPackage, table);
        }
        return iconDao;
    };
    /**
       * Get the feature table default feature styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.FeatureStyles} table feature styles or null
       */
    FeatureStyleExtension.prototype.getTableFeatureStyles = function (featureTable) {
        var featureStyles = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            var styles = this.getTableStyles(featureTable);
            var icons = this.getTableIcons(featureTable);
            if (styles !== null || icons !== null) {
                featureStyles = new featureStyles_1.default(styles, icons);
            }
        }
        return featureStyles;
    };
    /**
       * Get the default style of the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureStyleExtension.prototype.getTableStyleDefault = function (featureTable) {
        return this.getTableStyle(featureTable, null);
    };
    /**
       * Get the style of the feature table and geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       * @return {module:extension/style.StyleRow} style row
       */
    FeatureStyleExtension.prototype.getTableStyle = function (featureTable, geometryType) {
        var style = null;
        var styles = this.getTableStyles(featureTable);
        if (styles !== null) {
            if (geometryType === null) {
                style = styles.getDefault();
            }
            else {
                style = styles.getStyle(geometryType);
            }
        }
        return style;
    };
    /**
       * Get the feature table default styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.Styles} table styles or null
       */
    FeatureStyleExtension.prototype.getTableStyles = function (featureTable) {
        var styles = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            styles = this.getStyles(id, this.getTableStyleMappingDao(featureTable));
        }
        return styles;
    };
    /**
       * Get the default icon of the feature table
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureStyleExtension.prototype.getTableIconDefault = function (featureTable) {
        return this.getTableIcon(featureTable, null);
    };
    /**
       * Get the icon of the feature table and geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       * @return {module:extension/style.IconRow} icon row
       */
    FeatureStyleExtension.prototype.getTableIcon = function (featureTable, geometryType) {
        var icon = null;
        var icons = this.getTableIcons(featureTable);
        if (icons !== null) {
            if (geometryType === null) {
                icon = icons.getDefault();
            }
            else {
                icon = icons.getIcon(geometryType);
            }
        }
        return icon;
    };
    /**
       * Get the feature table default icons
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {module:extension/style.Icons} table icons or null
       */
    FeatureStyleExtension.prototype.getTableIcons = function (featureTable) {
        var icons = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            icons = this.getIcons(id, this.getTableIconMappingDao(featureTable));
        }
        return icons;
    };
    /**
       * Gets Icons for featureId and mappingDao
       * @param {Number} featureId
       * @param mappingDao
       * @returns {module:extension/style.Icons}
       * @private
       */
    FeatureStyleExtension.prototype.getIcons = function (featureId, mappingDao) {
        var icons = new icons_1.default();
        if (mappingDao !== null) {
            var iconDao = this.getIconDao();
            var styleMappingRows = mappingDao.queryByBaseId(featureId);
            for (var i = 0; i < styleMappingRows.length; i++) {
                var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
                var iconRow = iconDao.queryForId(styleMappingRow.getRelatedId());
                if (styleMappingRow.getGeometryTypeName() === null) {
                    icons.setDefault(iconRow);
                }
                else {
                    icons.setIcon(iconRow, styleMappingRow.getGeometryTypeName());
                }
            }
        }
        if (icons.isEmpty()) {
            icons = null;
        }
        return icons;
    };
    /**
       * Gets Styles for featureId and mappingDao
       * @param {Number} featureId
       * @param {module:extension/style.StyleMappingDao} mappingDao
       * @returns {module:extension/style.Styles}
       */
    FeatureStyleExtension.prototype.getStyles = function (featureId, mappingDao) {
        var styles = new styles_1.default();
        if (mappingDao !== null) {
            var styleDao = this.getStyleDao();
            var styleMappingRows = mappingDao.queryByBaseId(featureId);
            for (var i = 0; i < styleMappingRows.length; i++) {
                var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
                var styleRow = styleDao.queryForId(styleMappingRow.getRelatedId());
                if (styleMappingRow.getGeometryTypeName() === null) {
                    styles.setDefault(styleRow);
                }
                else {
                    styles.setStyle(styleRow, styleMappingRow.getGeometryTypeName());
                }
            }
        }
        if (styles.isEmpty()) {
            styles = null;
        }
        return styles;
    };
    /**
       * Get the feature styles for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyles} feature styles or null
       */
    FeatureStyleExtension.prototype.getFeatureStylesForFeatureRow = function (featureRow) {
        return this.getFeatureStyles(featureRow.featureTable, featureRow.getId());
    };
    /**
       * Get the feature styles for the feature row
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @return {module:extension/style.FeatureStyles} feature styles or null
       */
    FeatureStyleExtension.prototype.getFeatureStyles = function (featureTable, featureId) {
        var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
        var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
        var featureStyles = null;
        if (styles !== null || icons !== null) {
            featureStyles = new featureStyles_1.default(styles, icons);
        }
        return featureStyles;
    };
    /**
       * Get the styles for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.Styles} styles or null
       */
    FeatureStyleExtension.prototype.getStylesForFeatureRow = function (featureRow) {
        return this.getStyles(featureRow.getId(), this.getStyleMappingDao(featureRow.featureTable.table_name));
    };
    /**
       * Get the styles for the feature id
       * @param {String} tableName table name
       * @param {Number} featureId feature id
       * @return {module:extension/style.Styles} styles or null
       */
    FeatureStyleExtension.prototype.getStylesForFeatureId = function (tableName, featureId) {
        return this.getStyles(featureId, this.getStyleMappingDao(tableName));
    };
    /**
       * Get the icons for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.Icons} icons or null
       */
    FeatureStyleExtension.prototype.getIconsForFeatureRow = function (featureRow) {
        return this.getIcons(featureRow.getId(), this.getIconMappingDao(featureRow.featureTable.table_name));
    };
    /**
       * Get the icons for the feature id
       * @param {String} tableName table name
       * @param {Number} featureId feature id
       * @return {module:extension/style.Icons} icons or null
       */
    FeatureStyleExtension.prototype.getIconsForFeatureId = function (tableName, featureId) {
        return this.getIcons(featureId, this.getIconMappingDao(tableName));
    };
    /**
       * Get the feature style (style and icon) of the feature row, searching in
       * order: feature geometry type style or icon, feature default style or
       * icon, table geometry type style or icon, table default style or icon
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureStyleExtension.prototype.getFeatureStyleForFeatureRow = function (featureRow) {
        return new featureStyle_1.default(this.getStyle(featureRow.featureTable.table_name, featureRow.getId(), featureRow.getGeometryType(), true), this.getIcon(featureRow.featureTable.table_name, featureRow.getId(), featureRow.getGeometryType(), true));
    };
    /**
       * Get the feature style (style and icon) of the feature, searching in
       * order: feature geometry type style or icon, feature default style or
       * icon, table geometry type style or icon, table default style or icon
       * @param {module:features/user/featureRow} featureRow feature row
       * @return {module:extension/style.FeatureStyle} feature style
       */
    FeatureStyleExtension.prototype.getFeatureStyleDefault = function (featureRow) {
        return new featureStyle_1.default(this.getStyle(featureRow.featureTable.table_name, featureRow.getId(), null, true), this.getIcon(featureRow.featureTable.table_name, featureRow.getId(), null, true));
    };
    /**
       * Get the icon of the feature, searching in order: feature geometry type
       * icon, feature default icon, when tableIcon enabled continue searching:
       * table geometry type icon, table default icon
       * @param {module:features/user/featureTable|String} featureTable
       * @param {Number} featureId
       * @param {String} geometryType
       * @param {Boolean} tableIcon
       * @returns {module:extension/style.IconRow}
       * @private
       */
    FeatureStyleExtension.prototype.getIcon = function (featureTable, featureId, geometryType, tableIcon) {
        var iconRow = null;
        var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
        if (icons !== null) {
            iconRow = icons.getIcon(geometryType);
        }
        if (iconRow === null && tableIcon) {
            iconRow = this.getTableIcon(featureTable, geometryType);
        }
        return iconRow;
    };
    /**
       * Get the style of the feature, searching in order: feature geometry type
       * style, feature default style, when tableStyle enabled continue searching:
       * table geometry type style, table default style
       * @param {module:features/user/featureTable|String} featureTable
       * @param {Number} featureId
       * @param {String} geometryType
       * @param {Boolean} tableStyle
       * @returns {module:extension/style.StyleRow}
       * @private
       */
    FeatureStyleExtension.prototype.getStyle = function (featureTable, featureId, geometryType, tableStyle) {
        var styleRow = null;
        var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
        if (styles !== null) {
            styleRow = styles.getStyle(geometryType);
        }
        if (styleRow === null && tableStyle) {
            styleRow = this.getTableStyle(featureTable, geometryType);
        }
        return styleRow;
    };
    /**
       * Set the feature table default feature styles
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {module:extension/style.FeatureStyles} featureStyles feature styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableFeatureStyles = function (featureTable, featureStyles) {
        if (featureStyles !== null) {
            var promises = [];
            promises.push(this.setTableStyles(featureTable, featureStyles.getStyles()));
            promises.push(this.setTableIcons(featureTable, featureStyles.getIcons()));
            return Promise.all(promises);
        }
        else {
            this.deleteTableFeatureStyles(featureTable);
            return Promise.resolve();
        }
    };
    /**
       * Set the feature table default styles
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {module:extension/style.Styles} styles default styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableStyles = function (featureTable, styles) {
        // var tableName = featureTable.table_name ? featureTable.table_name : featureTable;
        this.deleteTableStyles(featureTable);
        if (styles !== null) {
            var promises = [];
            if (styles.getDefault() !== null) {
                promises.push(this.setTableStyleDefault(featureTable, styles.getDefault()));
            }
            var keys = Object.keys(styles.styles);
            for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                var value = styles.styles[key];
                promises.push(this.setTableStyle(featureTable, key, value));
            }
            return Promise.all(promises);
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the feature table style default
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableStyleDefault = function (featureTable, style) {
        return this.setTableStyle(featureTable, null, style);
    };
    /**
       * Set the feature table style for the geometry type
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableStyle = function (featureTable, geometryType, style) {
        this.deleteTableStyle(featureTable, geometryType);
        if (style !== null) {
            return this.createTableStyleRelationship(featureTable).then(function () {
                var featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
                var styleId = this.getOrInsertStyle(style);
                var mappingDao = this.getTableStyleMappingDao(featureTable);
                this.insertStyleMapping(mappingDao, featureContentsId.id, styleId, geometryType);
            }.bind(this));
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the feature table default icons
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {module:extension/style.Icons} icons default icons
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableIcons = function (featureTable, icons) {
        this.deleteTableIcons(featureTable);
        if (icons !== null) {
            var promises = [];
            if (icons.getDefault() !== null) {
                promises.push(this.setTableIconDefault(featureTable, icons.getDefault()));
            }
            var keys = Object.keys(icons.icons);
            for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                var value = icons.icons[key];
                promises.push(this.setTableIcon(featureTable, key, value));
            }
            return Promise.all(promises);
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the feature table icon default
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableIconDefault = function (featureTable, icon) {
        return this.setTableIcon(featureTable, null, icon);
    };
    /**
       * Set the feature table icon for the geometry type
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setTableIcon = function (featureTable, geometryType, icon) {
        this.deleteTableIcon(featureTable, geometryType);
        if (icon !== null) {
            return this.createTableIconRelationship(featureTable).then(function () {
                var featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
                var iconId = this.getOrInsertIcon(icon);
                var mappingDao = this.getTableIconMappingDao(featureTable);
                this.insertStyleMapping(mappingDao, featureContentsId.id, iconId, geometryType);
            }.bind(this));
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the feature styles for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyles} featureStyles feature styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStylesForFeatureRow = function (featureRow, featureStyles) {
        return this.setFeatureStyles(featureRow.featureTable.table_name, featureRow.getId(), featureStyles);
    };
    /**
       * Set the feature styles for the feature table and feature id
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.FeatureStyles} featureStyles feature styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyles = function (featureTable, featureId, featureStyles) {
        if (featureStyles !== null) {
            var promises = [];
            promises.push(this.setStyles(featureTable, featureId, featureStyles.getStyles()));
            promises.push(this.setIcons(featureTable, featureId, featureStyles.getIcons()));
            return Promise.all(promises);
        }
        else {
            this.deleteStyles(featureTable); //, featureId);
            this.deleteIcons(featureTable); //, featureId);
            return Promise.resolve();
        }
    };
    /**
       * Set the feature style (style and icon) of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyleForFeatureRow = function (featureRow, featureStyle) {
        return this.setFeatureStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), featureStyle);
    };
    /**
       * Set the feature style (style and icon) of the feature row for the
       * specified geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, featureStyle) {
        return this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.getId(), geometryType, featureStyle);
    };
    /**
       * Set the feature style default (style and icon) of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyleDefaultForFeatureRow = function (featureRow, featureStyle) {
        return this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.getId(), null, featureStyle);
    };
    /**
       * Set the feature style (style and icon) of the feature
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyle = function (featureTable, featureId, geometryType, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            var promises;
            return __generator(this, function (_a) {
                if (featureStyle !== null) {
                    promises = [];
                    promises.push(this.setStyle(featureTable, featureId, geometryType, featureStyle.getStyle()));
                    promises.push(this.setIcon(featureTable, featureId, geometryType, featureStyle.getIcon()));
                    return [2 /*return*/, Promise.all(promises)];
                }
                else {
                    this.deleteStyle(featureTable, featureId, geometryType);
                    this.deleteIcon(featureTable, featureId, geometryType);
                    return [2 /*return*/, Promise.resolve()];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
       * Set the feature style (style and icon) of the feature
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.FeatureStyle} featureStyle feature style
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setFeatureStyleDefault = function (featureTable, featureId, featureStyle) {
        return this.setFeatureStyle(featureTable, featureId, null, featureStyle);
    };
    /**
       * Set the styles for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.Styles} styles styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStylesForFeatureRow = function (featureRow, styles) {
        return this.setStyles(featureRow.featureTable.table_name, featureRow.getId(), styles);
    };
    /**
       * Set the styles for the feature table and feature id
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.Styles} styles styles
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyles = function (featureTable, featureId, styles) {
        this.deleteStylesForFeatureId(featureTable, featureId);
        if (styles !== null) {
            var promises = [];
            if (styles.getDefault() !== null) {
                promises.push(this.setStyleDefault(featureTable, featureId, styles.getDefault()));
            }
            var keys = Object.keys(styles.styles);
            for (var i = 0; i < keys.length; i++) {
                promises.push(this.setStyle(featureTable, featureId, keys[i], styles.styles[keys[i]]));
            }
            return Promise.all(promises);
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the style of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyleForFeatureRow = function (featureRow, style) {
        return this.setStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), style);
    };
    /**
       * Set the style of the feature row for the specified geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, style) {
        return this.setStyle(featureRow.featureTable.table_name, featureRow.getId(), geometryType, style);
    };
    /**
       * Set the default style of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyleDefaultForFeatureRow = function (featureRow, style) {
        return this.setStyle(featureRow.featureTable.table_name, featureRow.getId(), null, style);
    };
    /**
       * Set the style of the feature
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyle = function (featureTable, featureId, geometryType, style) {
        this.deleteStyle(featureTable, featureId, geometryType);
        if (style !== null) {
            return this.createStyleRelationship(featureTable).then(function () {
                var styleId = this.getOrInsertStyle(style);
                var mappingDao = this.getStyleMappingDao(featureTable);
                this.insertStyleMapping(mappingDao, featureId, styleId, geometryType);
            }.bind(this));
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the default style of the feature
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.StyleRow} style style row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setStyleDefault = function (featureTable, featureId, style) {
        return this.setStyle(featureTable, featureId, null, style);
    };
    /**
       * Set the icons for the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.Icons} icons icons
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIconsForFeatureRow = function (featureRow, icons) {
        return this.setIcons(featureRow.featureTable.table_name, featureRow.getId(), icons);
    };
    /**
       * Set the icons for the feature table and feature id
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.Icons} icons icons
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIcons = function (featureTable, featureId, icons) {
        this.deleteIconsForFeatureId(featureTable, featureId);
        if (icons !== null) {
            var promises = [];
            if (icons.getDefault() !== null) {
                promises.push(this.setIconDefault(featureTable, featureId, icons.getDefault()));
            }
            var keys = Object.keys(icons.icons);
            for (var i = 0; i < keys.length; i++) {
                promises.push(this.setIcon(featureTable, featureId, keys[i], icons.icons[keys[i]]));
            }
            return Promise.all(promises);
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the icon of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIconForFeatureRow = function (featureRow, icon) {
        return this.setIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), icon);
    };
    /**
       * Set the icon of the feature row for the specified geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIconForFeatureRowAndGeometryType = function (featureRow, geometryType, icon) {
        return this.setIcon(featureRow.featureTable.table_name, featureRow.getId(), geometryType, icon);
    };
    /**
       * Set the default icon of the feature row
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIconDefaultForFeatureRow = function (featureRow, icon) {
        return this.setIcon(featureRow.featureTable.table_name, featureRow.getId(), null, icon);
    };
    /**
       * Get the icon of the feature, searching in order: feature geometry type
       * icon, feature default icon, table geometry type icon, table default icon
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIcon = function (featureTable, featureId, geometryType, icon) {
        this.deleteIcon(featureTable, featureId, geometryType);
        if (icon !== null) {
            return this.createIconRelationship(featureTable).then(function () {
                var iconId = this.getOrInsertIcon(icon);
                var mappingDao = this.getIconMappingDao(featureTable);
                this.insertStyleMapping(mappingDao, featureId, iconId, geometryType);
            }.bind(this));
        }
        else {
            return Promise.resolve();
        }
    };
    /**
       * Set the default icon of the feature
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Promise}
       */
    FeatureStyleExtension.prototype.setIconDefault = function (featureTable, featureId, icon) {
        return this.setIcon(featureTable, featureId, null, icon);
    };
    /**
       * Get the style id, either from the existing style or by inserting a new one
       * @param {module:extension/style.StyleRow} style style row
       * @return {Number} style id
       */
    FeatureStyleExtension.prototype.getOrInsertStyle = function (style) {
        var styleId;
        if (style.hasId()) {
            styleId = style.getId();
        }
        else {
            var styleDao = this.getStyleDao();
            if (styleDao !== null) {
                styleId = styleDao.create(style);
                style.setId(styleId);
            }
        }
        return styleId;
    };
    /**
       * Get the icon id, either from the existing icon or by inserting a new one
       * @param {module:extension/style.IconRow} icon icon row
       * @return {Number} icon id
       */
    FeatureStyleExtension.prototype.getOrInsertIcon = function (icon) {
        var iconId;
        if (icon.hasId()) {
            iconId = icon.getId();
        }
        else {
            var iconDao = this.getIconDao();
            if (iconDao != null) {
                iconId = iconDao.create(icon);
                icon.setId(iconId);
            }
        }
        return iconId;
    };
    /**
       * Insert a style mapping row
       * @param {module:extension/style.StyleMappingDao} mappingDao mapping dao
       * @param {Number} baseId base id, either contents id or feature id
       * @param {Number} relatedId related id, either style or icon id
       * @param {String} geometryType geometry type or null
       */
    FeatureStyleExtension.prototype.insertStyleMapping = function (mappingDao, baseId, relatedId, geometryType) {
        var row = mappingDao.newRow();
        row.setBaseId(baseId);
        row.setRelatedId(relatedId);
        row.setGeometryTypeName(geometryType);
        mappingDao.create(row);
    };
    /**
       * Delete all feature styles including table styles, table icons, style, and icons
       * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteAllFeatureStyles = function (featureTable) {
        this.deleteTableFeatureStyles(featureTable);
        this.deleteFeatureStyles(featureTable);
    };
    /**
       * Delete all styles including table styles and feature row style
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteAllStyles = function (featureTable) {
        this.deleteTableStyles(featureTable);
        this.deleteStyles(featureTable);
    };
    /**
       * Delete all icons including table icons and feature row icons
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteAllIcons = function (featureTable) {
        this.deleteTableIcons(featureTable);
        this.deleteIcons(featureTable);
    };
    /**
       * Delete the feature table feature styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableFeatureStyles = function (featureTable) {
        this.deleteTableStyles(featureTable);
        this.deleteTableIcons(featureTable);
    };
    /**
       * Delete the feature table styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableStyles = function (featureTable) {
        this.deleteTableMappings(this.getTableStyleMappingDao(featureTable), featureTable);
    };
    /**
       * Delete the feature table default style
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableStyleDefault = function (featureTable) {
        this.deleteTableStyle(featureTable, null);
    };
    /**
       * Delete the feature table style for the geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteTableStyle = function (featureTable, geometryType) {
        this.deleteTableMapping(this.getTableStyleMappingDao(featureTable), featureTable, geometryType);
    };
    /**
       * Delete the feature table icons
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableIcons = function (featureTable) {
        this.deleteTableMappings(this.getTableIconMappingDao(featureTable), featureTable);
    };
    /**
       * Delete the feature table default icon
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableIconDefault = function (featureTable) {
        this.deleteTableIcon(featureTable, null);
    };
    /**
       * Delete the feature table icon for the geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteTableIcon = function (featureTable, geometryType) {
        this.deleteTableMapping(this.getTableIconMappingDao(featureTable), featureTable, geometryType);
    };
    /**
       * Delete the table style mappings
       * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteTableMappings = function (mappingDao, featureTable) {
        if (mappingDao !== null) {
            var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
            if (featureContentsId !== null) {
                mappingDao.deleteByBaseId(featureContentsId);
            }
        }
    };
    /**
       * Delete the table style mapping with the geometry type value
       * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteTableMapping = function (mappingDao, featureTable, geometryType) {
        if (mappingDao !== null) {
            var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
            if (featureContentsId !== null) {
                mappingDao.deleteByBaseIdAndGeometryType(featureContentsId, geometryType);
            }
        }
    };
    /**
       * Delete all feature styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteFeatureStyles = function (featureTable) {
        this.deleteStyles(featureTable);
        this.deleteIcons(featureTable);
    };
    /**
       * Delete all styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteStyles = function (featureTable) {
        this.deleteMappings(this.getStyleMappingDao(featureTable));
    };
    /**
       * Delete feature row styles
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteStylesForFeatureRow = function (featureRow) {
        this.deleteStylesForFeatureId(featureRow.featureTable.table_name, featureRow.getId());
    };
    /**
       * Delete feature row styles
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       */
    FeatureStyleExtension.prototype.deleteStylesForFeatureId = function (featureTable, featureId) {
        this.deleteMappingsForFeatureId(this.getStyleMappingDao(featureTable), featureId);
    };
    /**
       * Delete the feature row default style
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteStyleDefaultForFeatureRow = function (featureRow) {
        this.deleteStyleForFeatureRowAndGeometryType(featureRow, null);
    };
    /**
       * Delete the feature row default style
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       */
    FeatureStyleExtension.prototype.deleteStyleDefault = function (featureTable, featureId) {
        this.deleteStyle(featureTable, featureId, null);
    };
    /**
       * Delete the feature row style for the feature row geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteStyleForFeatureRow = function (featureRow) {
        this.deleteStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
       * Delete the feature row style for the geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteStyleForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        this.deleteStyle(featureRow.featureTable, featureRow.getId(), geometryType);
    };
    /**
       * Delete the feature row style for the geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteStyle = function (featureTable, featureId, geometryType) {
        this.deleteMapping(this.getStyleMappingDao(featureTable), featureId, geometryType);
    };
    /**
       * Delete all icons
       * @param {module:features/user/featureTable|String} featureTable feature table
       */
    FeatureStyleExtension.prototype.deleteIcons = function (featureTable) {
        this.deleteMappings(this.getIconMappingDao(featureTable));
    };
    /**
       * Delete feature row icons
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteIconsForFeatureRow = function (featureRow) {
        this.deleteIconsForFeatureId(featureRow.featureTable.table_name, featureRow.getId());
    };
    /**
       * Delete feature row icons
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       */
    FeatureStyleExtension.prototype.deleteIconsForFeatureId = function (featureTable, featureId) {
        this.deleteMappingsForFeatureId(this.getIconMappingDao(featureTable), featureId);
    };
    /**
       * Delete the feature row default icon
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteIconDefaultForFeatureRow = function (featureRow) {
        this.deleteIconDefault(featureRow.featureTable.table_name, featureRow.getId());
    };
    /**
       * Delete the feature row default icon
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       */
    FeatureStyleExtension.prototype.deleteIconDefault = function (featureTable, featureId) {
        this.deleteIcon(featureTable, featureId, null);
    };
    /**
       * Delete the feature row icon for the feature row geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       */
    FeatureStyleExtension.prototype.deleteIconForFeatureRow = function (featureRow) {
        this.deleteIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
       * Delete the feature row icon for the geometry type
       * @param {module:features/user/featureRow} featureRow feature row
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteIconForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        this.deleteIcon(featureRow.featureTable, featureRow.getId(), geometryType);
    };
    /**
       * Delete the feature row icon for the geometry type
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteIcon = function (featureTable, featureId, geometryType) {
        this.deleteMapping(this.getIconMappingDao(featureTable), featureId, geometryType);
    };
    /**
       * Delete all style mappings
       * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
       */
    FeatureStyleExtension.prototype.deleteMappings = function (mappingDao) {
        if (mappingDao !== null) {
            mappingDao.deleteAll();
        }
    };
    /**
       * Delete the style mappings
       * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
       * @param {Number} featureId feature id
       */
    FeatureStyleExtension.prototype.deleteMappingsForFeatureId = function (mappingDao, featureId) {
        if (mappingDao !== null) {
            mappingDao.deleteByBaseId(featureId);
        }
    };
    /**
       * Delete the style mapping with the geometry type value
       * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
       * @param {Number} featureId feature id
       * @param {String} geometryType geometry type
       */
    FeatureStyleExtension.prototype.deleteMapping = function (mappingDao, featureId, geometryType) {
        if (mappingDao !== null) {
            mappingDao.deleteByBaseIdAndGeometryType(featureId, geometryType);
        }
    };
    /**
       * Get all the unique style row ids the table maps to
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return style row ids
       */
    FeatureStyleExtension.prototype.getAllTableStyleIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getTableStyleMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
       * Get all the unique icon row ids the table maps to
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return icon row ids
       */
    FeatureStyleExtension.prototype.getAllTableIconIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getTableIconMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
       * Get all the unique style row ids the features map to
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Number[]} style row ids
       */
    FeatureStyleExtension.prototype.getAllStyleIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getStyleMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
       * Get all the unique icon row ids the features map to
       * @param {module:features/user/featureTable|String} featureTable feature table
       * @return {Number[]} icon row ids
       */
    FeatureStyleExtension.prototype.getAllIconIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getIconMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
       * Get name of feature table
       * @param featureTable
       * @returns {String}
       */
    FeatureStyleExtension.prototype.getFeatureTableName = function (featureTable) {
        return featureTable.table_name ? featureTable.table_name : featureTable;
    };
    /**
       * Remove all traces of the extension
       */
    FeatureStyleExtension.prototype.removeExtension = function () {
        this.deleteAllRelationships();
        this.geoPackage.deleteTable(styleTable_1.default.TABLE_NAME);
        this.geoPackage.deleteTable(iconTable_1.default.TABLE_NAME);
        if (this.extensionsDao.isTableExists()) {
            this.extensionsDao.deleteByExtension(FeatureStyleExtension.EXTENSION_NAME);
        }
    };
    FeatureStyleExtension.EXTENSION_NAME = 'nga_feature_style';
    FeatureStyleExtension.EXTENSION_AUTHOR = 'nga';
    FeatureStyleExtension.EXTENSION_NAME_NO_AUTHOR = 'feature_style';
    FeatureStyleExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/feature-style.html';
    FeatureStyleExtension.TABLE_MAPPING_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + "_style_";
    FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + "_style_default_";
    FeatureStyleExtension.TABLE_MAPPING_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + "_icon_";
    FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + "_icon_default_";
    return FeatureStyleExtension;
}(baseExtension_1.default));
exports.default = FeatureStyleExtension;

},{"../../user/userTableReader":125,"../baseExtension":24,"../contents/contentsIdDao":26,"../extension":29,"../relatedTables/userMappingTable":50,"./featureStyle":55,"./featureStyles":56,"./iconDao":59,"./iconTable":61,"./icons":62,"./styleDao":64,"./styleMappingDao":65,"./styleMappingTable":67,"./styleTable":69,"./styleTableReader":70,"./styles":71}],64:[function(require,module,exports){
"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleDao
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var attributeDao_1 = __importDefault(require("../../attributes/attributeDao"));
var styleRow_1 = __importDefault(require("./styleRow"));
/**
 * Style DAO for reading style tables
 * @extends {AttributesDao}
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage connection
 * @param  {string} table table name
 * @constructor
 */
var StyleDao = /** @class */ (function (_super) {
    __extends(StyleDao, _super);
    function StyleDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.table = table;
        return _this;
    }
    /**
     * Creates a StyleRow object from the results
     * @param results
     * @returns {module:extension/style.StyleRow}
     */
    StyleDao.prototype.createObject = function (results) {
        if (results) {
            return this.getRow(results);
        }
        return this.newRow();
    };
    /**
     * Create a new style row
     * @return {module:extension/style.StyleRow}
     */
    StyleDao.prototype.newRow = function () {
        return new styleRow_1.default(this.table);
    };
    /**
     * Create a style row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/style.StyleRow}             icon row
     */
    StyleDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new styleRow_1.default(this.table, columnTypes, values);
    };
    return StyleDao;
}(attributeDao_1.default));
exports.default = StyleDao;

},{"../../attributes/attributeDao":3,"./styleRow":68}],65:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class StyleMappingDao
 */
var userMappingDao_1 = __importDefault(require("../relatedTables/userMappingDao"));
var styleMappingTable_1 = __importDefault(require("./styleMappingTable"));
var userMappingTable_1 = __importDefault(require("../relatedTables/userMappingTable"));
var styleMappingRow_1 = __importDefault(require("./styleMappingRow"));
/**
 * Style Mapping DAO for reading user mapping data tables
 * @extends UserMappingDao
 * @param  {module:user/custom~UserCustomDao} userCustomDao
 * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
 * @param {StyleMappingTable} [styleMappingTable]
 * @constructor
 */
var StyleMappingDao = /** @class */ (function (_super) {
    __extends(StyleMappingDao, _super);
    function StyleMappingDao(userCustomDao, geoPackage, styleMappingTable) {
        return _super.call(this, userCustomDao, geoPackage, styleMappingTable || new styleMappingTable_1.default(userCustomDao.table.table_name, userCustomDao.table.columns)) || this;
    }
    /**
     * Create a new {module:user/custom~UserCustomTable}
     * @param  {module:user/custom~UserCustomDao} userCustomDao
     * @return {module:user/custom~UserCustomTable} userCustomTable user custom table
     */
    StyleMappingDao.prototype.createMappingTable = function (userCustomDao) {
        return new styleMappingTable_1.default(userCustomDao.table.table_name, userCustomDao.table.columns);
    };
    /**
     * Create a new {module:extension/style.StyleMappingRow}
     * @return {module:extension/style.StyleMappingRow}
     */
    StyleMappingDao.prototype.newRow = function () {
        return new styleMappingRow_1.default(this.table);
    };
    /**
     * Create a user mapping row
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values values
     * @return {module:extension/style.StyleMappingRow} style mapping row
     */
    StyleMappingDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new styleMappingRow_1.default(this.table, columnTypes, values);
    };
    /**
     * Delete by base id and geometry type
     * @param  {Number} baseId base id
     * @param  {String} geometryType geometry type
     * @return {Number} number of deleted rows
     */
    StyleMappingDao.prototype.deleteByBaseIdAndGeometryType = function (baseId, geometryType) {
        var where = '';
        where += this.buildWhereWithFieldAndValue(userMappingTable_1.default.COLUMN_BASE_ID, baseId);
        where += ' AND ';
        where += this.buildWhereWithFieldAndValue(styleMappingTable_1.default.COLUMN_GEOMETRY_TYPE_NAME, geometryType);
        var whereArgs = this.buildWhereArgs([baseId, geometryType]);
        return this.deleteWhere(where, whereArgs);
    };
    return StyleMappingDao;
}(userMappingDao_1.default));
exports.default = StyleMappingDao;

},{"../relatedTables/userMappingDao":48,"../relatedTables/userMappingTable":50,"./styleMappingRow":66,"./styleMappingTable":67}],66:[function(require,module,exports){
"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleMappingRow
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userMappingRow_1 = __importDefault(require("../relatedTables/userMappingRow"));
/**
 * User Mapping Row containing the values from a single result set row
 * @extends UserMappingRow
 * @param  {module:extension/style.StyleMappingTable} styleMappingTable style mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
var StyleMappingRow = /** @class */ (function (_super) {
    __extends(StyleMappingRow, _super);
    function StyleMappingRow(styleMappingTable, columnTypes, values) {
        var _this = _super.call(this, styleMappingTable, columnTypes, values) || this;
        _this.styleMappingTable = styleMappingTable;
        return _this;
    }
    /**
     * Get the geometry type name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleMappingRow.prototype.getGeometryTypeNameColumn = function () {
        return this.styleMappingTable.getGeometryTypeNameColumn();
    };
    /**
     * Gets the geometry type name
     * @return {string}
     */
    StyleMappingRow.prototype.getGeometryTypeName = function () {
        return this.getValueWithColumnName(this.getGeometryTypeNameColumn().name);
    };
    /**
     * Sets the geometry type name
     * @param  {string} geometryTypeName geometry type name
     */
    StyleMappingRow.prototype.setGeometryTypeName = function (geometryTypeName) {
        this.setValueWithColumnName(this.getGeometryTypeNameColumn().name, geometryTypeName);
    };
    return StyleMappingRow;
}(userMappingRow_1.default));
exports.default = StyleMappingRow;

},{"../relatedTables/userMappingRow":49}],67:[function(require,module,exports){
"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleMappingTable
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userMappingTable_1 = __importDefault(require("../relatedTables/userMappingTable"));
var userCustomColumn_1 = __importDefault(require("../../user/custom/userCustomColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Contains style mapping table factory and utility methods
 * @extends UserMappingTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   style mapping columns
 * @constructor
 */
var StyleMappingTable = /** @class */ (function (_super) {
    __extends(StyleMappingTable, _super);
    function StyleMappingTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Get the geometry type name column index
     * @return int
     */
    StyleMappingTable.prototype.getGeometryTypeNameColumnIndex = function () {
        return this.getColumnIndex(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
    };
    /**
     * Get the geometry type name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleMappingTable.prototype.getGeometryTypeNameColumn = function () {
        return this.getColumnWithColumnName(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
    };
    /**
     * Creates a user mapping table with the minimum required columns followed by the additional columns
     * @param  {string} tableName name of the table
     * @return {module:extension/relatedTables~UserMappingTable}
     */
    StyleMappingTable.create = function (tableName) {
        return new StyleMappingTable(tableName, StyleMappingTable.createColumns());
    };
    /**
     * Create the columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    StyleMappingTable.createColumns = function () {
        var columns = userMappingTable_1.default.createRequiredColumns();
        var index = columns.length;
        columns.push(userCustomColumn_1.default.createColumn(index, StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        return columns;
    };
    StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME = 'geometry_type_name';
    return StyleMappingTable;
}(userMappingTable_1.default));
exports.default = StyleMappingTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":117,"../relatedTables/userMappingTable":50}],68:[function(require,module,exports){
"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleRow
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var attributeRow_1 = __importDefault(require("../../attributes/attributeRow"));
/**
 * Style Row
 * @extends AttributesRow
 * @param  {module:extension/style.StyleTable} styleTable  style table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
var StyleRow = /** @class */ (function (_super) {
    __extends(StyleRow, _super);
    function StyleRow(styleTable, columnTypes, values) {
        var _this = _super.call(this, styleTable, columnTypes, values) || this;
        _this.styleTable = styleTable;
        return _this;
    }
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getNameColumn = function () {
        return this.styleTable.getNameColumn();
    };
    /**
     * Gets the name
     * @return {String}
     */
    StyleRow.prototype.getName = function () {
        return this.getValueWithColumnName(this.getNameColumn().name);
    };
    /**
     * Sets the name for the row
     * @param {String} name name
     */
    StyleRow.prototype.setName = function (name) {
        this.setValueWithColumnName(this.getNameColumn().name, name);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getDescriptionColumn = function () {
        return this.styleTable.getDescriptionColumn();
    };
    /**
     * Gets the description
     * @return {String}
     */
    StyleRow.prototype.getDescription = function () {
        return this.getValueWithColumnName(this.getDescriptionColumn().name);
    };
    /**
     * Sets the description for the row
     * @param {String} description description
     */
    StyleRow.prototype.setDescription = function (description) {
        this.setValueWithColumnName(this.getDescriptionColumn().name, description);
    };
    /**
     * Get the color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getColorColumn = function () {
        return this.styleTable.getColorColumn();
    };
    /**
     * Get the style color
     * @return {String} color
     */
    StyleRow.prototype.getColor = function () {
        return this.createColor(this.getHexColor(), this.getOpacity());
    };
    /**
     * Check if the style has a color
     * @return true if has a color
     */
    StyleRow.prototype.hasColor = function () {
        return this._hasColor(this.getHexColor(), this.getOpacity());
    };
    /**
     * Get the color
     * @return {String} color
     */
    StyleRow.prototype.getHexColor = function () {
        return this.getValueWithColumnName(this.getColorColumn().name);
    };
    /**
     * Set the color
     * @param {String} color color
     * @param {Number} opacity opacity
     */
    StyleRow.prototype.setColor = function (color, opacity) {
        this.setHexColor(color);
        this.setOpacity(opacity);
    };
    /**
     * Sets the color for the row
     * @param {String} color color
     */
    StyleRow.prototype.setHexColor = function (color) {
        var validatedColor = this.validateColor(color);
        this.setValueWithColumnName(this.getColorColumn().name, validatedColor);
    };
    /**
     * Get the opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getOpacityColumn = function () {
        return this.styleTable.getOpacityColumn();
    };
    /**
     * Gets the opacity
     * @return {Number}
     */
    StyleRow.prototype.getOpacity = function () {
        return this.getValueWithColumnName(this.getOpacityColumn().name);
    };
    /**
     * Get the opacity or default value
     * @return {Number} opacity
     */
    StyleRow.prototype.getOpacityOrDefault = function () {
        var opacity = this.getOpacity();
        if (opacity === null) {
            opacity = 1.0;
        }
        return opacity;
    };
    /**
     * Sets the opacity for the row
     * @param {Number} opacity opacity
     */
    StyleRow.prototype.setOpacity = function (opacity) {
        this.validateOpacity(opacity);
        this.setValueWithColumnName(this.getOpacityColumn().name, opacity);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getWidthColumn = function () {
        return this.styleTable.getWidthColumn();
    };
    /**
     * Gets the width
     * @return {number}
     */
    StyleRow.prototype.getWidth = function () {
        return this.getValueWithColumnName(this.getWidthColumn().name);
    };
    /**
     * Sets the width for the row
     * @param {Number} width width
     */
    StyleRow.prototype.setWidth = function (width) {
        if (width !== null && width < 0.0) {
            throw new Error("Width must be greater than or equal to 0.0, invalid value: " + width);
        }
        this.setValueWithColumnName(this.getWidthColumn().name, width);
    };
    /**
     * Get the width value or default width
     * @return width
     */
    StyleRow.prototype.getWidthOrDefault = function () {
        var width = this.getWidth();
        if (width === null) {
            width = 1.0;
        }
        return width;
    };
    /**
     * Get the fill color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getFillColorColumn = function () {
        return this.styleTable.getFillColorColumn();
    };
    /**
     * Get the style fill color
     * @return {String} color
     */
    StyleRow.prototype.getFillColor = function () {
        return this.createColor(this.getFillHexColor(), this.getFillOpacity());
    };
    /**
     * Check if the style has a fill color
     * @return true if has a color
     */
    StyleRow.prototype.hasFillColor = function () {
        return this._hasColor(this.getFillHexColor(), this.getFillOpacity());
    };
    /**
     * Get the fill color
     * @return {String} color
     */
    StyleRow.prototype.getFillHexColor = function () {
        return this.getValueWithColumnName(this.getFillColorColumn().name);
    };
    /**
     * Set the fill color
     * @param {String} color color
     * @param {Number} opacity opacity
     */
    StyleRow.prototype.setFillColor = function (color, opacity) {
        this.setFillHexColor(color);
        this.setFillOpacity(opacity);
    };
    /**
     * Sets the fill color for the row
     * @param {String} color color
     */
    StyleRow.prototype.setFillHexColor = function (color) {
        var validatedColor = this.validateColor(color);
        this.setValueWithColumnName(this.getFillColorColumn().name, validatedColor);
    };
    /**
     * Get the fill opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleRow.prototype.getFillOpacityColumn = function () {
        return this.styleTable.getFillOpacityColumn();
    };
    /**
     * Gets the fill opacity
     * @return {Number}
     */
    StyleRow.prototype.getFillOpacity = function () {
        return this.getValueWithColumnName(this.getFillOpacityColumn().name);
    };
    /**
     * Sets the fill opacity for the row
     * @param {Number} fillOpacity fillOpacity
     */
    StyleRow.prototype.setFillOpacity = function (fillOpacity) {
        this.validateOpacity(fillOpacity);
        this.setValueWithColumnName(this.getFillOpacityColumn().name, fillOpacity);
    };
    /**
     * Get the fill opacity or default value
     * @return {Number} fill opacity
     */
    StyleRow.prototype.getFillOpacityOrDefault = function () {
        var fillOpacity = this.getFillOpacity();
        if (fillOpacity == null) {
            fillOpacity = 1.0;
        }
        return fillOpacity;
    };
    /**
     * Validate and adjust the color value
     * @param {String} color color
     */
    StyleRow.prototype.validateColor = function (color) {
        var validated = color;
        if (color != null) {
            if (!color.startsWith("#")) {
                validated = "#" + color;
            }
            if (!StyleRow.colorPattern.test(validated)) {
                throw new Error("Color must be in hex format #RRGGBB or #RGB, invalid value: " + color);
            }
            validated = validated.toUpperCase();
        }
        return validated;
    };
    /**
     * Validate the opacity value
     * @param {Number} opacity opacity
     */
    StyleRow.prototype.validateOpacity = function (opacity) {
        if (opacity != null && (opacity < 0.0 || opacity > 1.0)) {
            throw new Error("Opacity must be set inclusively between 0.0 and 1.0, invalid value: " + opacity);
        }
    };
    /**
     * Create a color from the hex color and opacity
     * @param {String} hexColor hex color
     * @param {Number} opacity opacity
     * @return {String} rgba color
     */
    StyleRow.prototype.createColor = function (hexColor, opacity) {
        var color = '#000000';
        if (hexColor !== null) {
            color = hexColor;
        }
        if (opacity !== null) {
            var a = Math.round(opacity * 255).toString(16);
            if (a.length === 1) {
                a = "0" + a;
            }
            color += a;
        }
        return color.toUpperCase();
    };
    /**
     * Determine if a color exists from the hex color and opacity
     * @param {String} hexColor hex color
     * @param {Number} opacity opacity
     * @return true if has a color
     */
    StyleRow.prototype._hasColor = function (hexColor, opacity) {
        return hexColor !== null || opacity !== null;
    };
    /**
     * Color hex pattern
     */
    StyleRow.colorPattern = /^#([0-9a-fA-F]{3}){1,2}$/;
    return StyleRow;
}(attributeRow_1.default));
exports.default = StyleRow;

},{"../../attributes/attributeRow":4}],69:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class StyleTable
 */
var attributeTable_1 = __importDefault(require("../../attributes/attributeTable"));
var relationType_1 = __importDefault(require("../relatedTables/relationType"));
var userColumn_1 = __importDefault(require("../../user/userColumn"));
var userCustomColumn_1 = __importDefault(require("../../user/custom/userCustomColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Icon Requirements Class Media Table
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @constructor
 */
var StyleTable = /** @class */ (function (_super) {
    __extends(StyleTable, _super);
    function StyleTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        _this.TABLE_TYPE = 'media';
        _this.data_type = relationType_1.default.ATTRIBUTES.dataType;
        _this.relation_name = relationType_1.default.ATTRIBUTES.name;
        return _this;
    }
    /**
     * Get the name column index
     * @return int
     */
    StyleTable.prototype.getNameColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_NAME);
    };
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getNameColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_NAME);
    };
    /**
     * Get the description column index
     * @return int
     */
    StyleTable.prototype.getDescriptionColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getDescriptionColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the color column index
     * @return int
     */
    StyleTable.prototype.getColorColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_COLOR);
    };
    /**
     * Get the color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getColorColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_COLOR);
    };
    /**
     * Get the opacity column index
     * @return int
     */
    StyleTable.prototype.getOpacityColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_OPACITY);
    };
    /**
     * Get the opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getOpacityColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_OPACITY);
    };
    /**
     * Get the width column index
     * @return int
     */
    StyleTable.prototype.getWidthColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_WIDTH);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getWidthColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_WIDTH);
    };
    /**
     * Get the fill_color column index
     * @return int
     */
    StyleTable.prototype.getFillColorColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_FILL_COLOR);
    };
    /**
     * Get the fill_color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getFillColorColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_COLOR);
    };
    /**
     * Get the fill_opacity column index
     * @return int
     */
    StyleTable.prototype.getFillOpacityColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_FILL_OPACITY);
    };
    /**
     * Get the fill_opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getFillOpacityColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_OPACITY);
    };
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/style.StyleTable}
     */
    StyleTable.create = function () {
        return new StyleTable(StyleTable.TABLE_NAME, StyleTable.createColumns());
    };
    /**
     * Create the columns
     * @return {module:user/custom~UserCustomColumn[]}
     */
    StyleTable.createColumns = function () {
        var columns = [];
        var index = 0;
        columns.push(userColumn_1.default.createPrimaryKeyColumnWithIndexAndName(index++, StyleTable.COLUMN_ID));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_NAME, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_DESCRIPTION, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_COLOR, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_OPACITY, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_WIDTH, dataTypes_1.default.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index++, StyleTable.COLUMN_FILL_COLOR, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.default.createColumn(index, StyleTable.COLUMN_FILL_OPACITY, dataTypes_1.default.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
        return columns;
    };
    StyleTable.TABLE_NAME = 'nga_style';
    StyleTable.COLUMN_ID = 'id';
    StyleTable.COLUMN_NAME = 'name';
    StyleTable.COLUMN_DESCRIPTION = 'description';
    StyleTable.COLUMN_COLOR = 'color';
    StyleTable.COLUMN_OPACITY = 'opacity';
    StyleTable.COLUMN_WIDTH = 'width';
    StyleTable.COLUMN_FILL_COLOR = 'fill_color';
    StyleTable.COLUMN_FILL_OPACITY = 'fill_opacity';
    return StyleTable;
}(attributeTable_1.default));
exports.default = StyleTable;

},{"../../attributes/attributeTable":5,"../../db/dataTypes":18,"../../user/custom/userCustomColumn":117,"../../user/userColumn":121,"../relatedTables/relationType":44}],70:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class StyleTableReader
 */
var attributeTableReader_1 = __importDefault(require("../../attributes/attributeTableReader"));
var styleTable_1 = __importDefault(require("./styleTable"));
/**
 * Reads the metadata from an existing attribute table
 * @extends {AttributeTableReader}
 * @constructor
*/
var StyleTableReader = /** @class */ (function (_super) {
    __extends(StyleTableReader, _super);
    function StyleTableReader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     *
     * @param {String} tableName
     * @param columns
     * @returns {module:extension/style.StyleTable}
     */
    StyleTableReader.prototype.createTable = function (tableName, columns) {
        return new styleTable_1.default(tableName, columns);
    };
    return StyleTableReader;
}(attributeTableReader_1.default));
exports.default = StyleTableReader;

},{"../../attributes/attributeTableReader":6,"./styleTable":69}],71:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class Styles
 */
/**
 * Styles constructor
 * @constructor
 */
var Styles = /** @class */ (function () {
    function Styles() {
        this.defaultStyle = null;
        this.styles = {};
    }
    Styles.prototype.setDefault = function (styleRow) {
        this.defaultStyle = styleRow;
    };
    Styles.prototype.getDefault = function () {
        return this.defaultStyle;
    };
    Styles.prototype.setStyle = function (styleRow, geometryType) {
        if (geometryType != null) {
            if (styleRow != null) {
                this.styles[geometryType] = styleRow;
            }
            else {
                delete this.styles[geometryType];
            }
        }
        else {
            this.setDefault(styleRow);
        }
    };
    Styles.prototype.getStyle = function (geometryType) {
        var styleRow = null;
        if (geometryType != null) {
            styleRow = this.styles[geometryType];
        }
        if (styleRow === null || geometryType === null) {
            styleRow = this.getDefault();
        }
        return styleRow;
    };
    Styles.prototype.isEmpty = function () {
        return Object.keys(this.styles).length === 0 && this.defaultStyle === null;
    };
    return Styles;
}());
module.exports = Styles;

},{}],72:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * WebPExtension module.
 * @module WebPExtension
 * @see module:extension/BaseExtension
 */
var baseExtension_1 = __importDefault(require("../baseExtension"));
var extension_1 = __importDefault(require("../extension"));
var WebPExtension = /** @class */ (function (_super) {
    __extends(WebPExtension, _super);
    function WebPExtension(geoPackage, tableName) {
        var _this = _super.call(this, geoPackage) || this;
        _this.tableName = tableName;
        return _this;
    }
    WebPExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(WebPExtension.EXTENSION_NAME, this.tableName, 'tile_data', WebPExtension.EXTENSION_WEBP_DEFINITION, extension_1.default.READ_WRITE);
    };
    WebPExtension.EXTENSION_NAME = 'gpkg_webp';
    WebPExtension.EXTENSION_WEBP_AUTHOR = 'gpkg';
    WebPExtension.EXTENSION_WEBP_NAME_NO_AUTHOR = 'webp';
    WebPExtension.EXTENSION_WEBP_DEFINITION = 'http://www.geopackage.org/spec/#extension_webp';
    return WebPExtension;
}(baseExtension_1.default));
exports.default = WebPExtension;

},{"../baseExtension":24,"../extension":29}],73:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class GeometryColumns
 */
var GeometryColumns = /** @class */ (function () {
    function GeometryColumns() {
    }
    GeometryColumns.prototype.getGeometryType = function () {
        return this.geometry_type_name;
    };
    GeometryColumns.TABLE_NAME = "tableName";
    GeometryColumns.COLUMN_NAME = "columnName";
    GeometryColumns.GEOMETRY_TYPE_NAME = "geometryTypeName";
    GeometryColumns.SRS_ID = "srsId";
    GeometryColumns.Z = "z";
    GeometryColumns.M = "m";
    return GeometryColumns;
}());
exports.default = GeometryColumns;

},{}],74:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable camelcase */
/**
 * GeometryColumns module.
 * @module features/columns
 */
var dao_1 = __importDefault(require("../../dao/dao"));
var geometryColumns_1 = __importDefault(require("./geometryColumns"));
// /**
//  * Contents
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<Contents> contents;
//
// /**
//  * Geometry Columns
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<GeometryColumns> geometryColumns;
//
// /**
//  * Matrix Tile Set
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<TileMatrixSet> tileMatrixSet;
/**
 * Geometry Columns Data Access Object
 * @class GeometryColumnsDao
 * @extends Dao
 */
var GeometryColumnsDao = /** @class */ (function (_super) {
    __extends(GeometryColumnsDao, _super);
    function GeometryColumnsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Table Name
         * @type {String}
         */
        _this.gpkgTableName = 'gpkg_geometry_columns';
        _this.idColumns = [GeometryColumnsDao.COLUMN_ID_1, GeometryColumnsDao.COLUMN_ID_2];
        _this.columns = [GeometryColumnsDao.COLUMN_TABLE_NAME, GeometryColumnsDao.COLUMN_COLUMN_NAME, GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME, GeometryColumnsDao.COLUMN_SRS_ID, GeometryColumnsDao.COLUMN_Z, GeometryColumnsDao.COLUMN_M];
        return _this;
    }
    GeometryColumnsDao.prototype.createObject = function () {
        return new geometryColumns_1.default();
    };
    /**
     *  Query for the table name
     *
     *  @param {string} tableName table name
     */
    GeometryColumnsDao.prototype.queryForTableName = function (tableName) {
        var results = this.queryForAllEq(GeometryColumnsDao.COLUMN_TABLE_NAME, tableName);
        if (results && results.length) {
            var gc = this.createObject();
            this.populateObjectFromResult(gc, results[0]);
            return gc;
        }
        return;
    };
    /**
     *  Get the feature table names
     * @returns {String []} feature table names
     */
    GeometryColumnsDao.prototype.getFeatureTables = function () {
        var e_1, _a;
        var tableNames = [];
        try {
            for (var _b = __values(this.connection.each('select ' + GeometryColumnsDao.COLUMN_TABLE_NAME + ' from ' + this.gpkgTableName)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var result = _c.value;
                tableNames.push(result[GeometryColumnsDao.COLUMN_TABLE_NAME]);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return tableNames;
    };
    /**
     *  Get the Spatial Reference System of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     */
    GeometryColumnsDao.prototype.getSrs = function (geometryColumns) {
        var dao = this.geoPackage.getSpatialReferenceSystemDao();
        return dao.queryForId(geometryColumns.srs_id);
    };
    /**
     *  Get the Contents of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     *  @return {ContentsDao} contents dao
     */
    GeometryColumnsDao.prototype.getContents = function (geometryColumns) {
        var dao = this.geoPackage.getContentsDao();
        return dao.queryForId(geometryColumns.table_name);
    };
    GeometryColumnsDao.prototype.getProjection = function (projectionObject) {
        var srs = this.getSrs(projectionObject);
        var srsDao = this.geoPackage.getSpatialReferenceSystemDao();
        return srsDao.getProjection(srs);
    };
    /**
     * tableName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_TABLE_NAME = "table_name";
    /**
     * columnName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_COLUMN_NAME = "column_name";
    /**
     * id 1 field name, tableName
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_ID_1 = GeometryColumnsDao.COLUMN_TABLE_NAME;
    /**
     * id 2 field name, columnName
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_ID_2 = GeometryColumnsDao.COLUMN_COLUMN_NAME;
    /**
     * geometryTypeName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME = "geometry_type_name";
    /**
     * srsId field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_SRS_ID = 'srs_id';
    /**
     * z field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_Z = "z";
    /**
     * m field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_M = "m";
    return GeometryColumnsDao;
}(dao_1.default));
exports.default = GeometryColumnsDao;

},{"../../dao/dao":13,"./geometryColumns":73}],75:[function(require,module,exports){
"use strict";
/**
 * @module features/user/featureColumn
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userColumn_1 = __importDefault(require("../../user/userColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
/**
 * Represents a user feature column
 * @class
 * @extends UserColumn
 */
var FeatureColumn = /** @class */ (function (_super) {
    __extends(FeatureColumn, _super);
    function FeatureColumn(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType) {
        var _this = _super.call(this, index, name, dataType, max, notNull, defaultValue, primaryKey) || this;
        _this.geometryType = geometryType;
        if (!geometryType && dataType === dataTypes_1.default.GPKGDataType.GPKG_DT_GEOMETRY) {
            throw new Error('Data or Geometry Type is required to create column: ' + name);
        }
        return _this;
    }
    FeatureColumn.prototype.getTypeName = function () {
        if (this.isGeometry()) {
            return dataTypes_1.default.nameFromType(dataTypes_1.default.GPKGDataType.GPKG_DT_GEOMETRY);
        }
        return this.dataType !== undefined && dataTypes_1.default.nameFromType(this.dataType);
    };
    /**
     * Determine if this column is a geometry
     * @return {Boolean} true if a geometry column
     */
    FeatureColumn.prototype.isGeometry = function () {
        return this.geometryType !== undefined;
    };
    /**
     *  Create a new primary key column
     *
     *  @param {Number} index column index
     *  @param {string} name  column name
     *
     *  @return feature column
     */
    FeatureColumn.createPrimaryKeyColumnWithIndexAndName = function (index, name) {
        return new FeatureColumn(index, name, dataTypes_1.default.GPKGDataType.GPKG_DT_INTEGER, undefined, true, undefined, true);
    };
    /**
     *  Create a new geometry column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {String} type         geometry type
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *
     *  @return feature column
     */
    FeatureColumn.createGeometryColumn = function (index, name, type, notNull, defaultValue) {
        return new FeatureColumn(index, name, type, undefined, notNull, defaultValue, false, type);
    };
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} type         data type
     *  @param {Boolean} [notNull]      not null
     *  @param {Object} [defaultValue] default value or nil
     *
     *  @return feature column
     */
    FeatureColumn.createColumnWithIndex = function (index, name, type, notNull, defaultValue) {
        return FeatureColumn.createColumnWithIndexAndMax(index, name, type, undefined, notNull, defaultValue);
    };
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} type         data type
     *  @param {Number} max max value
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *
     *  @return feature column
     */
    FeatureColumn.createColumnWithIndexAndMax = function (index, name, type, max, notNull, defaultValue) {
        return new FeatureColumn(index, name, type, max, notNull, defaultValue, false);
    };
    return FeatureColumn;
}(userColumn_1.default));
exports.default = FeatureColumn;

},{"../../db/dataTypes":18,"../../user/userColumn":121}],76:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureDao module.
 * @module features/user/featureDao
 */
var reproject_1 = __importDefault(require("reproject"));
var line_intersect_1 = __importDefault(require("@turf/line-intersect"));
var intersect_1 = __importDefault(require("@turf/intersect"));
var boolean_within_1 = __importDefault(require("@turf/boolean-within"));
var featureTableIndex_1 = __importDefault(require("../../extension/index/featureTableIndex"));
var userDao_1 = __importDefault(require("../../user/userDao"));
var dataColumnsDao_1 = __importDefault(require("../../dataColumns/dataColumnsDao"));
var featureRow_1 = __importDefault(require("./featureRow"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
var boundingBox_1 = require("../../boundingBox");
/**
 * Feature DAO for reading feature user data tables
 * @class FeatureDao
 * @extends UserDao
 * @param  {any} db              database connection
 * @param  {FeatureTable} table           feature table
 * @param  {GeometryColumns} geometryColumns geometry columns
 * @param  {MetadataDao} metadataDao      metadata dao
 */
var FeatureDao = /** @class */ (function (_super) {
    __extends(FeatureDao, _super);
    function FeatureDao(geoPackage, table, geometryColumns, metadataDao) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.geometryColumns = geometryColumns;
        _this.metadataDao = metadataDao;
        _this.dataColumnsDao = new dataColumnsDao_1.default(geoPackage);
        _this.featureTableIndex = new featureTableIndex_1.default(geoPackage, _this);
        var dao = geoPackage.getGeometryColumnsDao();
        if (!dao.getContents(geometryColumns)) {
            throw new Error('Geometry Columns ' + dao.getId(geometryColumns) + ' has null Contents');
        }
        if (!dao.getSrs(geometryColumns)) {
            throw new Error('Geometry Columns ' + dao.getId(geometryColumns) + ' has null Spatial Reference System');
        }
        _this.projection = dao.getProjection(geometryColumns);
        return _this;
    }
    FeatureDao.prototype.createObject = function (results) {
        if (results) {
            return this.getRow(results);
        }
        return this.newRow();
    };
    FeatureDao.prototype.getContents = function () {
        var dao = this.geoPackage.getGeometryColumnsDao();
        return dao.getContents(this.geometryColumns);
    };
    /**
     * Get the feature table
     * @return {FeatureTable} the feature table
     */
    FeatureDao.prototype.getFeatureTable = function () {
        return this.table;
    };
    /**
     * Create a new feature row with the column types and values
     * @param  {Array} columnTypes column types
     * @param  {Array} values      values
     * @return {FeatureRow}             feature row
     */
    FeatureDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new featureRow_1.default(this.getFeatureTable(), columnTypes, values);
    };
    /**
     * Create a new feature row
     * @return {FeatureRow} feature row
     */
    FeatureDao.prototype.newRow = function () {
        return new featureRow_1.default(this.getFeatureTable());
    };
    /**
     * Get the geometry column name
     * @return {string} the geometry column name
     */
    FeatureDao.prototype.getGeometryColumnName = function () {
        return this.geometryColumns.column_name;
    };
    /**
     * Get the geometry types
     * @return {Number} well known binary geometry type
     */
    FeatureDao.prototype.getGeometryType = function () {
        return this.geometryColumns.getGeometryType();
    };
    FeatureDao.prototype.getSrs = function () {
        return this.geoPackage.getGeometryColumnsDao().getSrs(this.geometryColumns);
    };
    /**
     * Determine if the feature table is indexed
     * @returns {Boolean} indexed status of the table
     */
    FeatureDao.prototype.isIndexed = function () {
        return this.featureTableIndex.isIndexed();
    };
    /**
     * Query for count in bounding box
     * @param boundingBox
     * @returns {Number}}
     */
    FeatureDao.prototype.countWebMercatorBoundingBox = function (boundingBox) {
        return this.featureTableIndex.countWithBoundingBox(boundingBox, 'EPSG:3857');
    };
    /**
     * Fast query web mercator bounding box
     * @param {BoundingBox} boundingBox bounding box to query for
     * @returns {any}
     */
    FeatureDao.prototype.fastQueryWebMercatorBoundingBox = function (boundingBox) {
        var _a;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
        var thisgetRow = this.getRow.bind(this);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = thisgetRow(nextRow.value);
                    return {
                        value: featureRow,
                        done: false
                    };
                }
                else {
                    return {
                        done: true
                    };
                }
            },
            _a;
    };
    FeatureDao.prototype.queryIndexedFeaturesWithWebMercatorBoundingBox = function (boundingBox) {
        var _a;
        var srs = this.getSrs();
        var projection = this.projection;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
        var thisgetRow = this.getRow.bind(this);
        var projectedBoundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow;
                    var geometry;
                    while (!nextRow.done && !geometry) {
                        featureRow = thisgetRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        geometry = FeatureDao.verifyFeature(geometry, projectedBoundingBox);
                        if (geometry) {
                            geometry.properties = featureRow.values;
                            return {
                                value: featureRow,
                                done: false
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true
                };
            },
            _a;
    };
    /**
     * Calls geoJSONFeatureCallback with the geoJSON of each matched feature (always in 4326 projection)
     * @param  {BoundingBox} boundingBox        4326 bounding box to query
     * @param {Boolean} [skipVerification] do not verify if the feature actually exists in the box
     * @returns {any}
     */
    FeatureDao.prototype.queryForGeoJSONIndexedFeaturesWithBoundingBox = function (boundingBox, skipVerification) {
        var _a;
        if (skipVerification === void 0) { skipVerification = false; }
        var columns = [];
        var columnMap = {};
        var srs = this.getSrs();
        var projection = this.projection;
        this.table.columns.forEach(function (column) {
            var dataColumn = this.dataColumnsDao.getDataColumns(this.table.table_name, column.name);
            columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType ? dataTypes_1.default.nameFromType(column.dataType) : '',
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn
            });
            columnMap[column.name] = columns[columns.length - 1];
        }.bind(this));
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:4326')[Symbol.iterator]();
        var thisgetRow = this.getRow.bind(this);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            // eslint-disable-next-line complexity
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow;
                    var geometry;
                    while (!nextRow.done && !geometry) {
                        featureRow = thisgetRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        if (!skipVerification) {
                            geometry = FeatureDao.verifyFeature(geometry, boundingBox);
                        }
                        if (geometry) {
                            var geoJson = {
                                id: undefined,
                                properties: {},
                                geometry: geometry
                            };
                            for (var key in featureRow.values) {
                                if (Object.prototype.hasOwnProperty.call(featureRow.values, key) && key !== featureRow.getGeometryColumn().name && key !== 'id') {
                                    if (key.toLowerCase() === '_feature_id') {
                                        geoJson.id = featureRow.values[key];
                                    }
                                    else if (key.toLowerCase() === '_properties_id') {
                                        geoJson.properties[key.substring(12)] = featureRow.values[key];
                                    }
                                    else {
                                        geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
                                    }
                                }
                            }
                            geoJson.id = geoJson.id || featureRow.getId();
                            return {
                                value: geoJson,
                                done: false
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true
                };
            }.bind(this),
            _a;
    };
    FeatureDao.prototype.queryIndexedFeaturesWithBoundingBox = function (boundingBox) {
        var _a;
        var srs = this.getSrs();
        var projection = this.projection;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:4326');
        var thisgetRow = this.getRow.bind(this);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow;
                    var geometry;
                    while (!nextRow.done && !geometry) {
                        featureRow = thisgetRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        geometry = FeatureDao.verifyFeature(geometry, boundingBox);
                        if (geometry) {
                            geometry.properties = featureRow.values;
                            return {
                                value: featureRow,
                                done: false
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true
                };
            }.bind(this),
            _a;
    };
    FeatureDao.prototype.getBoundingBox = function () {
        var contents = this.getContents();
        return new boundingBox_1.BoundingBox(contents.min_x, contents.max_x, contents.min_y, contents.max_y);
    };
    FeatureDao.reprojectFeature = function (featureRow, srs, projection) {
        var geometry = featureRow.getGeometry().toGeoJSON();
        if (srs.organization + ':' + srs.organization_coordsys_id !== 'EPSG:4326') {
            geometry = reproject_1.default.reproject(geometry, projection, 'EPSG:4326');
        }
        return geometry;
    };
    FeatureDao.verifyFeature = function (geometry, boundingBox) {
        try {
            if (geometry.type === 'Point') {
                return geometry;
            }
            else if (geometry.type === 'LineString') {
                return FeatureDao.verifyLineString(geometry, boundingBox);
            }
            else if (geometry.type === 'Polygon') {
                return FeatureDao.verifyPolygon(geometry, boundingBox);
            }
            else if (geometry.type === 'MultiLineString') {
                return FeatureDao.verifyLineString(geometry, boundingBox);
            }
            else if (geometry.type === 'MultiPolygon') {
                return FeatureDao.verifyPolygon(geometry, boundingBox);
            }
        }
        catch (e) {
            return false;
        }
    };
    FeatureDao.verifyLineString = function (geometry, boundingBox) {
        var intersect = line_intersect_1.default(geometry, boundingBox.toGeoJSON().geometry);
        if (intersect.features.length) {
            return geometry;
        }
        else if (boolean_within_1.default(geometry, boundingBox.toGeoJSON().geometry)) {
            return geometry;
        }
    };
    FeatureDao.verifyPolygon = function (geometry, boundingBox) {
        var polyIntersect = intersect_1.default(geometry, boundingBox.toGeoJSON().geometry);
        if (polyIntersect) {
            return geometry;
        }
        else if (boolean_within_1.default(geometry, boundingBox.toGeoJSON().geometry)) {
            return geometry;
        }
    };
    return FeatureDao;
}(userDao_1.default));
exports.default = FeatureDao;

},{"../../boundingBox":7,"../../dataColumns/dataColumnsDao":17,"../../db/dataTypes":18,"../../extension/index/featureTableIndex":31,"../../user/userDao":122,"./featureRow":77,"@turf/boolean-within":136,"@turf/intersect":139,"@turf/line-intersect":141,"reproject":334}],77:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = __importDefault(require("../../user/userRow"));
var featureColumn_1 = __importDefault(require("./featureColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
var geometryData_1 = require("../../geom/geometryData");
/**
 * featureRow module.
 * @module features/user/featureRow
 */
/**
 * Feature Row containing the values from a single result set row
 * @param  {FeatureTable} featureTable feature table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
var FeatureRow = /** @class */ (function (_super) {
    __extends(FeatureRow, _super);
    function FeatureRow(featureTable, columnTypes, values) {
        var _this = _super.call(this, featureTable, columnTypes, values) || this;
        _this.featureTable = featureTable;
        return _this;
    }
    /**
     * Get the geometry column index
     * @return {Number} geometry column index
     */
    FeatureRow.prototype.getGeometryColumnIndex = function () {
        return this.featureTable.geometryIndex;
    };
    /**
     * Get the geometry column
     * @return {FeatureColumn} geometry column
     */
    FeatureRow.prototype.getGeometryColumn = function () {
        return this.featureTable.getGeometryColumn();
    };
    /**
     * Get the geometry
     * @return {Buffer} geometry data
     */
    FeatureRow.prototype.getGeometry = function () {
        return this.getValueWithIndex(this.featureTable.geometryIndex);
    };
    /**
     * Get the geometry's type
     * @return {String} geometry data
     */
    FeatureRow.prototype.getGeometryType = function () {
        var geometryType = null;
        var geometry = this.getValueWithIndex(this.featureTable.geometryIndex);
        if (geometry !== null) {
            geometryType = geometry.toGeoJSON().type;
        }
        return geometryType;
    };
    /**
     * set the geometry
     * @param {Buffer} geometryData geometry data
     */
    FeatureRow.prototype.setGeometry = function (geometryData) {
        this.setValueWithIndex(this.featureTable.geometryIndex, geometryData);
    };
    FeatureRow.prototype.toObjectValue = function (index, value) {
        var objectValue = value;
        var column = this.getColumnWithIndex(index);
        if (column instanceof featureColumn_1.default && column.isGeometry() && value) {
            objectValue = new geometryData_1.GeometryData(value);
        }
        return objectValue;
    };
    FeatureRow.prototype.toDatabaseValue = function (columnName) {
        var column = this.getColumnWithColumnName(columnName);
        var value = this.getValueWithColumnName(columnName);
        if (column instanceof featureColumn_1.default && column.isGeometry() && value.toData) {
            return value.toData();
        }
        else if (column.dataType === dataTypes_1.default.GPKGDataType.GPKG_DT_BOOLEAN) {
            return value === true ? 1 : 0;
        }
        return value;
    };
    return FeatureRow;
}(userRow_1.default));
exports.default = FeatureRow;

},{"../../db/dataTypes":18,"../../geom/geometryData":83,"../../user/userRow":123,"./featureColumn":75}],78:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureTable module.
 * @module features/user/featureTable
 */
var userTable_1 = __importDefault(require("../../user/userTable"));
/**
 * Represents a user feature table
 * @param  {string} tableName table name
 * @param  {array} columns   feature columns
 */
var FeatureTable = /** @class */ (function (_super) {
    __extends(FeatureTable, _super);
    function FeatureTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        var geometry = undefined;
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            if (column.isGeometry()) {
                _this.duplicateCheck(column.index, geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
                geometry = column.index;
            }
        }
        _this.missingCheck(geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
        _this.geometryIndex = geometry;
        return _this;
    }
    /**
     * Get the geometry feature column
     * @return {FeatureColumn} geometry feature column
     */
    FeatureTable.prototype.getGeometryColumn = function () {
        return this.getColumnWithIndex(this.geometryIndex);
    };
    FeatureTable.prototype.getTableType = function () {
        return userTable_1.default.FEATURE_TABLE;
    };
    return FeatureTable;
}(userTable_1.default));
exports.default = FeatureTable;

},{"../../user/userTable":124}],79:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureTableReader module.
 * @module features/user/featureTableReader
 */
var geometryColumnsDao_1 = __importDefault(require("../columns/geometryColumnsDao"));
var featureTable_1 = __importDefault(require("./featureTable"));
var userTableReader_1 = __importDefault(require("../../user/userTableReader"));
var featureColumn_1 = __importDefault(require("./featureColumn"));
var dataTypes_1 = __importDefault(require("../../db/dataTypes"));
var wkb_1 = require("../../wkb");
/**
* Reads the metadata from an existing feature table
* @class FeatureTableReader
*/
var FeatureTableReader = /** @class */ (function (_super) {
    __extends(FeatureTableReader, _super);
    function FeatureTableReader(tableNameOrGeometryColumns) {
        var _this = _super.call(this, tableNameOrGeometryColumns.table_name ? tableNameOrGeometryColumns.table_name : tableNameOrGeometryColumns) || this;
        tableNameOrGeometryColumns.table_name ? _this.geometryColumns = tableNameOrGeometryColumns : undefined;
        return _this;
    }
    FeatureTableReader.prototype.readFeatureTable = function (geoPackage) {
        if (!this.geometryColumns) {
            var gcd = new geometryColumnsDao_1.default(geoPackage);
            this.geometryColumns = gcd.queryForTableName(this.table_name);
            return this.readTable(geoPackage.getDatabase());
        }
        else {
            return this.readTable(geoPackage.getDatabase());
        }
    };
    FeatureTableReader.prototype.createTable = function (tableName, columns) {
        return new featureTable_1.default(tableName, columns);
    };
    FeatureTableReader.prototype.createColumnWithResults = function (results, index, name, type, max, notNull, defaultValue, primaryKey) {
        var geometry = name === this.geometryColumns.column_name;
        var geometryType = undefined;
        var dataType = undefined;
        if (geometry) {
            geometryType = wkb_1.WKB.fromName(type);
        }
        else {
            dataType = dataTypes_1.default.fromName(type);
        }
        var column = new featureColumn_1.default(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType);
        return column;
    };
    return FeatureTableReader;
}(userTableReader_1.default));
exports.default = FeatureTableReader;

},{"../../db/dataTypes":18,"../../user/userTableReader":125,"../../wkb":127,"../columns/geometryColumnsDao":74,"./featureColumn":75,"./featureTable":78}],80:[function(require,module,exports){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var crsWkt_1 = __importDefault(require("./extension/crsWkt"));
var relatedTables_1 = __importDefault(require("./extension/relatedTables"));
var _1 = __importDefault(require("./extension/style/."));
var _2 = __importDefault(require("./extension/contents/."));
var spatialReferenceSystemDao_1 = __importDefault(require("./core/srs/spatialReferenceSystemDao"));
var geometryColumnsDao_1 = __importDefault(require("./features/columns/geometryColumnsDao"));
var featureDao_1 = __importDefault(require("./features/user/featureDao"));
var featureTableReader_1 = __importDefault(require("./features/user/featureTableReader"));
var contentsDao_1 = __importDefault(require("./core/contents/contentsDao"));
var tileMatrixSetDao_1 = __importDefault(require("./tiles/matrixset/tileMatrixSetDao"));
var tileMatrixDao_1 = __importDefault(require("./tiles/matrix/tileMatrixDao"));
var dataColumnsDao_1 = __importDefault(require("./dataColumns/dataColumnsDao"));
var dataColumnConstraintsDao_1 = __importDefault(require("./dataColumnConstraints/dataColumnConstraintsDao"));
var metadataDao_1 = __importDefault(require("./metadata/metadataDao"));
var metadataReferenceDao_1 = __importDefault(require("./metadata/reference/metadataReferenceDao"));
var extensionDao_1 = __importDefault(require("./extension/extensionDao"));
var tableIndexDao_1 = __importDefault(require("./extension/index/tableIndexDao"));
var geometryIndexDao_1 = __importDefault(require("./extension/index/geometryIndexDao"));
var extendedRelationDao_1 = __importDefault(require("./extension/relatedTables/extendedRelationDao"));
var attributeDao_1 = __importDefault(require("./attributes/attributeDao"));
var tileDao_1 = __importDefault(require("./tiles/user/tileDao"));
var contentsIdDao_1 = __importDefault(require("./extension/contents/contentsIdDao"));
var attributeTable_1 = __importDefault(require("./attributes/attributeTable"));
var tileTableReader_1 = __importDefault(require("./tiles/user/tileTableReader"));
var attributeTableReader_1 = __importDefault(require("./attributes/attributeTableReader"));
var featureTable_1 = __importDefault(require("./features/user/featureTable"));
var styleMappingTable_1 = __importDefault(require("./extension/style/styleMappingTable"));
var tileTable_1 = __importDefault(require("./tiles/user/tileTable"));
var contents_1 = __importDefault(require("./core/contents/contents"));
var dataTypes_1 = __importDefault(require("./db/dataTypes"));
var schema_1 = __importDefault(require("./extension/schema"));
var tableCreator_1 = require("./db/tableCreator");
var tileMatrix_1 = require("./tiles/matrix/tileMatrix");
var tileBoundingBoxUtils_1 = require("./tiles/tileBoundingBoxUtils");
var tileMatrixSet_1 = require("./tiles/matrixset/tileMatrixSet");
var proj4_1 = __importDefault(require("proj4"));
var defs = __importStar(require("./proj4Defs"));
for (var def in defs) {
    if (defs[def]) {
        proj4_1.default.defs(def, defs[def]);
    }
}
/**
 * A `GeoPackage` instance is the interface to a physical GeoPackage SQLite
 * database.
 */
var GeoPackage = /** @class */ (function () {
    /**
     * Construct a new GeoPackage object
     * @param name name to give to this GeoPackage
     * @param path path to the GeoPackage
     * @param connection database connection to the GeoPackage
     */
    function GeoPackage(name, path, connection) {
        this.name = name;
        this.path = path;
        this.connection = connection;
        this.tableCreator = new tableCreator_1.TableCreator(this);
    }
    GeoPackage.prototype.close = function () {
        this.connection.close();
    };
    GeoPackage.prototype.getDatabase = function () {
        return this.connection;
    };
    GeoPackage.prototype.getPath = function () {
        return this.path;
    };
    GeoPackage.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.connection.export()];
            });
        });
    };
    /**
     * Get the GeoPackage name
     * @return the GeoPackage name
     */
    GeoPackage.prototype.getName = function () {
        return this.name;
    };
    /**
     * @returns {module:core/srs~SpatialReferenceSystemDao} the DAO to access the [SRS table]{@link module:core/srs~SpatialReferenceSystem} in this `GeoPackage`
     */
    GeoPackage.prototype.getSpatialReferenceSystemDao = function () {
        return this.spatialReferenceSystemDao || (this.spatialReferenceSystemDao = new spatialReferenceSystemDao_1.default(this));
    };
    /**
     * @returns {module:core/contents~ContentsDao} the DAO to access the [contents table]{@link module:core/contents~Contents} in this `GeoPackage`
     */
    GeoPackage.prototype.getContentsDao = function () {
        return this.contentsDao || (this.contentsDao = new contentsDao_1.default(this));
    };
    /**
     * @returns {module:tiles/matrixset~TileMatrixSetDao} the DAO to access the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet} in this `GeoPackage`
     */
    GeoPackage.prototype.getTileMatrixSetDao = function () {
        return this.tileMatrixSetDao || (this.tileMatrixSetDao = new tileMatrixSetDao_1.default(this));
    };
    /**
     * @returns {module:tiles/matrixset~TileMatrixDao} the DAO to access the [tile matrix]{@link module:tiles/matrixset~TileMatrix} in this `GeoPackage`
     */
    GeoPackage.prototype.getTileMatrixDao = function () {
        return this.tileMatrixDao || (this.tileMatrixDao = new tileMatrixDao_1.default(this));
    };
    GeoPackage.prototype.getDataColumnsDao = function () {
        return this.dataColumnsDao || (this.dataColumnsDao = new dataColumnsDao_1.default(this));
    };
    GeoPackage.prototype.getExtensionDao = function () {
        return this.extensionDao || (this.extensionDao = new extensionDao_1.default(this));
    };
    GeoPackage.prototype.getTableIndexDao = function () {
        return this.tableIndexDao || (this.tableIndexDao = new tableIndexDao_1.default(this));
    };
    GeoPackage.prototype.getGeometryColumnsDao = function () {
        return this.geometryColumnsDao || (this.geometryColumnsDao = new geometryColumnsDao_1.default(this));
    };
    GeoPackage.prototype.getDataColumnConstraintsDao = function () {
        return this.dataColumnConstraintsDao || (this.dataColumnConstraintsDao = new dataColumnConstraintsDao_1.default(this));
    };
    GeoPackage.prototype.getMetadataReferenceDao = function () {
        return this.metadataReferenceDao || (this.metadataReferenceDao = new metadataReferenceDao_1.default(this));
    };
    GeoPackage.prototype.getMetadataDao = function () {
        return this.metadataDao || (this.metadataDao = new metadataDao_1.default(this));
    };
    GeoPackage.prototype.getExtendedRelationDao = function () {
        return this.extendedRelationDao || (this.extendedRelationDao = new extendedRelationDao_1.default(this));
    };
    GeoPackage.prototype.getContentsIdDao = function () {
        return this.contentsIdDao || (this.contentsIdDao = new contentsIdDao_1.default(this));
    };
    GeoPackage.prototype.getContentsIdExtension = function () {
        return this.contentsIdExtension || (this.contentsIdExtension = new _2.default(this));
    };
    GeoPackage.prototype.getFeatureStyleExtension = function () {
        return this.featureStyleExtension || (this.featureStyleExtension = new _1.default(this));
    };
    GeoPackage.prototype.getGeometryIndexDao = function (featureDao) {
        return new geometryIndexDao_1.default(this, featureDao);
    };
    GeoPackage.prototype.getRelatedTablesExtension = function () {
        return this.relatedTablesExtension || (this.relatedTablesExtension = new relatedTables_1.default(this));
    };
    GeoPackage.prototype.getSrs = function (srsId) {
        var dao = this.getSpatialReferenceSystemDao();
        return dao.queryForId(srsId);
    };
    GeoPackage.prototype.createRequiredTables = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.tableCreator.createRequired()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this];
                }
            });
        });
    };
    GeoPackage.prototype.createSupportedExtensions = function () {
        var crs = new crsWkt_1.default(this);
        crs.getOrCreateExtension();
        var schema = new schema_1.default(this);
        schema.getOrCreateExtension();
        return this;
    };
    /**
     * @returns {module:tiles/user/tileDao~TileDao} the `TileDao` to access [tiles]{@link module:tiles/user/tileTable}
     */
    GeoPackage.prototype.getTileDaoWithTileMatrixSet = function (tileMatrixSet) {
        var tileMatrices = [];
        var tileMatrixDao = this.getTileMatrixDao();
        var results = tileMatrixDao.queryForAllEq(tileMatrixDao_1.default.COLUMN_TABLE_NAME, tileMatrixSet.table_name, null, null, tileMatrixDao_1.default.COLUMN_ZOOM_LEVEL + ' ASC, ' + tileMatrixDao_1.default.COLUMN_PIXEL_X_SIZE + ' DESC, ' + tileMatrixDao_1.default.COLUMN_PIXEL_Y_SIZE + ' DESC');
        results.forEach(function (result) {
            var tm = new tileMatrix_1.TileMatrix();
            tileMatrixDao.populateObjectFromResult(tm, result);
            tileMatrices.push(tm);
        });
        var tableReader = new tileTableReader_1.default(tileMatrixSet);
        var tileTable = tableReader.readTileTable(this);
        return new tileDao_1.default(this, tileTable, tileMatrixSet, tileMatrices);
    };
    GeoPackage.prototype.getTileDaoWithContents = function (contents) {
        var dao = this.getContentsDao();
        var tileMatrixSet = dao.getTileMatrixSet(contents);
        return this.getTileDaoWithTileMatrixSet(tileMatrixSet);
    };
    GeoPackage.prototype.getTileDao = function (tableName) {
        var tms = this.getTileMatrixSetDao();
        var results = tms.queryForAllEq(tileMatrixSetDao_1.default.COLUMN_TABLE_NAME, tableName);
        if (results.length > 1) {
            throw new Error('Unexpected state. More than one Tile Matrix Set matched for table name: ' + tableName + ', count: ' + results.length);
        }
        else if (results.length === 0) {
            throw new Error('No Tile Matrix found for table name: ' + tableName);
        }
        var tileMatrixSet = new tileMatrixSet_1.TileMatrixSet();
        tms.populateObjectFromResult(tileMatrixSet, results[0]);
        return this.getTileDaoWithTileMatrixSet(tileMatrixSet);
    };
    /**
     * Return a hash containing arrays of table names grouped under keys `features`,
     * `tiles`, and `attributes`.
     * @return {{features: string[], tiles: string[], attributes: string[]}}
     */
    GeoPackage.prototype.getTables = function () {
        var tables = {
            features: this.getFeatureTables(),
            tiles: this.getTileTables(),
            attributes: this.getAttributesTables()
        };
        return tables;
    };
    GeoPackage.prototype.getAttributesTables = function () {
        return this.getContentsDao().getTables(contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME);
    };
    GeoPackage.prototype.hasAttributeTable = function (attributeTableName) {
        var tables = this.getAttributesTables();
        return tables && tables.indexOf(attributeTableName) != -1;
    };
    /**
     *  Get the tile tables
     *  @returns {String[]} tile table names
     */
    GeoPackage.prototype.getTileTables = function () {
        var cd = this.getContentsDao();
        if (!cd.isTableExists()) {
            return [];
        }
        return cd.getTables(contentsDao_1.default.GPKG_CDT_TILES_NAME);
    };
    /**
     * Checks if the tile table exists in the GeoPackage
     * @param  {String} tileTableName name of the table to query for
     * @returns {Boolean} indicates the existence of the tile table
     */
    GeoPackage.prototype.hasTileTable = function (tileTableName) {
        var tables = this.getTileTables();
        return tables && tables.indexOf(tileTableName) !== -1;
    };
    /**
     * Checks if the feature table exists in the GeoPackage
     * @param  {String} featureTableName name of the table to query for
     * @returns {Boolean} indicates the existence of the feature table
     */
    GeoPackage.prototype.hasFeatureTable = function (featureTableName) {
        var tables = this.getFeatureTables();
        return tables && tables.indexOf(featureTableName) != -1;
    };
    /**
     *  Get the feature tables
     *  @returns {String[]} feature table names
     */
    GeoPackage.prototype.getFeatureTables = function () {
        var cd = this.getContentsDao();
        if (!cd.isTableExists()) {
            return [];
        }
        return cd.getTables(contentsDao_1.default.GPKG_CDT_FEATURES_NAME);
    };
    GeoPackage.prototype.isTable = function (tableName) {
        return !!this.connection.tableExists(tableName);
    };
    GeoPackage.prototype.isTableType = function (type, tableName) {
        return type === this.getTableType(tableName);
    };
    GeoPackage.prototype.getTableType = function (tableName) {
        var contents = this.getTableContents(tableName);
        if (contents) {
            return contents.data_type;
        }
    };
    GeoPackage.prototype.getTableContents = function (tableName) {
        return this.getContentsDao().queryForId(tableName);
    };
    GeoPackage.prototype.deleteTable = function (tableName) {
        this.connection.dropTable(tableName);
    };
    GeoPackage.prototype.getTableCreator = function () {
        return this.tableCreator;
    };
    GeoPackage.prototype.index = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tables, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tables = this.getFeatureTables();
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < tables.length)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.indexFeatureTable(tables[i])];
                    case 2:
                        if (!(_a.sent())) {
                            throw new Error('Unable to index table ' + tables[i]);
                        }
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/, true];
                }
            });
        });
    };
    GeoPackage.prototype.indexFeatureTable = function (table, progress) {
        return __awaiter(this, void 0, void 0, function () {
            var featureDao, fti, tableIndex;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        featureDao = this.getFeatureDao(table);
                        fti = featureDao.featureTableIndex;
                        tableIndex = fti.getTableIndex();
                        if (tableIndex) {
                            return [2 /*return*/, true];
                        }
                        return [4 /*yield*/, fti.index(progress)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     *  Get a Feature DAO from Geometry Columns
     *
     *  @param {GeometryColumns} geometryColumns Geometry Columns
     *  @returns {FeatureDao}
     */
    GeoPackage.prototype.getFeatureDaoWithGeometryColumns = function (geometryColumns) {
        if (!geometryColumns) {
            throw new Error('Non null Geometry Columns is required to create Feature DAO');
        }
        var tableReader = new featureTableReader_1.default(geometryColumns);
        var featureTable = tableReader.readFeatureTable(this);
        var dao = new featureDao_1.default(this, featureTable, geometryColumns, this.metadataDao);
        return dao;
    };
    /**
     * Get a Feature DAO from Contents
     * @param  {Contents}   contents Contents
     *  @returns {FeatureDao}
     */
    GeoPackage.prototype.getFeatureDaoWithContents = function (contents) {
        var dao = this.getContentsDao();
        var columns = dao.getGeometryColumns(contents);
        return this.getFeatureDaoWithGeometryColumns(columns);
    };
    /**
     * Get a Feature DAO from Contents
     * @param  {string}   tableName table name
     *  @returns {FeatureDao}
     */
    GeoPackage.prototype.getFeatureDao = function (tableName) {
        var dao = this.getGeometryColumnsDao();
        var geometryColumns = dao.queryForTableName(tableName);
        if (!geometryColumns) {
            throw new Error('No Feature Table exists for table name: ' + tableName);
        }
        return this.getFeatureDaoWithGeometryColumns(geometryColumns);
    };
    /**
     * Queries for GeoJSON features in a feature table
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     * @returns {Object[]} array of GeoJSON features
     */
    GeoPackage.prototype.queryForGeoJSONFeaturesInTable = function (tableName, boundingBox) {
        var e_1, _a;
        var featureDao = this.getFeatureDao(tableName);
        var features = [];
        var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
        try {
            for (var iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next(); !iterator_1_1.done; iterator_1_1 = iterator_1.next()) {
                var feature = iterator_1_1.value;
                features.push(feature);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return features;
    };
    /**
     * iterates GeoJSON features in a feature table within a bounding box
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     * @returns {Iterable<Object>} iterable of GeoJSON features
     */
    GeoPackage.prototype.iterateGeoJSONFeaturesInTableWithinBoundingBox = function (tableName, boundingBox) {
        var featureDao = this.getFeatureDao(tableName);
        return featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
    };
    /**
     * Create the Geometry Columns table if it does not already exist
     * @returns {Promise}
     */
    GeoPackage.prototype.createGeometryColumnsTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getGeometryColumnsDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createGeometryColumns()];
            });
        });
    };
    /**
     * Get a Attribute DAO
     * @param  {string}   tableName table name
     * @returns {AttributeDao}
     */
    GeoPackage.prototype.getAttributeDaoWithTableName = function (tableName) {
        var dao = this.getContentsDao();
        var contents = dao.queryForId(tableName);
        return this.getAttributeDaoWithContents(contents);
    };
    /**
     * Get a Attribute DAO
     * @param  {Contents}   contents Contents
     * @returns {AttributeDao}
     */
    GeoPackage.prototype.getAttributeDaoWithContents = function (contents) {
        if (!contents) {
            throw new Error('Non null Contents is required to create an Attributes DAO');
        }
        var reader = new attributeTableReader_1.default(contents.table_name);
        var table = reader.readTable(this.connection);
        table.setContents(contents);
        return new attributeDao_1.default(this, table);
    };
    GeoPackage.prototype.createAttributeTable = function (tableName, columns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var attributeTable, contents, dataColumnsDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        attributeTable = new attributeTable_1.default(tableName, columns);
                        this.tableCreator.createUserTable(attributeTable);
                        contents = new contents_1.default();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        this.getContentsDao().create(contents);
                        if (!(dataColumns && dataColumns.length)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 1:
                        _a.sent();
                        dataColumnsDao = this.getDataColumnsDao();
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao.create(dataColumn);
                        });
                        _a.label = 2;
                    case 2: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Create the given {@link module:features/user/featureTable~FeatureTable}
     * @param  {FeatureTable}   featureTable    feature table
     */
    GeoPackage.prototype.createFeatureTable = function (featureTable) {
        return this.tableCreator.createUserTable(featureTable);
    };
    GeoPackage.prototype.createFeatureTableWithGeometryColumns = function (geometryColumns, boundingBox, srsId, columns) {
        return this.createFeatureTableWithGeometryColumnsAndDataColumns(geometryColumns, boundingBox, srsId, columns, undefined);
    };
    GeoPackage.prototype.createFeatureTableWithGeometryColumnsAndDataColumns = function (geometryColumns, boundingBox, srsId, columns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var featureTable, contents, dataColumnsDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.createGeometryColumnsTable()];
                    case 1:
                        _a.sent();
                        featureTable = new featureTable_1.default(geometryColumns.table_name, columns);
                        this.createFeatureTable(featureTable);
                        contents = new contents_1.default();
                        contents.table_name = geometryColumns.table_name;
                        contents.data_type = contentsDao_1.default.GPKG_CDT_FEATURES_NAME;
                        contents.identifier = geometryColumns.table_name;
                        contents.last_change = new Date().toISOString();
                        contents.min_x = boundingBox.minLongitude;
                        contents.min_y = boundingBox.minLatitude;
                        contents.max_x = boundingBox.maxLongitude;
                        contents.max_y = boundingBox.maxLatitude;
                        contents.srs_id = srsId;
                        this.getContentsDao().create(contents);
                        geometryColumns.srs_id = srsId;
                        this.getGeometryColumnsDao().create(geometryColumns);
                        if (!dataColumns) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 2:
                        _a.sent();
                        dataColumnsDao = this.getDataColumnsDao();
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao.create(dataColumn);
                        });
                        _a.label = 3;
                    case 3: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Create the Tile Matrix Set table if it does not already exist
     * @returns {Promise} resolves when the table is created
     */
    GeoPackage.prototype.createTileMatrixSetTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getTileMatrixSetDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTileMatrixSet()];
            });
        });
    };
    /**
     * Create the Tile Matrix table if it does not already exist
     * @returns {Promise} resolves when the table is created
     */
    GeoPackage.prototype.createTileMatrixTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getTileMatrixDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTileMatrix()];
            });
        });
    };
    /**
     * Create the given tile table in this GeoPackage.
     *
     * @param  {module:tiles/user/tileTable~TileTable} tileTable
     * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
     */
    GeoPackage.prototype.createTileTable = function (tileTable) {
        return this.tableCreator.createUserTable(tileTable);
    };
    /**
     * Create a new [tile table]{@link module:tiles/user/tileTable~TileTable} in this GeoPackage.
     *
     * @param {String} tableName tile table name
     * @param {BoundingBox} contentsBoundingBox bounding box of the contents table
     * @param {Number} contentsSrsId srs id of the contents table
     * @param {BoundingBox} tileMatrixSetBoundingBox bounding box of the matrix set
     * @param {Number} tileMatrixSetSrsId srs id of the matrix set
     * @returns {Promise<TileMatrixSet>} `Promise` of the created {@link module:tiles/matrixset~TileMatrixSet}
     */
    GeoPackage.prototype.createTileTableWithTableName = function (tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId) {
        return __awaiter(this, void 0, void 0, function () {
            var columns, tileTable, contents, tileMatrixSet;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        columns = tileTable_1.default.createRequiredColumns();
                        tileTable = new tileTable_1.default(tableName, columns);
                        contents = new contents_1.default();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.default.GPKG_CDT_TILES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        contents.min_x = contentsBoundingBox.minLongitude;
                        contents.min_y = contentsBoundingBox.minLatitude;
                        contents.max_x = contentsBoundingBox.maxLongitude;
                        contents.max_y = contentsBoundingBox.maxLatitude;
                        contents.srs_id = contentsSrsId;
                        tileMatrixSet = new tileMatrixSet_1.TileMatrixSet();
                        tileMatrixSet.setContents(contents);
                        tileMatrixSet.srs_id = tileMatrixSetSrsId;
                        tileMatrixSet.min_x = tileMatrixSetBoundingBox.minLongitude;
                        tileMatrixSet.min_y = tileMatrixSetBoundingBox.minLatitude;
                        tileMatrixSet.max_x = tileMatrixSetBoundingBox.maxLongitude;
                        tileMatrixSet.max_y = tileMatrixSetBoundingBox.maxLatitude;
                        return [4 /*yield*/, this.createTileMatrixSetTable()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.createTileMatrixTable()];
                    case 2:
                        _a.sent();
                        this.createTileTable(tileTable);
                        this.getContentsDao().create(contents);
                        this.getTileMatrixSetDao().create(tileMatrixSet);
                        return [2 /*return*/, tileMatrixSet];
                }
            });
        });
    };
    /**
     * Create the tables and rows necessary to store tiles in a {@link module:tiles/matrixset~TileMatrixSet}.
     * This will create a [tile matrix row]{@link module:tiles/matrix~TileMatrix}
     * for every integral zoom level in the range `[minZoom..maxZoom]`.
     *
     * @param {BoundingBox} epsg3857TileBoundingBox
     * @param {TileMatrixSet} tileMatrixSet
     * @param {number} minZoom
     * @param {number} maxZoom
     * @param {number} [tileSize=256] optional tile size in pixels
     * @returns {module:geoPackage~GeoPackage} `this` `GeoPackage`
     */
    GeoPackage.prototype.createStandardWebMercatorTileMatrix = function (epsg3857TileBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize) {
        if (tileSize === void 0) { tileSize = 256; }
        tileSize = tileSize || 256;
        var tileMatrixDao = this.getTileMatrixDao();
        for (var zoom = minZoom; zoom <= maxZoom; zoom++) {
            var box = tileBoundingBoxUtils_1.TileBoundingBoxUtils.webMercatorTileBox(epsg3857TileBoundingBox, zoom);
            var matrixWidth = (box.maxX - box.minX) + 1;
            var matrixHeight = (box.maxY - box.minY) + 1;
            var pixelXSize = ((epsg3857TileBoundingBox.maxLongitude - epsg3857TileBoundingBox.minLongitude) / matrixWidth) / tileSize;
            var pixelYSize = ((epsg3857TileBoundingBox.maxLatitude - epsg3857TileBoundingBox.minLatitude) / matrixHeight) / tileSize;
            var tileMatrix = new tileMatrix_1.TileMatrix();
            tileMatrix.table_name = tileMatrixSet.table_name;
            tileMatrix.zoom_level = zoom;
            tileMatrix.matrix_width = matrixWidth;
            tileMatrix.matrix_height = matrixHeight;
            tileMatrix.tile_width = tileSize;
            tileMatrix.tile_height = tileSize;
            tileMatrix.pixel_x_size = pixelXSize;
            tileMatrix.pixel_y_size = pixelYSize;
            tileMatrixDao.create(tileMatrix);
        }
        return this;
    };
    /**
     * Adds a tile to the GeoPackage
     * @param  {object}   tileStream       Byte array or Buffer containing the tile bytes
     * @param  {String}   tableName  Table name to add the tile to
     * @param  {Number}   zoom       zoom level of this tile
     * @param  {Number}   tileRow    row of this tile
     * @param  {Number}   tileColumn column of this tile
     */
    GeoPackage.prototype.addTile = function (tileStream, tableName, zoom, tileRow, tileColumn) {
        var tileDao = this.getTileDao(tableName);
        var newRow = tileDao.newRow();
        newRow.setZoomLevel(zoom);
        newRow.setTileColumn(tileColumn);
        newRow.setTileRow(tileRow);
        newRow.setTileData(tileStream);
        return tileDao.create(newRow);
    };
    /**
     * Create the Data Columns table if it does not already exist
     */
    GeoPackage.prototype.createDataColumns = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getDataColumnsDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createDataColumns()];
            });
        });
    };
    /**
     * Create the Data Column Constraints table if it does not already exist
     */
    GeoPackage.prototype.createDataColumnConstraintsTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getDataColumnConstraintsDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createDataColumnConstraints()];
            });
        });
    };
    GeoPackage.prototype.createMetadataTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getMetadataDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createMetadata()];
            });
        });
    };
    GeoPackage.prototype.createMetadataReferenceTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getMetadataReferenceDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createMetadataReference()];
            });
        });
    };
    GeoPackage.prototype.createExtensionTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getExtensionDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createExtensions()];
            });
        });
    };
    GeoPackage.prototype.createTableIndexTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getTableIndexDao();
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTableIndex()];
            });
        });
    };
    GeoPackage.prototype.createGeometryIndexTable = function (featureDao) {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getGeometryIndexDao(featureDao);
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createGeometryIndex()];
            });
        });
    };
    GeoPackage.prototype.createStyleMappingTable = function (tableName, columns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var attributeTable, contents, dataColumnsDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        attributeTable = new styleMappingTable_1.default(tableName, columns);
                        this.tableCreator.createUserTable(attributeTable);
                        contents = new contents_1.default();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.default.GPKG_CDT_ATTRIBUTES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        this.getContentsDao().create(contents);
                        if (!dataColumns) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 1:
                        _a.sent();
                        dataColumnsDao = this.getDataColumnsDao();
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao.create(dataColumn);
                        });
                        _a.label = 2;
                    case 2: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Get the application id of the GeoPackage
     * @returns {string} application id
     */
    GeoPackage.prototype.getApplicationId = function () {
        var connection = this.getDatabase();
        return connection.getApplicationId();
    };
    GeoPackage.prototype.getInfoForTable = function (tableDao) {
        var info = {
            tableName: tableDao.table_name,
            tableType: tableDao.table.getTableType(),
            count: tableDao.getCount(),
            geometryColumns: undefined,
            minZoom: undefined,
            maxZoom: undefined,
            minWebMapZoom: undefined,
            maxWebMapZoom: undefined,
            zoomLevels: undefined,
            tileMatrixSet: undefined,
            contents: undefined,
            srs: undefined,
            columns: undefined,
            columnMap: undefined,
        };
        if (tableDao instanceof featureDao_1.default) {
            info.geometryColumns = {};
            info.geometryColumns.tableName = tableDao.geometryColumns.table_name;
            info.geometryColumns.geometryColumn = tableDao.geometryColumns.column_name;
            info.geometryColumns.geometryTypeName = tableDao.geometryColumns.geometry_type_name;
            info.geometryColumns.z = tableDao.geometryColumns.z;
            info.geometryColumns.m = tableDao.geometryColumns.m;
        }
        if (tableDao instanceof tileDao_1.default) {
            info.minZoom = tableDao.minZoom;
            info.maxZoom = tableDao.maxZoom;
            info.minWebMapZoom = tableDao.minWebMapZoom;
            info.maxWebMapZoom = tableDao.maxWebMapZoom;
            info.zoomLevels = tableDao.tileMatrices.length;
        }
        var dao;
        var contentsRetriever;
        if (tableDao instanceof featureDao_1.default) {
            dao = this.getGeometryColumnsDao();
            contentsRetriever = tableDao.geometryColumns;
        }
        else if (tableDao instanceof tileDao_1.default) {
            dao = this.getTileMatrixSetDao();
            contentsRetriever = tableDao.tileMatrixSet;
            info.tileMatrixSet = {};
            info.tileMatrixSet.srsId = tableDao.tileMatrixSet.srs_id;
            info.tileMatrixSet.minX = tableDao.tileMatrixSet.min_x;
            info.tileMatrixSet.maxX = tableDao.tileMatrixSet.max_x;
            info.tileMatrixSet.minY = tableDao.tileMatrixSet.min_y;
            info.tileMatrixSet.maxY = tableDao.tileMatrixSet.max_y;
        }
        var contents = dao.getContents(contentsRetriever);
        info.contents = {};
        info.contents.tableName = contents.table_name;
        info.contents.dataType = contents.data_type;
        info.contents.identifier = contents.identifier;
        info.contents.description = contents.description;
        info.contents.lastChange = contents.last_change;
        info.contents.minX = contents.min_x;
        info.contents.maxX = contents.max_x;
        info.contents.minY = contents.min_y;
        info.contents.maxY = contents.max_y;
        var contentsDao = this.getContentsDao();
        var contentsSrs = contentsDao.getSrs(contents);
        info.contents.srs = {
            name: contentsSrs.srs_name,
            id: contentsSrs.srs_id,
            organization: contentsSrs.organization,
            organization_coordsys_id: contentsSrs.organization_coordsys_id,
            definition: contentsSrs.definition,
            description: contentsSrs.description
        };
        var srs = tableDao.getSrs();
        info.srs = {
            name: srs.srs_name,
            id: srs.srs_id,
            organization: srs.organization,
            organization_coordsys_id: srs.organization_coordsys_id,
            definition: srs.definition,
            description: srs.description
        };
        info.columns = [];
        info.columnMap = {};
        var dcd = this.getDataColumnsDao();
        tableDao.table.columns.forEach(function (column) {
            var dataColumn = dcd.getDataColumns(tableDao.table.table_name, column.name);
            info.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType ? dataTypes_1.default.nameFromType(column.dataType) : '',
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn
            });
            info.columnMap[column.name] = info.columns[info.columns.length - 1];
        }.bind(this));
        return info;
    };
    GeoPackage.loadProjections = function (items) {
        if (!items)
            throw new Error('Invalid array of projections');
        for (var i = 0; i < items.length; i++) {
            if (!defs[items[i]])
                throw new Error('Projection not found');
            this.addProjection(items[i], defs[items[i]]);
        }
    };
    GeoPackage.addProjection = function (name, definition) {
        if (!name || !definition)
            throw new Error('Invalid projection name/definition');
        proj4_1.default.defs('' + name, '' + definition);
    };
    GeoPackage.hasProjection = function (name) {
        return proj4_1.default.defs('' + name);
    };
    return GeoPackage;
}());
exports.default = GeoPackage;

},{"./attributes/attributeDao":3,"./attributes/attributeTable":5,"./attributes/attributeTableReader":6,"./core/contents/contents":8,"./core/contents/contentsDao":9,"./core/srs/spatialReferenceSystemDao":11,"./dataColumnConstraints/dataColumnConstraintsDao":15,"./dataColumns/dataColumnsDao":17,"./db/dataTypes":18,"./db/tableCreator":23,"./extension/contents/.":27,"./extension/contents/contentsIdDao":26,"./extension/crsWkt":28,"./extension/extensionDao":30,"./extension/index/geometryIndexDao":33,"./extension/index/tableIndexDao":35,"./extension/relatedTables":40,"./extension/relatedTables/extendedRelationDao":39,"./extension/schema":54,"./extension/style/.":63,"./extension/style/styleMappingTable":67,"./features/columns/geometryColumnsDao":74,"./features/user/featureDao":76,"./features/user/featureTable":78,"./features/user/featureTableReader":79,"./metadata/metadataDao":85,"./metadata/reference/metadataReferenceDao":87,"./proj4Defs":89,"./tiles/matrix/tileMatrix":105,"./tiles/matrix/tileMatrixDao":106,"./tiles/matrixset/tileMatrixSet":107,"./tiles/matrixset/tileMatrixSetDao":108,"./tiles/tileBoundingBoxUtils":110,"./tiles/user/tileDao":113,"./tiles/user/tileTable":115,"./tiles/user/tileTableReader":116,"proj4":319}],81:[function(require,module,exports){
"use strict";
/**
 * GeoPackage Constants module.
 * @module dao/geoPackageConstants
 */
Object.defineProperty(exports, "__esModule", { value: true });
var GeoPackageConstants = /** @class */ (function () {
    function GeoPackageConstants() {
    }
    /** @constant {string} GEOPACKAGE_EXTENSION Extension to GeoPackage files */
    GeoPackageConstants.GEOPACKAGE_EXTENSION = 'gpkg';
    /** @constant {string} GEOPACKAGE_EXTENDED_EXTENSION Extension to GeoPackage extension files */
    GeoPackageConstants.GEOPACKAGE_EXTENDED_EXTENSION = 'gpkx';
    /** @constant {string} APPLICATION_ID GeoPackage application id */
    GeoPackageConstants.APPLICATION_ID = 'GPKG';
    /** @constant {string} USER_VERSION GeoPackage user version */
    GeoPackageConstants.USER_VERSION = '10200';
    /** @constant {string} GEOPACKAGE_EXTENSION_AUTHOR GeoPackage author */
    GeoPackageConstants.GEOPACKAGE_EXTENSION_AUTHOR = exports.GEOPACKAGE_EXTENSION;
    /** @constant {string} GEOMETRY_EXTENSION_PREFIX Geometry extension prefix */
    GeoPackageConstants.GEOMETRY_EXTENSION_PREFIX = 'geom';
    /** @constant {string} GEOPACKAGE_GEOMETRY_MAGIX_NUMBER Expected magic number */
    GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER = 'GP';
    /** @constant {string} GEOPACKAGE_GEOMETRY_VERSION_1 Expected version 1 value */
    GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1 = 0;
    /** @constant {string} SQLITE_HEADER_PREFIX SQLite header string prefix */
    GeoPackageConstants.SQLITE_HEADER_PREFIX = 'SQLite format 3';
    return GeoPackageConstants;
}());
exports.GeoPackageConstants = GeoPackageConstants;

},{}],82:[function(require,module,exports){
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bbox_1 = __importDefault(require("@turf/bbox"));
var DataTypes = /** @class */ (function () {
    function DataTypes() {
    }
    DataTypes.buildEnvelopeWithGeometry = function (wkbGeometry) {
        var geoJson = wkbGeometry.toGeoJSON();
        var bbox = bbox_1.default(geoJson);
        return {
            minX: bbox[0],
            minY: bbox[1],
            maxX: bbox[2],
            maxY: bbox[3]
        };
    };
    return DataTypes;
}());
exports.default = DataTypes;

},{"@turf/bbox":133}],83:[function(require,module,exports){
(function (Buffer){
"use strict";
/**
 * GeometryData module.
 * @module geom/geometryData
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var wkx_1 = __importDefault(require("wkx"));
var geoPackageConstants_1 = require("../geoPackageConstants");
/**
 * GeoPackage Geometry Data
 */
var GeometryData = /** @class */ (function () {
    function GeometryData(buffer) {
        this.empty = true;
        this.byteOrder = GeometryData.BIG_ENDIAN;
        if (buffer) {
            this.fromData(buffer);
        }
    }
    GeometryData.prototype.setSrsId = function (srsId) {
        this.srsId = srsId;
    };
    GeometryData.prototype.setGeometry = function (wkbGeometry) {
        this.empty = false;
        this.geometry = wkbGeometry;
    };
    GeometryData.prototype.setEnvelope = function (envelope) {
        this.envelope = envelope;
    };
    GeometryData.prototype.toGeoJSON = function () {
        return this.geometry.toGeoJSON();
    };
    GeometryData.prototype.fromData = function (buffer) {
        this.buffer = buffer;
        if (buffer instanceof Uint8Array) {
            this.buffer = buffer = Buffer.from(buffer);
        }
        var magicString = buffer.toString('ascii', 0, 2);
        if (magicString !== geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER) {
            throw new Error('Unexpected GeoPackage Geometry magic number: ' + magicString + ', Expected: ' + geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER);
        }
        var version = buffer.readUInt8(2);
        if (version !== geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1) {
            throw new Error('Unexpected GeoPackage Geometry version ' + version + ', Expected: ' + geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1);
        }
        var flags = buffer.readUInt8(3);
        var envelopeIndicator = this.readFlags(flags);
        this.srsId = buffer[this.byteOrder ? 'readUInt32LE' : 'readUInt32BE'](4);
        var envelopeAndOffset = this.readEnvelope(envelopeIndicator, buffer);
        this.envelope = envelopeAndOffset.envelope;
        var offset = envelopeAndOffset.offset;
        var wkbBuffer = buffer.slice(offset);
        try {
            this.geometry = wkx_1.default.Geometry.parse(wkbBuffer);
            this.geometryError = undefined;
        }
        catch (error) {
            this.geometryError = error.message;
            console.log('Error parsing geometry');
        }
    };
    GeometryData.prototype.toData = function () {
        var header = Buffer.alloc(8);
        // Write GP as the 2 byte magic number
        header.write(geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER);
        // Write a byte as the version value of 0 = version 1
        header.writeUInt8(geoPackageConstants_1.GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1, 2);
        // Build and write a flags byte
        var flags = this.buildFlagsByte();
        header.writeUInt8(flags, 3);
        // write the 4 byte srs id
        header[this.byteOrder ? 'writeUInt32LE' : 'writeUInt32BE'](this.srsId, 4);
        var envelopeBuffer = this.writeEnvelope();
        var concatArray = [header, envelopeBuffer];
        try {
            concatArray.push(this.geometry.toWkb());
            this.geometryError = undefined;
        }
        catch (error) {
            this.geometryError = error.message;
        }
        this.buffer = Buffer.concat(concatArray);
        return this.buffer;
    };
    GeometryData.prototype.writeEnvelope = function () {
        if (!this.envelope)
            return Buffer.alloc(0);
        var writeDoubleMethod = 'writeDouble' + (this.byteOrder ? 'LE' : 'BE');
        var length = 32;
        if (this.envelope.hasZ) {
            length += 16;
        }
        if (this.envelope.hasM) {
            length += 16;
        }
        var envelopeBuffer = Buffer.alloc(length);
        envelopeBuffer[writeDoubleMethod](this.envelope.minX, 0);
        envelopeBuffer[writeDoubleMethod](this.envelope.maxX, 8);
        envelopeBuffer[writeDoubleMethod](this.envelope.minY, 16);
        envelopeBuffer[writeDoubleMethod](this.envelope.maxY, 24);
        var position = 32;
        if (this.envelope.hasZ) {
            envelopeBuffer[writeDoubleMethod](this.envelope.minZ, position);
            envelopeBuffer[writeDoubleMethod](this.envelope.maxZ, position + 8);
            position = 48;
        }
        if (this.envelope.hasM) {
            envelopeBuffer[writeDoubleMethod](this.envelope.minM, position);
            envelopeBuffer[writeDoubleMethod](this.envelope.maxM, position + 8);
        }
        return envelopeBuffer;
    };
    GeometryData.prototype.buildFlagsByte = function () {
        var flag = 0;
        // Add the binary type to bit 5, 0 for standard and 1 for extended
        var binaryType = this.extended ? 1 : 0;
        flag += (binaryType << 5);
        // Add the empty geometry flag to bit 4, 0 for non-empty and 1 for empty
        var emptyValue = this.empty ? 1 : 0;
        flag += (emptyValue << 4);
        // Add the envelope contents indicator code (3-bit unsigned integer to bits 3, 2, and 1)
        var envelopeIndicator = !this.envelope ? 0 : this.getIndicatorWithEnvelope(this.envelope);
        flag += (envelopeIndicator << 1);
        // Add the byte order to bit 0, 0 for Big Endian and 1 for Little Endian
        var byteOrderValue = (this.byteOrder === GeometryData.BIG_ENDIAN) ? 0 : 1;
        flag += byteOrderValue;
        return flag;
    };
    GeometryData.prototype.getIndicatorWithEnvelope = function (envelope) {
        var indicator = 1;
        if (envelope.hasZ) {
            indicator++;
        }
        if (envelope.hasM) {
            indicator += 2;
        }
        return indicator;
    };
    GeometryData.prototype.readFlags = function (flagsInt) {
        // Verify the reserved bits at 7 and 6 are 0
        var reserved7 = (flagsInt >> 7) & 1;
        var reserved6 = (flagsInt >> 6) & 1;
        if (reserved7 !== 0 || reserved6 !== 0) {
            throw new Error('Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=' + reserved7 + ', 6=' + reserved6);
        }
        // Get the binary type from bit 5, 0 for standard and 1 for extended
        var binaryType = (flagsInt >> 5) & 1;
        this.extended = binaryType === 1;
        // Get the empty geometry flag from bit 4, 0 for non-empty and 1 for
        // empty
        var emptyValue = (flagsInt >> 4) & 1;
        this.empty = emptyValue === 1;
        // Get the envelope contents indicator code (3-bit unsigned integer from
        // bits 3, 2, and 1)
        var envelopeIndicator = (flagsInt >> 1) & 7;
        if (envelopeIndicator > 4) {
            throw new Error('Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: ' + envelopeIndicator);
        }
        // Get the byte order from bit 0, 0 for Big Endian and 1 for Little Endian
        var byteOrderValue = flagsInt & 1;
        this.byteOrder = byteOrderValue;
        return envelopeIndicator;
    };
    GeometryData.prototype.readEnvelope = function (envelopeIndicator, buffer) {
        var readDoubleMethod = 'readDouble' + (this.byteOrder ? 'LE' : 'BE');
        var envelopeByteOffset = 8;
        var reads = 0;
        var envelopeAndOffset = {
            envelope: undefined,
            offset: envelopeByteOffset
        };
        if (envelopeIndicator <= 0) {
            return envelopeAndOffset;
        }
        var envelope = {
            minX: null,
            maxX: null,
            minY: null,
            maxY: null,
            hasZ: false,
            hasM: false,
            minZ: null,
            maxZ: null,
            minM: null,
            maxM: null
        };
        // Read x and y values and create envelope
        envelope.minX = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        envelope.maxX = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        envelope.minY = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        envelope.maxY = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        envelope.hasZ = false;
        envelope.hasM = false;
        // Read z values
        if (envelopeIndicator === 2 || envelopeIndicator === 4) {
            envelope.hasZ = true;
            envelope.minZ = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
            envelope.maxZ = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        }
        // Read m values
        if (envelopeIndicator === 3 || envelopeIndicator === 4) {
            envelope.hasM = true;
            envelope.minM = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
            envelope.maxM = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
        }
        envelopeAndOffset.envelope = envelope;
        envelopeAndOffset.offset = envelopeByteOffset + (8 * reads);
        return envelopeAndOffset;
    };
    GeometryData.BIG_ENDIAN = 0;
    GeometryData.LITTLE_ENDIAN = 1;
    return GeometryData;
}());
exports.GeometryData = GeometryData;

}).call(this,require("buffer").Buffer)
},{"../geoPackageConstants":81,"buffer":197,"wkx":407}],84:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Contains metadata in MIME encodings structured in accordance with any
 * authoritative metadata specification
 * @class Metadata
 */
var Metadata = /** @class */ (function () {
    function Metadata() {
    }
    // eslint-disable-next-line complexity
    Metadata.prototype.getScopeInformation = function (type) {
        switch (type) {
            case Metadata.UNDEFINED:
                return {
                    name: Metadata.UNDEFINED,
                    code: 'NA',
                    definition: 'Metadata information scope is undefined'
                };
            case Metadata.FIELD_SESSION:
                return {
                    name: Metadata.FIELD_SESSION,
                    code: '012',
                    definition: 'Information applies to the field session'
                };
            case Metadata.COLLECTION_SESSION:
                return {
                    name: Metadata.COLLECTION_SESSION,
                    code: '004',
                    definition: 'Information applies to the collection session'
                };
            case Metadata.SERIES:
                return {
                    name: Metadata.SERIES,
                    code: '006',
                    definition: 'Information applies to the (dataset) series'
                };
            case Metadata.DATASET:
                return {
                    name: Metadata.DATASET,
                    code: '005',
                    definition: 'Information applies to the (geographic feature) dataset'
                };
            case Metadata.FEATURE_TYPE:
                return {
                    name: Metadata.FEATURE_TYPE,
                    code: '010',
                    definition: 'Information applies to a feature type (class)'
                };
            case Metadata.FEATURE:
                return {
                    name: Metadata.FEATURE,
                    code: '009',
                    definition: 'Information applies to a feature (instance)'
                };
            case Metadata.ATTRIBUTE_TYPE:
                return {
                    name: Metadata.ATTRIBUTE_TYPE,
                    code: '002',
                    definition: 'Information applies to the attribute class'
                };
            case Metadata.ATTRIBUTE:
                return {
                    name: Metadata.ATTRIBUTE,
                    code: '001',
                    definition: 'Information applies to the characteristic of a feature (instance)'
                };
            case Metadata.TILE:
                return {
                    name: Metadata.TILE,
                    code: '016',
                    definition: 'Information applies to a tile, a spatial subset of geographic data'
                };
            case Metadata.MODEL:
                return {
                    name: Metadata.MODEL,
                    code: '015',
                    definition: 'Information applies to a copy or imitation of an existing or hypothetical object'
                };
            case Metadata.CATALOG:
                return {
                    name: Metadata.CATALOG,
                    code: 'NA',
                    definition: 'Metadata applies to a feature catalog'
                };
            case Metadata.SCHEMA:
                return {
                    name: Metadata.SCHEMA,
                    code: 'NA',
                    definition: 'Metadata applies to an application schema'
                };
            case Metadata.TAXONOMY:
                return {
                    name: Metadata.TAXONOMY,
                    code: 'NA',
                    definition: 'Metadata applies to a taxonomy or knowledge system'
                };
            case Metadata.SOFTWARE:
                return {
                    name: Metadata.SOFTWARE,
                    code: '013',
                    definition: 'Information applies to a computer program or routine'
                };
            case Metadata.SERVICE:
                return {
                    name: Metadata.SERVICE,
                    code: '014',
                    definition: 'Information applies to a capability which a service provider entity makes available to a service user entity through a set of interfaces that define a behaviour, such as a use case'
                };
            case Metadata.COLLECTION_HARDWARE:
                return {
                    name: Metadata.COLLECTION_HARDWARE,
                    code: '003',
                    definition: 'Information applies to the collection hardware class'
                };
            case Metadata.NON_GEOGRAPHIC_DATASET:
                return {
                    name: Metadata.NON_GEOGRAPHIC_DATASET,
                    code: '007',
                    definition: 'Information applies to non-geographic data'
                };
            case Metadata.DIMENSION_GROUP:
                return {
                    name: Metadata.DIMENSION_GROUP,
                    code: '008',
                    definition: 'Information applies to a dimension group'
                };
        }
    };
    Metadata.UNDEFINED = "undefined";
    Metadata.FIELD_SESSION = "fieldSession";
    Metadata.COLLECTION_SESSION = "collectionSession";
    Metadata.SERIES = "series";
    Metadata.DATASET = "dataset";
    Metadata.FEATURE_TYPE = "featureType";
    Metadata.FEATURE = "feature";
    Metadata.ATTRIBUTE_TYPE = "attributeType";
    Metadata.ATTRIBUTE = "attribute";
    Metadata.TILE = "tile";
    Metadata.MODEL = "model";
    Metadata.CATALOG = "catalog";
    Metadata.SCHEMA = "schema";
    Metadata.TAXONOMY = "taxonomy";
    Metadata.SOFTWARE = "software";
    Metadata.SERVICE = "service";
    Metadata.COLLECTION_HARDWARE = "collectionHardware";
    Metadata.NON_GEOGRAPHIC_DATASET = "nonGeographicDataset";
    Metadata.DIMENSION_GROUP = "dimensionGroup";
    return Metadata;
}());
exports.Metadata = Metadata;

},{}],85:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Metadata module.
 * @module metadata
 * @see module:dao/dao
 */
var dao_1 = __importDefault(require("../dao/dao"));
var metadata_1 = require("./metadata");
/**
 * Metadata Data Access Object
 * @class
 * @extends Dao
 */
var MetadataDao = /** @class */ (function (_super) {
    __extends(MetadataDao, _super);
    function MetadataDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = MetadataDao.TABLE_NAME;
        _this.idColumns = [MetadataDao.COLUMN_ID];
        return _this;
    }
    MetadataDao.prototype.createObject = function () {
        return new metadata_1.Metadata();
    };
    MetadataDao.TABLE_NAME = "gpkg_metadata";
    MetadataDao.COLUMN_ID = "id";
    MetadataDao.COLUMN_MD_SCOPE = "md_scope";
    MetadataDao.COLUMN_MD_STANDARD_URI = "md_standard_uri";
    MetadataDao.COLUMN_MIME_TYPE = "mime_type";
    MetadataDao.COLUMN_METADATA = "metadata";
    return MetadataDao;
}(dao_1.default));
exports.default = MetadataDao;

},{"../dao/dao":13,"./metadata":84}],86:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Links metadata in the gpkg_metadata table to data in the feature, and tiles tables
 * @class MetadataReference
 */
var MetadataReference = /** @class */ (function () {
    function MetadataReference() {
    }
    /**
     * @param {string} columnName
     */
    MetadataReference.prototype.toDatabaseValue = function (columnName) {
        if (columnName === 'timestamp') {
            return this.timestamp.toISOString();
        }
        return this[columnName];
    };
    /**
     * Set the metadata
     * @param  {Metadata} [metadata] metadata
     */
    MetadataReference.prototype.setMetadata = function (metadata) {
        if (metadata) {
            this.md_file_id = metadata.id;
        }
        else {
            this.md_file_id = -1;
        }
    };
    /**
     * Set the parent metadata
     * @param  {Metadata} [metadata] parent metadata
     */
    MetadataReference.prototype.setParentMetadata = function (metadata) {
        if (metadata) {
            this.md_parent_id = metadata.id;
        }
        else {
            this.md_parent_id = -1;
        }
    };
    MetadataReference.prototype.setReferenceScopeType = function (referenceScopeType) {
        this.reference_scope = referenceScopeType;
        switch (referenceScopeType) {
            case MetadataReference.GEOPACKAGE:
                this.table_name = undefined;
                this.column_name = undefined;
                this.row_id_value = undefined;
                break;
            case MetadataReference.TABLE:
                this.column_name = undefined;
                this.row_id_value = undefined;
                break;
            case MetadataReference.ROW:
                this.column_name = undefined;
                break;
            case MetadataReference.COLUMN:
                this.row_id_value = undefined;
                break;
        }
    };
    MetadataReference.GEOPACKAGE = "geopackage";
    MetadataReference.TABLE = "table";
    MetadataReference.COLUMN = "column";
    MetadataReference.ROW = "row";
    MetadataReference.ROW_COL = "row/col";
    return MetadataReference;
}());
exports.default = MetadataReference;

},{}],87:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = __importDefault(require("../../dao/dao"));
var columnValues_1 = __importDefault(require("../../dao/columnValues"));
var metadataReference_1 = __importDefault(require("./metadataReference"));
/**
 * Metadata Reference Data Access Object
 * @class
 * @extends Dao
 */
var MetadataReferenceDao = /** @class */ (function (_super) {
    __extends(MetadataReferenceDao, _super);
    function MetadataReferenceDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = MetadataReferenceDao.TABLE_NAME;
        _this.idColumns = [MetadataReferenceDao.COLUMN_MD_FILE_ID, MetadataReferenceDao.COLUMN_MD_PARENT_ID];
        return _this;
    }
    MetadataReferenceDao.prototype.createObject = function () {
        return new metadataReference_1.default();
    };
    /**
     * @param {Number} parentId
     * @return {Number} number of rows updated
     */
    MetadataReferenceDao.prototype.removeMetadataParent = function (parentId) {
        var values = {};
        values[MetadataReferenceDao.COLUMN_MD_PARENT_ID] = null;
        var where = this.buildWhereWithFieldAndValue(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
        var whereArgs = this.buildWhereArgs(parentId);
        return this.updateWithValues(values, where, whereArgs);
    };
    /**
     * @param {Number} fileId
     * @param {Number} parentId
     * @return {Iterable.<Object>}
     */
    MetadataReferenceDao.prototype.queryByMetadataAndParent = function (fileId, parentId) {
        var columnValues = new columnValues_1.default();
        columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_FILE_ID, fileId);
        columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
        return this.queryForFieldValues(columnValues);
    };
    /**
     * @param {Number} fileId
     * @return {Iterable.<Object>}
     */
    MetadataReferenceDao.prototype.queryByMetadata = function (fileId) {
        var columnValues = new columnValues_1.default();
        columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_FILE_ID, fileId);
        return this.queryForFieldValues(columnValues);
    };
    /**
    * @param {Number} parentId
    * @return {Iterable.<Object>}
    */
    MetadataReferenceDao.prototype.queryByMetadataParent = function (parentId) {
        var columnValues = new columnValues_1.default();
        columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
        return this.queryForFieldValues(columnValues);
    };
    MetadataReferenceDao.TABLE_NAME = "gpkg_metadata_reference";
    MetadataReferenceDao.COLUMN_REFERENCE_SCOPE = "reference_scope";
    MetadataReferenceDao.COLUMN_TABLE_NAME = "table_name";
    MetadataReferenceDao.COLUMN_COLUMN_NAME = "column_name";
    MetadataReferenceDao.COLUMN_ROW_ID = "row_id";
    MetadataReferenceDao.COLUMN_TIMESTAMP = "timestamp";
    MetadataReferenceDao.COLUMN_MD_FILE_ID = "md_file_id";
    MetadataReferenceDao.COLUMN_MD_PARENT_ID = "md_parent_id";
    return MetadataReferenceDao;
}(dao_1.default));
exports.default = MetadataReferenceDao;

},{"../../dao/columnValues":12,"../../dao/dao":13,"./metadataReference":86}],88:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var OptionBuilder = /** @class */ (function () {
    function OptionBuilder() {
    }
    OptionBuilder.build = function (optionList) {
        var optionBuilder = {};
        optionList.forEach(function (option) {
            optionBuilder['set' + option.slice(0, 1).toUpperCase() + option.slice(1)] = function (param) {
                this[option] = param;
                return this;
            };
            optionBuilder['get' + option.slice(0, 1).toUpperCase() + option.slice(1)] = function () {
                return this[option];
            };
        });
        return optionBuilder;
    };
    return OptionBuilder;
}());
exports.OptionBuilder = OptionBuilder;

},{}],89:[function(require,module,exports){
module.exports = {
    "EPSG:3819": '+proj=longlat +ellps=bessel +towgs84=595.48,121.69,515.35,4.115,-2.9383,0.853,-3.408 +no_defs ',
    "EPSG:3821": '+proj=longlat +ellps=aust_SA +no_defs ',
    "EPSG:3824": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:3889": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:3906": '+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +no_defs ',
    "EPSG:4001": '+proj=longlat +ellps=airy +no_defs ',
    "EPSG:4002": '+proj=longlat +ellps=mod_airy +no_defs ',
    "EPSG:4003": '+proj=longlat +ellps=aust_SA +no_defs ',
    "EPSG:4004": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4005": '+proj=longlat +a=6377492.018 +b=6356173.508712696 +no_defs ',
    "EPSG:4006": '+proj=longlat +ellps=bess_nam +no_defs ',
    "EPSG:4007": '+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
    "EPSG:4008": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4009": '+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs ',
    "EPSG:4010": '+proj=longlat +a=6378300.789 +b=6356566.435 +no_defs ',
    "EPSG:4011": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4012": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4013": '+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_defs ',
    "EPSG:4014": '+proj=longlat +a=6378249.2 +b=6356514.996941779 +no_defs ',
    "EPSG:4015": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs ',
    "EPSG:4016": '+proj=longlat +ellps=evrstSS +no_defs ',
    "EPSG:4018": '+proj=longlat +a=6377304.063 +b=6356103.038993155 +no_defs ',
    "EPSG:4019": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:4020": '+proj=longlat +ellps=helmert +no_defs ',
    "EPSG:4021": '+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs ',
    "EPSG:4022": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4023": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4024": '+proj=longlat +ellps=krass +no_defs ',
    "EPSG:4025": '+proj=longlat +ellps=WGS66 +no_defs ',
    "EPSG:4027": '+proj=longlat +a=6376523 +b=6355862.933255573 +no_defs ',
    "EPSG:4028": '+proj=longlat +a=6378298.3 +b=6356657.142669561 +no_defs ',
    "EPSG:4029": '+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs ',
    "EPSG:4030": '+proj=longlat +ellps=WGS84 +no_defs ',
    "EPSG:4031": '+proj=longlat +ellps=WGS84 +no_defs ',
    "EPSG:4032": '+proj=longlat +a=6378136.2 +b=6356751.516927429 +no_defs ',
    "EPSG:4033": '+proj=longlat +a=6378136.3 +b=6356751.616592146 +no_defs ',
    "EPSG:4034": '+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs ',
    "EPSG:4035": '+proj=longlat +a=6371000 +b=6371000 +no_defs ',
    "EPSG:4036": '+proj=longlat +ellps=GRS67 +no_defs ',
    "EPSG:4041": '+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs ',
    "EPSG:4042": '+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +no_defs ',
    "EPSG:4043": '+proj=longlat +ellps=WGS72 +no_defs ',
    "EPSG:4044": '+proj=longlat +a=6377301.243 +b=6356100.230165384 +no_defs ',
    "EPSG:4045": '+proj=longlat +a=6377299.151 +b=6356098.145120132 +no_defs ',
    "EPSG:4046": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4047": '+proj=longlat +a=6371007 +b=6371007 +no_defs ',
    "EPSG:4052": '+proj=longlat +a=6370997 +b=6370997 +no_defs ',
    "EPSG:4053": '+proj=longlat +a=6371228 +b=6371228 +no_defs ',
    "EPSG:4054": '+proj=longlat +a=6378273 +b=6356889.449 +no_defs ',
    "EPSG:4055": '+proj=longlat +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4075": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4081": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4120": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4121": '+proj=longlat +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +no_defs ',
    "EPSG:4122": '+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs ',
    "EPSG:4123": '+proj=longlat +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +no_defs ',
    "EPSG:4124": '+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +no_defs ',
    "EPSG:4125": '+proj=longlat +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +no_defs ',
    "EPSG:4126": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:4127": '+proj=longlat +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +no_defs ',
    "EPSG:4128": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4129": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4130": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +no_defs ',
    "EPSG:4131": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +no_defs ',
    "EPSG:4132": '+proj=longlat +ellps=clrk80 +towgs84=-241.54,-163.64,396.06,0,0,0,0 +no_defs ',
    "EPSG:4133": '+proj=longlat +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +no_defs ',
    "EPSG:4134": '+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +no_defs ',
    "EPSG:4135": '+proj=longlat +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +no_defs ',
    "EPSG:4136": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4137": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4138": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4139": '+proj=longlat +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +no_defs ',
    "EPSG:4140": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4141": '+proj=longlat +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +no_defs ',
    "EPSG:4142": '+proj=longlat +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +no_defs ',
    "EPSG:4143": '+proj=longlat +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +no_defs ',
    "EPSG:4144": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=214,804,268,0,0,0,0 +no_defs ',
    "EPSG:4145": '+proj=longlat +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +no_defs ',
    "EPSG:4146": '+proj=longlat +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +no_defs ',
    "EPSG:4147": '+proj=longlat +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +no_defs ',
    "EPSG:4148": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4149": '+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +no_defs ',
    "EPSG:4150": '+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs ',
    "EPSG:4151": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4152": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4153": '+proj=longlat +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +no_defs ',
    "EPSG:4154": '+proj=longlat +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +no_defs ',
    "EPSG:4155": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +no_defs ',
    "EPSG:4156": '+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 +no_defs ',
    "EPSG:4157": '+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
    "EPSG:4158": '+proj=longlat +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +no_defs ',
    "EPSG:4159": '+proj=longlat +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +no_defs ',
    "EPSG:4160": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4161": '+proj=longlat +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +no_defs ',
    "EPSG:4162": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4163": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4164": '+proj=longlat +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +no_defs ',
    "EPSG:4165": '+proj=longlat +ellps=intl +towgs84=-173,253,27,0,0,0,0 +no_defs ',
    "EPSG:4166": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4167": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4168": '+proj=longlat +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +no_defs ',
    "EPSG:4169": '+proj=longlat +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +no_defs ',
    "EPSG:4170": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4171": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4172": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4173": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4174": '+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs ',
    "EPSG:4175": '+proj=longlat +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +no_defs ',
    "EPSG:4176": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4178": '+proj=longlat +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +no_defs ',
    "EPSG:4179": '+proj=longlat +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +no_defs ',
    "EPSG:4180": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4181": '+proj=longlat +ellps=intl +towgs84=-189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +no_defs ',
    "EPSG:4182": '+proj=longlat +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +no_defs ',
    "EPSG:4183": '+proj=longlat +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +no_defs ',
    "EPSG:4184": '+proj=longlat +ellps=intl +towgs84=-203,141,53,0,0,0,0 +no_defs ',
    "EPSG:4185": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4188": '+proj=longlat +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
    "EPSG:4189": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4190": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4191": '+proj=longlat +ellps=krass +no_defs ',
    "EPSG:4192": '+proj=longlat +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +no_defs ',
    "EPSG:4193": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs ',
    "EPSG:4194": '+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 +no_defs ',
    "EPSG:4195": '+proj=longlat +ellps=intl +towgs84=105,326,-102.5,0,0,0.814,-0.6 +no_defs ',
    "EPSG:4196": '+proj=longlat +ellps=intl +towgs84=-45,417,-3.5,0,0,0.814,-0.6 +no_defs ',
    "EPSG:4197": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4198": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4199": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4200": '+proj=longlat +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +no_defs ',
    "EPSG:4201": '+proj=longlat +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +no_defs ',
    "EPSG:4202": '+proj=longlat +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +no_defs ',
    "EPSG:4203": '+proj=longlat +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +no_defs ',
    "EPSG:4204": '+proj=longlat +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +no_defs ',
    "EPSG:4205": '+proj=longlat +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +no_defs ',
    "EPSG:4206": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4207": '+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +no_defs ',
    "EPSG:4208": '+proj=longlat +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +no_defs ',
    "EPSG:4209": '+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-143,-90,-294,0,0,0,0 +no_defs ',
    "EPSG:4210": '+proj=longlat +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +no_defs ',
    "EPSG:4211": '+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +no_defs ',
    "EPSG:4212": '+proj=longlat +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +no_defs ',
    "EPSG:4213": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +no_defs ',
    "EPSG:4214": '+proj=longlat +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +no_defs ',
    "EPSG:4215": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4216": '+proj=longlat +ellps=clrk66 +towgs84=-73,213,296,0,0,0,0 +no_defs ',
    "EPSG:4218": '+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 +no_defs ',
    "EPSG:4219": '+proj=longlat +ellps=bessel +towgs84=-384,664,-48,0,0,0,0 +no_defs ',
    "EPSG:4220": '+proj=longlat +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +no_defs ',
    "EPSG:4221": '+proj=longlat +ellps=intl +towgs84=-148,136,90,0,0,0,0 +no_defs ',
    "EPSG:4222": '+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +no_defs ',
    "EPSG:4223": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +no_defs ',
    "EPSG:4224": '+proj=longlat +ellps=intl +towgs84=-134,229,-29,0,0,0,0 +no_defs ',
    "EPSG:4225": '+proj=longlat +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +no_defs ',
    "EPSG:4226": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4227": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532,238.69,0,0,0,0 +no_defs ',
    "EPSG:4228": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4229": '+proj=longlat +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +no_defs ',
    "EPSG:4230": '+proj=longlat +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +no_defs ',
    "EPSG:4231": '+proj=longlat +ellps=intl +towgs84=-83.11,-97.38,-117.22,0.00569291,-0.0446976,0.0442851,0.1218 +no_defs ',
    "EPSG:4232": '+proj=longlat +ellps=clrk80 +towgs84=-346,-1,224,0,0,0,0 +no_defs ',
    "EPSG:4233": '+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs ',
    "EPSG:4234": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4235": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4236": '+proj=longlat +ellps=intl +towgs84=-637,-549,-203,0,0,0,0 +no_defs ',
    "EPSG:4237": '+proj=longlat +ellps=GRS67 +towgs84=52.17,-71.82,-14.9,0,0,0,0 +no_defs ',
    "EPSG:4238": '+proj=longlat +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +no_defs ',
    "EPSG:4239": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +no_defs ',
    "EPSG:4240": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=210,814,289,0,0,0,0 +no_defs ',
    "EPSG:4241": '+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs ',
    "EPSG:4242": '+proj=longlat +ellps=clrk66 +towgs84=70,207,389.5,0,0,0,0 +no_defs ',
    "EPSG:4243": '+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +no_defs ',
    "EPSG:4244": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-97,787,86,0,0,0,0 +no_defs ',
    "EPSG:4245": '+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +no_defs ',
    "EPSG:4246": '+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0,0,0,0 +no_defs ',
    "EPSG:4247": '+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +no_defs ',
    "EPSG:4248": '+proj=longlat +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +no_defs ',
    "EPSG:4249": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4250": '+proj=longlat +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0 +no_defs ',
    "EPSG:4251": '+proj=longlat +ellps=clrk80 +towgs84=-90,40,88,0,0,0,0 +no_defs ',
    "EPSG:4252": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4253": '+proj=longlat +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +no_defs ',
    "EPSG:4254": '+proj=longlat +ellps=intl +towgs84=16,196,93,0,0,0,0 +no_defs ',
    "EPSG:4255": '+proj=longlat +ellps=intl +towgs84=-333,-222,114,0,0,0,0 +no_defs ',
    "EPSG:4256": '+proj=longlat +ellps=clrk80 +towgs84=41,-220,-134,0,0,0,0 +no_defs ',
    "EPSG:4257": '+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +no_defs ',
    "EPSG:4258": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4259": '+proj=longlat +ellps=intl +towgs84=-254.1,-5.36,-100.29,0,0,0,0 +no_defs ',
    "EPSG:4260": '+proj=longlat +ellps=clrk80 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs ',
    "EPSG:4261": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +no_defs ',
    "EPSG:4262": '+proj=longlat +ellps=bessel +towgs84=639,405,60,0,0,0,0 +no_defs ',
    "EPSG:4263": '+proj=longlat +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +no_defs ',
    "EPSG:4264": '+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,0,0,0,0 +no_defs ',
    "EPSG:4265": '+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +no_defs ',
    "EPSG:4266": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-74,-130,42,0,0,0,0 +no_defs ',
    "EPSG:4267": '+proj=longlat +datum=NAD27 +no_defs ',
    "EPSG:4268": '+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs ',
    "EPSG:4269": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4270": '+proj=longlat +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +no_defs ',
    "EPSG:4271": '+proj=longlat +ellps=intl +towgs84=-10,375,165,0,0,0,0 +no_defs ',
    "EPSG:4272": '+proj=longlat +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +no_defs ',
    "EPSG:4273": '+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +no_defs ',
    "EPSG:4274": '+proj=longlat +ellps=intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +no_defs ',
    "EPSG:4275": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +no_defs ',
    "EPSG:4276": '+proj=longlat +ellps=WGS66 +no_defs ',
    "EPSG:4277": '+proj=longlat +ellps=airy +towgs84=446.448,-125.157,542.06,0.15,0.247,0.842,-20.489 +no_defs ',
    "EPSG:4278": '+proj=longlat +ellps=airy +no_defs ',
    "EPSG:4279": '+proj=longlat +ellps=airy +no_defs ',
    "EPSG:4280": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4281": '+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +no_defs ',
    "EPSG:4282": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-148,51,-291,0,0,0,0 +no_defs ',
    "EPSG:4283": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4284": '+proj=longlat +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +no_defs ',
    "EPSG:4285": '+proj=longlat +ellps=intl +towgs84=-128.16,-282.42,21.93,0,0,0,0 +no_defs ',
    "EPSG:4286": '+proj=longlat +ellps=helmert +no_defs ',
    "EPSG:4287": '+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 +no_defs ',
    "EPSG:4288": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4289": '+proj=longlat +ellps=bessel +towgs84=565.417,50.3319,465.552,-0.398957,0.343988,-1.8774,4.0725 +no_defs ',
    "EPSG:4291": '+proj=longlat +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +no_defs ',
    "EPSG:4292": '+proj=longlat +ellps=intl +towgs84=-355,21,72,0,0,0,0 +no_defs ',
    "EPSG:4293": '+proj=longlat +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +no_defs ',
    "EPSG:4294": '+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +no_defs ',
    "EPSG:4295": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4296": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4297": '+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +no_defs ',
    "EPSG:4298": '+proj=longlat +ellps=evrstSS +towgs84=-679,669,-48,0,0,0,0 +no_defs ',
    "EPSG:4299": '+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
    "EPSG:4300": '+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
    "EPSG:4301": '+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +no_defs ',
    "EPSG:4302": '+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +no_defs ',
    "EPSG:4303": '+proj=longlat +ellps=helmert +no_defs ',
    "EPSG:4304": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +no_defs ',
    "EPSG:4306": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4307": '+proj=longlat +ellps=clrk80 +towgs84=-209.362,-87.8162,404.62,0.0046,3.4784,0.5805,-1.4547 +no_defs ',
    "EPSG:4308": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4309": '+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +no_defs ',
    "EPSG:4310": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4311": '+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +no_defs ',
    "EPSG:4312": '+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +no_defs ',
    "EPSG:4313": '+proj=longlat +ellps=intl +towgs84=-106.869,52.2978,-103.724,0.3366,-0.457,1.8422,-1.2747 +no_defs ',
    "EPSG:4314": '+proj=longlat +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +no_defs ',
    "EPSG:4315": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +no_defs ',
    "EPSG:4316": '+proj=longlat +ellps=intl +towgs84=103.25,-100.4,-307.19,0,0,0,0 +no_defs ',
    "EPSG:4317": '+proj=longlat +ellps=krass +towgs84=28,-121,-77,0,0,0,0 +no_defs ',
    "EPSG:4318": '+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,0 +no_defs ',
    "EPSG:4319": '+proj=longlat +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +no_defs ',
    "EPSG:4322": '+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +no_defs ',
    "EPSG:4324": '+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +no_defs ',
    "EPSG:4326": '+proj=longlat +datum=WGS84 +no_defs ',
    "EPSG:4463": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4470": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4475": '+proj=longlat +ellps=intl +towgs84=-381.788,-57.501,-256.673,0,0,0,0 +no_defs ',
    "EPSG:4483": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4490": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:4555": '+proj=longlat +ellps=krass +no_defs ',
    "EPSG:4558": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4600": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4601": '+proj=longlat +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +no_defs ',
    "EPSG:4602": '+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +no_defs ',
    "EPSG:4603": '+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +no_defs ',
    "EPSG:4604": '+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +no_defs ',
    "EPSG:4605": '+proj=longlat +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +no_defs ',
    "EPSG:4606": '+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +no_defs ',
    "EPSG:4607": '+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +no_defs ',
    "EPSG:4608": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4609": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:4610": '+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs ',
    "EPSG:4611": '+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +no_defs ',
    "EPSG:4612": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4613": '+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +no_defs ',
    "EPSG:4614": '+proj=longlat +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +no_defs ',
    "EPSG:4615": '+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +no_defs ',
    "EPSG:4616": '+proj=longlat +ellps=intl +towgs84=-289,-124,60,0,0,0,0 +no_defs ',
    "EPSG:4617": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4618": '+proj=longlat +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 +no_defs ',
    "EPSG:4619": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4620": '+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0,0 +no_defs ',
    "EPSG:4621": '+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 +no_defs ',
    "EPSG:4622": '+proj=longlat +ellps=intl +towgs84=-467,-16,-300,0,0,0,0 +no_defs ',
    "EPSG:4623": '+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 +no_defs ',
    "EPSG:4624": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4625": '+proj=longlat +ellps=intl +towgs84=186,482,151,0,0,0,0 +no_defs ',
    "EPSG:4626": '+proj=longlat +ellps=intl +towgs84=94,-948,-1262,0,0,0,0 +no_defs ',
    "EPSG:4627": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4628": '+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +no_defs ',
    "EPSG:4629": '+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486,1.6045,0.8823,0.5565,1.3746 +no_defs ',
    "EPSG:4630": '+proj=longlat +ellps=intl +towgs84=84,274,65,0,0,0,0 +no_defs ',
    "EPSG:4631": '+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs ',
    "EPSG:4632": '+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +no_defs ',
    "EPSG:4633": '+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94,0,0,0,0 +no_defs ',
    "EPSG:4634": '+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +no_defs ',
    "EPSG:4635": '+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +no_defs ',
    "EPSG:4636": '+proj=longlat +ellps=intl +towgs84=365,194,166,0,0,0,0 +no_defs ',
    "EPSG:4637": '+proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +no_defs ',
    "EPSG:4638": '+proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +no_defs ',
    "EPSG:4639": '+proj=longlat +ellps=intl +towgs84=253,-132,-127,0,0,0,0 +no_defs ',
    "EPSG:4640": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4641": '+proj=longlat +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +no_defs ',
    "EPSG:4642": '+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +no_defs ',
    "EPSG:4643": '+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +no_defs ',
    "EPSG:4644": '+proj=longlat +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +no_defs ',
    "EPSG:4645": '+proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4646": '+proj=longlat +ellps=intl +towgs84=-963,510,-359,0,0,0,0 +no_defs ',
    "EPSG:4657": '+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28,199,5,0,0,0,0 +no_defs ',
    "EPSG:4658": '+proj=longlat +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +no_defs ',
    "EPSG:4659": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4660": '+proj=longlat +ellps=intl +towgs84=982.609,552.753,-540.873,6.68163,-31.6115,-19.8482,16.805 +no_defs ',
    "EPSG:4661": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4662": '+proj=longlat +ellps=intl +towgs84=-11.64,-348.6,291.98,0,0,0,0 +no_defs ',
    "EPSG:4663": '+proj=longlat +ellps=intl +towgs84=-502.862,-247.438,312.724,0,0,0,0 +no_defs ',
    "EPSG:4664": '+proj=longlat +ellps=intl +towgs84=-204.619,140.176,55.226,0,0,0,0 +no_defs ',
    "EPSG:4665": '+proj=longlat +ellps=intl +towgs84=-106.226,166.366,-37.893,0,0,0,0 +no_defs ',
    "EPSG:4666": '+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,565.223,0,0,0,0 +no_defs ',
    "EPSG:4667": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4668": '+proj=longlat +ellps=intl +towgs84=-86,-98,-119,0,0,0,0 +no_defs ',
    "EPSG:4669": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4670": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4671": '+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
    "EPSG:4672": '+proj=longlat +ellps=intl +towgs84=175,-38,113,0,0,0,0 +no_defs ',
    "EPSG:4673": '+proj=longlat +ellps=intl +towgs84=174.05,-25.49,112.57,-0,-0,0.554,0.2263 +no_defs ',
    "EPSG:4674": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4675": '+proj=longlat +ellps=clrk66 +towgs84=-100,-248,259,0,0,0,0 +no_defs ',
    "EPSG:4676": '+proj=longlat +ellps=krass +no_defs ',
    "EPSG:4677": '+proj=longlat +ellps=krass +no_defs ',
    "EPSG:4678": '+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.544,0,0,0,0 +no_defs ',
    "EPSG:4679": '+proj=longlat +ellps=clrk80 +towgs84=-80.01,253.26,291.19,0,0,0,0 +no_defs ',
    "EPSG:4680": '+proj=longlat +ellps=clrk80 +towgs84=124.5,-63.5,-281,0,0,0,0 +no_defs ',
    "EPSG:4681": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4682": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=283.7,735.9,261.1,0,0,0,0 +no_defs ',
    "EPSG:4683": '+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +no_defs ',
    "EPSG:4684": '+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs ',
    "EPSG:4685": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4686": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4687": '+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +no_defs ',
    "EPSG:4688": '+proj=longlat +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +no_defs ',
    "EPSG:4689": '+proj=longlat +ellps=intl +towgs84=410.721,55.049,80.746,2.5779,2.3514,0.6664,17.3311 +no_defs ',
    "EPSG:4690": '+proj=longlat +ellps=intl +towgs84=221.525,152.948,176.768,-2.3847,-1.3896,-0.877,11.4741 +no_defs ',
    "EPSG:4691": '+proj=longlat +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +no_defs ',
    "EPSG:4692": '+proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +no_defs ',
    "EPSG:4693": '+proj=longlat +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +no_defs ',
    "EPSG:4694": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4695": '+proj=longlat +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +no_defs ',
    "EPSG:4696": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4697": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4698": '+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs ',
    "EPSG:4699": '+proj=longlat +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +no_defs ',
    "EPSG:4700": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4701": '+proj=longlat +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +no_defs ',
    "EPSG:4702": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4703": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4704": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4705": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4706": '+proj=longlat +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +no_defs ',
    "EPSG:4707": '+proj=longlat +ellps=intl +towgs84=114,-116,-333,0,0,0,0 +no_defs ',
    "EPSG:4708": '+proj=longlat +ellps=aust_SA +towgs84=-491,-22,435,0,0,0,0 +no_defs ',
    "EPSG:4709": '+proj=longlat +ellps=intl +towgs84=145,75,-272,0,0,0,0 +no_defs ',
    "EPSG:4710": '+proj=longlat +ellps=intl +towgs84=-320,550,-494,0,0,0,0 +no_defs ',
    "EPSG:4711": '+proj=longlat +ellps=intl +towgs84=124,-234,-25,0,0,0,0 +no_defs ',
    "EPSG:4712": '+proj=longlat +ellps=intl +towgs84=-205,107,53,0,0,0,0 +no_defs ',
    "EPSG:4713": '+proj=longlat +ellps=clrk80 +towgs84=-79,-129,145,0,0,0,0 +no_defs ',
    "EPSG:4714": '+proj=longlat +ellps=intl +towgs84=-127,-769,472,0,0,0,0 +no_defs ',
    "EPSG:4715": '+proj=longlat +ellps=intl +towgs84=-104,-129,239,0,0,0,0 +no_defs ',
    "EPSG:4716": '+proj=longlat +ellps=intl +towgs84=298,-304,-375,0,0,0,0 +no_defs ',
    "EPSG:4717": '+proj=longlat +ellps=clrk66 +towgs84=-2,151,181,0,0,0,0 +no_defs ',
    "EPSG:4718": '+proj=longlat +ellps=intl +towgs84=230,-199,-752,0,0,0,0 +no_defs ',
    "EPSG:4719": '+proj=longlat +ellps=intl +towgs84=211,147,111,0,0,0,0 +no_defs ',
    "EPSG:4720": '+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +no_defs ',
    "EPSG:4721": '+proj=longlat +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +no_defs ',
    "EPSG:4722": '+proj=longlat +ellps=intl +towgs84=-794,119,-298,0,0,0,0 +no_defs ',
    "EPSG:4723": '+proj=longlat +ellps=clrk66 +towgs84=-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925 +no_defs ',
    "EPSG:4724": '+proj=longlat +ellps=intl +towgs84=208,-435,-229,0,0,0,0 +no_defs ',
    "EPSG:4725": '+proj=longlat +ellps=intl +towgs84=189,-79,-202,0,0,0,0 +no_defs ',
    "EPSG:4726": '+proj=longlat +ellps=clrk66 +towgs84=8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081 +no_defs ',
    "EPSG:4727": '+proj=longlat +ellps=intl +towgs84=403,-81,277,0,0,0,0 +no_defs ',
    "EPSG:4728": '+proj=longlat +ellps=intl +towgs84=-307,-92,127,0,0,0,0 +no_defs ',
    "EPSG:4729": '+proj=longlat +ellps=intl +towgs84=185,165,42,0,0,0,0 +no_defs ',
    "EPSG:4730": '+proj=longlat +ellps=intl +towgs84=170,42,84,0,0,0,0 +no_defs ',
    "EPSG:4731": '+proj=longlat +ellps=clrk80 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
    "EPSG:4732": '+proj=longlat +a=6378270 +b=6356794.343434343 +towgs84=102,52,-38,0,0,0,0 +no_defs ',
    "EPSG:4733": '+proj=longlat +ellps=intl +towgs84=276,-57,149,0,0,0,0 +no_defs ',
    "EPSG:4734": '+proj=longlat +ellps=intl +towgs84=-632,438,-609,0,0,0,0 +no_defs ',
    "EPSG:4735": '+proj=longlat +ellps=intl +towgs84=647,1777,-1124,0,0,0,0 +no_defs ',
    "EPSG:4736": '+proj=longlat +ellps=clrk80 +towgs84=260,12,-147,0,0,0,0 +no_defs ',
    "EPSG:4737": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4738": '+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
    "EPSG:4739": '+proj=longlat +ellps=intl +towgs84=-156,-271,-189,0,0,0,0 +no_defs ',
    "EPSG:4740": '+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0,0,1.5,-0,-0,0.076,0 +no_defs ',
    "EPSG:4741": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4742": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:4743": '+proj=longlat +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +no_defs ',
    "EPSG:4744": '+proj=longlat +ellps=clrk80 +no_defs ',
    "EPSG:4745": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4746": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:4747": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4748": '+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
    "EPSG:4749": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4750": '+proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +no_defs ',
    "EPSG:4751": '+proj=longlat +a=6377295.664 +b=6356094.667915204 +no_defs ',
    "EPSG:4752": '+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
    "EPSG:4753": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4754": '+proj=longlat +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +no_defs ',
    "EPSG:4755": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4756": '+proj=longlat +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +no_defs ',
    "EPSG:4757": '+proj=longlat +ellps=WGS84 +no_defs ',
    "EPSG:4758": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4759": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4760": '+proj=longlat +ellps=WGS66 +no_defs ',
    "EPSG:4761": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4762": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4763": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4764": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4765": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:4801": '+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +pm=bern +no_defs ',
    "EPSG:4802": '+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 +pm=bogota +no_defs ',
    "EPSG:4803": '+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +pm=lisbon +no_defs ',
    "EPSG:4804": '+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +no_defs ',
    "EPSG:4805": '+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +no_defs ',
    "EPSG:4806": '+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +pm=rome +no_defs ',
    "EPSG:4807": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +no_defs ',
    "EPSG:4808": '+proj=longlat +ellps=bessel +pm=jakarta +no_defs ',
    "EPSG:4809": '+proj=longlat +ellps=intl +pm=brussels +no_defs ',
    "EPSG:4810": '+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=paris +no_defs ',
    "EPSG:4811": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +pm=paris +no_defs ',
    "EPSG:4813": '+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta +no_defs ',
    "EPSG:4814": '+proj=longlat +ellps=bessel +pm=stockholm +no_defs ',
    "EPSG:4815": '+proj=longlat +ellps=bessel +pm=athens +no_defs ',
    "EPSG:4816": '+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +pm=paris +no_defs ',
    "EPSG:4817": '+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_defs ',
    "EPSG:4818": '+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 +pm=ferro +no_defs ',
    "EPSG:4819": '+proj=longlat +ellps=clrk80 +towgs84=-209.362,-87.8162,404.62,0.0046,3.4784,0.5805,-1.4547 +pm=paris +no_defs ',
    "EPSG:4820": '+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +pm=jakarta +no_defs ',
    "EPSG:4821": '+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs ',
    "EPSG:4823": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4824": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:4901": '+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.337208333333333 +no_defs ',
    "EPSG:4902": '+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris +no_defs ',
    "EPSG:4903": '+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madrid +no_defs ',
    "EPSG:4904": '+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,565.223,0,0,0,0 +pm=lisbon +no_defs ',
    "EPSG:5013": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5132": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:5228": '+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378 +no_defs ',
    "EPSG:5229": '+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378 +pm=ferro +no_defs ',
    "EPSG:5233": '+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-0.293,766.95,87.713,0.195704,1.69507,3.47302,-0.039338 +no_defs ',
    "EPSG:5246": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:5252": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5264": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5324": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5340": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5354": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5360": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5365": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5371": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5373": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5381": '+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5393": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5451": '+proj=longlat +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +no_defs ',
    "EPSG:5464": '+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
    "EPSG:5467": '+proj=longlat +ellps=clrk66 +no_defs ',
    "EPSG:5489": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5524": '+proj=longlat +ellps=intl +no_defs ',
    "EPSG:5527": '+proj=longlat +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +no_defs ',
    "EPSG:5546": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5561": '+proj=longlat +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +no_defs ',
    "EPSG:5593": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:5681": '+proj=longlat +ellps=bessel +no_defs ',
    "EPSG:5886": '+proj=longlat +ellps=GRS80 +no_defs ',
    "EPSG:6135": '+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
    "EPSG:2000": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:2001": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +units=m +no_defs ',
    "EPSG:2002": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +units=m +no_defs ',
    "EPSG:2003": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +units=m +no_defs ',
    "EPSG:2004": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +units=m +no_defs ',
    "EPSG:2005": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +units=m +no_defs ',
    "EPSG:2006": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +units=m +no_defs ',
    "EPSG:2007": '+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +units=m +no_defs ',
    "EPSG:2008": '+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2009": '+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2010": '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2011": '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2012": '+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2013": '+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2014": '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2015": '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2016": '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2017": '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2018": '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2019": '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2020": '+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2021": '+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2022": '+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2023": '+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2024": '+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2025": '+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2026": '+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2027": '+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2028": '+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2029": '+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2030": '+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2031": '+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2032": '+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2033": '+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2034": '+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2035": '+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2036": '+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2037": '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2038": '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2039": '+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.20451694444445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs ',
    "EPSG:2040": '+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
    "EPSG:2041": '+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
    "EPSG:2042": '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
    "EPSG:2043": '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
    "EPSG:2044": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
    "EPSG:2045": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
    "EPSG:2046": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2047": '+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2048": '+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2049": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2050": '+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2051": '+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2052": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2053": '+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2054": '+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2055": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2056": '+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs ',
    "EPSG:2057": '+proj=omerc +lat_0=27.51882880555555 +lonc=52.60353916666667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=658377.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +no_defs ',
    "EPSG:2058": '+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
    "EPSG:2059": '+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
    "EPSG:2060": '+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
    "EPSG:2061": '+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
    "EPSG:2062": '+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293 +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.142669561 +pm=madrid +units=m +no_defs ',
    "EPSG:2063": '+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs ',
    "EPSG:2064": '+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs ',
    "EPSG:2065": '+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589,76,480,0,0,0,0 +pm=ferro +units=m +no_defs ',
    "EPSG:2066": '+proj=cass +lat_0=11.25217861111111 +lon_0=-60.68600888888889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs ',
    "EPSG:2067": '+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +units=m +no_defs ',
    "EPSG:2068": '+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2069": '+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2070": '+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2071": '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2072": '+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2073": '+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2074": '+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2075": '+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2076": '+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2077": '+proj=utm +zone=32 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2078": '+proj=utm +zone=33 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2079": '+proj=utm +zone=34 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2080": '+proj=utm +zone=35 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2081": '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs ',
    "EPSG:2082": '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +no_defs ',
    "EPSG:2083": '+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs ',
    "EPSG:2084": '+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs ',
    "EPSG:2085": '+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99993602 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m +no_defs ',
    "EPSG:2086": '+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=500000 +y_0=229126.939 +datum=NAD27 +units=m +no_defs ',
    "EPSG:2087": '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
    "EPSG:2088": '+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +units=m +no_defs ',
    "EPSG:2089": '+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2090": '+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2091": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
    "EPSG:2092": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
    "EPSG:2093": '+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
    "EPSG:2094": '+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs ',
    "EPSG:2095": '+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,0,0 +units=m +no_defs ',
    "EPSG:2096": '+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
    "EPSG:2097": '+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
    "EPSG:2098": '+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
    "EPSG:2099": '+proj=cass +lat_0=25.38236111111111 +lon_0=50.76138888888889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no_defs ',
    "EPSG:2100": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +units=m +no_defs ',
    "EPSG:2101": '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.972 +ellps=intl +units=m +no_defs ',
    "EPSG:2102": '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=147315.028 +ellps=intl +units=m +no_defs ',
    "EPSG:2103": '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=447315.028 +ellps=intl +units=m +no_defs ',
    "EPSG:2104": '+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-23139.97 +ellps=intl +units=m +no_defs ',
    "EPSG:2105": '+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2106": '+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2107": '+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2108": '+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2109": '+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2110": '+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2111": '+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2112": '+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2113": '+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.7763888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2114": '+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2115": '+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2116": '+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2117": '+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2118": '+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2119": '+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2120": '+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2121": '+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2122": '+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2123": '+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2124": '+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2125": '+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2126": '+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2127": '+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2128": '+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2129": '+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2130": '+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2131": '+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2132": '+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2133": '+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2134": '+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2135": '+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2136": '+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997101815088 +no_defs ',
    "EPSG:2137": '+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +units=m +no_defs ',
    "EPSG:2138": '+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
    "EPSG:2139": '+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2140": '+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2141": '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2142": '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2143": '+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2144": '+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2145": '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2146": '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2147": '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2148": '+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2149": '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2150": '+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2151": '+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2152": '+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2153": '+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2154": '+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2155": '+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2156": '+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2157": '+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2158": '+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2159": '+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs ',
    "EPSG:2160": '+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs ',
    "EPSG:2161": '+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs ',
    "EPSG:2162": '+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs ',
    "EPSG:2163": '+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 +b=6370997 +units=m +no_defs ',
    "EPSG:2164": '+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
    "EPSG:2165": '+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
    "EPSG:2166": '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2167": '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2168": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2169": '+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.166666666666667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +units=m +no_defs ',
    "EPSG:2170": '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs ',
    "EPSG:2171": '+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:2172": '+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:2173": '+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:2174": '+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:2175": '+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.999983 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:2176": '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2177": '+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2178": '+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2179": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2180": '+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2188": '+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +units=m +no_defs ',
    "EPSG:2189": '+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +units=m +no_defs ',
    "EPSG:2190": '+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,0,0 +units=m +no_defs ',
    "EPSG:2191": '+proj=utm +zone=28 +ellps=intl +units=m +no_defs ',
    "EPSG:2192": '+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.337229166666667 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2193": '+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2194": '+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2195": '+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2196": '+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2197": '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2198": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2199": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs ',
    "EPSG:2200": '+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=300000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2201": '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2202": '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2203": '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2204": '+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=30480.06096012192 +datum=NAD27 +units=us-ft +no_defs ',
    "EPSG:2205": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2206": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2207": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2208": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2209": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2210": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2211": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2212": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2213": '+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2214": '+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs ',
    "EPSG:2215": '+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +units=m +no_defs ',
    "EPSG:2216": '+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs ',
    "EPSG:2217": '+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs ',
    "EPSG:2219": '+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2220": '+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2222": '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2223": '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2224": '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2225": '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2226": '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2227": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2228": '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2229": '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2230": '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2231": '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2232": '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2233": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2234": '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2235": '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2236": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2237": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2238": '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2239": '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2240": '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2241": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2242": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2243": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2244": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2245": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2246": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2247": '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2248": '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2249": '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2250": '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2251": '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2252": '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2253": '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2254": '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2255": '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2256": '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2257": '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2258": '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2259": '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2260": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2261": '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2262": '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2263": '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2264": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2265": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2266": '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2267": '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2268": '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2269": '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2270": '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2271": '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2272": '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2273": '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2274": '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2275": '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2276": '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2277": '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2278": '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2279": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2280": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2281": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2282": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2283": '+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2284": '+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2285": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2286": '+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2287": '+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2288": '+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2289": '+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2290": '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=700000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2291": '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2292": '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2294": '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2295": '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
    "EPSG:2308": '+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
    "EPSG:2309": '+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs ',
    "EPSG:2310": '+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs ',
    "EPSG:2311": '+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:2312": '+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:2313": '+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:2314": '+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs ',
    "EPSG:2315": '+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
    "EPSG:2316": '+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
    "EPSG:2317": '+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
    "EPSG:2318": '+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 +x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
    "EPSG:2319": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2320": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2321": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2322": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2323": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2324": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2325": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:2326": '+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.1785555555556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +units=m +no_defs ',
    "EPSG:2327": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2328": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2329": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2330": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2331": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2332": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2333": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2334": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2335": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2336": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2337": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2338": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2339": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2340": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2341": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2342": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2343": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2344": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2345": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2346": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2347": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2348": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2349": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2350": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2351": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2352": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2353": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2354": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2355": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2356": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2357": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2358": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2359": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2360": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2361": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2362": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2363": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2364": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2365": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2366": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2367": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2368": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2369": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2370": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2371": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2372": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2373": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2374": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2375": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2376": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2377": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2378": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2379": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2380": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2381": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2382": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2383": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2384": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2385": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2386": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2387": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2388": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2389": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2390": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
    "EPSG:2391": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:2392": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:2393": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:2394": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:2395": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
    "EPSG:2396": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
    "EPSG:2397": '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2398": '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2399": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
    "EPSG:2400": '+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:2401": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2402": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2403": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2404": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2405": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2406": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2407": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2408": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2409": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2410": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2411": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2412": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2413": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2414": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2415": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2416": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2417": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2418": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2419": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2420": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2421": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2422": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2423": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2424": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2425": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2426": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2427": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2428": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2429": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2430": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2431": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2432": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2433": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2434": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2435": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2436": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2437": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2438": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2439": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2440": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2441": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2442": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
    "EPSG:2443": '+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2444": '+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2445": '+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2446": '+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2447": '+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2448": '+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2449": '+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2450": '+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2451": '+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2452": '+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2453": '+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2454": '+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2455": '+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2456": '+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2457": '+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2458": '+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2459": '+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2460": '+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2461": '+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2462": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs ',
    "EPSG:2463": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2464": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2465": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2466": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2467": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2468": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2469": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2470": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2471": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2472": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2473": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2474": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2475": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2476": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2477": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2478": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2479": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2480": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2481": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2482": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2483": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2484": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2485": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2486": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2487": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2488": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2489": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2490": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2491": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2492": '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2493": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2494": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2495": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2496": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2497": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2498": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2499": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2500": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2501": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2502": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2503": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2504": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2505": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2506": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2507": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2508": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2509": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2510": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2511": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2512": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2513": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2514": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2515": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2516": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2517": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2518": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2519": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2520": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2521": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2522": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2523": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2524": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2525": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2526": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2527": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2528": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2529": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2530": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2531": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2532": '+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2533": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2534": '+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2535": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2536": '+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2537": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2538": '+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2539": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2540": '+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2541": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2542": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2543": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2544": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2545": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2546": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2547": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2548": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2549": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2550": '+proj=utm +zone=50 +south +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +units=m +no_defs ',
    "EPSG:2551": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2552": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2553": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2554": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2555": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2556": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2557": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2558": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2559": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2560": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2561": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2562": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2563": '+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2564": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2565": '+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2566": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2567": '+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2568": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2569": '+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2570": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2571": '+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2572": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2573": '+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2574": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2575": '+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2576": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2577": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2578": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2579": '+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2580": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2581": '+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2582": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2583": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2584": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2585": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2586": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2587": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2588": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2589": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2590": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2591": '+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2592": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2593": '+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2594": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2595": '+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2596": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2597": '+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2598": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2599": '+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2600": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2601": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2602": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2603": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2604": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2605": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2606": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2607": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2608": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2609": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2610": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2611": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2612": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2613": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2614": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2615": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2616": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2617": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2618": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2619": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2620": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2621": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2622": '+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2623": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2624": '+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2625": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2626": '+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2627": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2628": '+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2629": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2630": '+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2631": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2632": '+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2633": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2634": '+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2635": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2636": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2637": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2638": '+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2639": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2640": '+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2641": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2642": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2643": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2644": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2645": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2646": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2647": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2648": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2649": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2650": '+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2651": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2652": '+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2653": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2654": '+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2655": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2656": '+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2657": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2658": '+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2659": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2660": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2661": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2662": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2663": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2664": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2665": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2666": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2667": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2668": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2669": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2670": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2671": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2672": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2673": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2674": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2675": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2676": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2677": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2678": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2679": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2680": '+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2681": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2682": '+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2683": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2684": '+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2685": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2686": '+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2687": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2688": '+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2689": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2690": '+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2691": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2692": '+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2693": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2694": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2695": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2696": '+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2697": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2698": '+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2699": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2700": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2701": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2702": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2703": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2704": '+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2705": '+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2706": '+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2707": '+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2708": '+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2709": '+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2710": '+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2711": '+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2712": '+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2713": '+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2714": '+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2715": '+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2716": '+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2717": '+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2718": '+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2719": '+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2720": '+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2721": '+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2722": '+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2723": '+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2724": '+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2725": '+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2726": '+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2727": '+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2728": '+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2729": '+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2730": '+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2731": '+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2732": '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2733": '+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2734": '+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2735": '+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2736": '+proj=utm +zone=36 +south +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +units=m +no_defs ',
    "EPSG:2737": '+proj=utm +zone=37 +south +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +units=m +no_defs ',
    "EPSG:2738": '+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2739": '+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2740": '+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2741": '+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2742": '+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2743": '+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2744": '+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2745": '+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2746": '+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2747": '+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2748": '+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2749": '+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2750": '+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2751": '+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2752": '+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2753": '+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2754": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2755": '+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2756": '+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2757": '+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2758": '+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:2759": '+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2760": '+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2761": '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2762": '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2763": '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2764": '+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2765": '+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2766": '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2767": '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2768": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2769": '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2770": '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2771": '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2772": '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2773": '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2774": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2775": '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2776": '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2777": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2778": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2779": '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2780": '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2781": '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2782": '+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2783": '+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2784": '+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2785": '+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2786": '+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2787": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2788": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2789": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2790": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2791": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2792": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2793": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2794": '+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2795": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2796": '+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2797": '+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2798": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2799": '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2800": '+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2801": '+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2802": '+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2803": '+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2804": '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2805": '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2806": '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2807": '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2808": '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2809": '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2810": '+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2811": '+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2812": '+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2813": '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2814": '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2815": '+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2816": '+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2817": '+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2818": '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2819": '+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2820": '+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2821": '+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2822": '+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2823": '+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2824": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2825": '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2826": '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2827": '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2828": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2829": '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2830": '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2831": '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2832": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2833": '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2834": '+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2835": '+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2836": '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2837": '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2838": '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2839": '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2840": '+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2841": '+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2842": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2843": '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2844": '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2845": '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2846": '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2847": '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2848": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2849": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2850": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2851": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2852": '+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2853": '+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2854": '+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2855": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2856": '+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2857": '+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2858": '+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2859": '+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2860": '+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2861": '+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2862": '+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2863": '+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2864": '+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2865": '+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2866": '+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2867": '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2868": '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2869": '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2870": '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2871": '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2872": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2873": '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2874": '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2875": '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2876": '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2877": '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2878": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2879": '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2880": '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2881": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2882": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2883": '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2884": '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2885": '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2886": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2887": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2888": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2889": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2890": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2891": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2892": '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2893": '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2894": '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2895": '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2896": '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2897": '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2898": '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2899": '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2900": '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2901": '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2902": '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2903": '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2904": '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2905": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2906": '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2907": '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2908": '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2909": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2910": '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2911": '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2912": '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2913": '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2914": '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2915": '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2916": '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2917": '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2918": '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2919": '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2920": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2921": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2922": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2923": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2924": '+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2925": '+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2926": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2927": '+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2928": '+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2929": '+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2930": '+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2931": '+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +units=m +no_defs ',
    "EPSG:2932": '+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.99999 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +units=m +no_defs ',
    "EPSG:2933": '+proj=utm +zone=50 +south +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +units=m +no_defs ',
    "EPSG:2934": '+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +pm=jakarta +units=m +no_defs ',
    "EPSG:2935": '+proj=tmerc +lat_0=0.1166666666666667 +lon_0=41.53333333333333 +k=1 +x_0=1300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2936": '+proj=tmerc +lat_0=0.1166666666666667 +lon_0=44.53333333333333 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2937": '+proj=tmerc +lat_0=0.1166666666666667 +lon_0=47.53333333333333 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2938": '+proj=tmerc +lat_0=0.1166666666666667 +lon_0=50.53333333333333 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2939": '+proj=tmerc +lat_0=0.1333333333333333 +lon_0=50.76666666666667 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2940": '+proj=tmerc +lat_0=0.1333333333333333 +lon_0=53.76666666666667 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2941": '+proj=tmerc +lat_0=0.1333333333333333 +lon_0=56.76666666666667 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:2942": '+proj=utm +zone=28 +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +units=m +no_defs ',
    "EPSG:2943": '+proj=utm +zone=28 +ellps=intl +towgs84=-289,-124,60,0,0,0,0 +units=m +no_defs ',
    "EPSG:2944": '+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2945": '+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2946": '+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2947": '+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2948": '+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2949": '+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2950": '+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2951": '+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2952": '+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2953": '+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2954": '+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2955": '+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2956": '+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2957": '+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2958": '+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2959": '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2960": '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2961": '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2962": '+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2964": '+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
    "EPSG:2965": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2966": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2967": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2968": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:2969": '+proj=utm +zone=20 +ellps=intl +towgs84=137,248,-430,0,0,0,0 +units=m +no_defs ',
    "EPSG:2970": '+proj=utm +zone=20 +ellps=intl +towgs84=-467,-16,-300,0,0,0,0 +units=m +no_defs ',
    "EPSG:2971": '+proj=utm +zone=22 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ',
    "EPSG:2972": '+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2973": '+proj=utm +zone=20 +ellps=intl +towgs84=186,482,151,0,0,0,0 +units=m +no_defs ',
    "EPSG:2975": '+proj=utm +zone=40 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2976": '+proj=utm +zone=6 +south +ellps=intl +towgs84=162,117,154,0,0,0,0 +units=m +no_defs ',
    "EPSG:2977": '+proj=utm +zone=5 +south +ellps=intl +towgs84=72.438,345.918,79.486,1.6045,0.8823,0.5565,1.3746 +units=m +no_defs ',
    "EPSG:2978": '+proj=utm +zone=7 +south +ellps=intl +towgs84=84,274,65,0,0,0,0 +units=m +no_defs ',
    "EPSG:2979": '+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs ',
    "EPSG:2980": '+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs ',
    "EPSG:2981": '+proj=utm +zone=58 +south +ellps=intl +towgs84=335.47,222.58,-230.94,0,0,0,0 +units=m +no_defs ',
    "EPSG:2982": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +units=m +no_defs ',
    "EPSG:2983": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +units=m +no_defs ',
    "EPSG:2984": '+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=intl +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2987": '+proj=utm +zone=21 +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +units=m +no_defs ',
    "EPSG:2988": '+proj=utm +zone=1 +south +ellps=intl +towgs84=253,-132,-127,0,0,0,0 +units=m +no_defs ',
    "EPSG:2989": '+proj=utm +zone=20 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2990": '+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=50000 +y_0=160000 +ellps=intl +towgs84=94,-948,-1262,0,0,0,0 +units=m +no_defs ',
    "EPSG:2991": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2992": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2993": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:2994": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:2995": '+proj=utm +zone=58 +south +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +units=m +no_defs ',
    "EPSG:2996": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +units=m +no_defs ',
    "EPSG:2997": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +units=m +no_defs ',
    "EPSG:2998": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
    "EPSG:2999": '+proj=utm +zone=38 +south +ellps=intl +towgs84=-963,510,-359,0,0,0,0 +units=m +no_defs ',
    "EPSG:3000": '+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +units=m +no_defs ',
    "EPSG:3001": '+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
    "EPSG:3002": '+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +units=m +no_defs ',
    "EPSG:3003": '+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +units=m +no_defs ',
    "EPSG:3004": '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +units=m +no_defs ',
    "EPSG:3005": '+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3006": '+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3007": '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3008": '+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3009": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3010": '+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3011": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3012": '+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3013": '+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3014": '+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3015": '+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3016": '+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3017": '+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3018": '+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3019": '+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3020": '+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3021": '+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3022": '+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3023": '+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3024": '+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
    "EPSG:3025": '+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3026": '+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3027": '+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3028": '+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3029": '+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3030": '+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3031": '+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3032": '+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=70 +k=1 +x_0=6000000 +y_0=6000000 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3033": '+proj=lcc +lat_1=-68.5 +lat_2=-74.5 +lat_0=-50 +lon_0=70 +x_0=6000000 +y_0=6000000 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3034": '+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3035": '+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3036": '+proj=utm +zone=36 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs ',
    "EPSG:3037": '+proj=utm +zone=37 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs ',
    "EPSG:3038": '+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3039": '+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3040": '+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3041": '+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3042": '+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3043": '+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3044": '+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3045": '+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3046": '+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3047": '+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3048": '+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3049": '+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3050": '+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3051": '+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3054": '+proj=utm +zone=26 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
    "EPSG:3055": '+proj=utm +zone=27 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
    "EPSG:3056": '+proj=utm +zone=28 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
    "EPSG:3057": '+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3058": '+proj=tmerc +lat_0=0 +lon_0=-8.5 +k=1 +x_0=50000 +y_0=-7800000 +ellps=intl +towgs84=982.609,552.753,-540.873,6.68163,-31.6115,-19.8482,16.805 +units=m +no_defs ',
    "EPSG:3059": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3060": '+proj=utm +zone=58 +south +ellps=intl +towgs84=-11.64,-348.6,291.98,0,0,0,0 +units=m +no_defs ',
    "EPSG:3061": '+proj=utm +zone=28 +ellps=intl +towgs84=-502.862,-247.438,312.724,0,0,0,0 +units=m +no_defs ',
    "EPSG:3062": '+proj=utm +zone=26 +ellps=intl +towgs84=-204.619,140.176,55.226,0,0,0,0 +units=m +no_defs ',
    "EPSG:3063": '+proj=utm +zone=26 +ellps=intl +towgs84=-106.226,166.366,-37.893,0,0,0,0 +units=m +no_defs ',
    "EPSG:3064": '+proj=utm +zone=32 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3065": '+proj=utm +zone=33 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3066": '+proj=tmerc +lat_0=0 +lon_0=37 +k=0.9998 +x_0=500000 +y_0=-3000000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
    "EPSG:3067": '+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3068": '+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 +x_0=40000 +y_0=10000 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
    "EPSG:3069": '+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=500000 +y_0=-4500000 +datum=NAD27 +units=m +no_defs ',
    "EPSG:3070": '+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3071": '+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3072": '+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3073": '+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3074": '+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3075": '+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3076": '+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3077": '+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3078": '+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3079": '+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3080": '+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=914400 +y_0=914400 +datum=NAD27 +units=ft +no_defs ',
    "EPSG:3081": '+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3082": '+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3083": '+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3084": '+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3085": '+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3086": '+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3087": '+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3088": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3089": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3090": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3091": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3092": '+proj=utm +zone=51 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
    "EPSG:3093": '+proj=utm +zone=52 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
    "EPSG:3094": '+proj=utm +zone=53 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
    "EPSG:3095": '+proj=utm +zone=54 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
    "EPSG:3096": '+proj=utm +zone=55 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
    "EPSG:3097": '+proj=utm +zone=51 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3098": '+proj=utm +zone=52 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3099": '+proj=utm +zone=53 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3100": '+proj=utm +zone=54 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3101": '+proj=utm +zone=55 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3102": '+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=95169.31165862332 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3103": '+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3104": '+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3105": '+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3106": '+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +towgs84=283.7,735.9,261.1,0,0,0,0 +units=m +no_defs ',
    "EPSG:3107": '+proj=lcc +lat_1=-28 +lat_2=-36 +lat_0=-32 +lon_0=135 +x_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3108": '+proj=tmerc +lat_0=49.5 +lon_0=-2.416666666666667 +k=0.999997 +x_0=47000 +y_0=50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3109": '+proj=tmerc +lat_0=49.225 +lon_0=-2.135 +k=0.9999999000000001 +x_0=40000 +y_0=70000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3110": '+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=4500000 +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
    "EPSG:3111": '+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3112": '+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3113": '+proj=tmerc +lat_0=-28 +lon_0=153 +k=0.99999 +x_0=50000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3114": '+proj=tmerc +lat_0=4.596200416666666 +lon_0=-80.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3115": '+proj=tmerc +lat_0=4.596200416666666 +lon_0=-77.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3116": '+proj=tmerc +lat_0=4.596200416666666 +lon_0=-74.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3117": '+proj=tmerc +lat_0=4.596200416666666 +lon_0=-71.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3118": '+proj=tmerc +lat_0=4.596200416666666 +lon_0=-68.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3119": '+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs ',
    "EPSG:3120": '+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5467000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3121": '+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
    "EPSG:3122": '+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
    "EPSG:3123": '+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
    "EPSG:3124": '+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
    "EPSG:3125": '+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
    "EPSG:3126": '+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3127": '+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3128": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3129": '+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3130": '+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3131": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3132": '+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3133": '+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3134": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3135": '+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3136": '+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3137": '+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3138": '+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3140": '+proj=cass +lat_0=-18 +lon_0=178 +x_0=109435.392 +y_0=141622.272 +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +to_meter=0.201168 +no_defs ',
    "EPSG:3141": '+proj=utm +zone=60 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs ',
    "EPSG:3142": '+proj=utm +zone=1 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs ',
    "EPSG:3143": '+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +units=m +no_defs ',
    "EPSG:3146": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3147": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3148": '+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
    "EPSG:3149": '+proj=utm +zone=49 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
    "EPSG:3150": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:3151": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:3152": '+proj=tmerc +lat_0=0 +lon_0=18.05779 +k=0.99999425 +x_0=100178.1808 +y_0=-6500614.7836 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3153": '+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3154": '+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3155": '+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3156": '+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3157": '+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3158": '+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3159": '+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3160": '+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3161": '+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3162": '+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3163": '+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3164": '+proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +units=m +no_defs ',
    "EPSG:3165": '+proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
    "EPSG:3166": '+proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.29472222222222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.313000000000001 +y_0=-2.354 +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
    "EPSG:3167": '+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=40000 +y_0=0 +no_uoff +gamma=323.1301023611111 +a=6377295.664 +b=6356094.667915204 +to_meter=20.116756 +no_defs ',
    "EPSG:3168": '+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=804670.24 +y_0=0 +no_uoff +gamma=323.1301023611111 +a=6377295.664 +b=6356094.667915204 +units=m +no_defs ',
    "EPSG:3169": '+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3170": '+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3171": '+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3172": '+proj=utm +zone=59 +south +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +units=m +no_defs ',
    "EPSG:3174": '+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-84.455955 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3175": '+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-83.248627 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3176": '+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
    "EPSG:3177": '+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9965000000000001 +x_0=1000000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3178": '+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3179": '+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3180": '+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3181": '+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3182": '+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3183": '+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3184": '+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3185": '+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3186": '+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3187": '+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3188": '+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3189": '+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3190": '+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3191": '+proj=tmerc +lat_0=0 +lon_0=11 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3192": '+proj=tmerc +lat_0=0 +lon_0=13 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3193": '+proj=tmerc +lat_0=0 +lon_0=15 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3194": '+proj=tmerc +lat_0=0 +lon_0=17 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3195": '+proj=tmerc +lat_0=0 +lon_0=19 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3196": '+proj=tmerc +lat_0=0 +lon_0=21 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3197": '+proj=tmerc +lat_0=0 +lon_0=23 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3198": '+proj=tmerc +lat_0=0 +lon_0=25 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3199": '+proj=utm +zone=32 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3200": '+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +towgs84=-241.54,-163.64,396.06,0,0,0,0 +units=m +no_defs ',
    "EPSG:3201": '+proj=utm +zone=33 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3202": '+proj=utm +zone=34 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3203": '+proj=utm +zone=35 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
    "EPSG:3204": '+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3205": '+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3206": '+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3207": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-174 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3208": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3209": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3210": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3211": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3212": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3213": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3214": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3215": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3216": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3217": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3218": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3219": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3220": '+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3221": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3222": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3223": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3224": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3225": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-18 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3226": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-6 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3227": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=6 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3228": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=18 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3229": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=30 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3230": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3231": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3232": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3233": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3234": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3235": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3236": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3237": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3238": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3239": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3240": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3241": '+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=174 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3242": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-153 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3243": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-135 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3244": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-117 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3245": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-99 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3246": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-81 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3247": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-63 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3248": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-27 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3249": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-9 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3250": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=9 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3251": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=27 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3252": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=45 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3253": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=63 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3254": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=81 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3255": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=99 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3256": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=117 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3257": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=135 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3258": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=153 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3259": '+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=171 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3260": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-168 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3261": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-144 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3262": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-120 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3263": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-96 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3264": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-72 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3265": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-48 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3266": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-24 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3267": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3268": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=24 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3269": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=48 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3270": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=72 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3271": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=96 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3272": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=120 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3273": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=144 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3274": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=168 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3275": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3276": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3277": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3278": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3279": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3280": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3281": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3282": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3283": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3284": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3285": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3286": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3287": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3288": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3289": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3290": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3291": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3292": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3293": '+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3294": '+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-78 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3296": '+proj=utm +zone=5 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
    "EPSG:3297": '+proj=utm +zone=6 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
    "EPSG:3298": '+proj=utm +zone=7 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
    "EPSG:3299": '+proj=utm +zone=8 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
    "EPSG:3300": '+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +units=m +no_defs ',
    "EPSG:3301": '+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3302": '+proj=utm +zone=7 +south +ellps=intl +towgs84=410.721,55.049,80.746,2.5779,2.3514,0.6664,17.3311 +units=m +no_defs ',
    "EPSG:3303": '+proj=utm +zone=7 +south +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +units=m +no_defs ',
    "EPSG:3304": '+proj=utm +zone=6 +south +ellps=intl +towgs84=221.525,152.948,176.768,-2.3847,-1.3896,-0.877,11.4741 +units=m +no_defs ',
    "EPSG:3305": '+proj=utm +zone=6 +south +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +units=m +no_defs ',
    "EPSG:3306": '+proj=utm +zone=5 +south +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +units=m +no_defs ',
    "EPSG:3307": '+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +units=m +no_defs ',
    "EPSG:3308": '+proj=lcc +lat_1=-30.75 +lat_2=-35.75 +lat_0=-33.25 +lon_0=147 +x_0=9300000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3309": '+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +datum=NAD27 +units=m +no_defs ',
    "EPSG:3310": '+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3311": '+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3312": '+proj=utm +zone=21 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ',
    "EPSG:3313": '+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3314": '+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=0 +lon_0=26 +x_0=0 +y_0=0 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
    "EPSG:3315": '+proj=tmerc +lat_0=-9 +lon_0=26 +k=0.9998 +x_0=0 +y_0=0 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
    "EPSG:3316": '+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3317": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3318": '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3319": '+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3320": '+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3321": '+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3322": '+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3323": '+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3324": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3325": '+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3326": '+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3327": '+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3328": '+proj=sterea +lat_0=52.16666666666666 +lon_0=19.16666666666667 +k=0.999714 +x_0=500000 +y_0=500000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3329": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3330": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3331": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3332": '+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3333": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3334": '+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3335": '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
    "EPSG:3336": '+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs ',
    "EPSG:3337": '+proj=lcc +lat_1=-20.19506944444445 +lat_0=-20.19506944444445 +lon_0=57.52182777777778 +k_0=1 +x_0=1000000 +y_0=1000000 +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +units=m +no_defs ',
    "EPSG:3338": '+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3339": '+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
    "EPSG:3340": '+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
    "EPSG:3341": '+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
    "EPSG:3342": '+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
    "EPSG:3343": '+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3344": '+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3345": '+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3346": '+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3347": '+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3348": '+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3349": '+proj=merc +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3350": '+proj=tmerc +lat_0=0.1 +lon_0=21.95 +k=1 +x_0=250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3351": '+proj=tmerc +lat_0=0.1 +lon_0=24.95 +k=1 +x_0=1250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3352": '+proj=tmerc +lat_0=0.1 +lon_0=27.95 +k=1 +x_0=2250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3353": '+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs ',
    "EPSG:3354": '+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs ',
    "EPSG:3355": '+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=810000 +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +units=m +no_defs ',
    "EPSG:3356": '+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925 +units=m +no_defs ',
    "EPSG:3357": '+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081 +units=m +no_defs ',
    "EPSG:3358": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3359": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024385 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3360": '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3361": '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3362": '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3363": '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3364": '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3365": '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3366": '+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +units=m +no_defs ',
    "EPSG:3367": '+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3368": '+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3369": '+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3370": '+proj=utm +zone=59 +datum=NAD27 +units=m +no_defs ',
    "EPSG:3371": '+proj=utm +zone=60 +datum=NAD27 +units=m +no_defs ',
    "EPSG:3372": '+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3373": '+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3374": '+proj=utm +zone=29 +ellps=intl +units=m +no_defs ',
    "EPSG:3375": '+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257964666666 +k=0.99984 +x_0=804671 +y_0=0 +no_uoff +gamma=323.1301023611111 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3376": '+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.99984 +x_0=0 +y_0=0 +no_uoff +gamma=53.13010236111111 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3377": '+proj=cass +lat_0=2.121679744444445 +lon_0=103.4279362361111 +x_0=-14810.562 +y_0=8758.32 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3378": '+proj=cass +lat_0=2.682347636111111 +lon_0=101.9749050416667 +x_0=3673.785 +y_0=-4240.573 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3379": '+proj=cass +lat_0=3.769388088888889 +lon_0=102.3682989833333 +x_0=-7368.228 +y_0=6485.858 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3380": '+proj=cass +lat_0=3.68464905 +lon_0=101.3891079138889 +x_0=-34836.161 +y_0=56464.049 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3381": '+proj=cass +lat_0=4.9762852 +lon_0=103.070275625 +x_0=19594.245 +y_0=3371.895 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3382": '+proj=cass +lat_0=5.421517541666667 +lon_0=100.3443769638889 +x_0=-23.414 +y_0=62.283 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3383": '+proj=cass +lat_0=5.964672713888889 +lon_0=100.6363711111111 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3384": '+proj=cass +lat_0=4.859063022222222 +lon_0=100.8154105861111 +x_0=-1.769 +y_0=133454.779 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3385": '+proj=cass +lat_0=5.972543658333334 +lon_0=102.2952416694444 +x_0=13227.851 +y_0=8739.894 +ellps=GRS80 +units=m +no_defs ',
    "EPSG:3386": '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:3387": '+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=5500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
    "EPSG:3388": '+proj=merc +lon_0=51 +lat_ts=42 +x_0=0 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3389": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
    "EPSG:3390": '+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
    "EPSG:3391": '+proj=utm +zone=37 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
    "EPSG:3392": '+proj=utm +zone=38 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
    "EPSG:3393": '+proj=utm +zone=39 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
    "EPSG:3394": '+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +units=m +no_defs ',
    "EPSG:3395": '+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3396": '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3397": '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3398": '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3399": '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
    "EPSG:3400": '+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3401": '+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3402": '+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3403": '+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3404": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3405": '+proj=utm +zone=48 +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_defs ',
    "EPSG:3406": '+proj=utm +zone=49 +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_defs ',
    "EPSG:3407": '+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.3047972654 +no_defs ',
    "EPSG:3408": '+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
    "EPSG:3409": '+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
    "EPSG:3410": '+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
    "EPSG:3411": '+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs ',
    "EPSG:3412": '+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs ',
    "EPSG:3413": '+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3414": '+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.8333333333333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +units=m +no_defs ',
    "EPSG:3415": '+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs ',
    "EPSG:3416": '+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3417": '+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3418": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3419": '+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3420": '+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3421": '+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3422": '+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3423": '+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3424": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3425": '+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3426": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3427": '+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3428": '+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3429": '+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3430": '+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3431": '+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3432": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3433": '+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3434": '+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3435": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3436": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3437": '+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3438": '+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3439": '+proj=utm +zone=39 +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs ',
    "EPSG:3440": '+proj=utm +zone=40 +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs ',
    "EPSG:3441": '+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3442": '+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3443": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3444": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3445": '+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3446": '+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3447": '+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=150328 +y_0=166262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3448": '+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=750000 +y_0=650000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3449": '+proj=utm +zone=17 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3450": '+proj=utm +zone=18 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3451": '+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3452": '+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3453": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3454": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3455": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3456": '+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3457": '+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3458": '+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3459": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3460": '+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +units=m +no_defs ',
    "EPSG:3461": '+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs ',
    "EPSG:3462": '+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs ',
    "EPSG:3463": '+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3464": '+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3465": '+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3466": '+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3467": '+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3468": '+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +no_uoff +gamma=323.1301023611111 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3469": '+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3470": '+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3471": '+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3472": '+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3473": '+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3474": '+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3475": '+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3476": '+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3477": '+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3478": '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3479": '+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3480": '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3481": '+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3482": '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3483": '+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3484": '+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3485": '+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3486": '+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3487": '+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3488": '+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3489": '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3490": '+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3491": '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3492": '+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3493": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3494": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3495": '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3496": '+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3497": '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3498": '+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3499": '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3500": '+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3501": '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3502": '+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3503": '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3504": '+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3505": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3506": '+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3507": '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3508": '+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3509": '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3510": '+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3511": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3512": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3513": '+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3514": '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3515": '+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3516": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3517": '+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3518": '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3519": '+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3520": '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3521": '+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3522": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3523": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3524": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3525": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3526": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3527": '+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3528": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3529": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3530": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3531": '+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3532": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3533": '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3534": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3535": '+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3536": '+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3537": '+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3538": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3539": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3540": '+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3541": '+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3542": '+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3543": '+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3544": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3545": '+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3546": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3547": '+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3548": '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3549": '+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3550": '+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3551": '+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3552": '+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3553": '+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3554": '+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3555": '+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3556": '+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3557": '+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3558": '+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3559": '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3560": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3561": '+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3562": '+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3563": '+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3564": '+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3565": '+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3566": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3567": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3568": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3569": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3570": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3571": '+proj=laea +lat_0=90 +lon_0=180 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3572": '+proj=laea +lat_0=90 +lon_0=-150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3573": '+proj=laea +lat_0=90 +lon_0=-100 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3574": '+proj=laea +lat_0=90 +lon_0=-40 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3575": '+proj=laea +lat_0=90 +lon_0=10 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3576": '+proj=laea +lat_0=90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
    "EPSG:3577": '+proj=aea +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=132 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3578": '+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3579": '+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3580": '+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3581": '+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3582": '+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3583": '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3584": '+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3585": '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3586": '+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3587": '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3588": '+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3589": '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3590": '+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3591": '+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3592": '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3593": '+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3594": '+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3595": '+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3596": '+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3597": '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3598": '+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3599": '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3600": '+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3601": '+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3602": '+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3603": '+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3604": '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3605": '+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3606": '+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3607": '+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3608": '+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3609": '+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3610": '+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3611": '+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3612": '+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3613": '+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3614": '+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3615": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3616": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3617": '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3618": '+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3619": '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3620": '+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3621": '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3622": '+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3623": '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3624": '+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3625": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3626": '+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3627": '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3628": '+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3629": '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3630": '+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3631": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3632": '+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3633": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3634": '+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3635": '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3636": '+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3637": '+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3638": '+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3639": '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3640": '+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3641": '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3642": '+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3643": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3644": '+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3645": '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3646": '+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3647": '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3648": '+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3649": '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3650": '+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3651": '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3652": '+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3653": '+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3654": '+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3655": '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3656": '+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3657": '+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3658": '+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3659": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3660": '+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3661": '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3662": '+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3663": '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3664": '+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3665": '+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3666": '+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3667": '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3668": '+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3669": '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3670": '+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3671": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3672": '+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3673": '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3674": '+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3675": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3676": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3677": '+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3678": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3679": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3680": '+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3681": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3682": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
    "EPSG:3683": '+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
    "EPSG:3684": '+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
    "EPSG:3685": '+proj=lcc +lat_1=39.2 +lat_2=38.03333333