"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module attributes/attributeDao
 */
var userDao_1 = require("../user/userDao");
var attributeRow_1 = require("./attributeRow");
/**
 * Attribute DAO for reading attribute user data tables
 * @class AttributeDao
 * @extends UserDao
 * @param  {module:geoPackage~GeoPackage} geoPackage              geopackage object
 * @param  {module:attributes/attributeTable~AttributeTable} table           attribute table
 */
var AttributeDao = /** @class */ (function (_super) {
    __extends(AttributeDao, _super);
    function AttributeDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.table = table;
        if (!table.contents) {
            throw new Error('Attributes table has null Contents');
        }
        _this.contents = table.contents;
        return _this;
    }
    /**
     * Create a new attribute row with the column types and values
     * @param  {Array} columnTypes column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:attributes/attributeRow~AttributeRow}             attribute row
     */
    AttributeDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new attributeRow_1.AttributeRow(this.table, columnTypes, values);
    };
    /**
     * Create a new attribute row
     * @return {module:attributes/attributeRow~AttributeRow} attribute row
     */
    AttributeDao.prototype.newRow = function () {
        return new attributeRow_1.AttributeRow(this.table);
    };
    return AttributeDao;
}(userDao_1.UserDao));
exports.AttributeDao = AttributeDao;
//# sourceMappingURL=attributeDao.js.map