"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module attributes/attributeTable
 */
var contentsDao_1 = require("../core/contents/contentsDao");
var userTable_1 = require("../user/userTable");
/**
 * Represents a user attribute table
 * @class AttributeTable
 * @extends UserTable
 * @constructor
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 */
var AttributeTable = /** @class */ (function (_super) {
    __extends(AttributeTable, _super);
    function AttributeTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Set the contents
     * @param  {module:core/contents~Contents} contents the contents
     */
    AttributeTable.prototype.setContents = function (contents) {
        this.contents = contents;
        if (contents.data_type !== contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME) {
            throw new Error("The Contents of an Attributes Table must have a data type of " + contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
        }
        return true;
    };
    return AttributeTable;
}(userTable_1.UserTable));
exports.AttributeTable = AttributeTable;
//# sourceMappingURL=attributeTable.js.map