"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Stores minimal application schema identifying, descriptive and MIME type
 * information about columns in user vector feature and tile matrix data tables
 * that supplements the data available from the SQLite sqlite_master table and
 * pragma table_info(table_name) SQL function. The gpkg_data_columns data CAN be
 * used to provide more specific column data types and value ranges and
 * application specific structural and semantic information to enable more
 * informative user menu displays and more effective user decisions on the
 * suitability of GeoPackage contents for specific purposes.
 * @class DataColumns
 */
var DataColumns = /** @class */ (function () {
    /**
     *
     * @param {object} [object] object containing properties to apply to this
     */
    function DataColumns(object) {
        object = object || {};
        this.table_name = object.table_name;
        this.column_name = object.column_name;
        this.name = object.name;
        this.title = object.title;
        this.description = object.description;
        this.mime_type = object.mime_type;
        this.constraint_name = object.constraint_name;
    }
    return DataColumns;
}());
exports.DataColumns = DataColumns;
//# sourceMappingURL=dataColumns.js.map