"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var extension_1 = require("./extension");
/**
 * Base Extension
 */
/**
 * Abstract base GeoPackage extension
 */
var BaseExtension = /** @class */ (function () {
    /**
     *
     * @param geoPackage GeoPackage object
     */
    function BaseExtension(geoPackage) {
        this.geoPackage = geoPackage;
        this.connection = geoPackage.connection;
        this.extensionsDao = geoPackage.extensionDao;
    }
    /**
     * Get the extension or create as needed
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @param  {String}   definition    extension definition
     * @param  {String}   scopeType     extension scope type
     * @return {Promise<Extension>}
     */
    BaseExtension.prototype.getOrCreate = function (extensionName, tableName, columnName, definition, scopeType) {
        return __awaiter(this, void 0, void 0, function () {
            var extension;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        extension = this.getExtension(extensionName, tableName, columnName);
                        if (extension.length) {
                            return [2 /*return*/, extension[0]];
                        }
                        return [4 /*yield*/, this.extensionsDao.createTable()];
                    case 1:
                        _a.sent();
                        this.createExtension(extensionName, tableName, columnName, definition, scopeType);
                        return [2 /*return*/, this.getExtension(extensionName, tableName, columnName)[0]];
                }
            });
        });
    };
    /**
     * Get the extension for the name, table name and column name
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @return {Extension[]}
     */
    BaseExtension.prototype.getExtension = function (extensionName, tableName, columnName) {
        if (!this.extensionsDao.isTableExists()) {
            return [];
        }
        return this.extensionsDao.queryByExtensionAndTableNameAndColumnName(extensionName, tableName, columnName);
    };
    /**
     * Determine if the GeoPackage has the extension
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @returns {Boolean} if the extension exists
     */
    BaseExtension.prototype.hasExtension = function (extensionName, tableName, columnName) {
        return !!this.getExtension(extensionName, tableName, columnName).length;
    };
    /**
     * Create the extension
     * @param {string} extensionName
     * @param {string} tableName
     * @param {string} columnName
     * @param {string} definition
     * @param {string} scopeType
     */
    BaseExtension.prototype.createExtension = function (extensionName, tableName, columnName, definition, scopeType) {
        var extension = new extension_1.Extension();
        extension.table_name = tableName;
        extension.column_name = columnName;
        extension.extension_name = extensionName;
        extension.definition = definition;
        extension.scope = scopeType;
        return this.extensionsDao.create(extension);
    };
    return BaseExtension;
}());
exports.BaseExtension = BaseExtension;
//# sourceMappingURL=baseExtension.js.map