"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = require("../../dao/dao");
var contentsId_1 = require("./contentsId");
/**
 * Contents Id Data Access Object
 * @constructor
 * @extends Dao
 */
var ContentsIdDao = /** @class */ (function (_super) {
    __extends(ContentsIdDao, _super);
    function ContentsIdDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ContentsIdDao.TABLE_NAME;
        _this.idColumns = ['id'];
        return _this;
    }
    /**
     * Create a {module:extension/contents.ContentsId} object
     * @return {module:extension/contents.ContentsId}
     */
    ContentsIdDao.prototype.createObject = function (results) {
        var c = new contentsId_1.ContentsId();
        if (results) {
            c.id = results.id;
            c.table_name = results.table_name;
        }
        return c;
    };
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    ContentsIdDao.prototype.createTable = function () {
        return this.geoPackage.getTableCreator().createContentsId();
    };
    /**
     * Get all the table names
     * @return {string[]}
     */
    ContentsIdDao.prototype.getTableNames = function () {
        var tableNames = [];
        var tableNameColumns = this.queryForColumns('table_name');
        for (var i = 0; i < tableNameColumns.length; i++) {
            tableNames.push(tableNameColumns[i].table_name);
        }
        return tableNames;
    };
    /**
     * Query by table name
     * @param  {string} tableName name of the table
     * @return {module:extension/contents.ContentsId}
     */
    ContentsIdDao.prototype.queryForTableName = function (tableName) {
        var contentsIds = this.queryForAll(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
        if (contentsIds.length > 0) {
            return contentsIds[0];
        }
        else {
            return null;
        }
    };
    /**
     * Delete by tableName
     * @param  {string} tableName the table name to delete by
     * @return {number} number of deleted rows
     */
    ContentsIdDao.prototype.deleteByTableName = function (tableName) {
        return this.deleteWhere(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
    };
    ContentsIdDao.TABLE_NAME = 'nga_contents_id';
    ContentsIdDao.COLUMN_ID = 'id';
    ContentsIdDao.COLUMN_TABLE_NAME = 'table_name';
    return ContentsIdDao;
}(dao_1.Dao));
exports.ContentsIdDao = ContentsIdDao;
//# sourceMappingURL=contentsIdDao.js.map