"use strict";
/**
 * @module extension/contents
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = require("../baseExtension");
var extension_1 = require("../extension");
var contentsIdDao_1 = require("./contentsIdDao");
var contentsDao_1 = require("../../core/contents/contentsDao");
/**
 * Style extension
 */
var ContentsIdExtension = /** @class */ (function (_super) {
    __extends(ContentsIdExtension, _super);
    function ContentsIdExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.contentsIdDao = geoPackage.contentsIdDao;
        return _this;
    }
    /**
     * Get or create the contents id extension
     * @return {Promise}
     */
    ContentsIdExtension.prototype.getOrCreateExtension = function () {
        return __awaiter(this, void 0, void 0, function () {
            var extension;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getOrCreate(ContentsIdExtension.EXTENSION_NAME, null, null, ContentsIdExtension.EXTENSION_DEFINITION, extension_1.Extension.READ_WRITE)];
                    case 1:
                        extension = _a.sent();
                        return [4 /*yield*/, this.contentsIdDao.createTable()];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, extension];
                }
            });
        });
    };
    Object.defineProperty(ContentsIdExtension.prototype, "dao", {
        /**
         * Get the ContentsIdDao
         * @returns {module:extension/contents.ContentsIdDao}
         */
        get: function () {
            return this.contentsIdDao;
        },
        enumerable: true,
        configurable: true
    });
    ContentsIdExtension.prototype.has = function () {
        return this.hasExtension(ContentsIdExtension.EXTENSION_NAME, null, null) && this.contentsIdDao.isTableExists();
    };
    /**
     * Get the ContentsId object
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.get = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
     * Get the ContentsId object
     * @param tableName
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.getByTableName = function (tableName) {
        var contentsId = null;
        if (this.contentsIdDao.isTableExists()) {
            contentsId = this.contentsIdDao.queryForTableName(tableName);
        }
        return contentsId;
    };
    /**
     * Get the ContentsId id
     * @param contents {module:core/contents.Contents}
     * @returns {Number}
     */
    ContentsIdExtension.prototype.getId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getIdByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
     * Get the ContentsId id
     * @param tableName
     * @returns {Number}
     */
    ContentsIdExtension.prototype.getIdByTableName = function (tableName) {
        var id = null;
        if (this.contentsIdDao.isTableExists()) {
            var contentsId = this.contentsIdDao.queryForTableName(tableName);
            if (contentsId) {
                id = contentsId.id;
            }
        }
        return id;
    };
    /**
     * Creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.create = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.createWithTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
     * Creates contentsId for contents
     * @param tableName
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.createWithTableName = function (tableName) {
        var contentsId = this.contentsIdDao.createObject();
        contentsId.table_name = tableName;
        contentsId.id = this.contentsIdDao.create(contentsId);
        return contentsId;
    };
    /**
     * Creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.createId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.createIdWithTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
     * Creates contentsId for contents
     * @param tableName {string}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.createIdWithTableName = function (tableName) {
        return this.createWithTableName(tableName);
    };
    /**
     * Gets or creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.getOrCreateId = function (contents) {
        var contentsId = null;
        if (contents && contents.table_name) {
            contentsId = this.getOrCreateIdByTableName(contents.table_name);
        }
        return contentsId;
    };
    /**
     * Gets or creates contentsId for table name
     * @param tableName {string}
     * @returns {module:extension/contents.ContentsId}
     */
    ContentsIdExtension.prototype.getOrCreateIdByTableName = function (tableName) {
        var contentId = this.getByTableName(tableName);
        if (contentId == null) {
            contentId = this.createWithTableName(tableName);
        }
        return contentId;
    };
    /**
     * Deletes contentsId for contents
     * @param contents {module:core/contents.Contents}
     */
    ContentsIdExtension.prototype.deleteId = function (contents) {
        var deleted = 0;
        if (contents && contents.table_name) {
            deleted = this.deleteIdByTableName(contents.table_name);
        }
        return deleted;
    };
    /**
     * Deletes contentId for table name
     * @param tableName {string}
     */
    ContentsIdExtension.prototype.deleteIdByTableName = function (tableName) {
        return this.contentsIdDao.deleteByTableName(tableName);
    };
    /**
     * Number of contentsIds
     * @returns {number}
     */
    ContentsIdExtension.prototype.count = function () {
        var count = 0;
        if (this.has()) {
            count = this.contentsIdDao.count();
        }
        return count;
    };
    /**
     * Create contentsIds for contents of type passed in
     * @param type defaults to ""
     * @returns {number}
     */
    ContentsIdExtension.prototype.createIds = function (type) {
        if (type === void 0) { type = ''; }
        var missing = this.getMissing(type);
        for (var i = 0; i < missing.length; i++) {
            this.getOrCreateIdByTableName(missing[i].table_name);
        }
        return missing.length;
    };
    /**
     * Deletes ids by type
     * @param type
     * @returns {number}
     */
    ContentsIdExtension.prototype.deleteIds = function (type) {
        if (type === void 0) { type = ''; }
        var deleted = 0;
        if (this.has()) {
            if (type.length === 0) {
                deleted = this.contentsIdDao.deleteAll();
            }
            else {
                var ids = this.getIdsByType(type);
                for (var i = 0; i < ids.length; i++) {
                    deleted += this.contentsIdDao.deleteById(ids[i].id);
                }
            }
        }
        return deleted;
    };
    ContentsIdExtension.prototype.getIdsByType = function (type) {
        if (type === void 0) { type = ''; }
        var contentIds = [];
        if (this.has()) {
            var query = 'SELECT ';
            query += contentsIdDao_1.ContentsIdDao.COLUMN_ID;
            query += ', ';
            query += contentsIdDao_1.ContentsIdDao.COLUMN_TABLE_NAME;
            query += ' FROM ' + contentsIdDao_1.ContentsIdDao.TABLE_NAME;
            query += ' WHERE ';
            query += contentsIdDao_1.ContentsIdDao.COLUMN_TABLE_NAME;
            query += ' IN (SELECT ';
            query += contentsDao_1.ContentsDao.COLUMN_TABLE_NAME;
            query += ' FROM ';
            query += contentsDao_1.ContentsDao.TABLE_NAME;
            var where = '';
            var params = [];
            if (type != null && type.length > 0) {
                where += contentsDao_1.ContentsDao.COLUMN_DATA_TYPE;
                where += ' = ?';
                params.push(type);
            }
            if (where.length > 0) {
                query += ' WHERE ' + where;
            }
            query += ')';
            contentIds = this.connection.all(query, params);
        }
        return contentIds;
    };
    /**
     * @typedef ContentsTableName
     * @type {Object}
     * @property {string} table_name the table name
     *
     * Get contents without contents ids
     * @param type
     * @returns {ContentsTableName[]} contentsTableNames
     */
    ContentsIdExtension.prototype.getMissing = function (type) {
        if (type === void 0) { type = ''; }
        var query = 'SELECT ' + contentsDao_1.ContentsDao.COLUMN_TABLE_NAME + ' FROM ' + contentsDao_1.ContentsDao.TABLE_NAME;
        var where = '';
        var params = [];
        if (type != null && type.length > 0) {
            where += contentsDao_1.ContentsDao.COLUMN_DATA_TYPE;
            where += ' = ?';
            params.push(type);
        }
        if (this.has()) {
            if (where.length > 0) {
                where += ' AND ';
            }
            where += contentsDao_1.ContentsDao.COLUMN_TABLE_NAME;
            where += ' NOT IN (SELECT ';
            where += contentsIdDao_1.ContentsIdDao.COLUMN_TABLE_NAME;
            where += ' FROM ';
            where += contentsIdDao_1.ContentsIdDao.TABLE_NAME;
            where += ')';
        }
        if (where.length > 0) {
            query += ' WHERE ' + where;
        }
        return this.connection.all(query, params);
    };
    /**
     * Remove contents id extension
     */
    ContentsIdExtension.prototype.removeExtension = function () {
        if (this.contentsIdDao.isTableExists()) {
            this.geoPackage.deleteTable(contentsIdDao_1.ContentsIdDao.TABLE_NAME);
        }
        if (this.extensionsDao.isTableExists()) {
            this.extensionsDao.deleteByExtension(ContentsIdExtension.EXTENSION_NAME);
        }
    };
    ContentsIdExtension.EXTENSION_NAME = 'nga_contents_id';
    ContentsIdExtension.EXTENSION_AUTHOR = 'nga';
    ContentsIdExtension.EXTENSION_NAME_NO_AUTHOR = 'contents_id';
    ContentsIdExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/contents-id.html';
    return ContentsIdExtension;
}(baseExtension_1.BaseExtension));
exports.ContentsIdExtension = ContentsIdExtension;
//# sourceMappingURL=index.js.map