import { Extension } from './extension';
import { Dao } from '../dao/dao';
import { DBValue } from '../db/dbAdapter';
/**
 * Extension Data Access Object
 * @class
 * @extends Dao
 */
export declare class ExtensionDao extends Dao<Extension> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_TABLE_NAME: string;
    static readonly COLUMN_COLUMN_NAME: string;
    static readonly COLUMN_EXTENSION_NAME: string;
    static readonly COLUMN_DEFINITION: string;
    static readonly COLUMN_SCOPE: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    /**
     * Creates an Extension object from the raw database row
     * @param {object} row raw database row
     * @returns {Extension}
     */
    createObject(row: Record<string, DBValue>): Extension;
    /**
     * Query by extension name and return the first result
     * @param {String} extensionName extension name
     * @returns {Extension}
     */
    queryByExtension(extensionName: string): Extension;
    /**
     * Query by extension name and return all results
     * @param {String} extensionName extension name
     * @returns {Extension[]}
     */
    queryAllByExtension(extensionName: string): Extension[];
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @returns {Extension[]}
     */
    queryByExtensionAndTableName(extensionName: string, tableName: string): Extension[];
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @param {String} columnName column name
     * @returns {Extension[]}
     */
    queryByExtensionAndTableNameAndColumnName(extensionName: string, tableName: string, columnName: string): Extension[];
    /**
     * Creates the extensions table
     */
    createTable(): Promise<boolean>;
    /**
     * Deletes all extension entries with this name
     * @param {String} extensionName extension name to delete
     * @returns {Number} Number of extensions deleted
     */
    deleteByExtension(extensionName: string): number;
    /**
     * Deletes all extension entries with this name and table name
     * @param {String} extensionName extension name to delete
     * @param {String} tableName table name to delete
     * @returns {Number} Number of extensions deleted
     */
    deleteByExtensionAndTableName(extensionName: string, tableName: string): number;
}
