"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var extension_1 = require("./extension");
var dao_1 = require("../dao/dao");
var columnValues_1 = require("../dao/columnValues");
var tableCreator_1 = require("../db/tableCreator");
/**
 * Extension Data Access Object
 * @class
 * @extends Dao
 */
var ExtensionDao = /** @class */ (function (_super) {
    __extends(ExtensionDao, _super);
    function ExtensionDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ExtensionDao.TABLE_NAME;
        _this.idColumns = [
            ExtensionDao.COLUMN_TABLE_NAME,
            ExtensionDao.COLUMN_COLUMN_NAME,
            ExtensionDao.COLUMN_EXTENSION_NAME,
        ];
        return _this;
    }
    /**
     * Creates an Extension object from the raw database row
     * @param {object} row raw database row
     * @returns {Extension}
     */
    ExtensionDao.prototype.createObject = function (row) {
        var e = new extension_1.Extension();
        e.table_name = row['table_name'];
        e.column_name = row['column_name'];
        e.extension_name = row['extension_name'];
        e.definition = row['definition'];
        e.scope = row['scope'];
        return e;
    };
    /**
     * Query by extension name and return the first result
     * @param {String} extensionName extension name
     * @returns {Extension}
     */
    ExtensionDao.prototype.queryByExtension = function (extensionName) {
        var results = this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        if (!results[0])
            return;
        var e = this.createObject(results[0]);
        return e;
    };
    /**
     * Query by extension name and return all results
     * @param {String} extensionName extension name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryAllByExtension = function (extensionName) {
        var e_1, _a;
        var extensions = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return extensions;
    };
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryByExtensionAndTableName = function (extensionName, tableName) {
        var e_2, _a;
        var values = new columnValues_1.ColumnValues();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        var extensions = [];
        try {
            for (var _b = __values(this.queryForFieldValues(values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (extensions.length) {
            return extensions;
        }
        else {
            return;
        }
    };
    /**
     * Query by extension name and table name and return all results
     * @param {String} extensionName extension name
     * @param {String} tableName table name
     * @param {String} columnName column name
     * @returns {Extension[]}
     */
    ExtensionDao.prototype.queryByExtensionAndTableNameAndColumnName = function (extensionName, tableName, columnName) {
        var e_3, _a;
        var values = new columnValues_1.ColumnValues();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        values.addColumn(ExtensionDao.COLUMN_COLUMN_NAME, columnName);
        var extensions = [];
        try {
            for (var _b = __values(this.queryForFieldValues(values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                var e = this.createObject(row);
                extensions.push(e);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return extensions;
    };
    /**
     * Creates the extensions table
     */
    ExtensionDao.prototype.createTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tc;
            return __generator(this, function (_a) {
                tc = new tableCreator_1.TableCreator(this.geoPackage);
                return [2 /*return*/, tc.createExtensions()];
            });
        });
    };
    /**
     * Deletes all extension entries with this name
     * @param {String} extensionName extension name to delete
     * @returns {Number} Number of extensions deleted
     */
    ExtensionDao.prototype.deleteByExtension = function (extensionName) {
        var values = new columnValues_1.ColumnValues();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        return this.deleteWhere(this.buildWhere(values, '='), this.buildWhereArgs(values));
    };
    /**
     * Deletes all extension entries with this name and table name
     * @param {String} extensionName extension name to delete
     * @param {String} tableName table name to delete
     * @returns {Number} Number of extensions deleted
     */
    ExtensionDao.prototype.deleteByExtensionAndTableName = function (extensionName, tableName) {
        var values = new columnValues_1.ColumnValues();
        values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
        values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
        return this.deleteWhere(this.buildWhere(values, 'and'), this.buildWhereArgs(values));
    };
    ExtensionDao.TABLE_NAME = 'gpkg_extensions';
    ExtensionDao.COLUMN_TABLE_NAME = 'table_name';
    ExtensionDao.COLUMN_COLUMN_NAME = 'column_name';
    ExtensionDao.COLUMN_EXTENSION_NAME = 'extension_name';
    ExtensionDao.COLUMN_DEFINITION = 'definition';
    ExtensionDao.COLUMN_SCOPE = 'scope';
    return ExtensionDao;
}(dao_1.Dao));
exports.ExtensionDao = ExtensionDao;
//# sourceMappingURL=extensionDao.js.map