import { UserRow } from '../../user/userRow';
import { UserTable } from '../../user/userTable';
import { DublinCoreType } from './dublinCoreType';
import { UserColumn } from '../../user/userColumn';
/**
 * Dublin Core Metadata Initiative
 * @module extension/relatedTables
 */
/**
 * Dublin Core Metadata Initiative
 * @class
 */
export declare class DublinCoreMetadata {
    /**
     * Check if the table has a column for the Dublin Core Type term
     * @param  {module:user/userTable~UserTable|module:user/userRow~UserRow} table user table or user row to check
     * @param  {module:extension/relatedTables~DublinCoreType} type  Dublin Core Type
     * @return {Boolean}
     */
    static hasColumn(table: UserTable | UserRow, type: DublinCoreType): boolean;
    /**
     * Get the column from the table for the Dublin Core Type term
     * @param  {module:user/userTable~UserTable|module:user/userRow~UserRow} table user table or user row to check
     * @param  {module:extension/relatedTables~DublinCoreType} type  Dublin Core Type
     * @return {module:user/userColumn~UserColumn}
     */
    static getColumn(table: UserTable | UserRow, type: DublinCoreType): UserColumn;
    /**
     * Get the value from the row for the Dublin Core Type term
     * @param  {module:user/userRow~UserRow} row user row to get value from
     * @param  {module:extension/relatedTables~DublinCoreType} type  Dublin Core Type
     * @return {Object}
     */
    static getValue(row: UserRow, type: DublinCoreType): any;
    /**
     * Set the value in the row for the Dublin Core Type term
     * @param  {module:user/userRow~UserRow} row user row to set the value
     * @param  {module:extension/relatedTables~DublinCoreType} type  Dublin Core Type
     * @param  {Object} value value to set
     */
    static setValue(row: UserRow, type: DublinCoreType, value: any): void;
}
