import { Dao } from '../../dao/dao';
import { ExtendedRelation } from './extendedRelation';
import { DBValue } from '../../db/dbAdapter';
/**
 * Extended Relations Data Access Object
 * @class ExtendedRelationDao
 * @extends Dao
 */
export declare class ExtendedRelationDao extends Dao<ExtendedRelation> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_ID: string;
    static readonly COLUMN_BASE_TABLE_NAME: string;
    static readonly COLUMN_BASE_PRIMARY_COLUMN: string;
    static readonly COLUMN_RELATED_TABLE_NAME: string;
    static readonly COLUMN_RELATED_PRIMARY_COLUMN: string;
    static readonly COLUMN_RELATION_NAME: string;
    static readonly COLUMN_MAPPING_TABLE_NAME: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    /**
     * Create a {module:extension/relatedTables~ExtendedRelation} object
     * @return {module:extension/relatedTables~ExtendedRelation}
     */
    createObject(result?: Record<string, DBValue>): ExtendedRelation;
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    createTable(): Promise<boolean>;
    /**
     * Get all the base table names
     * @return {string[]}
     */
    getBaseTables(): string[];
    /**
     * Get all the related table names
     * @return {string[]}
     */
    getRelatedTables(): string[];
    /**
     * Get all relations for the given base table name
     * @param  {string} baseTable base table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    getBaseTableRelations(baseTable: string): ExtendedRelation[];
    /**
     * Get all relations for the given related table name
     * @param  {string} relatedTable related table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    getRelatedTableRelations(relatedTable: string): ExtendedRelation[];
    /**
     * Get all relations for the base table with the relation name
     * @param  {string} baseTable base table name
     * @param  {string} name      relation name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    getBaseTableRelationsWithName(baseTable: string, name: string): ExtendedRelation[];
    /**
     * Get all relations to the table.  Returns relations where the table is the base table and relations where the table is the related table.
     * @param  {string} table table name to query for
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    getTableRelations(table: string): ExtendedRelation[];
    /**
     * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
     * @param {String} [baseTableName] base table name
     * @param {String} [relatedTableName] related table name
     * @param {String} [mappingTableName] mapping table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    getRelations(baseTableName?: string, relatedTableName?: string, mappingTableName?: string): ExtendedRelation[];
    /**
     * Get all relations by the mapping table name
     * @param  {string} mappingTableName name of the mapping table
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    queryByMappingTableName(mappingTableName: string): ExtendedRelation[];
}
