"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = require("../../dao/dao");
var columnValues_1 = require("../../dao/columnValues");
var extendedRelation_1 = require("./extendedRelation");
/**
 * Extended Relations Data Access Object
 * @class ExtendedRelationDao
 * @extends Dao
 */
var ExtendedRelationDao = /** @class */ (function (_super) {
    __extends(ExtendedRelationDao, _super);
    function ExtendedRelationDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = ExtendedRelationDao.TABLE_NAME;
        _this.idColumns = ['id'];
        return _this;
    }
    /**
     * Create a {module:extension/relatedTables~ExtendedRelation} object
     * @return {module:extension/relatedTables~ExtendedRelation}
     */
    ExtendedRelationDao.prototype.createObject = function (result) {
        var er = new extendedRelation_1.ExtendedRelation();
        if (result) {
            er.base_table_name = result.base_table_name;
            er.base_primary_column = result.base_primary_column;
            er.related_table_name = result.base_primary_column;
            er.related_table_name = result.related_table_name;
            er.relation_name = result.relation_name;
            er.mapping_table_name = result.mapping_table_name;
            er.related_primary_column = result.related_primary_column;
            er.id = result.id;
        }
        return er;
    };
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    ExtendedRelationDao.prototype.createTable = function () {
        var tc = this.geoPackage.getTableCreator();
        return tc.createExtendedRelations();
    };
    /**
     * Get all the base table names
     * @return {string[]}
     */
    ExtendedRelationDao.prototype.getBaseTables = function () {
        var baseTables = [];
        var baseTableColumns = this.queryForColumns('base_table_name');
        for (var i = 0; i < baseTableColumns.length; i++) {
            baseTables.push(baseTableColumns[i].base_table_name);
        }
        return baseTables;
    };
    /**
     * Get all the related table names
     * @return {string[]}
     */
    ExtendedRelationDao.prototype.getRelatedTables = function () {
        var relatedTables = [];
        var relatedTableColumns = this.queryForColumns('related_table_name');
        for (var i = 0; i < relatedTableColumns.length; i++) {
            relatedTables.push(relatedTableColumns[i].related_table_name);
        }
        return relatedTables;
    };
    /**
     * Get all relations for the given base table name
     * @param  {string} baseTable base table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getBaseTableRelations = function (baseTable) {
        var e_1, _a;
        var results = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return results;
    };
    /**
     * Get all relations for the given related table name
     * @param  {string} relatedTable related table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getRelatedTableRelations = function (relatedTable) {
        var e_2, _a;
        var results = [];
        try {
            for (var _b = __values(this.queryForAllEq(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTable)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return results;
    };
    /**
     * Get all relations for the base table with the relation name
     * @param  {string} baseTable base table name
     * @param  {string} name      relation name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getBaseTableRelationsWithName = function (baseTable, name) {
        var e_3, _a;
        var fields = new columnValues_1.ColumnValues();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATION_NAME, name);
        var where = this.buildWhere(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return results;
    };
    /**
     * Get all relations to the table.  Returns relations where the table is the base table and relations where the table is the related table.
     * @param  {string} table table name to query for
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getTableRelations = function (table) {
        var e_4, _a;
        var fields = new columnValues_1.ColumnValues();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, table);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, table);
        var where = this.buildWhere(fields, 'or');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return results;
    };
    /**
     * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
     * @param {String} [baseTableName] base table name
     * @param {String} [relatedTableName] related table name
     * @param {String} [mappingTableName] mapping table name
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.getRelations = function (baseTableName, relatedTableName, mappingTableName) {
        var e_5, _a;
        var fields = new columnValues_1.ColumnValues();
        fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTableName);
        fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTableName);
        fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
        var where = this.buildWhereLike(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return results;
    };
    /**
     * Get all relations by the mapping table name
     * @param  {string} mappingTableName name of the mapping table
     * @return {module:extension/relatedTables~ExtendedRelation[]}
     */
    ExtendedRelationDao.prototype.queryByMappingTableName = function (mappingTableName) {
        var e_6, _a;
        var fields = new columnValues_1.ColumnValues();
        fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
        var where = this.buildWhere(fields, 'and');
        var whereArgs = this.buildWhereArgs(fields);
        var results = [];
        try {
            for (var _b = __values(this.queryForAll(where, whereArgs)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var relation = _c.value;
                results.push(this.createObject(relation));
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return results;
    };
    ExtendedRelationDao.TABLE_NAME = 'gpkgext_relations';
    ExtendedRelationDao.COLUMN_ID = ExtendedRelationDao.TABLE_NAME + '.id';
    ExtendedRelationDao.COLUMN_BASE_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.base_table_name';
    ExtendedRelationDao.COLUMN_BASE_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.base_primary_column';
    ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.related_table_name';
    ExtendedRelationDao.COLUMN_RELATED_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.related_primary_column';
    ExtendedRelationDao.COLUMN_RELATION_NAME = ExtendedRelationDao.TABLE_NAME + '.relation_name';
    ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.mapping_table_name';
    return ExtendedRelationDao;
}(dao_1.Dao));
exports.ExtendedRelationDao = ExtendedRelationDao;
//# sourceMappingURL=extendedRelationDao.js.map