import { UserDao } from '../../user/userDao';
import { MediaTable } from './mediaTable';
import { MediaRow } from './mediaRow';
import { GeoPackage } from '../../geoPackage';
import { DBValue } from '../../db/dbAdapter';
import { DataTypes } from '../../db/dataTypes';
/**
 * MediaDao module.
 * @module extension/relatedTables
 */
/**
 * User Media DAO for reading user media data tables
 * @class
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
export declare class MediaDao<T extends MediaRow> extends UserDao<MediaRow> {
    mediaTable: MediaTable;
    constructor(geoPackage: GeoPackage, mediaTable: MediaTable);
    /**
     * Create a new media row
     * @return {module:extension/relatedTables~MediaRow}
     */
    newRow(): MediaRow;
    /**
     * Create a media row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~MediaRow}             media row
     */
    newRowWithColumnTypes(columnTypes: {
        [key: string]: DataTypes;
    }, values: Record<string, DBValue>): MediaRow;
    /**
     * Gets the media table
     * @return {module:extension/relatedTables~MediaTable}
     */
    getTable(): MediaTable;
    /**
     * Reads the table specified from the geopackage
     * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
     * @param  {string} tableName       table name
     * @return {module:user/userDao~UserDao}
     */
    static readTable(geoPackage: GeoPackage, tableName: string): MediaDao<MediaRow>;
}
