/// <reference types="node" />
import { MediaTable } from './mediaTable';
import { UserRow } from '../../user/userRow';
import { DBValue } from '../../db/dbAdapter';
import { UserColumn } from '../../user/userColumn';
import { DataTypes } from '../../db/dataTypes';
/**
 * MediaRow module.
 * @module extension/relatedTables
 */
/**
 * User Media Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~MediaTable} mediaTable  media table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
export declare class MediaRow extends UserRow {
    mediaTable: MediaTable;
    constructor(mediaTable: MediaTable, columnTypes?: {
        [key: string]: DataTypes;
    }, values?: Record<string, DBValue>);
    /**
     * Gets the id column
     * @return {module:user/userColumn~UserColumn}
     */
    getIdColumn(): UserColumn;
    /**
     * Gets the id
     * @return {Number}
     */
    get id(): number;
    /**
     * Get the data column
     * @return {module:user/userColumn~UserColumn}
     */
    getDataColumn(): UserColumn;
    /**
     * Gets the data
     * @return {Buffer}
     */
    getData(): Buffer;
    /**
     * Get the data image
     *
     * @return {Promise<Image>}
     */
    getDataImage(): Promise<any>;
    /**
     * Get the scaled data image
     * @param {Number} scale
     * @return {Promise<Image>}
     */
    getScaledDataImage(scale: number): Promise<any>;
    /**
     * Sets the data for the row
     * @param  {Buffer} data data
     */
    setData(data: Buffer): void;
    /**
     * Get the content type column
     * @return {module:user/userColumn~UserColumn}
     */
    getContentTypeColumn(): UserColumn;
    /**
     * Gets the content type
     * @return {string}
     */
    getContentType(): string;
    /**
     * Sets the content type for the row
     * @param  {string} contentType contentType
     */
    setContentType(contentType: string): void;
}
