"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = require("../../user/userRow");
var imageUtils_1 = require("../../tiles/imageUtils");
/**
 * MediaRow module.
 * @module extension/relatedTables
 */
/**
 * User Media Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~MediaTable} mediaTable  media table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var MediaRow = /** @class */ (function (_super) {
    __extends(MediaRow, _super);
    function MediaRow(mediaTable, columnTypes, values) {
        var _this = _super.call(this, mediaTable, columnTypes, values) || this;
        _this.mediaTable = mediaTable;
        return _this;
    }
    /**
     * Gets the id column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getIdColumn = function () {
        return this.mediaTable.getIdColumn();
    };
    Object.defineProperty(MediaRow.prototype, "id", {
        /**
         * Gets the id
         * @return {Number}
         */
        get: function () {
            return this.getValueWithColumnName(this.getIdColumn().name);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Get the data column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getDataColumn = function () {
        return this.mediaTable.getDataColumn();
    };
    /**
     * Gets the data
     * @return {Buffer}
     */
    MediaRow.prototype.getData = function () {
        return this.getValueWithColumnName(this.getDataColumn().name);
    };
    /**
     * Get the data image
     *
     * @return {Promise<Image>}
     */
    MediaRow.prototype.getDataImage = function () {
        return imageUtils_1.ImageUtils.getImage(this.getData(), this.getContentType());
    };
    /**
     * Get the scaled data image
     * @param {Number} scale
     * @return {Promise<Image>}
     */
    MediaRow.prototype.getScaledDataImage = function (scale) {
        return imageUtils_1.ImageUtils.getScaledImage(this.getData(), scale);
    };
    /**
     * Sets the data for the row
     * @param  {Buffer} data data
     */
    MediaRow.prototype.setData = function (data) {
        this.setValueWithColumnName(this.getDataColumn().name, data);
    };
    /**
     * Get the content type column
     * @return {module:user/userColumn~UserColumn}
     */
    MediaRow.prototype.getContentTypeColumn = function () {
        return this.mediaTable.getContentTypeColumn();
    };
    /**
     * Gets the content type
     * @return {string}
     */
    MediaRow.prototype.getContentType = function () {
        return this.getValueWithColumnName(this.getContentTypeColumn().name);
    };
    /**
     * Sets the content type for the row
     * @param  {string} contentType contentType
     */
    MediaRow.prototype.setContentType = function (contentType) {
        this.setValueWithColumnName(this.getContentTypeColumn().name, contentType);
    };
    return MediaRow;
}(userRow_1.UserRow));
exports.MediaRow = MediaRow;
//# sourceMappingURL=mediaRow.js.map