/**
 * simpleAttributesTable module.
 * @module extension/relatedTables
 */
import { UserRelatedTable } from './userRelatedTable';
import { RelationType } from './relationType';
import { UserColumn } from '../../user/userColumn';
import { DataTypes } from '../../db/dataTypes';
/**
 * Simple Attributes Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 * @param {string[]} requiredColumns required column names
 */
export declare class SimpleAttributesTable extends UserRelatedTable {
    static readonly RELATION_TYPE: RelationType;
    static readonly COLUMN_ID: string;
    readonly TABLE_TYPE: string;
    constructor(tableName: string, columns?: UserColumn[], requiredColumns?: string[]);
    /**
     * Validate that Simple Attributes columns to verify at least one non id
     * column exists and that all columns are simple data types
     */
    validateColumns(): boolean;
    /**
     * Get the column index of the id column
     * @return {Number}
     */
    getIdColumnIndex(): number;
    /**
     * Get the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    getIdColumn(): UserColumn;
    /**
     * Create a simple attributes table with the columns
     * @param  {string} tableName name of the table
     * @param  {module:user/userColumn~UserColumn[]} additionalColumns additional columns
     * @return {module:extension/relatedTables~SimpleAttributesTable}
     */
    static create(tableName: string, additionalColumns?: UserColumn[]): SimpleAttributesTable;
    /**
     * Get the required columns
     * @param  {string} [idColumnName=id] id column name
     * @return {string[]}
     */
    static requiredColumns(idColumnName?: string): string[];
    /**
     * Get the number of required columns
     * @return {Number}
     */
    static numRequiredColumns(): number;
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @param  {string} [idColumnName=id]  id column name
     * @return {module:user/userColumn~UserColumn[]}
     */
    static createRequiredColumns(startingIndex?: number, idColumnName?: string): UserColumn[];
    /**
     * Create the primary key id column
     * @param  {Number} index        index of the column
     * @param  {string} idColumnName name of the id column
     * @return {module:user/userColumn~UserColumn}
     */
    static createIdColumn(index: number, idColumnName: string): UserColumn;
    /**
     * Determine if the column is a simple column
     * @param  {module:user/userColumn~UserColumn} column column to check
     * @return {Boolean}
     */
    static isSimple(column: UserColumn): boolean;
    /**
     * Determine if the data type is a simple type: TEXT, INTEGER, or REAL
     * @param {module:db/dataTypes~GPKGDataType} dataType
     * @return {Boolean}
     */
    static isSimpleDataType(dataType: DataTypes): boolean;
}
