"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = require("../../user/userRow");
/**
 * UserMappingRow module.
 * @module extension/relatedTables
 */
/**
 * User Mapping Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~UserMappingTable} table user mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var UserMappingRow = /** @class */ (function (_super) {
    __extends(UserMappingRow, _super);
    function UserMappingRow(table, columnTypes, values) {
        var _this = _super.call(this, table, columnTypes, values) || this;
        _this.table = table;
        return _this;
    }
    /**
     * Get the base id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingRow.prototype.getBaseIdColumn = function () {
        return this.table.getBaseIdColumn();
    };
    /**
     * Gets the base id
     * @return {Number}
     */
    UserMappingRow.prototype.getBaseId = function () {
        return this.getValueWithColumnName(this.getBaseIdColumn().name);
    };
    /**
     * Sets the base id
     * @param  {Number} baseId base id
     */
    UserMappingRow.prototype.setBaseId = function (baseId) {
        this.setValueWithColumnName(this.getBaseIdColumn().name, baseId);
    };
    /**
     * Get the related id column
     * @return {module:user/userColumn~UserColumn}
     */
    UserMappingRow.prototype.getRelatedIdColumn = function () {
        return this.table.getRelatedIdColumn();
    };
    /**
     * Gets the related id
     * @return {Number}
     */
    UserMappingRow.prototype.getRelatedId = function () {
        return this.getValueWithColumnName(this.getRelatedIdColumn().name);
    };
    /**
     * Sets the related id
     * @param  {Number} relatedId related id
     */
    UserMappingRow.prototype.setRelatedId = function (relatedId) {
        this.setValueWithColumnName(this.getRelatedIdColumn().name, relatedId);
    };
    return UserMappingRow;
}(userRow_1.UserRow));
exports.UserMappingRow = UserMappingRow;
//# sourceMappingURL=userMappingRow.js.map