/**
 * userRelatedTable module.
 * @module extension/relatedTables
 */
import { UserTable } from '../../user/userTable';
import { UserColumn } from '../../user/userColumn';
import { Contents } from '../../core/contents/contents';
/**
 * User Defined Related Table
 * @param  {string} tableName table name
 * @param  {array} columns   attribute columns
 */
/**
 * User Defined Related Table
 * @param  {string} tableName       table name
 * @param  {string} relationName    relation name
 * @param  {string} dataType        Contents data type
 * @param  {module:user/userColumn~UserColumn} columns         columns
 * @param  {string[]} [requiredColumns] required columns
 * @return {module:extension/relatedTables~UserRelatedTable}
 */
export declare class UserRelatedTable extends UserTable {
    relation_name: string;
    data_type: string;
    contents: Contents;
    constructor(tableName: string, relation_name: string, data_type: string, columns: UserColumn[], requiredColumns: string[]);
    getTableType(): string;
    /**
     * Sets the contents
     * @param  {module:core/contents~Contents} contents contents
     * @throw Error if the contents data type does not match this data type
     */
    setContents(contents: Contents): boolean;
}
