import { Dao } from '../../dao/dao';
import { RTreeIndex } from './rtreeIndex';
import { FeatureDao } from '../../features/user/featureDao';
import { GeoPackage } from '../../geoPackage';
import { FeatureRow } from '../../features/user/featureRow';
import { DBValue } from '../../db/dbAdapter';
/**
 * RTree module.
 */
/**
 * RTree Index Data Access Object
 * @class
 * @extends Dao
 */
export declare class RTreeIndexDao extends Dao<RTreeIndex> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_TABLE_NAME: string;
    static readonly COLUMN_GEOM_ID: string;
    static readonly COLUMN_MIN_X: string;
    static readonly COLUMN_MAX_X: string;
    static readonly COLUMN_MIN_Y: string;
    static readonly COLUMN_MAX_Y: string;
    static readonly COLUMN_MIN_Z: string;
    static readonly COLUMN_MAX_Z: string;
    static readonly COLUMN_MIN_M: string;
    static readonly COLUMN_MAX_M: string;
    static readonly EXTENSION_NAME: string;
    static readonly EXTENSION_RTREE_INDEX_AUTHOR: string;
    static readonly EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR: string;
    static readonly EXTENSION_RTREE_INDEX_DEFINITION: string;
    gpkgTableName: string;
    featureDao: FeatureDao<FeatureRow>;
    constructor(geoPackage: GeoPackage, featureDao: FeatureDao<FeatureRow>);
    createObject(results?: Record<string, DBValue>): RTreeIndex;
    /**
     * Generate query components
     * @param envelope
     * @returns {{whereArgs: Array, where: string, join: string, tableNameArr: string[]}}
     * @private
     */
    _generateGeometryEnvelopeQuery(envelope: {
        minX: number;
        maxX: number;
        minY: number;
        maxY: number;
    }): {
        whereArgs: any[];
        where: string;
        join: string;
        tableNameArr: string[];
    };
    /**
     * Query witha geometry envelope
     * @param  {any} envelope envelope
     * @return {IterableIterator<any>}
     */
    queryWithGeometryEnvelope(envelope: {
        minX: number;
        maxX: number;
        minY: number;
        maxY: number;
    }): IterableIterator<any>;
    countWithGeometryEnvelope(envelope: {
        minX: number;
        maxX: number;
        minY: number;
        maxY: number;
    }): number;
}
