import { StyleRow } from './styleRow';
import { IconRow } from './iconRow';
/**
 * FeatureStyle constructor
 * @param {module:extension/style.StyleRow} styleRow
 * @param {module:extension/style.IconRow} iconRow
 * @constructor
 */
export declare class FeatureStyle {
    styleRow: StyleRow;
    iconRow: IconRow;
    constructor(styleRow: StyleRow, iconRow: IconRow);
    /**
     * Set style
     * @param {module:extension/style.StyleRow} styleRow
     */
    setStyle(styleRow: StyleRow): void;
    /**
     * Get style
     * @returns {module:extension/style.StyleRow}
     */
    getStyle(): StyleRow;
    /**
     * Returns true if has style
     * @returns {Boolean}
     */
    hasStyle(): boolean;
    /**
     * Set icon
     * @param {module:extension/style.IconRow} iconRow
     */
    setIcon(iconRow: IconRow): void;
    /**
     * Get icon
     * @returns {module:extension/style.IconRow}
     */
    getIcon(): IconRow;
    /**
     * Returns true if has icon
     * @returns {Boolean}
     */
    hasIcon(): boolean;
}
