import { IconRow } from './iconRow';
/**
 * @memberOf module:extension/style
 * @class IconCache
 */
/**
 * Constructor, created with cache size of {@link #IconCache.DEFAULT_CACHE_SIZE}
 * @constructor
 */
export declare class IconCache {
    cacheSize: number;
    static DEFAULT_CACHE_SIZE: number;
    iconCache: {
        [key: number]: any;
    };
    accessHistory: number[];
    constructor(cacheSize?: number);
    /**
     * Get the cached image for the icon row or null if not cached
     * @param {module:extension/style.IconRow} iconRow icon row
     * @return {Image} icon image or null
     */
    getIconForIconRow(iconRow: IconRow): any;
    /**
     * Get the cached image for the icon row id or null if not cached
     * @param {Number} iconRowId icon row id
     * @return {Image} icon image or null
     */
    get(iconRowId: number): any;
    /**
     * Cache the icon image for the icon row
     * @param {module:extension/style.IconRow} iconRow icon row
     * @param {Image} image icon image
     * @return {Image} previous cached icon image or null
     */
    putIconForIconRow(iconRow: IconRow, image: any): any;
    /**
     * Cache the icon image for the icon row id
     * @param {Number} iconRowId icon row id
     * @param {Image} image icon image
     * @return {Image} previous cached icon image or null
     */
    put(iconRowId: number, image: any): any;
    /**
     * Remove the cached image for the icon row
     * @param {module:extension/style.IconRow} iconRow icon row
     * @return {Image} removed icon image or null
     */
    removeIconForIconRow(iconRow: IconRow): any;
    /**
     * Remove the cached image for the icon row id
     * @param {Number} iconRowId icon row id
     * @return {Image} removed icon image or null
     */
    remove(iconRowId: number): any;
    /**
     * Clear the cache
     */
    clear(): void;
    /**
     * Resize the cache
     * @param {Number} maxSize max size
     */
    resize(maxSize: number): void;
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise<Image>} icon image
     */
    createIcon(icon: IconRow): Promise<any>;
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {Number} scale scale factor
     * @return {Promise<Image>} icon image
     */
    createScaledIcon(icon: IconRow, scale: number): Promise<any>;
    /**
     * Create an icon image for the icon row without caching
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise<Image>} icon image
     */
    createIconNoCache(icon: IconRow): Promise<any>;
    /**
     * Create an icon image for the icon row without caching
     * @param icon icon row
     * @param scale scale factor
     * @return {Promise<Image>} icon image
     */
    createScaledIconNoCache(icon: IconRow, scale: number): Promise<any>;
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {module:extension/style.IconCache} iconCache icon cache
     * @return {Promise<Image>} icon image
     */
    createAndCacheIcon(icon: IconRow, iconCache: IconCache): Promise<any>;
    /**
     * Create or retrieve from cache an icon image for the icon row
     * @param {module:extension/style.IconRow} icon icon row
     * @param {Number} scale scale factor
     * @param {module:extension/style.IconCache} iconCache icon cache
     * @return {Promise<Image>} icon image
     */
    createAndCacheScaledIcon(icon: IconRow, scale: number, iconCache: IconCache): Promise<any>;
}
