/**
 * @memberOf module:extension/style
 * @class IconTable
 */
import { MediaTable } from '../relatedTables/mediaTable';
import { UserColumn } from '../../user/userColumn';
/**
 * Icon Requirements Class Media Table
 * @class
 * @extends {MediaTable}
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
export declare class IconTable extends MediaTable {
    static readonly TABLE_NAME = "nga_icon";
    static readonly COLUMN_NAME = "name";
    static readonly COLUMN_DESCRIPTION = "description";
    static readonly COLUMN_WIDTH = "width";
    static readonly COLUMN_HEIGHT = "height";
    static readonly COLUMN_ANCHOR_U = "anchor_u";
    static readonly COLUMN_ANCHOR_V = "anchor_v";
    readonly TABLE_TYPE = "media";
    /**
     * Get the name column index
     * @return int
     */
    getNameColumnIndex(): number;
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    getNameColumn(): UserColumn;
    /**
     * Get the description column index
     * @return int
     */
    getDescriptionColumnIndex(): number;
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    getDescriptionColumn(): UserColumn;
    /**
     * Get the width column index
     * @return int
     */
    getWidthColumnIndex(): number;
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    getWidthColumn(): UserColumn;
    /**
     * Get the height column index
     * @return int
     */
    getHeightColumnIndex(): number;
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    getHeightColumn(): UserColumn;
    /**
     * Get the anchor_u column index
     * @return int
     */
    getAnchorUColumnIndex(): number;
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    getAnchorUColumn(): UserColumn;
    /**
     * Get the anchor_v column index
     * @return int
     */
    getAnchorVColumnIndex(): number;
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    getAnchorVColumn(): UserColumn;
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/relatedTables~MediaTable}
     */
    static create(): IconTable;
    static createRequiredColumns(): UserColumn[];
    /**
     * Get the required columns
     * @return {string[]}
     */
    static requiredColumns(): string[];
    /**
     * Create the columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    static createColumns(): UserColumn[];
}
