"use strict";
/**
 * @module extension/style
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = require("../baseExtension");
var extension_1 = require("../extension");
var contentsIdDao_1 = require("../contents/contentsIdDao");
var iconTable_1 = require("./iconTable");
var iconDao_1 = require("./iconDao");
var styleTable_1 = require("./styleTable");
var styleDao_1 = require("./styleDao");
var styleMappingTable_1 = require("./styleMappingTable");
var styleMappingDao_1 = require("./styleMappingDao");
var userMappingTable_1 = require("../relatedTables/userMappingTable");
var styleTableReader_1 = require("./styleTableReader");
var userTableReader_1 = require("../../user/userTableReader");
var featureTable_1 = require("../../features/user/featureTable");
var featureStyles_1 = require("./featureStyles");
var featureStyle_1 = require("./featureStyle");
var styles_1 = require("./styles");
var icons_1 = require("./icons");
/**
 * Style extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @extends BaseExtension
 * @constructor
 */
var FeatureStyleExtension = /** @class */ (function (_super) {
    __extends(FeatureStyleExtension, _super);
    function FeatureStyleExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.relatedTablesExtension = geoPackage.relatedTablesExtension;
        _this.contentsIdExtension = geoPackage.contentsIdExtension;
        return _this;
    }
    /**
     * Get or create the metadata extension
     *  @param {module:features/user/featureTable|String} featureTable, defaults to null
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.getOrCreateExtension = function (featureTable) {
        return this.getOrCreate(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null, FeatureStyleExtension.EXTENSION_DEFINITION, extension_1.Extension.READ_WRITE);
    };
    /**
     * Determine if the GeoPackage has the extension or has the extension for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {Boolean}
     */
    FeatureStyleExtension.prototype.has = function (featureTable) {
        return this.hasExtension(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null);
    };
    /**
     * Gets featureTables
     * @returns {String[]}
     */
    FeatureStyleExtension.prototype.getTables = function () {
        var tables = [];
        if (this.extensionsDao.isTableExists()) {
            var extensions = this.extensionsDao.queryAllByExtension(FeatureStyleExtension.EXTENSION_NAME);
            for (var i = 0; i < extensions.length; i++) {
                tables.push(extensions[i].table_name);
            }
        }
        return tables;
    };
    /**
     * Get the related tables extension
     * @returns {module:extension/relatedTables~RelatedTablesExtension}
     */
    FeatureStyleExtension.prototype.getRelatedTables = function () {
        return this.relatedTablesExtension;
    };
    /**
     * Get the contentsId extension
     * @returns {module:extension/contents~ContentsIdExtension}
     */
    FeatureStyleExtension.prototype.getContentsId = function () {
        return this.contentsIdExtension;
    };
    /**
     * Create style, icon, table style, and table icon relationships for the
     * feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.createRelationships = function (featureTable) {
        return __awaiter(this, void 0, void 0, function () {
            var promises;
            return __generator(this, function (_a) {
                promises = [];
                promises.push(this.createStyleRelationship(featureTable));
                promises.push(this.createTableStyleRelationship(featureTable));
                promises.push(this.createIconRelationship(featureTable));
                promises.push(this.createTableIconRelationship(featureTable));
                return [2 /*return*/, Promise.all(promises).then(function (_a) {
                        var _b = __read(_a, 4), styleRelationship = _b[0], tableStyleRelationship = _b[1], iconRelationship = _b[2], tableIconRelationship = _b[3];
                        return ({
                            styleRelationship: styleRelationship,
                            tableStyleRelationship: tableStyleRelationship,
                            iconRelationship: iconRelationship,
                            tableIconRelationship: tableIconRelationship,
                        });
                    })];
            });
        });
    };
    /**
     * Check if feature table has a style, icon, table style, or table icon
     * relationships
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {boolean}
     */
    FeatureStyleExtension.prototype.hasRelationship = function (featureTable) {
        return (this.hasStyleRelationship(featureTable) ||
            this.hasTableStyleRelationship(featureTable) ||
            this.hasIconRelationship(featureTable) ||
            this.hasTableIconRelationship(featureTable));
    };
    /**
     * Create a style relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.createStyleRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), styleTable_1.StyleTable.TABLE_NAME);
    };
    /**
     * Determine if a style relationship exists for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {boolean}
     */
    FeatureStyleExtension.prototype.hasStyleRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), styleTable_1.StyleTable.TABLE_NAME);
    };
    /**
     * Create a feature table style relationship
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.createTableStyleRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), this.getFeatureTableName(featureTable), contentsIdDao_1.ContentsIdDao.TABLE_NAME, styleTable_1.StyleTable.TABLE_NAME);
    };
    /**
     * Determine if a feature table style relationship exists
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {boolean} true if relationship exists
     */
    FeatureStyleExtension.prototype.hasTableStyleRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), contentsIdDao_1.ContentsIdDao.TABLE_NAME, styleTable_1.StyleTable.TABLE_NAME);
    };
    /**
     * Create an icon relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.createIconRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), iconTable_1.IconTable.TABLE_NAME);
    };
    /**
     * Determine if an icon relationship exists for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {boolean} true if relationship exists
     */
    FeatureStyleExtension.prototype.hasIconRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), iconTable_1.IconTable.TABLE_NAME);
    };
    /**
     * Create a feature table icon relationship
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.createTableIconRelationship = function (featureTable) {
        return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), this.getFeatureTableName(featureTable), contentsIdDao_1.ContentsIdDao.TABLE_NAME, iconTable_1.IconTable.TABLE_NAME);
    };
    /**
     * Determine if a feature table icon relationship exists
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @returns {Boolean} true if relationship exists
     */
    FeatureStyleExtension.prototype.hasTableIconRelationship = function (featureTable) {
        return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), contentsIdDao_1.ContentsIdDao.TABLE_NAME, iconTable_1.IconTable.TABLE_NAME);
    };
    /**
     * Get the mapping table name
     * @param tablePrefix table name prefix
     * @param {module:features/user/featureTable|String} featureTable feature table name
     * @returns {String} mapping table name
     */
    FeatureStyleExtension.prototype.getMappingTableName = function (tablePrefix, featureTable) {
        return tablePrefix + this.getFeatureTableName(featureTable);
    };
    /**
     * Check if the style extension relationship between a feature table and
     * style extension table exists
     * @param {String} mappingTableName mapping table name
     * @param {String} baseTable base table name
     * @param {String} relatedTable related table name
     * @returns {boolean} true if relationship exists
     */
    FeatureStyleExtension.prototype._hasStyleRelationship = function (mappingTableName, baseTable, relatedTable) {
        return this.relatedTablesExtension.hasRelations(baseTable, relatedTable, mappingTableName);
    };
    /**
     * Create a style extension relationship between a feature table and style
     * extension table
     * @param {String} mappingTableName mapping table name
     * @param {String} featureTable feature table
     * @param {String} baseTable base table name
     * @param {String} relatedTable related table name
     * @return {Promise}
     * @private
     */
    FeatureStyleExtension.prototype._createStyleRelationship = function (mappingTableName, featureTable, baseTable, relatedTable) {
        return __awaiter(this, void 0, void 0, function () {
            var relationships;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!this._hasStyleRelationship(mappingTableName, baseTable, relatedTable)) return [3 /*break*/, 4];
                        // Create the extension
                        return [4 /*yield*/, this.getOrCreateExtension(featureTable)];
                    case 1:
                        // Create the extension
                        _a.sent();
                        if (!(baseTable === contentsIdDao_1.ContentsIdDao.TABLE_NAME && !this.contentsIdExtension.has())) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.contentsIdExtension.getOrCreateExtension()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3: return [2 /*return*/, this._handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable)];
                    case 4:
                        relationships = this.geoPackage.extendedRelationDao.getRelations(baseTable, relatedTable, mappingTableName);
                        // TODO this isn't quite right
                        return [2 /*return*/, relationships[0]];
                }
            });
        });
    };
    /**
     * Private function to aid in creation of the a style extension relationship between a feature table and style extension table
     * @param {String} mappingTableName
     * @param {String} baseTable
     * @param {String} relatedTable
     * @return {Promise}
     * @private
     */
    FeatureStyleExtension.prototype._handleCreateStyleRelationship = function (mappingTableName, baseTable, relatedTable) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (relatedTable === styleTable_1.StyleTable.TABLE_NAME) {
                    return [2 /*return*/, this.relatedTablesExtension.addAttributesRelationship(this.geoPackage.relatedTablesExtension
                            .getRelationshipBuilder()
                            .setBaseTableName(baseTable)
                            .setUserMappingTable(styleMappingTable_1.StyleMappingTable.create(mappingTableName))
                            .setRelatedTable(styleTable_1.StyleTable.create()))];
                }
                else {
                    return [2 /*return*/, this.relatedTablesExtension.addMediaRelationship(this.geoPackage.relatedTablesExtension
                            .getRelationshipBuilder()
                            .setBaseTableName(baseTable)
                            .setUserMappingTable(styleMappingTable_1.StyleMappingTable.create(mappingTableName))
                            .setRelatedTable(iconTable_1.IconTable.create()))];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Delete the style and icon table and row relationships for all feature
     * tables
     */
    FeatureStyleExtension.prototype.deleteAllRelationships = function () {
        var removed = {
            styleRelationships: 0,
            tableStyleRelationships: 0,
            iconRelationship: 0,
            tableIconRelationship: 0,
        };
        var tables = this.getTables();
        for (var i = 0; i < tables.length; i++) {
            var _a = this.deleteRelationships(tables[i]), styleRelationships = _a.styleRelationships, tableStyleRelationships = _a.tableStyleRelationships, iconRelationship = _a.iconRelationship, tableIconRelationship = _a.tableIconRelationship;
            removed.styleRelationships += styleRelationships;
            removed.tableStyleRelationships += tableStyleRelationships;
            removed.iconRelationship += iconRelationship;
            removed.tableIconRelationship += tableIconRelationship;
        }
        return removed;
    };
    /**
     * Delete the style and icon table and row relationships for the feature
     * table
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteRelationships = function (featureTable) {
        return {
            styleRelationships: this.deleteStyleRelationship(featureTable),
            tableStyleRelationships: this.deleteTableStyleRelationship(featureTable),
            iconRelationship: this.deleteIconRelationship(featureTable),
            tableIconRelationship: this.deleteTableIconRelationship(featureTable),
        };
    };
    /**
     * Delete a style relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteStyleRelationship = function (featureTable) {
        return this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), featureTable);
    };
    /**
     * Delete a table style relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableStyleRelationship = function (featureTable) {
        return this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), featureTable);
    };
    /**
     * Delete a icon relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteIconRelationship = function (featureTable) {
        return this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), featureTable);
    };
    /**
     * Delete a table icon relationship for the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableIconRelationship = function (featureTable) {
        return this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), featureTable);
    };
    /**
     * Delete a style extension feature table relationship and the mapping table
     * @param {String} mappingTableName
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @private
     */
    FeatureStyleExtension.prototype._deleteStyleRelationship = function (mappingTableName, featureTable) {
        var removed = 0;
        var relationships = this.geoPackage.extendedRelationDao.queryByMappingTableName(mappingTableName);
        for (var i = 0; i < relationships.length; i++) {
            removed += this.relatedTablesExtension.removeRelationship(relationships[i]);
        }
        if (!this.hasRelationship(featureTable)) {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtensionAndTableName(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable));
            }
        }
        return removed;
    };
    /**
     * Get a Style Mapping DAO
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleMappingDao} style mapping DAO
     */
    FeatureStyleExtension.prototype.getStyleMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable);
    };
    /**
     * Get a Table Style Mapping DAO
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleMappingDao} table style mapping DAO
     */
    FeatureStyleExtension.prototype.getTableStyleMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable);
    };
    /**
     * Get a Icon Mapping DAO
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleMappingDao} icon mapping DAO
     */
    FeatureStyleExtension.prototype.getIconMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable);
    };
    /**
     * Get a Table Icon Mapping DAO
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleMappingDao} table icon mapping DAO
     */
    FeatureStyleExtension.prototype.getTableIconMappingDao = function (featureTable) {
        return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable);
    };
    /**
     * Get a Style Mapping DAO from a table name
     * @param {String} tablePrefix table name prefix
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleMappingDao} style mapping dao
     * @private
     */
    FeatureStyleExtension.prototype._getMappingDao = function (tablePrefix, featureTable) {
        var featureTableName = this.getFeatureTableName(featureTable);
        var tableName = tablePrefix + featureTableName;
        var dao = null;
        if (this.geoPackage.isTable(tableName)) {
            dao = new styleMappingDao_1.StyleMappingDao(this.relatedTablesExtension.getUserDao(tableName, userMappingTable_1.UserMappingTable.requiredColumns()), this.geoPackage);
        }
        return dao;
    };
    /**
     * Get a style DAO
     * @return {module:extension/style.StyleDao} style DAO
     */
    FeatureStyleExtension.prototype.getStyleDao = function () {
        var styleDao = null;
        if (this.geoPackage.isTable(styleTable_1.StyleTable.TABLE_NAME)) {
            var contents = this.geoPackage.contentsDao.queryForId(styleTable_1.StyleTable.TABLE_NAME);
            if (contents) {
                var reader = new styleTableReader_1.StyleTableReader(contents.table_name);
                var table = reader.readTable(this.geoPackage.connection);
                this.relatedTablesExtension.setContents(table);
                styleDao = new styleDao_1.StyleDao(this.geoPackage, table);
            }
        }
        return styleDao;
    };
    /**
     * Get a icon DAO
     * @return {module:extension/style.IconDao}
     */
    FeatureStyleExtension.prototype.getIconDao = function () {
        var iconDao = null;
        if (this.geoPackage.isTable(iconTable_1.IconTable.TABLE_NAME)) {
            var reader = new userTableReader_1.UserTableReader(iconTable_1.IconTable.TABLE_NAME, iconTable_1.IconTable.requiredColumns());
            var userTable = reader.readTable(this.geoPackage.database);
            var table = new iconTable_1.IconTable(userTable.table_name, userTable.columns, iconTable_1.IconTable.requiredColumns());
            table.setContents(this.geoPackage.contentsDao.queryForId(iconTable_1.IconTable.TABLE_NAME));
            iconDao = new iconDao_1.IconDao(this.geoPackage, table);
        }
        return iconDao;
    };
    /**
     * Get the feature table default feature styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.FeatureStyles} table feature styles or null
     */
    FeatureStyleExtension.prototype.getTableFeatureStyles = function (featureTable) {
        var featureStyles = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            var styles = this.getTableStyles(featureTable);
            var icons = this.getTableIcons(featureTable);
            if (styles !== null || icons !== null) {
                featureStyles = new featureStyles_1.FeatureStyles(styles, icons);
            }
        }
        return featureStyles;
    };
    /**
     * Get the default style of the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.StyleRow} style row
     */
    FeatureStyleExtension.prototype.getTableStyleDefault = function (featureTable) {
        return this.getTableStyle(featureTable, null);
    };
    /**
     * Get the style of the feature table and geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     * @return {module:extension/style.StyleRow} style row
     */
    FeatureStyleExtension.prototype.getTableStyle = function (featureTable, geometryType) {
        var style = null;
        var styles = this.getTableStyles(featureTable);
        if (styles !== null) {
            if (geometryType === null) {
                style = styles.getDefault();
            }
            else {
                style = styles.getStyle(geometryType);
            }
        }
        return style;
    };
    /**
     * Get the feature table default styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.Styles} table styles or null
     */
    FeatureStyleExtension.prototype.getTableStyles = function (featureTable) {
        var styles = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            styles = this.getStyles(id, this.getTableStyleMappingDao(featureTable));
        }
        return styles;
    };
    /**
     * Get the default icon of the feature table
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.IconRow} icon row
     */
    FeatureStyleExtension.prototype.getTableIconDefault = function (featureTable) {
        return this.getTableIcon(featureTable, null);
    };
    /**
     * Get the icon of the feature table and geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     * @return {module:extension/style.IconRow} icon row
     */
    FeatureStyleExtension.prototype.getTableIcon = function (featureTable, geometryType) {
        var icon = null;
        var icons = this.getTableIcons(featureTable);
        if (icons !== null) {
            if (geometryType === null) {
                icon = icons.getDefault();
            }
            else {
                icon = icons.getIcon(geometryType);
            }
        }
        return icon;
    };
    /**
     * Get the feature table default icons
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {module:extension/style.Icons} table icons or null
     */
    FeatureStyleExtension.prototype.getTableIcons = function (featureTable) {
        var icons = null;
        var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
        if (id !== null) {
            icons = this.getIcons(id, this.getTableIconMappingDao(featureTable));
        }
        return icons;
    };
    /**
     * Gets Icons for featureId and mappingDao
     * @param {Number} featureId
     * @param mappingDao
     * @returns {module:extension/style.Icons}
     * @private
     */
    FeatureStyleExtension.prototype.getIcons = function (featureId, mappingDao) {
        var icons = new icons_1.Icons();
        if (mappingDao !== null) {
            var iconDao = this.getIconDao();
            var styleMappingRows = mappingDao.queryByBaseId(featureId);
            for (var i = 0; i < styleMappingRows.length; i++) {
                var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
                var iconRow = iconDao.queryForId(styleMappingRow.getRelatedId());
                if (styleMappingRow.getGeometryTypeName() === null) {
                    icons.setDefault(iconRow);
                }
                else {
                    icons.setIcon(iconRow, styleMappingRow.getGeometryTypeName());
                }
            }
        }
        if (icons.isEmpty()) {
            icons = null;
        }
        return icons;
    };
    /**
     * Gets Styles for featureId and mappingDao
     * @param {Number} featureId
     * @param {module:extension/style.StyleMappingDao} mappingDao
     * @returns {module:extension/style.Styles}
     */
    FeatureStyleExtension.prototype.getStyles = function (featureId, mappingDao) {
        var styles = new styles_1.Styles();
        if (mappingDao !== null) {
            var styleDao = this.getStyleDao();
            var styleMappingRows = mappingDao.queryByBaseId(featureId);
            for (var i = 0; i < styleMappingRows.length; i++) {
                var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
                var styleRow = styleDao.queryForId(styleMappingRow.getRelatedId());
                if (styleMappingRow.getGeometryTypeName() === null) {
                    styles.setDefault(styleRow);
                }
                else {
                    styles.setStyle(styleRow, styleMappingRow.getGeometryTypeName());
                }
            }
        }
        if (styles.isEmpty()) {
            styles = null;
        }
        return styles;
    };
    /**
     * Get the feature styles for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @return {module:extension/style.FeatureStyles} feature styles or null
     */
    FeatureStyleExtension.prototype.getFeatureStylesForFeatureRow = function (featureRow) {
        return this.getFeatureStyles(featureRow.featureTable, featureRow.id);
    };
    /**
     * Get the feature styles for the feature row
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @return {module:extension/style.FeatureStyles} feature styles or null
     */
    FeatureStyleExtension.prototype.getFeatureStyles = function (featureTable, featureId) {
        var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
        var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
        var featureStyles = null;
        if (styles !== null || icons !== null) {
            featureStyles = new featureStyles_1.FeatureStyles(styles, icons);
        }
        return featureStyles;
    };
    /**
     * Get the styles for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @return {module:extension/style.Styles} styles or null
     */
    FeatureStyleExtension.prototype.getStylesForFeatureRow = function (featureRow) {
        return this.getStyles(featureRow.id, this.getStyleMappingDao(featureRow.featureTable.table_name));
    };
    /**
     * Get the styles for the feature id
     * @param {String} tableName table name
     * @param {Number} featureId feature id
     * @return {module:extension/style.Styles} styles or null
     */
    FeatureStyleExtension.prototype.getStylesForFeatureId = function (tableName, featureId) {
        return this.getStyles(featureId, this.getStyleMappingDao(tableName));
    };
    /**
     * Get the icons for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @return {module:extension/style.Icons} icons or null
     */
    FeatureStyleExtension.prototype.getIconsForFeatureRow = function (featureRow) {
        return this.getIcons(featureRow.id, this.getIconMappingDao(featureRow.featureTable.table_name));
    };
    /**
     * Get the icons for the feature id
     * @param {String} tableName table name
     * @param {Number} featureId feature id
     * @return {module:extension/style.Icons} icons or null
     */
    FeatureStyleExtension.prototype.getIconsForFeatureId = function (tableName, featureId) {
        return this.getIcons(featureId, this.getIconMappingDao(tableName));
    };
    /**
     * Get the feature style (style and icon) of the feature row, searching in
     * order: feature geometry type style or icon, feature default style or
     * icon, table geometry type style or icon, table default style or icon
     * @param {module:features/user/featureRow} featureRow feature row
     * @return {module:extension/style.FeatureStyle} feature style
     */
    FeatureStyleExtension.prototype.getFeatureStyleForFeatureRow = function (featureRow) {
        return new featureStyle_1.FeatureStyle(this.getStyle(featureRow.featureTable.table_name, featureRow.id, featureRow.getGeometryType(), true), this.getIcon(featureRow.featureTable.table_name, featureRow.id, featureRow.getGeometryType(), true));
    };
    /**
     * Get the feature style (style and icon) of the feature, searching in
     * order: feature geometry type style or icon, feature default style or
     * icon, table geometry type style or icon, table default style or icon
     * @param {module:features/user/featureRow} featureRow feature row
     * @return {module:extension/style.FeatureStyle} feature style
     */
    FeatureStyleExtension.prototype.getFeatureStyleDefault = function (featureRow) {
        return new featureStyle_1.FeatureStyle(this.getStyle(featureRow.featureTable.table_name, featureRow.id, null, true), this.getIcon(featureRow.featureTable.table_name, featureRow.id, null, true));
    };
    /**
     * Get the icon of the feature, searching in order: feature geometry type
     * icon, feature default icon, when tableIcon enabled continue searching:
     * table geometry type icon, table default icon
     * @param {module:features/user/featureTable|String} featureTable
     * @param {Number} featureId
     * @param {String} geometryType
     * @param {Boolean} tableIcon
     * @returns {module:extension/style.IconRow}
     * @private
     */
    FeatureStyleExtension.prototype.getIcon = function (featureTable, featureId, geometryType, tableIcon) {
        var iconRow = null;
        var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
        if (icons !== null) {
            iconRow = icons.getIcon(geometryType);
        }
        if (iconRow === null && tableIcon) {
            iconRow = this.getTableIcon(featureTable, geometryType);
        }
        return iconRow;
    };
    /**
     * Get the style of the feature, searching in order: feature geometry type
     * style, feature default style, when tableStyle enabled continue searching:
     * table geometry type style, table default style
     * @param {module:features/user/featureTable|String} featureTable
     * @param {Number} featureId
     * @param {String} geometryType
     * @param {Boolean} tableStyle
     * @returns {module:extension/style.StyleRow}
     * @private
     */
    FeatureStyleExtension.prototype.getStyle = function (featureTable, featureId, geometryType, tableStyle) {
        var styleRow = null;
        var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
        if (styles !== null) {
            styleRow = styles.getStyle(geometryType);
        }
        if (styleRow === null && tableStyle) {
            styleRow = this.getTableStyle(featureTable, geometryType);
        }
        return styleRow;
    };
    /**
     * Set the feature table default feature styles
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {module:extension/style.FeatureStyles} featureStyles feature styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableFeatureStyles = function (featureTable, featureStyles) {
        return __awaiter(this, void 0, void 0, function () {
            var tableStyles, tableIcons;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(featureStyles !== null)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.setTableStyles(featureTable, featureStyles.getStyles())];
                    case 1:
                        tableStyles = _a.sent();
                        return [4 /*yield*/, this.setTableIcons(featureTable, featureStyles.getIcons())];
                    case 2:
                        tableIcons = _a.sent();
                        return [2 /*return*/, {
                                tableStyles: tableStyles,
                                tableIcons: tableIcons,
                            }];
                    case 3: return [2 /*return*/, {
                            deleted: this.deleteTableFeatureStyles(featureTable),
                            tableStyles: undefined,
                            tableIcons: undefined,
                        }];
                }
            });
        });
    };
    /**
     * Set the feature table default styles
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {module:extension/style.Styles} styles default styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableStyles = function (featureTable, styles) {
        return __awaiter(this, void 0, void 0, function () {
            var deleted, promises, keys, i, key, value;
            return __generator(this, function (_a) {
                deleted = this.deleteTableStyles(featureTable);
                if (styles !== null) {
                    promises = [];
                    if (styles.getDefault() !== null) {
                        promises.push(this.setTableStyleDefault(featureTable, styles.getDefault()));
                    }
                    keys = Object.keys(styles.styles);
                    for (i = 0; i < keys.length; i++) {
                        key = keys[i];
                        value = styles.styles[key];
                        promises.push(this.setTableStyle(featureTable, key, value));
                    }
                    return [2 /*return*/, Promise.all(promises).then(function (_a) {
                            var _b = __read(_a), styleDefault = _b[0], styles = _b.slice(1);
                            return ({
                                styleDefault: styleDefault,
                                styles: styles,
                                deleted: deleted,
                            });
                        })];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Set the feature table style default
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableStyleDefault = function (featureTable, style) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setTableStyle(featureTable, null, style)];
            });
        });
    };
    /**
     * Set the feature table style for the geometry type
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableStyle = function (featureTable, geometryType, style) {
        return __awaiter(this, void 0, void 0, function () {
            var featureContentsId, styleId, mappingDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.deleteTableStyle(featureTable, geometryType);
                        if (!(style !== null)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createTableStyleRelationship(featureTable)];
                    case 1:
                        _a.sent();
                        featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
                        styleId = this.getOrInsertStyle(style);
                        mappingDao = this.getTableStyleMappingDao(featureTable);
                        return [2 /*return*/, this.insertStyleMapping(mappingDao, featureContentsId.id, styleId, geometryType)];
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Set the feature table default icons
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {module:extension/style.Icons} icons default icons
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableIcons = function (featureTable, icons) {
        return __awaiter(this, void 0, void 0, function () {
            var deleted, promises, keys, i, key, value;
            return __generator(this, function (_a) {
                deleted = this.deleteTableIcons(featureTable);
                if (icons !== null) {
                    promises = [];
                    if (icons.getDefault() !== null) {
                        promises.push(this.setTableIconDefault(featureTable, icons.getDefault()));
                    }
                    keys = Object.keys(icons.icons);
                    for (i = 0; i < keys.length; i++) {
                        key = keys[i];
                        value = icons.icons[key];
                        promises.push(this.setTableIcon(featureTable, key, value));
                    }
                    return [2 /*return*/, Promise.all(promises).then(function (_a) {
                            var _b = __read(_a), iconDefault = _b[0], icons = _b.slice(1);
                            return ({
                                iconDefault: iconDefault,
                                icons: icons,
                                deleted: deleted,
                            });
                        })];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Set the feature table icon default
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableIconDefault = function (featureTable, icon) {
        return this.setTableIcon(featureTable, null, icon);
    };
    /**
     * Set the feature table icon for the geometry type
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setTableIcon = function (featureTable, geometryType, icon) {
        return __awaiter(this, void 0, void 0, function () {
            var featureContentsId, iconId, mappingDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.deleteTableIcon(featureTable, geometryType);
                        if (!(icon !== null)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createTableIconRelationship(featureTable)];
                    case 1:
                        _a.sent();
                        featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
                        iconId = this.getOrInsertIcon(icon);
                        mappingDao = this.getTableIconMappingDao(featureTable);
                        return [2 /*return*/, this.insertStyleMapping(mappingDao, featureContentsId.id, iconId, geometryType)];
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Set the feature styles for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.FeatureStyles} featureStyles feature styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStylesForFeatureRow = function (featureRow, featureStyles) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setFeatureStyles(featureRow.featureTable.table_name, featureRow.id, featureStyles)];
            });
        });
    };
    /**
     * Set the feature styles for the feature table and feature id
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.FeatureStyles} featureStyles feature styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyles = function (featureTable, featureId, featureStyles) {
        return __awaiter(this, void 0, void 0, function () {
            var styles, icons, deletedStyles, deletedIcons;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(featureStyles !== null)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.setStyles(featureTable, featureId, featureStyles.getStyles())];
                    case 1:
                        styles = _a.sent();
                        return [4 /*yield*/, this.setIcons(featureTable, featureId, featureStyles.getIcons())];
                    case 2:
                        icons = _a.sent();
                        return [2 /*return*/, {
                                styles: styles,
                                icons: icons,
                            }];
                    case 3:
                        deletedStyles = this.deleteStyles(featureTable);
                        deletedIcons = this.deleteIcons(featureTable);
                        return [2 /*return*/, {
                                styles: undefined,
                                icons: undefined,
                                deleted: {
                                    deletedStyles: deletedStyles,
                                    deletedIcons: deletedIcons,
                                },
                            }];
                }
            });
        });
    };
    /**
     * Set the feature style (style and icon) of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.FeatureStyle} featureStyle feature style
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyleForFeatureRow = function (featureRow, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setFeatureStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), featureStyle)];
            });
        });
    };
    /**
     * Set the feature style (style and icon) of the feature row for the
     * specified geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {String} geometryType geometry type
     * @param {module:extension/style.FeatureStyle} featureStyle feature style
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.id, geometryType, featureStyle)];
            });
        });
    };
    /**
     * Set the feature style default (style and icon) of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.FeatureStyle} featureStyle feature style
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyleDefaultForFeatureRow = function (featureRow, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.id, null, featureStyle)];
            });
        });
    };
    /**
     * Set the feature style (style and icon) of the feature
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     * @param {module:extension/style.FeatureStyle} featureStyle feature style
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyle = function (featureTable, featureId, geometryType, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            var promises;
            return __generator(this, function (_a) {
                if (featureStyle !== null) {
                    promises = [];
                    promises.push(this.setStyle(featureTable, featureId, geometryType, featureStyle.getStyle()));
                    promises.push(this.setIcon(featureTable, featureId, geometryType, featureStyle.getIcon()));
                    return [2 /*return*/, Promise.all(promises).then(function (_a) {
                            var _b = __read(_a, 2), style = _b[0], icon = _b[1];
                            return ({
                                style: style,
                                icon: icon,
                            });
                        })];
                }
                else {
                    return [2 /*return*/, {
                            style: undefined,
                            icon: undefined,
                            deleted: {
                                style: this.deleteStyle(featureTable, featureId, geometryType),
                                icon: this.deleteIcon(featureTable, featureId, geometryType),
                            },
                        }];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Set the feature style (style and icon) of the feature
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.FeatureStyle} featureStyle feature style
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setFeatureStyleDefault = function (featureTable, featureId, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setFeatureStyle(featureTable, featureId, null, featureStyle)];
            });
        });
    };
    /**
     * Set the styles for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.Styles} styles styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStylesForFeatureRow = function (featureRow, styles) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setStyles(featureRow.featureTable.table_name, featureRow.id, styles)];
            });
        });
    };
    /**
     * Set the styles for the feature table and feature id
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.Styles} styles styles
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyles = function (featureTable, featureId, styles) {
        return __awaiter(this, void 0, void 0, function () {
            var deleted, promises, keys, i;
            return __generator(this, function (_a) {
                deleted = this.deleteStylesForFeatureId(featureTable, featureId);
                if (styles !== null) {
                    promises = [];
                    if (styles.getDefault() !== null) {
                        promises.push(this.setStyleDefault(featureTable, featureId, styles.getDefault()));
                    }
                    keys = Object.keys(styles.styles);
                    for (i = 0; i < keys.length; i++) {
                        promises.push(this.setStyle(featureTable, featureId, keys[i], styles.styles[keys[i]]));
                    }
                    return [2 /*return*/, Promise.all(promises).then(function (_a) {
                            var _b = __read(_a), styleDefault = _b[0], styles = _b.slice(1);
                            return ({
                                styleDefault: styleDefault,
                                styles: styles,
                                deleted: deleted,
                            });
                        })];
                }
                else {
                    return [2 /*return*/, {
                            styleDefault: undefined,
                            styles: undefined,
                            deleted: deleted,
                        }];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Set the style of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyleForFeatureRow = function (featureRow, style) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), style)];
            });
        });
    };
    /**
     * Set the style of the feature row for the specified geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {String} geometryType geometry type
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyleForFeatureRowAndGeometryType = function (featureRow, geometryType, style) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setStyle(featureRow.featureTable.table_name, featureRow.id, geometryType, style)];
            });
        });
    };
    /**
     * Set the default style of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyleDefaultForFeatureRow = function (featureRow, style) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setStyle(featureRow.featureTable.table_name, featureRow.id, null, style)];
            });
        });
    };
    /**
     * Set the style of the feature
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyle = function (featureTable, featureId, geometryType, style) {
        return __awaiter(this, void 0, void 0, function () {
            var styleId, mappingDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.deleteStyle(featureTable, featureId, geometryType);
                        if (!(style !== null)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createStyleRelationship(featureTable)];
                    case 1:
                        _a.sent();
                        styleId = this.getOrInsertStyle(style);
                        mappingDao = this.getStyleMappingDao(featureTable);
                        return [2 /*return*/, this.insertStyleMapping(mappingDao, featureId, styleId, geometryType)];
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Set the default style of the feature
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.StyleRow} style style row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setStyleDefault = function (featureTable, featureId, style) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setStyle(featureTable, featureId, null, style)];
            });
        });
    };
    /**
     * Set the icons for the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.Icons} icons icons
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIconsForFeatureRow = function (featureRow, icons) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setIcons(featureRow.featureTable.table_name, featureRow.id, icons)];
            });
        });
    };
    /**
     * Set the icons for the feature table and feature id
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.Icons} icons icons
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIcons = function (featureTable, featureId, icons) {
        return __awaiter(this, void 0, void 0, function () {
            var deleted, promises, keys, i;
            return __generator(this, function (_a) {
                deleted = this.deleteIconsForFeatureId(featureTable, featureId);
                if (icons !== null) {
                    promises = [];
                    if (icons.getDefault() !== null) {
                        promises.push(this.setIconDefault(featureTable, featureId, icons.getDefault()));
                    }
                    keys = Object.keys(icons.icons);
                    for (i = 0; i < keys.length; i++) {
                        promises.push(this.setIcon(featureTable, featureId, keys[i], icons.icons[keys[i]]));
                    }
                    return [2 /*return*/, Promise.all(promises).then(function (_a) {
                            var _b = __read(_a), iconDefault = _b[0], icons = _b.slice(1);
                            return ({
                                iconDefault: iconDefault,
                                icons: icons,
                                deleted: deleted,
                            });
                        })];
                }
                else {
                    return [2 /*return*/, {
                            iconDefault: undefined,
                            icons: undefined,
                            deleted: deleted,
                        }];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Set the icon of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIconForFeatureRow = function (featureRow, icon) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), icon)];
            });
        });
    };
    /**
     * Set the icon of the feature row for the specified geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {String} geometryType geometry type
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIconForFeatureRowAndGeometryType = function (featureRow, geometryType, icon) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setIcon(featureRow.featureTable.table_name, featureRow.id, geometryType, icon)];
            });
        });
    };
    /**
     * Set the default icon of the feature row
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIconDefaultForFeatureRow = function (featureRow, icon) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setIcon(featureRow.featureTable.table_name, featureRow.id, null, icon)];
            });
        });
    };
    /**
     * Get the icon of the feature, searching in order: feature geometry type
     * icon, feature default icon, table geometry type icon, table default icon
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIcon = function (featureTable, featureId, geometryType, icon) {
        return __awaiter(this, void 0, void 0, function () {
            var iconId, mappingDao;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.deleteIcon(featureTable, featureId, geometryType);
                        if (!(icon !== null)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createIconRelationship(featureTable)];
                    case 1:
                        _a.sent();
                        iconId = this.getOrInsertIcon(icon);
                        mappingDao = this.getIconMappingDao(featureTable);
                        return [2 /*return*/, this.insertStyleMapping(mappingDao, featureId, iconId, geometryType)];
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Set the default icon of the feature
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Promise}
     */
    FeatureStyleExtension.prototype.setIconDefault = function (featureTable, featureId, icon) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.setIcon(featureTable, featureId, null, icon)];
            });
        });
    };
    /**
     * Get the style id, either from the existing style or by inserting a new one
     * @param {module:extension/style.StyleRow} style style row
     * @return {Number} style id
     */
    FeatureStyleExtension.prototype.getOrInsertStyle = function (style) {
        var styleId;
        if (style.hasId()) {
            styleId = style.id;
        }
        else {
            var styleDao = this.getStyleDao();
            if (styleDao !== null) {
                styleId = styleDao.create(style);
                style.setId(styleId);
            }
        }
        return styleId;
    };
    /**
     * Get the icon id, either from the existing icon or by inserting a new one
     * @param {module:extension/style.IconRow} icon icon row
     * @return {Number} icon id
     */
    FeatureStyleExtension.prototype.getOrInsertIcon = function (icon) {
        var iconId;
        if (icon.hasId()) {
            iconId = icon.id;
        }
        else {
            var iconDao = this.getIconDao();
            if (iconDao != null) {
                iconId = iconDao.create(icon);
                icon.setId(iconId);
            }
        }
        return iconId;
    };
    /**
     * Insert a style mapping row
     * @param {module:extension/style.StyleMappingDao} mappingDao mapping dao
     * @param {Number} baseId base id, either contents id or feature id
     * @param {Number} relatedId related id, either style or icon id
     * @param {String} geometryType geometry type or null
     */
    FeatureStyleExtension.prototype.insertStyleMapping = function (mappingDao, baseId, relatedId, geometryType) {
        var row = mappingDao.newRow();
        row.setBaseId(baseId);
        row.setRelatedId(relatedId);
        row.setGeometryTypeName(geometryType);
        return mappingDao.create(row);
    };
    /**
     * Delete all feature styles including table styles, table icons, style, and icons
     * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteAllFeatureStyles = function (featureTable) {
        return {
            tableStyles: this.deleteTableFeatureStyles(featureTable),
            styles: this.deleteFeatureStyles(featureTable),
        };
    };
    /**
     * Delete all styles including table styles and feature row style
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteAllStyles = function (featureTable) {
        return {
            tableStyles: this.deleteTableStyles(featureTable),
            styles: this.deleteStyles(featureTable),
        };
    };
    /**
     * Delete all icons including table icons and feature row icons
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteAllIcons = function (featureTable) {
        return {
            tableIcons: this.deleteTableIcons(featureTable),
            icons: this.deleteIcons(featureTable),
        };
    };
    /**
     * Delete the feature table feature styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableFeatureStyles = function (featureTable) {
        return {
            styles: this.deleteTableStyles(featureTable),
            icons: this.deleteTableIcons(featureTable),
        };
    };
    /**
     * Delete the feature table styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableStyles = function (featureTable) {
        return this.deleteTableMappings(this.getTableStyleMappingDao(featureTable), featureTable);
    };
    /**
     * Delete the feature table default style
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableStyleDefault = function (featureTable) {
        return this.deleteTableStyle(featureTable, null);
    };
    /**
     * Delete the feature table style for the geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteTableStyle = function (featureTable, geometryType) {
        return this.deleteTableMapping(this.getTableStyleMappingDao(featureTable), featureTable, geometryType);
    };
    /**
     * Delete the feature table icons
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableIcons = function (featureTable) {
        return this.deleteTableMappings(this.getTableIconMappingDao(featureTable), featureTable);
    };
    /**
     * Delete the feature table default icon
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableIconDefault = function (featureTable) {
        return this.deleteTableIcon(featureTable, null);
    };
    /**
     * Delete the feature table icon for the geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteTableIcon = function (featureTable, geometryType) {
        return this.deleteTableMapping(this.getTableIconMappingDao(featureTable), featureTable, geometryType);
    };
    /**
     * Delete the table style mappings
     * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteTableMappings = function (mappingDao, featureTable) {
        if (mappingDao !== null) {
            var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
            if (featureContentsId !== null) {
                return mappingDao.deleteByBaseId(featureContentsId);
            }
        }
        return 0;
    };
    /**
     * Delete the table style mapping with the geometry type value
     * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteTableMapping = function (mappingDao, featureTable, geometryType) {
        if (mappingDao !== null) {
            var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
            if (featureContentsId !== null) {
                return mappingDao.deleteByBaseIdAndGeometryType(featureContentsId, geometryType);
            }
        }
        return 0;
    };
    /**
     * Delete all feature styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteFeatureStyles = function (featureTable) {
        return {
            styles: this.deleteStyles(featureTable),
            icons: this.deleteIcons(featureTable),
        };
    };
    /**
     * Delete all styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteStyles = function (featureTable) {
        return this.deleteMappings(this.getStyleMappingDao(featureTable));
    };
    /**
     * Delete feature row styles
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteStylesForFeatureRow = function (featureRow) {
        return this.deleteStylesForFeatureId(featureRow.featureTable.table_name, featureRow.id);
    };
    /**
     * Delete feature row styles
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     */
    FeatureStyleExtension.prototype.deleteStylesForFeatureId = function (featureTable, featureId) {
        return this.deleteMappingsForFeatureId(this.getStyleMappingDao(featureTable), featureId);
    };
    /**
     * Delete the feature row default style
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteStyleDefaultForFeatureRow = function (featureRow) {
        return this.deleteStyleForFeatureRowAndGeometryType(featureRow, null);
    };
    /**
     * Delete the feature row default style
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     */
    FeatureStyleExtension.prototype.deleteStyleDefault = function (featureTable, featureId) {
        return this.deleteStyle(featureTable, featureId, null);
    };
    /**
     * Delete the feature row style for the feature row geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteStyleForFeatureRow = function (featureRow) {
        return this.deleteStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
     * Delete the feature row style for the geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteStyleForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        return this.deleteStyle(featureRow.featureTable, featureRow.id, geometryType);
    };
    /**
     * Delete the feature row style for the geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteStyle = function (featureTable, featureId, geometryType) {
        return this.deleteMapping(this.getStyleMappingDao(featureTable), featureId, geometryType);
    };
    /**
     * Delete the style row and associated mappings by style row
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {module:extension/style.StyleRow} styleRow style row
     */
    FeatureStyleExtension.prototype.deleteStyleAndMappingsByStyleRow = function (featureTable, styleRow) {
        return this.deleteStyleAndMappingsByStyleRowId(featureTable, styleRow.id);
    };
    /**
     * Delete the style row and associated mappings by style row id
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} styleRowId style row id
     */
    FeatureStyleExtension.prototype.deleteStyleAndMappingsByStyleRowId = function (featureTable, styleRowId) {
        this.getStyleDao().deleteById(styleRowId);
        this.getStyleMappingDao(featureTable).deleteByRelatedId(styleRowId);
        return this.getTableStyleMappingDao(featureTable).deleteByRelatedId(styleRowId);
    };
    /**
     * Delete all icons
     * @param {module:features/user/featureTable|String} featureTable feature table
     */
    FeatureStyleExtension.prototype.deleteIcons = function (featureTable) {
        return this.deleteMappings(this.getIconMappingDao(featureTable));
    };
    /**
     * Delete feature row icons
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteIconsForFeatureRow = function (featureRow) {
        return this.deleteIconsForFeatureId(featureRow.featureTable.table_name, featureRow.id);
    };
    /**
     * Delete feature row icons
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     */
    FeatureStyleExtension.prototype.deleteIconsForFeatureId = function (featureTable, featureId) {
        return this.deleteMappingsForFeatureId(this.getIconMappingDao(featureTable), featureId);
    };
    /**
     * Delete the feature row default icon
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteIconDefaultForFeatureRow = function (featureRow) {
        return this.deleteIconDefault(featureRow.featureTable.table_name, featureRow.id);
    };
    /**
     * Delete the feature row default icon
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     */
    FeatureStyleExtension.prototype.deleteIconDefault = function (featureTable, featureId) {
        return this.deleteIcon(featureTable, featureId, null);
    };
    /**
     * Delete the feature row icon for the feature row geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     */
    FeatureStyleExtension.prototype.deleteIconForFeatureRow = function (featureRow) {
        return this.deleteIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
    };
    /**
     * Delete the feature row icon for the geometry type
     * @param {module:features/user/featureRow} featureRow feature row
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteIconForFeatureRowAndGeometryType = function (featureRow, geometryType) {
        return this.deleteIcon(featureRow.featureTable, featureRow.id, geometryType);
    };
    /**
     * Delete the feature row icon for the geometry type
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteIcon = function (featureTable, featureId, geometryType) {
        return this.deleteMapping(this.getIconMappingDao(featureTable), featureId, geometryType);
    };
    /**
     * Delete the icon row and associated mappings by icon row
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {module:extension/style.IconRow} iconRow icon row
     */
    FeatureStyleExtension.prototype.deleteIconAndMappingsByIconRow = function (featureTable, iconRow) {
        return this.deleteIconAndMappingsByIconRowId(featureTable, iconRow.id);
    };
    /**
     * Delete the icon row and associated mappings by icon row id
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @param {Number} iconRowId icon row id
     */
    FeatureStyleExtension.prototype.deleteIconAndMappingsByIconRowId = function (featureTable, iconRowId) {
        this.getIconDao().deleteById(iconRowId);
        this.getIconMappingDao(featureTable).deleteByRelatedId(iconRowId);
        return this.getTableIconMappingDao(featureTable).deleteByRelatedId(iconRowId);
    };
    /**
     * Delete all style mappings
     * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
     */
    FeatureStyleExtension.prototype.deleteMappings = function (mappingDao) {
        if (mappingDao !== null) {
            return mappingDao.deleteAll();
        }
        return 0;
    };
    /**
     * Delete the style mappings
     * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
     * @param {Number} featureId feature id
     */
    FeatureStyleExtension.prototype.deleteMappingsForFeatureId = function (mappingDao, featureId) {
        if (mappingDao !== null && featureId) {
            return mappingDao.deleteByBaseId(featureId);
        }
        return 0;
    };
    /**
     * Delete the style mapping with the geometry type value
     * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
     * @param {Number} featureId feature id
     * @param {String} geometryType geometry type
     */
    FeatureStyleExtension.prototype.deleteMapping = function (mappingDao, featureId, geometryType) {
        if (mappingDao !== null) {
            return mappingDao.deleteByBaseIdAndGeometryType(featureId, geometryType);
        }
        return 0;
    };
    /**
     * Get all the unique style row ids the table maps to
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return style row ids
     */
    FeatureStyleExtension.prototype.getAllTableStyleIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getTableStyleMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
     * Get all the unique icon row ids the table maps to
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return icon row ids
     */
    FeatureStyleExtension.prototype.getAllTableIconIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getTableIconMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
     * Get all the unique style row ids the features map to
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Number[]} style row ids
     */
    FeatureStyleExtension.prototype.getAllStyleIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getStyleMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
     * Get all the unique icon row ids the features map to
     * @param {module:features/user/featureTable|String} featureTable feature table
     * @return {Number[]} icon row ids
     */
    FeatureStyleExtension.prototype.getAllIconIds = function (featureTable) {
        var styleIds = null;
        var mappingDao = this.getIconMappingDao(featureTable);
        if (mappingDao !== null) {
            styleIds = mappingDao.uniqueRelatedIds().map(function (row) { return row['related_id']; });
        }
        return styleIds;
    };
    /**
     * Get name of feature table
     * @param featureTable
     * @returns {String}
     */
    FeatureStyleExtension.prototype.getFeatureTableName = function (featureTable) {
        return featureTable instanceof featureTable_1.FeatureTable ? featureTable.table_name : featureTable;
    };
    /**
     * Remove all traces of the extension
     */
    FeatureStyleExtension.prototype.removeExtension = function () {
        this.deleteAllRelationships();
        this.geoPackage.deleteTable(styleTable_1.StyleTable.TABLE_NAME);
        this.geoPackage.deleteTable(iconTable_1.IconTable.TABLE_NAME);
        if (this.extensionsDao.isTableExists()) {
            return this.extensionsDao.deleteByExtension(FeatureStyleExtension.EXTENSION_NAME);
        }
        return 0;
    };
    FeatureStyleExtension.EXTENSION_NAME = 'nga_feature_style';
    FeatureStyleExtension.EXTENSION_AUTHOR = 'nga';
    FeatureStyleExtension.EXTENSION_NAME_NO_AUTHOR = 'feature_style';
    FeatureStyleExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/feature-style.html';
    FeatureStyleExtension.TABLE_MAPPING_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + '_style_';
    FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + '_style_default_';
    FeatureStyleExtension.TABLE_MAPPING_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + '_icon_';
    FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + '_icon_default_';
    return FeatureStyleExtension;
}(baseExtension_1.BaseExtension));
exports.FeatureStyleExtension = FeatureStyleExtension;
//# sourceMappingURL=index.js.map