"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleDao
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var attributeDao_1 = require("../../attributes/attributeDao");
var styleRow_1 = require("./styleRow");
/**
 * Style DAO for reading style tables
 * @extends {AttributesDao}
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage connection
 * @param  {string} table table name
 * @constructor
 */
var StyleDao = /** @class */ (function (_super) {
    __extends(StyleDao, _super);
    function StyleDao(geoPackage, table) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.table = table;
        return _this;
    }
    /**
     * Creates a StyleRow object from the results
     * @param results
     * @returns {module:extension/style.StyleRow}
     */
    StyleDao.prototype.createObject = function (results) {
        if (results) {
            return this.getRow(results);
        }
        return this.newRow();
    };
    /**
     * Create a new style row
     * @return {module:extension/style.StyleRow}
     */
    StyleDao.prototype.newRow = function () {
        return new styleRow_1.StyleRow(this.table);
    };
    /**
     * Create a style row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/style.StyleRow}             icon row
     */
    StyleDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new styleRow_1.StyleRow(this.table, columnTypes, values);
    };
    return StyleDao;
}(attributeDao_1.AttributeDao));
exports.StyleDao = StyleDao;
//# sourceMappingURL=styleDao.js.map