"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleMappingRow
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userMappingRow_1 = require("../relatedTables/userMappingRow");
/**
 * User Mapping Row containing the values from a single result set row
 * @extends UserMappingRow
 * @param  {module:extension/style.StyleMappingTable} styleMappingTable style mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
var StyleMappingRow = /** @class */ (function (_super) {
    __extends(StyleMappingRow, _super);
    function StyleMappingRow(styleMappingTable, columnTypes, values) {
        var _this = _super.call(this, styleMappingTable, columnTypes, values) || this;
        _this.styleMappingTable = styleMappingTable;
        return _this;
    }
    /**
     * Get the geometry type name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleMappingRow.prototype.getGeometryTypeNameColumn = function () {
        return this.styleMappingTable.getGeometryTypeNameColumn();
    };
    /**
     * Gets the geometry type name
     * @return {string}
     */
    StyleMappingRow.prototype.getGeometryTypeName = function () {
        return this.getValueWithColumnName(this.getGeometryTypeNameColumn().name);
    };
    /**
     * Sets the geometry type name
     * @param  {string} geometryTypeName geometry type name
     */
    StyleMappingRow.prototype.setGeometryTypeName = function (geometryTypeName) {
        this.setValueWithColumnName(this.getGeometryTypeNameColumn().name, geometryTypeName);
    };
    return StyleMappingRow;
}(userMappingRow_1.UserMappingRow));
exports.StyleMappingRow = StyleMappingRow;
//# sourceMappingURL=styleMappingRow.js.map