"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class GeometryColumns
 */
var GeometryColumns = /** @class */ (function () {
    function GeometryColumns() {
    }
    Object.defineProperty(GeometryColumns.prototype, "geometryType", {
        get: function () {
            return this.geometry_type_name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeometryColumns.prototype, "id", {
        get: function () {
            return this.table_name + " " + this.column_name;
        },
        enumerable: true,
        configurable: true
    });
    GeometryColumns.TABLE_NAME = 'tableName';
    GeometryColumns.COLUMN_NAME = 'columnName';
    GeometryColumns.GEOMETRY_TYPE_NAME = 'geometryTypeName';
    GeometryColumns.SRS_ID = 'srsId';
    GeometryColumns.Z = 'z';
    GeometryColumns.M = 'm';
    return GeometryColumns;
}());
exports.GeometryColumns = GeometryColumns;
//# sourceMappingURL=geometryColumns.js.map