"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureDao module.
 * @module features/user/featureDao
 */
// @ts-ignore
var reproject_1 = __importDefault(require("reproject"));
var line_intersect_1 = __importDefault(require("@turf/line-intersect"));
var intersect_1 = __importDefault(require("@turf/intersect"));
// @ts-ignore
var boolean_within_1 = __importDefault(require("@turf/boolean-within"));
var featureTableIndex_1 = require("../../extension/index/featureTableIndex");
var userDao_1 = require("../../user/userDao");
var dataColumnsDao_1 = require("../../dataColumns/dataColumnsDao");
var featureRow_1 = require("./featureRow");
var dataTypes_1 = require("../../db/dataTypes");
var boundingBox_1 = require("../../boundingBox");
/**
 * Feature DAO for reading feature user data tables
 * @class FeatureDao
 * @extends UserDao
 * @param  {any} db              database connection
 * @param  {FeatureTable} table           feature table
 * @param  {GeometryColumns} geometryColumns geometry columns
 * @param  {MetadataDao} metadataDao      metadata dao
 */
var FeatureDao = /** @class */ (function (_super) {
    __extends(FeatureDao, _super);
    function FeatureDao(geoPackage, table, geometryColumns, metadataDao) {
        var _this = _super.call(this, geoPackage, table) || this;
        _this.table = table;
        _this.geometryColumns = geometryColumns;
        _this.metadataDao = metadataDao;
        _this.dataColumnsDao = new dataColumnsDao_1.DataColumnsDao(geoPackage);
        _this.featureTableIndex = new featureTableIndex_1.FeatureTableIndex(geoPackage, _this);
        var dao = geoPackage.geometryColumnsDao;
        if (!dao.getContents(geometryColumns)) {
            throw new Error('Geometry Columns ' + geometryColumns.id + ' has null Contents');
        }
        if (!dao.getSrs(geometryColumns)) {
            throw new Error('Geometry Columns ' + geometryColumns.id + ' has null Spatial Reference System');
        }
        _this.projection = dao.getProjection(geometryColumns);
        return _this;
    }
    FeatureDao.prototype.createObject = function (results) {
        if (results) {
            return this.getRow(results);
        }
        return this.newRow();
    };
    FeatureDao.prototype.getRow = function (results) {
        return _super.prototype.getRow.call(this, results);
    };
    FeatureDao.prototype.getContents = function () {
        var dao = this.geoPackage.geometryColumnsDao;
        return dao.getContents(this.geometryColumns);
    };
    /**
     * Get the feature table
     * @return {FeatureTable} the feature table
     */
    FeatureDao.prototype.getFeatureTable = function () {
        return this.table;
    };
    FeatureDao.prototype.getTable = function () {
        return this.table;
    };
    /**
     * Create a new feature row with the column types and values
     * @param  {Array} columnTypes column types
     * @param  {Array} values      values
     * @return {FeatureRow}             feature row
     */
    FeatureDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new featureRow_1.FeatureRow(this.getFeatureTable(), columnTypes, values);
    };
    /**
     * Create a new feature row
     * @return {FeatureRow} feature row
     */
    FeatureDao.prototype.newRow = function () {
        return new featureRow_1.FeatureRow(this.getFeatureTable());
    };
    /**
     * Get the geometry column name
     * @return {string} the geometry column name
     */
    FeatureDao.prototype.getGeometryColumnName = function () {
        return this.geometryColumns.column_name;
    };
    /**
     * Get the geometry types
     * @return {Number} well known binary geometry type
     */
    //TODO is this a string?
    FeatureDao.prototype.getGeometryType = function () {
        return this.geometryColumns.geometryType;
    };
    FeatureDao.prototype.getSrs = function () {
        return this.geoPackage.geometryColumnsDao.getSrs(this.geometryColumns);
    };
    /**
     * Determine if the feature table is indexed
     * @returns {Boolean} indexed status of the table
     */
    FeatureDao.prototype.isIndexed = function () {
        return this.featureTableIndex.isIndexed();
    };
    FeatureDao.prototype.index = function (progress) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.featureTableIndex.index(progress)];
            });
        });
    };
    /**
     * Query for count in bounding box
     * @param boundingBox
     * @returns {Number}
     */
    FeatureDao.prototype.countWebMercatorBoundingBox = function (boundingBox) {
        return this.featureTableIndex.countWithBoundingBox(boundingBox, 'EPSG:3857');
    };
    /**
     * Query for count in bounding box
     * @param boundingBox
     * @param projection
     * @returns {Number}}
     */
    FeatureDao.prototype.countInBoundingBox = function (boundingBox, projection) {
        return this.featureTableIndex.countWithBoundingBox(boundingBox, projection);
    };
    /**
     * Fast query web mercator bounding box
     * @param {BoundingBox} boundingBox bounding box to query for
     * @returns {any}
     */
    FeatureDao.prototype.fastQueryWebMercatorBoundingBox = function (boundingBox) {
        var _a;
        var _this = this;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = _this.getRow(nextRow.value);
                    return {
                        value: featureRow,
                        done: false,
                    };
                }
                else {
                    return {
                        value: undefined,
                        done: true,
                    };
                }
            },
            _a;
    };
    FeatureDao.prototype.queryIndexedFeaturesWithWebMercatorBoundingBox = function (boundingBox) {
        var _a;
        var srs = this.getSrs();
        var projection = this.projection;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
        var thisgetRow = this.getRow.bind(this);
        var projectedBoundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = void 0;
                    var geometry = void 0;
                    while (!nextRow.done && !geometry) {
                        featureRow = thisgetRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        geometry = FeatureDao.verifyFeature(geometry, projectedBoundingBox);
                        if (geometry) {
                            geometry.properties = featureRow.values;
                            return {
                                value: featureRow,
                                done: false,
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true,
                    value: undefined,
                };
            },
            _a;
    };
    FeatureDao.prototype.fastQueryBoundingBox = function (boundingBox, projection) {
        var _a;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, projection);
        var thisgetRow = this.getRow.bind(this);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = thisgetRow(nextRow.value);
                    return {
                        value: featureRow,
                        done: false,
                    };
                }
                else {
                    return {
                        done: true,
                        value: undefined,
                    };
                }
            },
            _a;
    };
    FeatureDao.prototype.queryIndexedFeaturesWithBoundingBox = function (boundingBox) {
        var _a;
        var srs = this.getSrs();
        var projection = this.projection;
        var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, projection);
        var thisgetRow = this.getRow.bind(this);
        var projectedBoundingBox = boundingBox.projectBoundingBox(projection, this.projection);
        return _a = {},
            _a[Symbol.iterator] = function () {
                return this;
            },
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = void 0;
                    var geometry = void 0;
                    while (!nextRow.done && !geometry) {
                        featureRow = thisgetRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        geometry = FeatureDao.verifyFeature(geometry, projectedBoundingBox);
                        if (geometry) {
                            geometry.properties = featureRow.values;
                            return {
                                value: featureRow,
                                done: false,
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true,
                    value: undefined,
                };
            },
            _a;
    };
    /**
     * Calls geoJSONFeatureCallback with the geoJSON of each matched feature (always in 4326 projection)
     * @param  {BoundingBox} boundingBox        4326 bounding box to query
     * @param {Boolean} [skipVerification] do not verify if the feature actually exists in the box
     * @returns {any}
     */
    FeatureDao.prototype.queryForGeoJSONIndexedFeaturesWithBoundingBox = function (boundingBox, skipVerification) {
        var _a;
        var _this = this;
        if (skipVerification === void 0) { skipVerification = false; }
        var columns = [];
        var columnMap = {};
        var srs = this.getSrs();
        var projection = this.projection;
        this.table.columns.forEach(function (column) {
            var dataColumn = _this.dataColumnsDao.getDataColumns(_this.table.table_name, column.name);
            columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType ? dataTypes_1.DataTypes.nameFromType(column.dataType) : '',
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn,
            });
            columnMap[column.name] = columns[columns.length - 1];
        });
        var iterator;
        if (boundingBox) {
            iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:4326')[Symbol.iterator]();
        }
        else {
            iterator = this.queryForEach();
        }
        return _a = {
                srs: srs,
                featureDao: this
            },
            _a[Symbol.iterator] = function () {
                return this;
            },
            // eslint-disable-next-line complexity
            _a.next = function () {
                var nextRow = iterator.next();
                if (!nextRow.done) {
                    var featureRow = void 0;
                    var geometry = void 0;
                    while (!nextRow.done && !geometry) {
                        featureRow = _this.getRow(nextRow.value);
                        geometry = FeatureDao.reprojectFeature(featureRow, srs, projection);
                        if (!skipVerification && boundingBox) {
                            geometry = FeatureDao.verifyFeature(geometry, boundingBox);
                        }
                        if (geometry) {
                            var geoJson = {
                                id: undefined,
                                properties: {},
                                geometry: geometry,
                            };
                            for (var key in featureRow.values) {
                                if (Object.prototype.hasOwnProperty.call(featureRow.values, key) &&
                                    key !== featureRow.getGeometryColumn().name &&
                                    key !== 'id') {
                                    if (key.toLowerCase() === '_feature_id') {
                                        geoJson.id = featureRow.values[key];
                                    }
                                    else if (key.toLowerCase() === '_properties_id') {
                                        geoJson.properties[key.substring(12)] = featureRow.values[key];
                                    }
                                    else {
                                        geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
                                    }
                                }
                            }
                            geoJson.id = geoJson.id || featureRow.id;
                            return {
                                value: geoJson,
                                done: false,
                            };
                        }
                        else {
                            nextRow = iterator.next();
                        }
                    }
                }
                return {
                    done: true,
                    value: undefined,
                };
            },
            _a;
    };
    FeatureDao.prototype.getBoundingBox = function () {
        var contents = this.getContents();
        return new boundingBox_1.BoundingBox(contents.min_x, contents.max_x, contents.min_y, contents.max_y);
    };
    FeatureDao.reprojectFeature = function (featureRow, srs, projection) {
        var geometry = featureRow.getGeometry().toGeoJSON();
        if (srs.organization + ':' + srs.organization_coordsys_id !== 'EPSG:4326') {
            geometry = reproject_1.default.reproject(geometry, projection, 'EPSG:4326');
        }
        return geometry;
    };
    FeatureDao.verifyFeature = function (geometry, boundingBox) {
        try {
            if (geometry.type === 'Point') {
                return geometry;
            }
            else if (geometry.type === 'LineString') {
                return FeatureDao.verifyLineString(geometry, boundingBox);
            }
            else if (geometry.type === 'Polygon') {
                return FeatureDao.verifyPolygon(geometry, boundingBox);
            }
            else if (geometry.type === 'MultiLineString') {
                return FeatureDao.verifyLineString(geometry, boundingBox);
            }
            else if (geometry.type === 'MultiPolygon') {
                return FeatureDao.verifyPolygon(geometry, boundingBox);
            }
        }
        catch (e) {
            return undefined;
        }
    };
    FeatureDao.verifyLineString = function (geometry, boundingBox) {
        var intersect = line_intersect_1.default(geometry, boundingBox.toGeoJSON().geometry);
        if (intersect.features.length) {
            return geometry;
        }
        else if (boolean_within_1.default(geometry, boundingBox.toGeoJSON().geometry)) {
            return geometry;
        }
    };
    FeatureDao.verifyPolygon = function (geometry, boundingBox) {
        var polyIntersect = intersect_1.default(geometry, boundingBox.toGeoJSON().geometry);
        if (polyIntersect) {
            return geometry;
        }
        else if (boolean_within_1.default(geometry, boundingBox.toGeoJSON().geometry)) {
            return geometry;
        }
    };
    return FeatureDao;
}(userDao_1.UserDao));
exports.FeatureDao = FeatureDao;
//# sourceMappingURL=featureDao.js.map