"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = require("../../user/userRow");
var featureColumn_1 = require("./featureColumn");
var dataTypes_1 = require("../../db/dataTypes");
var geometryData_1 = require("../../geom/geometryData");
/**
 * featureRow module.
 * @module features/user/featureRow
 */
/**
 * Feature Row containing the values from a single result set row
 * @param  {FeatureTable} featureTable feature table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
var FeatureRow = /** @class */ (function (_super) {
    __extends(FeatureRow, _super);
    function FeatureRow(featureTable, columnTypes, values) {
        var _this = _super.call(this, featureTable, columnTypes, values) || this;
        _this.featureTable = featureTable;
        return _this;
    }
    /**
     * Get the geometry column index
     * @return {Number} geometry column index
     */
    FeatureRow.prototype.getGeometryColumnIndex = function () {
        return this.featureTable.geometryIndex;
    };
    /**
     * Get the geometry column
     * @return {FeatureColumn} geometry column
     */
    FeatureRow.prototype.getGeometryColumn = function () {
        return this.featureTable.getGeometryColumn();
    };
    /**
     * Get the geometry
     * @return {Buffer} geometry data
     */
    FeatureRow.prototype.getGeometry = function () {
        return this.getValueWithIndex(this.featureTable.geometryIndex);
    };
    /**
     * Get the geometry's type
     * @return {String} geometry data
     */
    FeatureRow.prototype.getGeometryType = function () {
        var geometryType = null;
        var geometry = this.getValueWithIndex(this.featureTable.geometryIndex);
        if (geometry !== null) {
            geometryType = geometry.toGeoJSON().type;
        }
        return geometryType;
    };
    /**
     * set the geometry
     * @param {Buffer} geometryData geometry data
     */
    FeatureRow.prototype.setGeometry = function (geometryData) {
        this.setValueWithIndex(this.featureTable.geometryIndex, geometryData);
    };
    FeatureRow.prototype.toObjectValue = function (index, value) {
        var objectValue = value;
        var column = this.getColumnWithIndex(index);
        if ((column instanceof featureColumn_1.FeatureColumn && column.isGeometry() && value && value instanceof Buffer) ||
            value instanceof Uint8Array) {
            objectValue = new geometryData_1.GeometryData(value);
        }
        return objectValue;
    };
    FeatureRow.prototype.toDatabaseValue = function (columnName) {
        var column = this.getColumnWithColumnName(columnName);
        var value = this.getValueWithColumnName(columnName);
        if (column instanceof featureColumn_1.FeatureColumn && column.isGeometry() && value.toData) {
            return value.toData();
        }
        else if (column.dataType === dataTypes_1.DataTypes.BOOLEAN) {
            return value === true ? 1 : 0;
        }
        return value;
    };
    return FeatureRow;
}(userRow_1.UserRow));
exports.FeatureRow = FeatureRow;
//# sourceMappingURL=featureRow.js.map