/**
 * featureTable module.
 * @module features/user/featureTable
 */
import { UserTable } from '../../user/userTable';
import { FeatureColumn } from './featureColumn';
import { UserColumn } from '../../user/userColumn';
/**
 * Represents a user feature table
 * @param  {string} tableName table name
 * @param  {array} columns   feature columns
 */
export declare class FeatureTable extends UserTable {
    geometryIndex: number;
    constructor(tableName: string, columns?: UserColumn[]);
    /**
     * Get the geometry feature column
     * @return {FeatureColumn} geometry feature column
     */
    getGeometryColumn(): FeatureColumn;
    getTableType(): string;
}
