"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureTableReader module.
 * @module features/user/featureTableReader
 */
var geometryColumnsDao_1 = require("../columns/geometryColumnsDao");
var featureTable_1 = require("./featureTable");
var userTableReader_1 = require("../../user/userTableReader");
var featureColumn_1 = require("./featureColumn");
var dataTypes_1 = require("../../db/dataTypes");
var wkb_1 = require("../../wkb");
var geometryColumns_1 = require("../columns/geometryColumns");
/**
 * Reads the metadata from an existing feature table
 * @class FeatureTableReader
 */
var FeatureTableReader = /** @class */ (function (_super) {
    __extends(FeatureTableReader, _super);
    function FeatureTableReader(tableNameOrGeometryColumns) {
        var _this = _super.call(this, tableNameOrGeometryColumns instanceof geometryColumns_1.GeometryColumns
            ? tableNameOrGeometryColumns.table_name
            : tableNameOrGeometryColumns) || this;
        tableNameOrGeometryColumns instanceof geometryColumns_1.GeometryColumns
            ? (_this.geometryColumns = tableNameOrGeometryColumns)
            : undefined;
        return _this;
    }
    FeatureTableReader.prototype.readFeatureTable = function (geoPackage) {
        if (!this.geometryColumns) {
            var gcd = new geometryColumnsDao_1.GeometryColumnsDao(geoPackage);
            this.geometryColumns = gcd.queryForTableName(this.table_name);
            return this.readTable(geoPackage.database);
        }
        else {
            return this.readTable(geoPackage.database);
        }
    };
    FeatureTableReader.prototype.createTable = function (tableName, columns) {
        return new featureTable_1.FeatureTable(tableName, columns);
    };
    FeatureTableReader.prototype.createColumn = function (index, name, type, max, notNull, defaultValue, primaryKey) {
        var geometry = name === this.geometryColumns.column_name;
        var geometryType = undefined;
        var dataType = undefined;
        if (geometry) {
            geometryType = wkb_1.WKB.fromName(type);
        }
        else {
            dataType = dataTypes_1.DataTypes.fromName(type);
        }
        var column = new featureColumn_1.FeatureColumn(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType);
        return column;
    };
    return FeatureTableReader;
}(userTableReader_1.UserTableReader));
exports.FeatureTableReader = FeatureTableReader;
//# sourceMappingURL=featureTableReader.js.map