"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var wkx_1 = __importDefault(require("wkx"));
// @ts-ignore
var reproject_1 = __importDefault(require("reproject"));
var point_to_line_distance_1 = __importDefault(require("@turf/point-to-line-distance"));
var polygon_to_line_1 = __importDefault(require("@turf/polygon-to-line"));
var boolean_point_in_polygon_1 = __importDefault(require("@turf/boolean-point-in-polygon"));
// @ts-ignore
var distance_1 = __importDefault(require("@turf/distance"));
var helpers = __importStar(require("@turf/helpers"));
var geometryData_1 = require("./geom/geometryData");
var crsWkt_1 = require("./extension/crsWkt");
var relatedTables_1 = require("./extension/relatedTables");
var _1 = require("./extension/style/.");
var _2 = require("./extension/contents/.");
var spatialReferenceSystemDao_1 = require("./core/srs/spatialReferenceSystemDao");
var geometryColumnsDao_1 = require("./features/columns/geometryColumnsDao");
var featureDao_1 = require("./features/user/featureDao");
var featureTableReader_1 = require("./features/user/featureTableReader");
var contentsDao_1 = require("./core/contents/contentsDao");
var tileMatrixSetDao_1 = require("./tiles/matrixset/tileMatrixSetDao");
var tileMatrixDao_1 = require("./tiles/matrix/tileMatrixDao");
var dataColumnsDao_1 = require("./dataColumns/dataColumnsDao");
var dataColumnConstraintsDao_1 = require("./dataColumnConstraints/dataColumnConstraintsDao");
var metadataDao_1 = require("./metadata/metadataDao");
var metadataReferenceDao_1 = require("./metadata/reference/metadataReferenceDao");
var extensionDao_1 = require("./extension/extensionDao");
var tableIndexDao_1 = require("./extension/index/tableIndexDao");
var geometryIndexDao_1 = require("./extension/index/geometryIndexDao");
var extendedRelationDao_1 = require("./extension/relatedTables/extendedRelationDao");
var attributeDao_1 = require("./attributes/attributeDao");
var tileDao_1 = require("./tiles/user/tileDao");
var contentsIdDao_1 = require("./extension/contents/contentsIdDao");
var attributeTable_1 = require("./attributes/attributeTable");
var tileTableReader_1 = require("./tiles/user/tileTableReader");
var attributeTableReader_1 = require("./attributes/attributeTableReader");
var featureTable_1 = require("./features/user/featureTable");
var styleMappingTable_1 = require("./extension/style/styleMappingTable");
var tileTable_1 = require("./tiles/user/tileTable");
var contents_1 = require("./core/contents/contents");
var dataTypes_1 = require("./db/dataTypes");
var schema_1 = require("./extension/schema");
var geometryColumns_1 = require("./features/columns/geometryColumns");
var tableCreator_1 = require("./db/tableCreator");
var tileMatrix_1 = require("./tiles/matrix/tileMatrix");
var tileBoundingBoxUtils_1 = require("./tiles/tileBoundingBoxUtils");
var boundingBox_1 = require("./boundingBox");
var tileMatrixSet_1 = require("./tiles/matrixset/tileMatrixSet");
var proj4_1 = __importDefault(require("proj4"));
var userColumn_1 = require("./user/userColumn");
var dataColumns_1 = require("./dataColumns/dataColumns");
var defs = __importStar(require("./proj4Defs"));
var geoPackageValidate_1 = require("./validate/geoPackageValidate");
var featureColumn_1 = require("./features/user/featureColumn");
var mediaTable_1 = require("./extension/relatedTables/mediaTable");
var relationType_1 = require("./extension/relatedTables/relationType");
var simpleAttributesTable_1 = require("./extension/relatedTables/simpleAttributesTable");
var features_1 = require("./tiles/features");
var retriever_1 = require("./tiles/retriever");
var anyDefs = defs;
for (var def in anyDefs) {
    if (anyDefs[def]) {
        proj4_1.default.defs(def, anyDefs[def]);
    }
}
/**
 * A `GeoPackage` instance is the interface to a physical GeoPackage SQLite
 * database.
 */
var GeoPackage = /** @class */ (function () {
    /**
     * Construct a new GeoPackage object
     * @param name name to give to this GeoPackage
     * @param path path to the GeoPackage
     * @param connection database connection to the GeoPackage
     */
    function GeoPackage(name, path, connection) {
        this.name = name;
        this.path = path;
        this.connection = connection;
        this.tableCreator = new tableCreator_1.TableCreator(this);
    }
    GeoPackage.prototype.close = function () {
        this.connection.close();
    };
    Object.defineProperty(GeoPackage.prototype, "database", {
        get: function () {
            return this.connection;
        },
        enumerable: true,
        configurable: true
    });
    GeoPackage.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.connection.export()];
            });
        });
    };
    GeoPackage.prototype.validate = function () {
        return __awaiter(this, void 0, void 0, function () {
            var errors;
            return __generator(this, function (_a) {
                errors = [];
                errors = errors.concat(geoPackageValidate_1.GeoPackageValidate.validateMinimumTables(this));
                return [2 /*return*/, errors];
            });
        });
    };
    Object.defineProperty(GeoPackage.prototype, "spatialReferenceSystemDao", {
        /**
         * @returns {module:core/srs~SpatialReferenceSystemDao} the DAO to access the [SRS table]{@link module:core/srs~SpatialReferenceSystem} in this `GeoPackage`
         */
        get: function () {
            return this._spatialReferenceSystemDao || (this._spatialReferenceSystemDao = new spatialReferenceSystemDao_1.SpatialReferenceSystemDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "contentsDao", {
        /**
         * @returns {module:core/contents~ContentsDao} the DAO to access the [contents table]{@link module:core/contents~Contents} in this `GeoPackage`
         */
        get: function () {
            return this._contentsDao || (this._contentsDao = new contentsDao_1.ContentsDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "tileMatrixSetDao", {
        /**
         * @returns {module:tiles/matrixset~TileMatrixSetDao} the DAO to access the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet} in this `GeoPackage`
         */
        get: function () {
            return this._tileMatrixSetDao || (this._tileMatrixSetDao = new tileMatrixSetDao_1.TileMatrixSetDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "tileMatrixDao", {
        /**
         * @returns {module:tiles/matrixset~TileMatrixDao} the DAO to access the [tile matrix]{@link module:tiles/matrixset~TileMatrix} in this `GeoPackage`
         */
        get: function () {
            return this._tileMatrixDao || (this._tileMatrixDao = new tileMatrixDao_1.TileMatrixDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "dataColumnsDao", {
        get: function () {
            return this._dataColumnsDao || (this._dataColumnsDao = new dataColumnsDao_1.DataColumnsDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "extensionDao", {
        get: function () {
            return this._extensionDao || (this._extensionDao = new extensionDao_1.ExtensionDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "tableIndexDao", {
        get: function () {
            return this._tableIndexDao || (this._tableIndexDao = new tableIndexDao_1.TableIndexDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "geometryColumnsDao", {
        get: function () {
            return this._geometryColumnsDao || (this._geometryColumnsDao = new geometryColumnsDao_1.GeometryColumnsDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "dataColumnConstraintsDao", {
        get: function () {
            return this._dataColumnConstraintsDao || (this._dataColumnConstraintsDao = new dataColumnConstraintsDao_1.DataColumnConstraintsDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "metadataReferenceDao", {
        get: function () {
            return this._metadataReferenceDao || (this._metadataReferenceDao = new metadataReferenceDao_1.MetadataReferenceDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "metadataDao", {
        get: function () {
            return this._metadataDao || (this._metadataDao = new metadataDao_1.MetadataDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "extendedRelationDao", {
        get: function () {
            return this._extendedRelationDao || (this._extendedRelationDao = new extendedRelationDao_1.ExtendedRelationDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "contentsIdDao", {
        get: function () {
            return this._contentsIdDao || (this._contentsIdDao = new contentsIdDao_1.ContentsIdDao(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "contentsIdExtension", {
        get: function () {
            return this._contentsIdExtension || (this._contentsIdExtension = new _2.ContentsIdExtension(this));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GeoPackage.prototype, "featureStyleExtension", {
        get: function () {
            return this._featureStyleExtension || (this._featureStyleExtension = new _1.FeatureStyleExtension(this));
        },
        enumerable: true,
        configurable: true
    });
    GeoPackage.prototype.getGeometryIndexDao = function (featureDao) {
        return new geometryIndexDao_1.GeometryIndexDao(this, featureDao);
    };
    Object.defineProperty(GeoPackage.prototype, "relatedTablesExtension", {
        get: function () {
            return this._relatedTablesExtension || (this._relatedTablesExtension = new relatedTables_1.RelatedTablesExtension(this));
        },
        enumerable: true,
        configurable: true
    });
    GeoPackage.prototype.getSrs = function (srsId) {
        var dao = this.spatialReferenceSystemDao;
        return dao.queryForId(srsId);
    };
    GeoPackage.prototype.createRequiredTables = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.tableCreator.createRequired()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, this];
                }
            });
        });
    };
    GeoPackage.prototype.createSupportedExtensions = function () {
        var crs = new crsWkt_1.CrsWktExtension(this);
        crs.getOrCreateExtension();
        var schema = new schema_1.SchemaExtension(this);
        schema.getOrCreateExtension();
        return this;
    };
    /**
     * Get a Tile DAO
     * @param  {string}   tableName table name
     *  @returns {FeatureDao}
     */
    GeoPackage.prototype.getTileDao = function (table) {
        if (table instanceof contents_1.Contents) {
            table = this.contentsDao.getTileMatrixSet(table);
        }
        else if (!(table instanceof tileMatrixSet_1.TileMatrixSet)) {
            var tms = this.tileMatrixSetDao;
            var results_1 = tms.queryForAllEq(tileMatrixSetDao_1.TileMatrixSetDao.COLUMN_TABLE_NAME, table);
            if (results_1.length > 1) {
                throw new Error('Unexpected state. More than one Tile Matrix Set matched for table name: ' +
                    table +
                    ', count: ' +
                    results_1.length);
            }
            else if (results_1.length === 0) {
                throw new Error('No Tile Matrix found for table name: ' + table);
            }
            table = tms.createObject(results_1[0]);
        }
        if (!table) {
            throw new Error('Non null TileMatrixSet is required to create Tile DAO');
        }
        var tileMatrices = [];
        var tileMatrixDao = this.tileMatrixDao;
        var results = tileMatrixDao.queryForAllEq(tileMatrixDao_1.TileMatrixDao.COLUMN_TABLE_NAME, table.table_name, null, null, tileMatrixDao_1.TileMatrixDao.COLUMN_ZOOM_LEVEL +
            ' ASC, ' +
            tileMatrixDao_1.TileMatrixDao.COLUMN_PIXEL_X_SIZE +
            ' DESC, ' +
            tileMatrixDao_1.TileMatrixDao.COLUMN_PIXEL_Y_SIZE +
            ' DESC');
        results.forEach(function (result) {
            var tm = tileMatrixDao.createObject(result);
            tileMatrices.push(tm);
        });
        var tableReader = new tileTableReader_1.TileTableReader(table);
        var tileTable = tableReader.readTileTable(this);
        return new tileDao_1.TileDao(this, tileTable, table, tileMatrices);
    };
    GeoPackage.prototype.getTables = function (fullInformation) {
        if (fullInformation === void 0) { fullInformation = false; }
        if (!fullInformation) {
            var tables = {
                features: this.getFeatureTables(),
                tiles: this.getTileTables(),
                attributes: this.getAttributesTables(),
            };
            return tables;
        }
        else {
            var tables = {
                features: this.contentsDao.getContentsForTableType(contentsDao_1.ContentsDao.GPKG_CDT_FEATURES_NAME),
                tiles: this.contentsDao.getContentsForTableType(contentsDao_1.ContentsDao.GPKG_CDT_TILES_NAME),
                attributes: this.contentsDao.getContentsForTableType(contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME),
            };
            return tables;
        }
    };
    GeoPackage.prototype.getAttributesTables = function () {
        return this.contentsDao.getTables(contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
    };
    GeoPackage.prototype.hasAttributeTable = function (attributeTableName) {
        var tables = this.getAttributesTables();
        return tables && tables.indexOf(attributeTableName) != -1;
    };
    /**
     *  Get the tile tables
     *  @returns {String[]} tile table names
     */
    GeoPackage.prototype.getTileTables = function () {
        var cd = this.contentsDao;
        if (!cd.isTableExists()) {
            return [];
        }
        return cd.getTables(contentsDao_1.ContentsDao.GPKG_CDT_TILES_NAME);
    };
    /**
     * Checks if the tile table exists in the GeoPackage
     * @param  {String} tileTableName name of the table to query for
     * @returns {Boolean} indicates the existence of the tile table
     */
    GeoPackage.prototype.hasTileTable = function (tileTableName) {
        var tables = this.getTileTables();
        return tables && tables.indexOf(tileTableName) !== -1;
    };
    /**
     * Checks if the feature table exists in the GeoPackage
     * @param  {String} featureTableName name of the table to query for
     * @returns {Boolean} indicates the existence of the feature table
     */
    GeoPackage.prototype.hasFeatureTable = function (featureTableName) {
        var tables = this.getFeatureTables();
        return tables && tables.indexOf(featureTableName) != -1;
    };
    /**
     *  Get the feature tables
     *  @returns {String[]} feature table names
     */
    GeoPackage.prototype.getFeatureTables = function () {
        var cd = this.contentsDao;
        if (!cd.isTableExists()) {
            return [];
        }
        return cd.getTables(contentsDao_1.ContentsDao.GPKG_CDT_FEATURES_NAME);
    };
    GeoPackage.prototype.isTable = function (tableName) {
        return !!this.connection.tableExists(tableName);
    };
    GeoPackage.prototype.isTableType = function (type, tableName) {
        return type === this.getTableType(tableName);
    };
    GeoPackage.prototype.getTableType = function (tableName) {
        var contents = this.getTableContents(tableName);
        if (contents) {
            return contents.data_type;
        }
    };
    GeoPackage.prototype.getTableContents = function (tableName) {
        return this.contentsDao.queryForId(tableName);
    };
    GeoPackage.prototype.deleteTable = function (tableName) {
        return this.connection.dropTable(tableName);
    };
    GeoPackage.prototype.getTableCreator = function () {
        return this.tableCreator;
    };
    GeoPackage.prototype.index = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tables, i;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tables = this.getFeatureTables();
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < tables.length)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.indexFeatureTable(tables[i])];
                    case 2:
                        if (!(_a.sent())) {
                            throw new Error('Unable to index table ' + tables[i]);
                        }
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/, true];
                }
            });
        });
    };
    GeoPackage.prototype.indexFeatureTable = function (table, progress) {
        return __awaiter(this, void 0, void 0, function () {
            var featureDao, fti;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        featureDao = this.getFeatureDao(table);
                        fti = featureDao.featureTableIndex;
                        if (fti.isIndexed()) {
                            return [2 /*return*/, true];
                        }
                        return [4 /*yield*/, fti.index(progress)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Get a Feature DAO from Contents
     * @param  {string}   tableName table name
     *  @returns {FeatureDao}
     */
    GeoPackage.prototype.getFeatureDao = function (table) {
        if (table instanceof contents_1.Contents) {
            table = this.contentsDao.getGeometryColumns(table);
        }
        else if (!(table instanceof geometryColumns_1.GeometryColumns)) {
            table = this.geometryColumnsDao.queryForTableName(table);
        }
        if (!table) {
            throw new Error('Non null Geometry Columns is required to create Feature DAO');
        }
        var tableReader = new featureTableReader_1.FeatureTableReader(table);
        var featureTable = tableReader.readFeatureTable(this);
        var dao = new featureDao_1.FeatureDao(this, featureTable, table, this.metadataDao);
        return dao;
    };
    /**
     * Queries for GeoJSON features in a feature table
     * @param  {String}   tableName   Table name to query
     * @param  {BoundingBox}   boundingBox BoundingBox to query
     * @returns {Object[]} array of GeoJSON features
     */
    GeoPackage.prototype.queryForGeoJSONFeaturesInTable = function (tableName, boundingBox) {
        var e_1, _a;
        var featureDao = this.getFeatureDao(tableName);
        var features = [];
        var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
        try {
            for (var iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next(); !iterator_1_1.done; iterator_1_1 = iterator_1.next()) {
                var feature = iterator_1_1.value;
                features.push(feature);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return features;
    };
    /**
     * Create the Geometry Columns table if it does not already exist
     * @returns {Promise}
     */
    GeoPackage.prototype.createGeometryColumnsTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.geometryColumnsDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createGeometryColumns()];
            });
        });
    };
    /**
     * Get a Attribute DAO
     * @param  {Contents}   contents Contents
     * @returns {AttributeDao}
     */
    GeoPackage.prototype.getAttributeDao = function (table) {
        if (!(table instanceof contents_1.Contents)) {
            table = this.contentsDao.queryForId(table);
        }
        if (!table) {
            throw new Error('Non null Contents is required to create an Attributes DAO');
        }
        var reader = new attributeTableReader_1.AttributeTableReader(table.table_name);
        var attributeTable = reader.readTable(this.connection);
        attributeTable.setContents(table);
        return new attributeDao_1.AttributeDao(this, attributeTable);
    };
    /**
     * Create an attribute table with the properties specified.
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param tableName name of the table to create
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @param {DataColumns} [properties.dataColumn] data column for the property
     * @return {Promise}
     */
    GeoPackage.prototype.createAttributeTable = function (tableName, columns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var attributeCoulmns, columnNumber, i, property, dc, attributeTable, contents, dataColumnsDao_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        attributeCoulmns = [];
                        if (columns && columns.length > 0 && columns[0] instanceof userColumn_1.UserColumn) {
                            attributeCoulmns = columns;
                        }
                        else {
                            columnNumber = 0;
                            attributeCoulmns.push(userColumn_1.UserColumn.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
                            dataColumns = [];
                            for (i = 0; i < columns.length; i++) {
                                property = columns[i];
                                attributeCoulmns.push(userColumn_1.UserColumn.createColumn(columnNumber++, property.name, dataTypes_1.DataTypes.fromName(property.dataType)));
                                if (property.dataColumn) {
                                    dc = new dataColumns_1.DataColumns();
                                    dc.table_name = property.dataColumn.table_name;
                                    dc.column_name = property.dataColumn.column_name;
                                    dc.name = property.dataColumn.name;
                                    dc.title = property.dataColumn.title;
                                    dc.description = property.dataColumn.description;
                                    dc.mime_type = property.dataColumn.mime_type;
                                    dc.constraint_name = property.dataColumn.constraint_name;
                                    dataColumns.push(dc);
                                }
                            }
                        }
                        attributeTable = new attributeTable_1.AttributeTable(tableName, attributeCoulmns);
                        this.tableCreator.createUserTable(attributeTable);
                        contents = new contents_1.Contents();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        this.contentsDao.create(contents);
                        if (!(dataColumns && dataColumns.length)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 1:
                        _a.sent();
                        dataColumnsDao_2 = this.dataColumnsDao;
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao_2.create(dataColumn);
                        });
                        _a.label = 2;
                    case 2: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Create a media table with the properties specified.  These properties are added to the required columns
     * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @return {Promise}
     */
    GeoPackage.prototype.createMediaTable = function (tableName, properties) {
        var relatedTables = this.relatedTablesExtension;
        var columns = [];
        var columnNumber = mediaTable_1.MediaTable.numRequiredColumns();
        if (properties) {
            for (var i = 0; i < properties.length; i++) {
                var property = properties[i];
                columns.push(userColumn_1.UserColumn.createColumn(columnNumber++, property.name, dataTypes_1.DataTypes.fromName(property.dataType), property.notNull, property.defaultValue, property.max));
            }
        }
        var mediaTable = mediaTable_1.MediaTable.create(tableName, columns);
        relatedTables.createRelatedTable(mediaTable);
        return relatedTables.getMediaDao(mediaTable);
    };
    GeoPackage.prototype.linkMedia = function (baseTableName, baseId, mediaTableName, mediaId) {
        return __awaiter(this, void 0, void 0, function () {
            var relatedTables;
            return __generator(this, function (_a) {
                relatedTables = this.relatedTablesExtension;
                return [2 /*return*/, relatedTables.linkRelatedIds(baseTableName, baseId, mediaTableName, mediaId, relationType_1.RelationType.MEDIA)];
            });
        });
    };
    GeoPackage.prototype.getLinkedMedia = function (baseTableName, baseId) {
        var relationships = this.getRelatedRows(baseTableName, baseId);
        var mediaRelationships = [];
        for (var i = 0; i < relationships.length; i++) {
            var relationship = relationships[i];
            if (relationship.relation_name === relationType_1.RelationType.MEDIA.name) {
                for (var r = 0; r < relationship.mappingRows.length; r++) {
                    var row = relationship.mappingRows[r].row;
                    mediaRelationships.push(row);
                }
            }
        }
        return mediaRelationships;
    };
    /**
     * Adds a GeoJSON feature to the GeoPackage
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {object}   feature    GeoJSON feature to add
     * @param  {string}   tableName  name of the table that will store the feature
     * @param {boolean} index updates the FeatureTableIndex extension if it exists
     */
    GeoPackage.prototype.addGeoJSONFeatureToGeoPackage = function (feature, tableName, index) {
        if (index === void 0) { index = false; }
        var featureDao = this.getFeatureDao(tableName);
        var srs = featureDao.getSrs();
        var featureRow = featureDao.newRow();
        var geometryData = new geometryData_1.GeometryData();
        geometryData.setSrsId(srs.srs_id);
        if (!(srs.organization === 'EPSG' && srs.organization_coordsys_id === 4326)) {
            feature = reproject_1.default.reproject(feature, 'EPSG:4326', featureDao.projection);
        }
        var featureGeometry = typeof feature.geometry === 'string' ? JSON.parse(feature.geometry) : feature.geometry;
        var geometry = wkx_1.default.Geometry.parseGeoJSON(featureGeometry);
        geometryData.setGeometry(geometry);
        featureRow.setGeometry(geometryData);
        for (var propertyKey in feature.properties) {
            if (Object.prototype.hasOwnProperty.call(feature.properties, propertyKey)) {
                featureRow.setValueWithColumnName(propertyKey, feature.properties[propertyKey]);
            }
        }
        var id = featureDao.create(featureRow);
        if (index) {
            var fti = featureDao.featureTableIndex;
            var tableIndex = fti.getTableIndex();
            if (!tableIndex)
                return id;
            fti.indexRow(tableIndex, id, geometryData);
            fti.updateLastIndexed(tableIndex);
        }
        return id;
    };
    GeoPackage.prototype.addAttributeRow = function (tableName, row) {
        var attributeDao = this.getAttributeDao(tableName);
        var attributeRow = attributeDao.getRow(row);
        return attributeDao.create(attributeRow);
    };
    /**
     * Create a simple attributes table with the properties specified.
     * @param {Object[]} properties properties to create columns from
     * @param {string} properties.name name of the column
     * @param {string} properties.dataType name of the data type
     * @return {Promise}
     */
    GeoPackage.prototype.createSimpleAttributesTable = function (tableName, properties) {
        var relatedTables = this.relatedTablesExtension;
        var columns = [];
        var columnNumber = simpleAttributesTable_1.SimpleAttributesTable.numRequiredColumns();
        if (properties) {
            for (var i = 0; i < properties.length; i++) {
                var property = properties[i];
                columns.push(userColumn_1.UserColumn.createColumn(columnNumber++, property.name, dataTypes_1.DataTypes.fromName(property.dataType), true));
            }
        }
        var simpleAttributesTable = simpleAttributesTable_1.SimpleAttributesTable.create(tableName, columns);
        relatedTables.createRelatedTable(simpleAttributesTable);
        return relatedTables.getSimpleAttributesDao(simpleAttributesTable);
    };
    GeoPackage.prototype.addMedia = function (tableName, dataBuffer, contentType, additionalProperties) {
        var relatedTables = this.relatedTablesExtension;
        var mediaDao = relatedTables.getMediaDao(tableName);
        var row = mediaDao.newRow();
        row.setContentType(contentType);
        row.setData(dataBuffer);
        for (var key in additionalProperties) {
            row.setValueWithColumnName(key, additionalProperties[key]);
        }
        return mediaDao.create(row);
    };
    GeoPackage.prototype.getRelatedRows = function (baseTableName, baseId) {
        return this.relatedTablesExtension.getRelatedRows(baseTableName, baseId);
    };
    /**
     * Create the given {@link module:features/user/featureTable~FeatureTable}
     * @param  {FeatureTable}   featureTable    feature table
     */
    GeoPackage.prototype.createUserFeatureTable = function (featureTable) {
        return this.tableCreator.createUserTable(featureTable);
    };
    GeoPackage.prototype.createFeatureTableFromProperties = function (tableName, properties) {
        return __awaiter(this, void 0, void 0, function () {
            var geometryColumn, columns, columnNumber, i, property;
            return __generator(this, function (_a) {
                geometryColumn = new geometryColumns_1.GeometryColumns();
                geometryColumn.table_name = tableName;
                geometryColumn.column_name = 'geometry';
                geometryColumn.geometry_type_name = 'GEOMETRY';
                geometryColumn.z = 0;
                geometryColumn.m = 0;
                columns = [];
                columnNumber = 0;
                columns.push(featureColumn_1.FeatureColumn.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
                columns.push(featureColumn_1.FeatureColumn.createGeometryColumn(columnNumber++, geometryColumn.column_name, geometryColumn.geometry_type_name, false, null));
                for (i = 0; properties && i < properties.length; i++) {
                    property = properties[i];
                    columns.push(featureColumn_1.FeatureColumn.createColumn(columnNumber++, property.name, dataTypes_1.DataTypes.fromName(property.dataType)));
                }
                return [2 /*return*/, this.createFeatureTable(tableName, geometryColumn, columns)];
            });
        });
    };
    GeoPackage.prototype.createFeatureTable = function (tableName, geometryColumns, featureColumns, boundingBox, srsId, dataColumns) {
        if (boundingBox === void 0) { boundingBox = new boundingBox_1.BoundingBox(-180, 180, -90, 90); }
        if (srsId === void 0) { srsId = 4326; }
        return __awaiter(this, void 0, void 0, function () {
            var geometryColumn, columns, columnNumber, i, property, featureTable, contents, dataColumnsDao_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.createGeometryColumnsTable()];
                    case 1:
                        _a.sent();
                        if (geometryColumns) {
                            geometryColumn = geometryColumns;
                        }
                        else {
                            geometryColumn = new geometryColumns_1.GeometryColumns();
                            geometryColumn.table_name = tableName;
                            geometryColumn.column_name = 'geometry';
                            geometryColumn.geometry_type_name = 'GEOMETRY';
                            geometryColumn.z = 0;
                            geometryColumn.m = 0;
                        }
                        columns = [];
                        if (featureColumns && featureColumns.length > 0 && featureColumns[0] instanceof userColumn_1.UserColumn) {
                            columns = featureColumns;
                        }
                        else {
                            columnNumber = 0;
                            columns.push(featureColumn_1.FeatureColumn.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
                            columns.push(featureColumn_1.FeatureColumn.createGeometryColumn(columnNumber++, geometryColumn.column_name, geometryColumn.geometry_type_name, false, null));
                            for (i = 0; featureColumns && i < featureColumns.length; i++) {
                                property = featureColumns[i];
                                columns.push(featureColumn_1.FeatureColumn.createColumn(columnNumber++, property.name, dataTypes_1.DataTypes.fromName(property.dataType)));
                            }
                        }
                        featureTable = new featureTable_1.FeatureTable(geometryColumn.table_name, columns);
                        this.createUserFeatureTable(featureTable);
                        contents = new contents_1.Contents();
                        contents.table_name = geometryColumn.table_name;
                        contents.data_type = contentsDao_1.ContentsDao.GPKG_CDT_FEATURES_NAME;
                        contents.identifier = geometryColumn.table_name;
                        contents.last_change = new Date().toISOString();
                        contents.min_x = boundingBox.minLongitude;
                        contents.min_y = boundingBox.minLatitude;
                        contents.max_x = boundingBox.maxLongitude;
                        contents.max_y = boundingBox.maxLatitude;
                        contents.srs_id = srsId;
                        this.contentsDao.create(contents);
                        geometryColumn.srs_id = srsId;
                        this.geometryColumnsDao.create(geometryColumn);
                        if (!dataColumns) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 2:
                        _a.sent();
                        dataColumnsDao_3 = this.dataColumnsDao;
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao_3.create(dataColumn);
                        });
                        _a.label = 3;
                    case 3: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Create the Tile Matrix Set table if it does not already exist
     * @returns {Promise} resolves when the table is created
     */
    GeoPackage.prototype.createTileMatrixSetTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.tileMatrixSetDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTileMatrixSet()];
            });
        });
    };
    /**
     * Create the Tile Matrix table if it does not already exist
     * @returns {Promise} resolves when the table is created
     */
    GeoPackage.prototype.createTileMatrixTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.tileMatrixDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTileMatrix()];
            });
        });
    };
    /**
     * Create the given tile table in this GeoPackage.
     *
     * @param  {module:tiles/user/tileTable~TileTable} tileTable
     * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
     */
    GeoPackage.prototype.createTileTable = function (tileTable) {
        return this.tableCreator.createUserTable(tileTable);
    };
    /**
     * Create a new [tile table]{@link module:tiles/user/tileTable~TileTable} in this GeoPackage.
     *
     * @param {String} tableName tile table name
     * @param {BoundingBox} contentsBoundingBox bounding box of the contents table
     * @param {Number} contentsSrsId srs id of the contents table
     * @param {BoundingBox} tileMatrixSetBoundingBox bounding box of the matrix set
     * @param {Number} tileMatrixSetSrsId srs id of the matrix set
     * @returns {Promise<TileMatrixSet>} `Promise` of the created {@link module:tiles/matrixset~TileMatrixSet}
     */
    GeoPackage.prototype.createTileTableWithTableName = function (tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId) {
        return __awaiter(this, void 0, void 0, function () {
            var columns, tileTable, contents, tileMatrixSet;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        columns = tileTable_1.TileTable.createRequiredColumns();
                        tileTable = new tileTable_1.TileTable(tableName, columns);
                        contents = new contents_1.Contents();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.ContentsDao.GPKG_CDT_TILES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        contents.min_x = contentsBoundingBox.minLongitude;
                        contents.min_y = contentsBoundingBox.minLatitude;
                        contents.max_x = contentsBoundingBox.maxLongitude;
                        contents.max_y = contentsBoundingBox.maxLatitude;
                        contents.srs_id = contentsSrsId;
                        tileMatrixSet = new tileMatrixSet_1.TileMatrixSet();
                        tileMatrixSet.contents = contents;
                        tileMatrixSet.srs_id = tileMatrixSetSrsId;
                        tileMatrixSet.min_x = tileMatrixSetBoundingBox.minLongitude;
                        tileMatrixSet.min_y = tileMatrixSetBoundingBox.minLatitude;
                        tileMatrixSet.max_x = tileMatrixSetBoundingBox.maxLongitude;
                        tileMatrixSet.max_y = tileMatrixSetBoundingBox.maxLatitude;
                        return [4 /*yield*/, this.createTileMatrixSetTable()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.createTileMatrixTable()];
                    case 2:
                        _a.sent();
                        this.createTileTable(tileTable);
                        this.contentsDao.create(contents);
                        this.tileMatrixSetDao.create(tileMatrixSet);
                        return [2 /*return*/, tileMatrixSet];
                }
            });
        });
    };
    /**
     * Create the [tables and rows](https://www.geopackage.org/spec121/index.html#tiles)
     * necessary to store tiles according to the ubiquitous [XYZ web/slippy-map tiles](https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames) scheme.
     * The extent for the [contents table]{@link module:core/contents~Contents} row,
     * `contentsBoundingBox`, is [informational only](https://www.geopackage.org/spec121/index.html#gpkg_contents_cols),
     * and need not match the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet}
     * extent, `tileMatrixSetBoundingBox`, which should be the precise bounding box
     * used to calculate the tile row and column coordinates of all tiles in the
     * tile set.  The two SRS ID parameters, `contentsSrsId` and `tileMatrixSetSrsId`,
     * must match, however.  See {@link module:tiles/matrixset~TileMatrixSet} for
     * more information about how GeoPackage consumers use the bouding boxes for a
     * tile set.
     *
     * @param {string} tableName the name of the table that will store the tiles
     * @param {BoundingBox} contentsBoundingBox the bounds stored in the [`gpkg_contents`]{@link module:core/contents~Contents} table row for the tile matrix set
     * @param {SRSRef} contentsSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}; must match `tileMatrixSetSrsId`
     * @param {BoundingBox} tileMatrixSetBoundingBox the bounds stored in the [`gpkg_tile_matrix_set`]{@link module:tiles/matrixset~TileMatrixSet} table row
     * @param {SRSRef} tileMatrixSetSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}
     *   for the [tile matrix set](https://www.geopackage.org/spec121/index.html#_tile_matrix_set) table; must match `contentsSrsId`
     * @param {number} minZoom the zoom level of the lowest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
     * @param {number} maxZoom the zoom level of the highest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
     * @param tileSize the width and height in pixels of the tile images; defaults to 256
     * @returns {Promise} a `Promise` that resolves with the created {@link module:tiles/matrixset~TileMatrixSet} object, or rejects with an `Error`
     *
     * @todo make `tileMatrixSetSrsId` optional because it always has to be the same anyway
     */
    GeoPackage.prototype.createStandardWebMercatorTileTable = function (tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId, minZoom, maxZoom, tileSize) {
        if (tileSize === void 0) { tileSize = 256; }
        return __awaiter(this, void 0, void 0, function () {
            var tileMatrixSet;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.createTileTableWithTableName(tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId)];
                    case 1:
                        tileMatrixSet = _a.sent();
                        this.createStandardWebMercatorTileMatrix(tileMatrixSetBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize);
                        return [2 /*return*/, tileMatrixSet];
                }
            });
        });
    };
    /**
     * Create the tables and rows necessary to store tiles in a {@link module:tiles/matrixset~TileMatrixSet}.
     * This will create a [tile matrix row]{@link module:tiles/matrix~TileMatrix}
     * for every integral zoom level in the range `[minZoom..maxZoom]`.
     *
     * @param {BoundingBox} epsg3857TileBoundingBox
     * @param {TileMatrixSet} tileMatrixSet
     * @param {number} minZoom
     * @param {number} maxZoom
     * @param {number} [tileSize=256] optional tile size in pixels
     * @returns {module:geoPackage~GeoPackage} `this` `GeoPackage`
     */
    GeoPackage.prototype.createStandardWebMercatorTileMatrix = function (epsg3857TileBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize) {
        if (tileSize === void 0) { tileSize = 256; }
        tileSize = tileSize || 256;
        var tileMatrixDao = this.tileMatrixDao;
        for (var zoom = minZoom; zoom <= maxZoom; zoom++) {
            var box = tileBoundingBoxUtils_1.TileBoundingBoxUtils.webMercatorTileBox(epsg3857TileBoundingBox, zoom);
            var matrixWidth = box.maxLongitude - box.minLongitude + 1;
            var matrixHeight = box.maxLatitude - box.minLatitude + 1;
            var pixelXSize = (epsg3857TileBoundingBox.maxLongitude - epsg3857TileBoundingBox.minLongitude) / matrixWidth / tileSize;
            var pixelYSize = (epsg3857TileBoundingBox.maxLatitude - epsg3857TileBoundingBox.minLatitude) / matrixHeight / tileSize;
            var tileMatrix = new tileMatrix_1.TileMatrix();
            tileMatrix.table_name = tileMatrixSet.table_name;
            tileMatrix.zoom_level = zoom;
            tileMatrix.matrix_width = matrixWidth;
            tileMatrix.matrix_height = matrixHeight;
            tileMatrix.tile_width = tileSize;
            tileMatrix.tile_height = tileSize;
            tileMatrix.pixel_x_size = pixelXSize;
            tileMatrix.pixel_y_size = pixelYSize;
            tileMatrixDao.create(tileMatrix);
        }
        return this;
    };
    /**
     * Adds a tile to the GeoPackage
     * @param  {object}   tileStream       Byte array or Buffer containing the tile bytes
     * @param  {String}   tableName  Table name to add the tile to
     * @param  {Number}   zoom       zoom level of this tile
     * @param  {Number}   tileRow    row of this tile
     * @param  {Number}   tileColumn column of this tile
     */
    GeoPackage.prototype.addTile = function (tileStream, tableName, zoom, tileRow, tileColumn) {
        var tileDao = this.getTileDao(tableName);
        var newRow = tileDao.newRow();
        newRow.zoomLevel = zoom;
        newRow.tileColumn = tileColumn;
        newRow.tileRow = tileRow;
        newRow.tileData = tileStream;
        return tileDao.create(newRow);
    };
    /**
     * Gets a tile from the specified table
     * @param  {string}   table      name of the table to get the tile from
     * @param  {Number}   zoom       zoom level of the tile
     * @param  {Number}   tileRow    row of the tile
     * @param  {Number}   tileColumn column of the tile
     *
     * @todo jsdoc return value
     */
    GeoPackage.prototype.getTileFromTable = function (table, zoom, tileRow, tileColumn) {
        var tileDao = this.getTileDao(table);
        return tileDao.queryForTile(tileColumn, tileRow, zoom);
    };
    /**
     * Gets the tiles in the EPSG:4326 bounding box
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {string}   table      name of the tile table
     * @param  {Number}   zoom       Zoom of the tiles to query for
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackage.prototype.getTilesInBoundingBox = function (table, zoom, west, east, south, north) {
        var e_2, _a;
        var tiles = {
            columns: [],
            srs: undefined,
            tiles: [],
            west: undefined,
            east: undefined,
            south: undefined,
            north: undefined,
            zoom: undefined,
        };
        var tileDao = this.getTileDao(table);
        if (zoom < tileDao.minZoom || zoom > tileDao.maxZoom) {
            return;
        }
        for (var i = 0; i < tileDao.table.columns.length; i++) {
            var column = tileDao.table.columns[i];
            tiles.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
            });
        }
        var srs = tileDao.getSrs();
        tiles.srs = srs;
        tiles.tiles = [];
        var tms = tileDao.tileMatrixSet;
        var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
        if (!tm) {
            return tiles;
        }
        var mapBoundingBox = new boundingBox_1.BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
        tiles.west = Math.max(-180, west).toFixed(2);
        tiles.east = Math.min(east, 180).toFixed(2);
        tiles.south = south.toFixed(2);
        tiles.north = north.toFixed(2);
        tiles.zoom = zoom;
        mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);
        var grid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.boundingBox, tm.matrix_width, tm.matrix_height, mapBoundingBox);
        var iterator = tileDao.queryByTileGrid(grid, zoom);
        try {
            for (var iterator_2 = __values(iterator), iterator_2_1 = iterator_2.next(); !iterator_2_1.done; iterator_2_1 = iterator_2.next()) {
                var row = iterator_2_1.value;
                var tile = {};
                tile.tableName = table;
                tile.id = row.id;
                var tileBB = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileBoundingBox(tms.boundingBox, tm, row.tileColumn, row.row);
                tile.minLongitude = tileBB.minLongitude;
                tile.maxLongitude = tileBB.maxLongitude;
                tile.minLatitude = tileBB.minLatitude;
                tile.maxLatitude = tileBB.maxLatitude;
                tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
                tile.values = [];
                for (var i = 0; i < tiles.columns.length; i++) {
                    var value = row.values[tiles.columns[i].name];
                    if (tiles.columns[i].name === 'tile_data') {
                        tile.values.push('data');
                    }
                    else if (value === null || value === 'null') {
                        tile.values.push('');
                    }
                    else {
                        tile.values.push(value.toString());
                        tile[tiles.columns[i].name] = value;
                    }
                }
                tiles.tiles.push(tile);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (iterator_2_1 && !iterator_2_1.done && (_a = iterator_2.return)) _a.call(iterator_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return tiles;
    };
    /**
     * Gets the tiles in the EPSG:4326 bounding box
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {string}   table      name of the tile table
     * @param  {Number}   webZoom       Zoom of the tiles to query for
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackage.prototype.getTilesInBoundingBoxWebZoom = function (table, webZoom, west, east, south, north) {
        var e_3, _a;
        var tiles = {
            columns: [],
            srs: undefined,
            tiles: [],
            west: undefined,
            east: undefined,
            south: undefined,
            north: undefined,
            zoom: undefined,
        };
        var tileDao = this.getTileDao(table);
        if (webZoom < tileDao.minWebMapZoom || webZoom > tileDao.maxWebMapZoom) {
            return;
        }
        tiles.columns = [];
        for (var i = 0; i < tileDao.table.columns.length; i++) {
            var column = tileDao.table.columns[i];
            tiles.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
            });
        }
        var srs = tileDao.getSrs();
        tiles.srs = srs;
        tiles.tiles = [];
        var zoom = tileDao.webZoomToGeoPackageZoom(webZoom);
        var tms = tileDao.tileMatrixSet;
        var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
        if (!tm) {
            return tiles;
        }
        var mapBoundingBox = new boundingBox_1.BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
        tiles.west = Math.max(-180, west).toFixed(2);
        tiles.east = Math.min(east, 180).toFixed(2);
        tiles.south = south.toFixed(2);
        tiles.north = north.toFixed(2);
        tiles.zoom = zoom;
        mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);
        var grid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.boundingBox, tm.matrix_width, tm.matrix_height, mapBoundingBox);
        var iterator = tileDao.queryByTileGrid(grid, zoom);
        try {
            for (var iterator_3 = __values(iterator), iterator_3_1 = iterator_3.next(); !iterator_3_1.done; iterator_3_1 = iterator_3.next()) {
                var row = iterator_3_1.value;
                var tile = {
                    tableName: undefined,
                    id: undefined,
                    minLongitude: undefined,
                    maxLongitude: undefined,
                    minLatitude: undefined,
                    maxLatitude: undefined,
                    projection: undefined,
                    values: [],
                };
                tile.tableName = table;
                tile.id = row.id;
                var tileBB = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileBoundingBox(tms.boundingBox, tm, row.tileColumn, row.row);
                tile.minLongitude = tileBB.minLongitude;
                tile.maxLongitude = tileBB.maxLongitude;
                tile.minLatitude = tileBB.minLatitude;
                tile.maxLatitude = tileBB.maxLatitude;
                tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
                tile.values = [];
                for (var i = 0; i < tiles.columns.length; i++) {
                    var value = row.values[tiles.columns[i].name];
                    if (tiles.columns[i].name === 'tile_data') {
                        tile.values.push('data');
                    }
                    else if (value === null || value === 'null') {
                        tile.values.push('');
                    }
                    else {
                        tile.values.push(value.toString());
                        tile[tiles.columns[i].name] = value;
                    }
                }
                tiles.tiles.push(tile);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (iterator_3_1 && !iterator_3_1.done && (_a = iterator_3.return)) _a.call(iterator_3);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return tiles;
    };
    GeoPackage.prototype.getFeatureTileFromXYZ = function (table, x, y, z, width, height) {
        return __awaiter(this, void 0, void 0, function () {
            var featureDao, ft;
            return __generator(this, function (_a) {
                x = Number(x);
                y = Number(y);
                z = Number(z);
                width = Number(width);
                height = Number(height);
                featureDao = this.getFeatureDao(table);
                if (!featureDao)
                    return [2 /*return*/];
                ft = new features_1.FeatureTiles(featureDao, width, height);
                return [2 /*return*/, ft.drawTile(x, y, z)];
            });
        });
    };
    GeoPackage.prototype.getClosestFeatureInXYZTile = function (table, x, y, z, latitude, longitude) {
        var e_4, _a;
        x = Number(x);
        y = Number(y);
        z = Number(z);
        var featureDao = this.getFeatureDao(table);
        if (!featureDao)
            return;
        var ft = new features_1.FeatureTiles(featureDao, 256, 256);
        var tileCount = ft.getFeatureCountXYZ(x, y, z);
        var boundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
        boundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
        if (tileCount > 10000) {
            // too many, send back the entire tile
            // add the goepackage name and table
            var gj = boundingBox.toGeoJSON();
            gj.feature_count = tileCount;
            gj.coverage = true;
            gj.gp_table = table;
            gj.gp_name = this.name;
            return gj;
        }
        var ne = [boundingBox.maxLongitude, boundingBox.maxLatitude];
        var sw = [boundingBox.minLongitude, boundingBox.minLatitude];
        var width = ne[0] - sw[0];
        var widthPerPixel = width / 256;
        var tolerance = 10 * widthPerPixel;
        boundingBox.maxLongitude = longitude + tolerance;
        boundingBox.minLongitude = longitude - tolerance;
        boundingBox.maxLatitude = latitude + tolerance;
        boundingBox.minLatitude = latitude - tolerance;
        var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
        var features = [];
        var closestDistance = 100000000000;
        var closest;
        var centerPoint = helpers.point([longitude, latitude]);
        try {
            for (var iterator_4 = __values(iterator), iterator_4_1 = iterator_4.next(); !iterator_4_1.done; iterator_4_1 = iterator_4.next()) {
                var feature = iterator_4_1.value;
                feature.type = 'Feature';
                var distance = GeoPackage.determineDistance(centerPoint.geometry, feature);
                if (distance < closestDistance) {
                    closest = feature;
                    closestDistance = distance;
                }
                else if (distance === closestDistance && closest.geometry.type !== 'Point') {
                    closest = feature;
                    closestDistance = distance;
                }
                features.push(feature);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (iterator_4_1 && !iterator_4_1.done && (_a = iterator_4.return)) _a.call(iterator_4);
            }
            finally { if (e_4) throw e_4.error; }
        }
        if (closest) {
            closest.gp_table = table;
            closest.gp_name = this.name;
            closest.distance = closestDistance;
        }
        return closest;
    };
    GeoPackage.determineDistance = function (point, feature) {
        if (feature.type === 'FeatureCollection') {
            feature.features.forEach(function (feature) {
                GeoPackage.determineDistance(point, feature);
            });
        }
        else {
            var geometry = feature.geometry;
            if (geometry.type === 'Point') {
                return distance_1.default(point, geometry);
            }
            if (geometry.type === 'LineString') {
                return this.determineDistanceFromLine(point, geometry);
            }
            if (geometry.type === 'MultiLineString') {
                var distance_2 = Number.MAX_SAFE_INTEGER;
                geometry.coordinates.forEach(function (lineStringCoordinate) {
                    var lineString = helpers.lineString(lineStringCoordinate);
                    distance_2 = Math.min(distance_2, GeoPackage.determineDistance(point, lineString));
                });
                return distance_2;
            }
            if (geometry.type === 'Polygon') {
                return GeoPackage.determineDistanceFromPolygon(point, geometry);
            }
            if (geometry.type === 'MultiPolygon') {
                return GeoPackage.determineDistanceFromPolygon(point, geometry);
            }
            return Number.MAX_SAFE_INTEGER;
        }
    };
    GeoPackage.determineDistanceFromLine = function (point, lineString) {
        return point_to_line_distance_1.default(point, lineString);
    };
    GeoPackage.determineDistanceFromPolygon = function (point, polygon) {
        if (boolean_point_in_polygon_1.default(point, polygon)) {
            return 0;
        }
        return GeoPackage.determineDistance(point, polygon_to_line_1.default(polygon));
    };
    /**
     * Create the Data Columns table if it does not already exist
     */
    GeoPackage.prototype.createDataColumns = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.dataColumnsDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createDataColumns()];
            });
        });
    };
    /**
     * Create the Data Column Constraints table if it does not already exist
     */
    GeoPackage.prototype.createDataColumnConstraintsTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.dataColumnConstraintsDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createDataColumnConstraints()];
            });
        });
    };
    GeoPackage.prototype.createMetadataTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.metadataDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createMetadata()];
            });
        });
    };
    GeoPackage.prototype.createMetadataReferenceTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.metadataReferenceDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createMetadataReference()];
            });
        });
    };
    GeoPackage.prototype.createExtensionTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.extensionDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createExtensions()];
            });
        });
    };
    GeoPackage.prototype.createTableIndexTable = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.tableIndexDao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createTableIndex()];
            });
        });
    };
    GeoPackage.prototype.createGeometryIndexTable = function (featureDao) {
        return __awaiter(this, void 0, void 0, function () {
            var dao;
            return __generator(this, function (_a) {
                dao = this.getGeometryIndexDao(featureDao);
                if (dao.isTableExists()) {
                    return [2 /*return*/, true];
                }
                return [2 /*return*/, this.tableCreator.createGeometryIndex()];
            });
        });
    };
    GeoPackage.prototype.createStyleMappingTable = function (tableName, columns, dataColumns) {
        return __awaiter(this, void 0, void 0, function () {
            var attributeTable, contents, dataColumnsDao_4;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        attributeTable = new styleMappingTable_1.StyleMappingTable(tableName, columns);
                        this.tableCreator.createUserTable(attributeTable);
                        contents = new contents_1.Contents();
                        contents.table_name = tableName;
                        contents.data_type = contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME;
                        contents.identifier = tableName;
                        contents.last_change = new Date().toISOString();
                        this.contentsDao.create(contents);
                        if (!dataColumns) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.createDataColumns()];
                    case 1:
                        _a.sent();
                        dataColumnsDao_4 = this.dataColumnsDao;
                        dataColumns.forEach(function (dataColumn) {
                            dataColumnsDao_4.create(dataColumn);
                        });
                        _a.label = 2;
                    case 2: return [2 /*return*/, true];
                }
            });
        });
    };
    /**
     * Get the application id of the GeoPackage
     * @returns {string} application id
     */
    GeoPackage.prototype.getApplicationId = function () {
        return this.database.getApplicationId();
    };
    GeoPackage.createDataColumnMap = function (featureDao) {
        var columnMap = {};
        var dcd = new dataColumnsDao_1.DataColumnsDao(featureDao.geoPackage);
        featureDao.table.columns.forEach(function (column) {
            var dataColumn = dcd.getDataColumns(featureDao.table.table_name, column.name);
            columnMap[column.name] = {
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType ? dataTypes_1.DataTypes.nameFromType(column.dataType) : '',
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn,
            };
        }.bind(this));
        return columnMap;
    };
    GeoPackage.prototype.iterateGeoJSONFeatures = function (tableName, boundingBox) {
        var featureDao = this.getFeatureDao(tableName);
        return featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
    };
    /**
     * Gets a GeoJSON feature from the table by id
     * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
     * @param  {string}   table      name of the table to get the feature from
     * @param  {Number}   featureId  ID of the feature
     */
    GeoPackage.prototype.getFeature = function (table, featureId) {
        var featureDao = this.getFeatureDao(table);
        var srs = featureDao.getSrs();
        var feature = featureDao.queryForId(featureId);
        if (!feature) {
            var features = featureDao.queryForAllEq('_feature_id', featureId);
            if (features.length) {
                feature = featureDao.getRow(features[0]);
            }
            else {
                features = featureDao.queryForAllEq('_properties_id', featureId);
                if (features.length) {
                    feature = featureDao.getRow(features[0]);
                }
            }
        }
        if (feature) {
            return GeoPackage.parseFeatureRowIntoGeoJSON(feature, srs);
        }
    };
    // eslint-disable-next-line complexity
    GeoPackage.parseFeatureRowIntoGeoJSON = function (featureRow, srs, columnMap) {
        var geoJson = {
            type: 'Feature',
            properties: {},
            id: undefined,
            geometry: undefined,
        };
        var geometry = featureRow.getGeometry();
        if (geometry && geometry.geometry) {
            var geoJsonGeom = geometry.geometry.toGeoJSON();
            if (srs.definition &&
                srs.definition !== 'undefined' &&
                srs.organization.toUpperCase() + ':' + srs.organization_coordsys_id !== 'EPSG:4326') {
                geoJsonGeom = reproject_1.default.reproject(geoJsonGeom, srs.projection, 'EPSG:4326');
            }
            geoJson.geometry = geoJsonGeom;
        }
        for (var key in featureRow.values) {
            if (Object.prototype.hasOwnProperty.call(featureRow.values, key) &&
                key !== featureRow.getGeometryColumn().name &&
                key !== 'id') {
                if (key.toLowerCase() === '_feature_id') {
                    geoJson.id = featureRow.values[key];
                }
                else if (key.toLowerCase() === '_properties_id') {
                    geoJson.properties[key.substring(12)] = featureRow.values[key];
                }
                else if (columnMap && columnMap[key]) {
                    geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
                }
                else {
                    geoJson.properties[key] = featureRow.values[key];
                }
            }
            else if (featureRow.getGeometryColumn().name === key) {
                // geoJson.properties[key] = geometry && !geometry.geometryError ? 'Valid' : geometry.geometryError;
            }
        }
        geoJson.id = geoJson.id || featureRow.id;
        return geoJson;
    };
    /**
     * Gets the features in the EPSG:3857 tile
     * @param  {string}   table      name of the feature table
     * @param  {Number}   x       x tile number
     * @param  {Number}   y       y tile number
     * @param  {Number}   z      z tile number
     * @param  {Boolean}   [skipVerification]      skip the extra verification to determine if the feature really is within the tile
     */
    GeoPackage.prototype.getGeoJSONFeaturesInTile = function (table, x, y, z, skipVerification) {
        if (skipVerification === void 0) { skipVerification = false; }
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, bb, featureDao, features, iterator, iterator_5, iterator_5_1, feature;
            var e_5, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
                        bb = webMercatorBoundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
                        return [4 /*yield*/, this.indexFeatureTable(table)];
                    case 1:
                        _b.sent();
                        featureDao = this.getFeatureDao(table);
                        if (!featureDao)
                            return [2 /*return*/];
                        features = [];
                        iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(bb, skipVerification);
                        try {
                            for (iterator_5 = __values(iterator), iterator_5_1 = iterator_5.next(); !iterator_5_1.done; iterator_5_1 = iterator_5.next()) {
                                feature = iterator_5_1.value;
                                features.push(feature);
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (iterator_5_1 && !iterator_5_1.done && (_a = iterator_5.return)) _a.call(iterator_5);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                        return [2 /*return*/, features];
                }
            });
        });
    };
    /**
     * Gets the features in the EPSG:4326 bounding box
     * @param  {string}   table      name of the feature table
     * @param  {Number}   west       EPSG:4326 western boundary
     * @param  {Number}   east       EPSG:4326 eastern boundary
     * @param  {Number}   south      EPSG:4326 southern boundary
     * @param  {Number}   north      EPSG:4326 northern boundary
     */
    GeoPackage.prototype.getFeaturesInBoundingBox = function (table, west, east, south, north) {
        return __awaiter(this, void 0, void 0, function () {
            var featureDao, bb, iterator;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.indexFeatureTable(table)];
                    case 1:
                        _a.sent();
                        featureDao = this.getFeatureDao(table);
                        if (!featureDao)
                            throw new Error('Unable to find table ' + table);
                        bb = new boundingBox_1.BoundingBox(west, east, south, north);
                        iterator = featureDao.queryIndexedFeaturesWithBoundingBox(bb);
                        return [2 /*return*/, iterator];
                }
            });
        });
    };
    /**
     * Get the standard 3857 XYZ tile from the GeoPackage.  If a canvas is provided, the tile will be drawn in the canvas
     * @param  {string}   table      name of the table containing the tiles
     * @param  {Number}   x          x index of the tile
     * @param  {Number}   y          y index of the tile
     * @param  {Number}   z          zoom level of the tile
     * @param  {Number}   width      width of the resulting tile
     * @param  {Number}   height     height of the resulting tile
     * @param  {any}   canvas     canvas element to draw the tile into
     */
    GeoPackage.prototype.xyzTile = function (table, x, y, z, width, height, canvas) {
        if (width === void 0) { width = 256; }
        if (height === void 0) { height = 256; }
        return __awaiter(this, void 0, void 0, function () {
            var tileDao, retriever;
            return __generator(this, function (_a) {
                width = Number(width);
                height = Number(height);
                tileDao = this.getTileDao(table);
                retriever = new retriever_1.GeoPackageTileRetriever(tileDao, width, height);
                if (!canvas) {
                    return [2 /*return*/, retriever.getTile(x, y, z)];
                }
                else {
                    return [2 /*return*/, retriever.drawTileIn(x, y, z, canvas)];
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Draws a tile projected into the specified projection, bounded by the specified by the bounds in EPSG:4326 into the canvas or the image is returned if no canvas is passed in
     * @param  {string}   table      name of the table containing the tiles
     * @param  {Number}   minLat     minimum latitude bounds of tile
     * @param  {Number}   minLon     minimum longitude bounds of tile
     * @param  {Number}   maxLat     maximum latitude bounds of tile
     * @param  {Number}   maxLon     maximum longitude bounds of tile
     * @param  {Number}   z          zoom level of the tile
     * @param  {Number}   width      width of the resulting tile
     * @param  {Number}   height     height of the resulting tile
     * @param  {any}   canvas     canvas element to draw the tile into
     */
    GeoPackage.prototype.projectedTile = function (table, minLat, minLon, maxLat, maxLon, z, projection, width, height, canvas) {
        if (width === void 0) { width = 256; }
        if (height === void 0) { height = 256; }
        return __awaiter(this, void 0, void 0, function () {
            var tileDao, retriever, bounds;
            return __generator(this, function (_a) {
                tileDao = this.getTileDao(table);
                retriever = new retriever_1.GeoPackageTileRetriever(tileDao, width, height);
                bounds = new boundingBox_1.BoundingBox(minLon, maxLon, minLat, maxLat);
                return [2 /*return*/, retriever.getTileWithWgs84BoundsInProjection(bounds, z, projection, canvas)];
            });
        });
    };
    GeoPackage.prototype.getInfoForTable = function (tableDao) {
        var info = {
            tableName: tableDao.table_name,
            tableType: tableDao.table.getTableType(),
            count: tableDao.getCount(),
            geometryColumns: undefined,
            minZoom: undefined,
            maxZoom: undefined,
            minWebMapZoom: undefined,
            maxWebMapZoom: undefined,
            zoomLevels: undefined,
            tileMatrixSet: undefined,
            contents: undefined,
            srs: undefined,
            columns: undefined,
            columnMap: undefined,
        };
        if (tableDao instanceof featureDao_1.FeatureDao) {
            info.geometryColumns = {
                tableName: tableDao.geometryColumns.table_name,
                geometryColumn: tableDao.geometryColumns.column_name,
                geometryTypeName: tableDao.geometryColumns.geometry_type_name,
                z: tableDao.geometryColumns.z,
                m: tableDao.geometryColumns.m,
            };
        }
        if (tableDao instanceof tileDao_1.TileDao) {
            info.minZoom = tableDao.minZoom;
            info.maxZoom = tableDao.maxZoom;
            info.minWebMapZoom = tableDao.minWebMapZoom;
            info.maxWebMapZoom = tableDao.maxWebMapZoom;
            info.zoomLevels = tableDao.tileMatrices.length;
        }
        var contents;
        if (tableDao instanceof featureDao_1.FeatureDao) {
            contents = this.geometryColumnsDao.getContents(tableDao.geometryColumns);
        }
        else if (tableDao instanceof tileDao_1.TileDao) {
            contents = this.tileMatrixSetDao.getContents(tableDao.tileMatrixSet);
            info.tileMatrixSet = {
                srsId: tableDao.tileMatrixSet.srs_id,
                minX: tableDao.tileMatrixSet.min_x,
                maxX: tableDao.tileMatrixSet.max_x,
                minY: tableDao.tileMatrixSet.min_y,
                maxY: tableDao.tileMatrixSet.max_y,
            };
        }
        var contentsSrs = this.contentsDao.getSrs(contents);
        info.contents = {
            tableName: contents.table_name,
            dataType: contents.data_type,
            identifier: contents.identifier,
            description: contents.description,
            lastChange: contents.last_change,
            minX: contents.min_x,
            maxX: contents.max_x,
            minY: contents.min_y,
            maxY: contents.max_y,
            srs: {
                name: contentsSrs.srs_name,
                id: contentsSrs.srs_id,
                organization: contentsSrs.organization,
                organization_coordsys_id: contentsSrs.organization_coordsys_id,
                definition: contentsSrs.definition,
                description: contentsSrs.description,
            },
        };
        info.contents.srs = {
            name: contentsSrs.srs_name,
            id: contentsSrs.srs_id,
            organization: contentsSrs.organization,
            organization_coordsys_id: contentsSrs.organization_coordsys_id,
            definition: contentsSrs.definition,
            description: contentsSrs.description,
        };
        var srs = tableDao.getSrs();
        info.srs = {
            name: srs.srs_name,
            id: srs.srs_id,
            organization: srs.organization,
            organization_coordsys_id: srs.organization_coordsys_id,
            definition: srs.definition,
            description: srs.description,
        };
        info.columns = [];
        info.columnMap = {};
        var dcd = this.dataColumnsDao;
        tableDao.table.columns.forEach(function (column) {
            var dataColumn = dcd.getDataColumns(tableDao.table.table_name, column.name);
            info.columns.push({
                index: column.index,
                name: column.name,
                max: column.max,
                min: column.min,
                notNull: column.notNull,
                primaryKey: column.primaryKey,
                dataType: column.dataType,
                displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
                dataColumn: dataColumn,
            });
            info.columnMap[column.name] = info.columns[info.columns.length - 1];
        }.bind(this));
        return info;
    };
    GeoPackage.loadProjections = function (items) {
        if (!items)
            throw new Error('Invalid array of projections');
        for (var i = 0; i < items.length; i++) {
            if (!anyDefs[items[i]])
                throw new Error('Projection not found');
            this.addProjection(items[i], anyDefs[items[i]]);
        }
    };
    GeoPackage.addProjection = function (name, definition) {
        if (!name || !definition)
            throw new Error('Invalid projection name/definition');
        proj4_1.default.defs('' + name, '' + definition);
    };
    GeoPackage.hasProjection = function (name) {
        return proj4_1.default.defs('' + name);
    };
    return GeoPackage;
}());
exports.GeoPackage = GeoPackage;
//# sourceMappingURL=geoPackage.js.map