import { TileMatrix } from '../matrix/tileMatrix';
import { TileMatrixSet } from '../matrixset/tileMatrixSet';
import { SpatialReferenceSystem } from '../../core/srs/spatialReferenceSystem';
import { TileCreator } from './tileCreator';
import { BoundingBox } from '../../boundingBox';
export declare class CanvasTileCreator extends TileCreator {
    canvas: HTMLCanvasElement;
    ctx: any;
    image: HTMLImageElement;
    tileCanvas: HTMLCanvasElement;
    tileContext: any;
    imageData: Uint8ClampedArray;
    constructor(width: number, height: number, tileMatrix: TileMatrix, tileMatrixSet: TileMatrixSet, tileBoundingBox: BoundingBox, srs: SpatialReferenceSystem, projectionTo: string, canvas?: any);
    initialize(): Promise<CanvasTileCreator>;
    addPixel(targetX: number, targetY: number, sourceX: number, sourceY: number): void;
    loadImage(tileData: any): Promise<any>;
    addTile(tileData: any, gridColumn: number, gridRow: number): Promise<void>;
    getCompleteTile(): Promise<any>;
    reproject(tileData: any, tilePieceBoundingBox: any): Promise<void>;
    workerDone(data: any, piecePosition: any, ctx: any): void;
}
