"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var file_type_1 = __importDefault(require("file-type"));
var tileCreator_1 = require("./tileCreator");
var tileUtilities_1 = __importDefault(require("./tileUtilities"));
var projectTile_1 = __importDefault(require("./projectTile"));
var CanvasTileCreator = /** @class */ (function (_super) {
    __extends(CanvasTileCreator, _super);
    function CanvasTileCreator(width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo, canvas) {
        var _this = _super.call(this, width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo) || this;
        // eslint-disable-next-line no-undef
        _this.canvas = canvas || document.createElement('canvas');
        _this.canvas.width = width;
        _this.canvas.height = height;
        _this.ctx = _this.canvas.getContext('2d');
        // eslint-disable-next-line no-undef
        _this.image = document.createElement('img');
        // eslint-disable-next-line no-undef
        _this.tileCanvas = document.createElement('canvas');
        _this.tileContext = _this.tileCanvas.getContext('2d');
        _this.tileCanvas.width = tileMatrix.tile_width;
        _this.tileCanvas.height = tileMatrix.tile_height;
        _this.imageData = new Uint8ClampedArray(width * height * 4);
        return _this;
    }
    CanvasTileCreator.prototype.initialize = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this];
            });
        });
    };
    CanvasTileCreator.prototype.addPixel = function (targetX, targetY, sourceX, sourceY) {
        var color = this.tileContext.getImageData(sourceX, sourceY, 1, 1);
        this.imageData.set(color.data, targetY * this.width * 4 + targetX * 4);
    };
    CanvasTileCreator.prototype.loadImage = function (tileData) {
        return __awaiter(this, void 0, void 0, function () {
            var type, binary, bytes, len, i, base64Data;
            var _this = this;
            return __generator(this, function (_a) {
                type = file_type_1.default(tileData);
                binary = '';
                bytes = tileData;
                len = bytes.byteLength;
                for (i = 0; i < len; i++) {
                    binary += String.fromCharCode(bytes[i]);
                }
                base64Data = btoa(binary);
                return [2 /*return*/, new Promise(function (resolve) {
                        _this.chunks = [];
                        _this.image.onload = function () {
                            resolve(_this.tileContext.drawImage(_this.image, 0, 0));
                        };
                        _this.image.src = 'data:' + type.mime + ';base64,' + base64Data;
                    })];
            });
        });
    };
    CanvasTileCreator.prototype.addTile = function (tileData, gridColumn, gridRow) {
        return __awaiter(this, void 0, void 0, function () {
            var type;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        type = file_type_1.default(tileData);
                        return [4 /*yield*/, this.loadImage(tileData)];
                    case 1:
                        _a.sent();
                        this.projectTile(tileData, gridColumn, gridRow);
                        if (this.chunks && this.chunks.length) {
                            return [2 /*return*/, this.chunks.reduce(function (sequence, chunk) {
                                    var type = file_type_1.default(tileData);
                                    var binary = '';
                                    var bytes = chunk.chunk;
                                    var len = bytes.byteLength;
                                    for (var i = 0; i < len; i++) {
                                        binary += String.fromCharCode(bytes[i]);
                                    }
                                    // eslint-disable-next-line no-undef
                                    var base64DataChunk = btoa(binary);
                                    // eslint-disable-next-line no-undef
                                    var image = document.createElement('img');
                                    return sequence.then(function () {
                                        return new Promise(function (resolve) {
                                            image.onload = function () {
                                                var p = chunk.position;
                                                _this.ctx.drawImage(image, p.sx, p.sy, p.sWidth, p.sHeight, p.dx, p.dy, p.dWidth, p.dHeight);
                                                resolve();
                                            };
                                            image.src = 'data:' + type.mime + ';base64,' + base64DataChunk;
                                        });
                                    });
                                }, Promise.resolve())];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    CanvasTileCreator.prototype.getCompleteTile = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.canvas.toDataURL()];
            });
        });
    };
    CanvasTileCreator.prototype.reproject = function (tileData, tilePieceBoundingBox) {
        return __awaiter(this, void 0, void 0, function () {
            var ctx, piecePosition, job;
            var _this = this;
            return __generator(this, function (_a) {
                ctx = this.ctx;
                piecePosition = tileUtilities_1.default.getPiecePosition(tilePieceBoundingBox, this.tileBoundingBox, this.height, this.width, this.projectionTo, this.projectionFrom, this.projectionFromDefinition, this.tileHeightUnitsPerPixel, this.tileWidthUnitsPerPixel, this.tileMatrix.pixel_x_size, this.tileMatrix.pixel_y_size);
                job = {
                    tileBoundingBox: JSON.stringify(this.tileBoundingBox),
                    tileWidthUnitsPerPixel: this.tileWidthUnitsPerPixel,
                    tileHeightUnitsPerPixel: this.tileHeightUnitsPerPixel,
                    projectionTo: this.projectionTo,
                    projectionFrom: this.projectionFrom,
                    projectionFromDefinition: this.projectionFromDefinition,
                    tileWidth: this.tileMatrix.tile_width,
                    tileHeight: this.tileMatrix.tile_height,
                    pixelYSize: this.tileMatrix.pixel_y_size,
                    pixelXSize: this.tileMatrix.pixel_x_size,
                    height: this.height,
                    width: this.width,
                    tilePieceBoundingBox: JSON.stringify(tilePieceBoundingBox),
                    imageData: this.tileContext.getImageData(0, 0, this.tileMatrix.tile_width, this.tileMatrix.tile_height).data
                        .buffer,
                };
                return [2 /*return*/, new Promise(function (resolve) {
                        try {
                            var work = require('webworkify');
                            var worker = work(require('./tileWorker.js'));
                            worker.onmessage = function (e) {
                                resolve(_this.workerDone(e.data, piecePosition, ctx));
                            };
                            worker.postMessage(job, [
                                _this.tileContext.getImageData(0, 0, _this.tileMatrix.tile_width, _this.tileMatrix.tile_height).data.buffer,
                            ]);
                        }
                        catch (e) {
                            var worker = projectTile_1.default;
                            worker(job, function (err, data) {
                                resolve(this.workerDone(data, piecePosition, ctx));
                            });
                        }
                    })];
            });
        });
    };
    CanvasTileCreator.prototype.workerDone = function (data, piecePosition, ctx) {
        if (data.message === 'done') {
            var imageData = new Uint8ClampedArray(data.imageData);
            var offsetX = piecePosition.startX;
            var offsetY = piecePosition.startY;
            var finalWidth = data.finalWidth;
            var finalHeight = data.finalHeight;
            // eslint-disable-next-line no-undef
            var tmpCanvas = document.createElement('canvas');
            tmpCanvas.width = finalWidth;
            tmpCanvas.height = finalHeight;
            tmpCanvas.getContext('2d').putImageData(new ImageData(imageData, finalWidth, finalHeight), 0, 0);
            ctx.drawImage(tmpCanvas, offsetX, offsetY);
        }
    };
    return CanvasTileCreator;
}(tileCreator_1.TileCreator));
exports.CanvasTileCreator = CanvasTileCreator;
//# sourceMappingURL=canvas.js.map