"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-ignore
var concat_stream_1 = __importDefault(require("concat-stream"));
var imageUtils_1 = require("../imageUtils");
var tileCreator_1 = require("./tileCreator");
var NodeTileCreator = /** @class */ (function (_super) {
    __extends(NodeTileCreator, _super);
    function NodeTileCreator(width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo, canvas) {
        var _this = _super.call(this, width, height, tileMatrix, tileMatrixSet, tileBoundingBox, srs, projectionTo) || this;
        _this.canvas = canvas;
        _this.pixelAdded = false;
        return _this;
    }
    NodeTileCreator.prototype.initialize = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this;
                        return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('canvas')); })];
                    case 1:
                        _a.Canvas = _b.sent();
                        this.canvas = this.canvas || this.Canvas.createCanvas(this.width, this.height);
                        this.ctx = this.canvas.getContext('2d');
                        this.tileCanvas = this.Canvas.createCanvas(this.width, this.height);
                        this.tileContext = this.tileCanvas.getContext('2d');
                        this.tileCanvas.width = this.tileMatrix.tile_width;
                        this.tileCanvas.height = this.tileMatrix.tile_height;
                        this.imageData = this.Canvas.createImageData(new Uint8ClampedArray(this.width * this.height * 4), this.width, this.height);
                        return [2 /*return*/, this];
                }
            });
        });
    };
    NodeTileCreator.prototype.addPixel = function (targetX, targetY, sourceX, sourceY) {
        var color = this.tileContext.getImageData(sourceX, sourceY, 1, 1);
        this.imageData.data.set(color.data, targetY * this.width * 4 + targetX * 4);
        this.pixelAdded = true;
    };
    NodeTileCreator.prototype.addTile = function (tileData, gridColumn, gridRow) {
        return __awaiter(this, void 0, void 0, function () {
            var tile, i, image, p;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, imageUtils_1.ImageUtils.getImage(tileData)];
                    case 1:
                        tile = _a.sent();
                        this.tileContext.drawImage(tile, 0, 0);
                        this.chunks = [];
                        return [4 /*yield*/, this.projectTile(tileData, gridColumn, gridRow)];
                    case 2:
                        _a.sent();
                        if (this.pixelAdded) {
                            this.ctx.putImageData(this.imageData, 0, 0);
                        }
                        if (!(this.chunks && this.chunks.length)) return [3 /*break*/, 6];
                        i = 0;
                        _a.label = 3;
                    case 3:
                        if (!(i < this.chunks.length)) return [3 /*break*/, 6];
                        return [4 /*yield*/, imageUtils_1.ImageUtils.getImage(tileData)];
                    case 4:
                        image = _a.sent();
                        p = this.chunks[i].position;
                        this.ctx.drawImage(image, p.sx, p.sy, p.sWidth, p.sHeight, p.dx, p.dy, p.dWidth, p.dHeight);
                        _a.label = 5;
                    case 5:
                        i++;
                        return [3 /*break*/, 3];
                    case 6: return [2 /*return*/, this.canvas];
                }
            });
        });
    };
    NodeTileCreator.prototype.getCompleteTile = function (format) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) {
                        var writeStream = concat_stream_1.default(function (buffer) {
                            resolve(buffer);
                        });
                        var stream = null;
                        if (format === 'png') {
                            stream = _this.canvas.createPNGStream();
                        }
                        else {
                            stream = _this.canvas.createJPEGStream();
                        }
                        stream.pipe(writeStream);
                    })];
            });
        });
    };
    return NodeTileCreator;
}(tileCreator_1.TileCreator));
exports.NodeTileCreator = NodeTileCreator;
//# sourceMappingURL=node.js.map