/// <reference types="node" />
/**
 * CustomFeaturesTile module.
 * @module tiles/features/custom
 */
/**
 * Custom Feature Tile
 * @constructor
 */
export declare abstract class CustomFeaturesTile {
    static readonly isElectron: boolean;
    static readonly isNode: string;
    static readonly useNodeCanvas: boolean;
    tileBorderStrokeWidth: number;
    tileBorderColor: string;
    tileFillColor: string;
    compressFormat: string;
    drawUnindexedTiles: boolean;
    constructor();
    /**
     * Draw a tile with the provided text label in the middle
     * @param {Number} tileWidth
     * @param {Number} tileHeight
     * @param {String} text
     * @param canvas optional canvas
     * @return {Promise<String|Buffer>}
     */
    abstract drawTile(tileWidth: number, tileHeight: number, text: string, canvas?: any): Promise<string | Buffer | Uint8Array>;
    /**
     * Draw a tile with the provided text label in the middle
     * @param {Number} tileWidth
     * @param {Number} tileHeight
     * @param canvas optional canvas
     * @return {Promise<String|Buffer>}
     */
    abstract drawUnindexedTile(tileWidth: number, tileHeight: number, canvas?: any): Promise<string | Buffer | Uint8Array>;
}
