"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * CustomFeaturesTile module.
 * @module tiles/features/custom
 */
/**
 * Custom Feature Tile
 * @constructor
 */
var CustomFeaturesTile = /** @class */ (function () {
    function CustomFeaturesTile() {
        this.compressFormat = 'png';
        this.tileBorderStrokeWidth = 2;
        this.tileBorderColor = 'rgba(0, 0, 0, 1.0)';
        this.tileFillColor = 'rgba(0, 0, 0, 0.0625)';
        this.drawUnindexedTiles = true;
    }
    CustomFeaturesTile.isElectron = !!(typeof navigator !== 'undefined' && navigator.userAgent.toLowerCase().indexOf(' electron/') > -1);
    CustomFeaturesTile.isNode = typeof process !== 'undefined' && process.version;
    CustomFeaturesTile.useNodeCanvas = CustomFeaturesTile.isNode && !CustomFeaturesTile.isElectron;
    return CustomFeaturesTile;
}());
exports.CustomFeaturesTile = CustomFeaturesTile;
//# sourceMappingURL=customFeaturesTile.js.map