/// <reference types="node" />
import { CustomFeaturesTile } from './customFeaturesTile';
/**
 * Draws a tile indicating the number of features that exist within the tile,
 * visible when zoomed in closer. The number is drawn in the center of the tile
 * and by default is surrounded by a colored circle with border. By default a
 * tile border is drawn and the tile is colored (transparently most likely). The
 * paint objects for each draw type can be modified to or set to null (except
 * for the text paint object).
 */
export declare class NumberFeaturesTile extends CustomFeaturesTile {
    textSize: number;
    textFont: string;
    textColor: string;
    circleStrokeWidth: number;
    circleBorderColor: string;
    circleFillColor: string;
    circlePaddingPercentage: number;
    defaultFontRegistered: boolean;
    constructor();
    /**
     * register a font
     * @private
     */
    _registerDefaultFont(): void;
    /**
     * Get the text size
     * @return {Number} text size
     */
    getTextSize(): number;
    /**
     * Set the text size
     * @param {Number} textSize text size
     */
    setTextSize(textSize: number): void;
    /**
     * Get the text color
     * @return {String} text color
     */
    getTextColor(): string;
    /**
     * Set the text color
     * @param {String} textColor text color
     */
    setTextColor(textColor: string): void;
    /**
     * Get the circle stroke width
     * @return {Number} circle stroke width
     */
    getCircleStrokeWidth(): number;
    /**
     * Set the circle stroke width
     * @param {Number} circleStrokeWidth circle stroke width
     */
    setCircleStrokeWidth(circleStrokeWidth: number): void;
    /**
     * Get the circle color
     * @return {String} circle color
     */
    getCircleColor(): string;
    /**
     * Set the circle color
     * @param {String} circleBorderColor circle color
     */
    setCircleColor(circleBorderColor: string): void;
    /**
     * Get the circle fill color
     * @return {String} circle fill color
     */
    getCircleFillColor(): string;
    /**
     * Set the circle fill color
     * @param {String} circleFillColor circle fill color
     */
    setCircleFillColor(circleFillColor: string): void;
    /**
     * Get the circle padding percentage around the text
     * @return {Number} circle padding percentage, 0.0 to 1.0
     */
    getCirclePaddingPercentage(): number;
    /**
     * Set the circle padding percentage to pad around the text, value between
     * 0.0 and 1.0
     * @param {Number} circlePaddingPercentage circle padding percentage
     */
    setCirclePaddingPercentage(circlePaddingPercentage: number): void;
    /**
     * Get the tile border stroke width
     * @return {Number} tile border stroke width
     */
    getTileBorderStrokeWidth(): number;
    /**
     * Set the tile border stroke width
     *
     * @param {Number} tileBorderStrokeWidth tile border stroke width
     */
    setTileBorderStrokeWidth(tileBorderStrokeWidth: number): void;
    /**
     * Get the tile border color
     * @return {String} tile border color
     */
    getTileBorderColor(): string;
    /**
     * Set the tile border color
     * @param {String} tileBorderColor tile border color
     */
    setTileBorderColor(tileBorderColor: string): void;
    /**
     * Get the tile fill color
     * @return {String} tile fill color
     */
    getTileFillColor(): string;
    /**
     * Set the tile fill color
     * @param {String} tileFillColor tile fill color
     */
    setTileFillColor(tileFillColor: string): void;
    /**
     * Is the draw unindexed tiles option enabled
     * @return {Boolean} true if drawing unindexed tiles
     */
    isDrawUnindexedTiles(): boolean;
    /**
     * Set the draw unindexed tiles option
     * @param {Boolean} drawUnindexedTiles draw unindexed tiles flag
     */
    setDrawUnindexedTiles(drawUnindexedTiles: boolean): void;
    /**
     * Get the compression format
     * @return {String} the compression format (either png or jpeg)
     */
    getCompressFormat(): string;
    /**
     * Set the compression format
     * @param {String} compressFormat either 'png' or 'jpeg'
     */
    setCompressFormat(compressFormat: string): void;
    /**
     * Draw unindexed tile
     * @param tileWidth
     * @param tileHeight
     * @param canvas
     * @returns {Promise<String|Buffer>}
     */
    drawUnindexedTile(tileWidth: number, tileHeight: number, canvas?: any): Promise<string | Buffer | Uint8Array>;
    /**
     * Draw a tile with the provided text label in the middle
     * @param {Number} tileWidth
     * @param {Number} tileHeight
     * @param {String} text
     * @param tileCanvas
     * @return {Promise<String|Buffer>}
     */
    drawTile(tileWidth: number, tileHeight: number, text: string, tileCanvas: null): Promise<string | Buffer | Uint8Array>;
}
